/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.LineBand;
import de.cismet.cids.custom.wrrl_db_mv.util.linearreferencing.LinearReferencingHelper;
import de.cismet.cids.custom.wrrl_db_mv.util.linearreferencing.LinearReferencingSingletonInstances;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanStore;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.jbands.BandMemberEvent;
import de.cismet.tools.gui.jbands.JBandCursorManager;
import de.cismet.tools.gui.jbands.interfaces.BandMember;
import de.cismet.tools.gui.jbands.interfaces.BandMemberListener;
import de.cismet.tools.gui.jbands.interfaces.BandMemberSelectable;
import de.cismet.tools.gui.jbands.interfaces.ModifiableBandMember;
import de.cismet.tools.gui.jbands.interfaces.Section;
import de.cismet.tools.gui.jbands.interfaces.StationaryBandMemberMouseListeningComponent;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingWorker;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.PinstripePainter;
import org.jdesktop.swingx.painter.RectanglePainter;

public abstract class LineBandMember
extends JXPanel
implements ModifiableBandMember,
Section,
CidsBeanStore,
StationaryBandMemberMouseListeningComponent,
BandMemberSelectable,
PropertyChangeListener,
ActionListener,
PopupMenuListener {
    protected static final Logger LOG = Logger.getLogger(LineBandMember.class);
    protected PinstripePainter stripes = new PinstripePainter();
    protected Painter unselectedBackgroundPainter = null;
    protected Painter selectedBackgroundPainter = null;
    protected CidsBean bean;
    protected boolean isSelected = false;
    protected JPopupMenu popup = new JPopupMenu();
    protected boolean newMode = false;
    protected int mouseClickedXPosition = 0;
    protected String lineFieldName = "linie";
    double von = 0.0;
    double bis = 0.0;
    private JLabel labText;
    private CidsBean stationFrom;
    private CidsBean stationTill;
    private boolean dragStart = false;
    private int dragSide = 0;
    private double oldStationValue;
    private JMenuItem deleteItem = new JMenuItem("l\u00f6schen");
    private JMenuItem splitItem = new JMenuItem("teilen");
    private LineBand parent;
    private List<BandMemberListener> listenerList = new ArrayList<BandMemberListener>();
    private boolean readOnly;

    public LineBandMember(LineBand parent) {
        this(parent, false);
    }

    public LineBandMember(LineBand parent, boolean readOnly) {
        this.readOnly = readOnly;
        this.initComponents();
        this.stripes.setPaint((Paint)new Color(200, 200, 200, 200));
        this.stripes.setSpacing(5.0);
        this.setAlpha(0.8f);
        this.parent = parent;
        this.popup.addPopupMenuListener(this);
    }

    public JComponent getBandMemberComponent() {
        return this;
    }

    public double getMax() {
        return this.von < this.bis ? this.bis : this.von;
    }

    public double getMin() {
        return this.von < this.bis ? this.von : this.bis;
    }

    public double getFrom() {
        return this.von;
    }

    public double getTo() {
        return this.bis;
    }

    public CidsBean getCidsBean() {
        return this.bean;
    }

    public void setText(String text) {
        this.labText.setText(text);
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.removeOldListener();
        this.bean = cidsBean;
        this.popup.removeAll();
        this.configurePopupMenu();
        this.von = (Double)this.bean.getProperty(this.lineFieldName + ".von.wert");
        this.bis = (Double)this.bean.getProperty(this.lineFieldName + ".bis.wert");
        this.bean.addPropertyChangeListener((PropertyChangeListener)this);
        CidsBean linieBean = (CidsBean)this.bean.getProperty(this.lineFieldName);
        if (linieBean != null) {
            linieBean.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.manageStationListener(cidsBean);
        this.determineBackgroundColour();
    }

    protected void setDefaultBackground() {
        this.unselectedBackgroundPainter = new MattePainter((Paint)new Color(229, 0, 0));
        this.selectedBackgroundPainter = new CompoundPainter(new Painter[]{this.unselectedBackgroundPainter, new RectanglePainter(3, 3, 3, 3, 3, 3, true, (Paint)new Color(100, 100, 100, 100), 2.0f, (Paint)new Color(50, 50, 50, 100))});
        if (this.isSelected) {
            this.setBackgroundPainter(this.selectedBackgroundPainter);
        } else {
            this.setBackgroundPainter(this.unselectedBackgroundPainter);
        }
    }

    protected void configurePopupMenu() {
        this.splitItem.addActionListener(this);
        this.popup.add(this.splitItem);
        this.popup.addSeparator();
        this.deleteItem.addActionListener(this);
        this.popup.add(this.deleteItem);
    }

    private void removeOldListener() {
        if (this.bean != null) {
            this.bean.removePropertyChangeListener((PropertyChangeListener)this);
            CidsBean oldLine = (CidsBean)this.bean.getProperty(this.lineFieldName);
            if (oldLine != null) {
                oldLine.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.stationFrom = (CidsBean)oldLine.getProperty("von");
            this.stationTill = (CidsBean)oldLine.getProperty("bis");
            if (this.stationFrom != null) {
                this.stationFrom.removePropertyChangeListener((PropertyChangeListener)this);
            }
            if (this.stationTill != null) {
                this.stationTill.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }

    protected abstract void determineBackgroundColour();

    private void manageStationListener(CidsBean cidsBean) {
        CidsBean linieBean = (CidsBean)cidsBean.getProperty(this.lineFieldName);
        if (linieBean != null) {
            this.stationFrom = (CidsBean)linieBean.getProperty("von");
            this.stationTill = (CidsBean)linieBean.getProperty("bis");
            if (this.stationFrom != null) {
                this.stationFrom.addPropertyChangeListener((PropertyChangeListener)this);
            }
            if (this.stationTill != null) {
                this.stationTill.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }

    private void initComponents() {
        this.labText = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.setLayout(new GridBagLayout());
        this.labText.setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.labText, gridBagConstraints);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && this.bean != null) {
            Geometry g = (Geometry)this.bean.getProperty(this.lineFieldName + ".geom.geo_field");
            final MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
            XBoundingBox xbb = new XBoundingBox(g);
            mc.gotoBoundingBoxWithHistory((BoundingBox)new XBoundingBox(g.getEnvelope().buffer((xbb.getWidth() + xbb.getHeight()) / 2.0 * 0.1)));
            DefaultStyledFeature dsf = new DefaultStyledFeature();
            dsf.setGeometry(g);
            dsf.setCanBeSelected(false);
            dsf.setLinePaint((Paint)Color.YELLOW);
            dsf.setLineWidth(6);
            final PFeature highlighter = new PFeature((Feature)dsf, mc);
            mc.getHighlightingLayer().addChild((PNode)highlighter);
            highlighter.animateToTransparency(0.1f, 2000L);
            CismetThreadPool.execute((Runnable)new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    Thread.currentThread();
                    Thread.sleep(2500L);
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        mc.getHighlightingLayer().removeChild((PNode)highlighter);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (JBandCursorManager.getInstance().isLocked()) {
            JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
        }
        this.setAlpha(1.0f);
    }

    public void mouseExited(MouseEvent e) {
        this.setAlpha(0.8f);
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() && this.isSelected) {
            this.showPopupMenu(e.getX(), e.getY());
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.dragStart) {
            this.parent.normalizeStationOfModifiedMember(this.bean, this.dragSide == 1);
            this.dragStart = false;
            JBandCursorManager.getInstance().setLocked(false);
        }
        if (e.isPopupTrigger() && this.isSelected) {
            this.showPopupMenu(e.getX(), e.getY());
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (JBandCursorManager.getInstance().isLocked()) {
            JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
        }
    }

    public void mouseDragged(MouseEvent e, double station) {
        if (JBandCursorManager.getInstance().isLocked()) {
            JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
        }
        if (!this.dragStart) {
            if (JBandCursorManager.getInstance().getCursor().equals(Cursor.getPredefinedCursor(10))) {
                this.dragSide = 1;
                this.dragStart = true;
                this.oldStationValue = (Double)this.stationFrom.getProperty("wert");
                JBandCursorManager.getInstance().setCursor(Cursor.getPredefinedCursor(10));
                JBandCursorManager.getInstance().setLocked(true);
                JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
            } else if (JBandCursorManager.getInstance().getCursor().equals(Cursor.getPredefinedCursor(11))) {
                this.dragSide = 2;
                this.dragStart = true;
                this.oldStationValue = (Double)this.stationTill.getProperty("wert");
                JBandCursorManager.getInstance().setCursor(Cursor.getPredefinedCursor(11));
                JBandCursorManager.getInstance().setLocked(true);
                JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
            }
        } else if (this.dragSide == 1) {
            try {
                this.stationFrom.setProperty("wert", (Object)Math.floor(station));
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while setting new station value.", (Throwable)ex);
            }
            if ((e.getModifiersEx() & 0x40) == 64) {
                this.parent.splitStation(this.bean, this.oldStationValue, true);
            }
        } else {
            try {
                this.stationTill.setProperty("wert", (Object)Math.floor(station));
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while setting new station value.", (Throwable)ex);
            }
            if ((e.getModifiersEx() & 0x40) == 64) {
                this.parent.splitStation(this.bean, this.oldStationValue, false);
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (!JBandCursorManager.getInstance().isLocked()) {
            if (this.isSelected && !this.isReadOnly()) {
                if (e.getX() < 5) {
                    JBandCursorManager.getInstance().setCursor(Cursor.getPredefinedCursor(10));
                    JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
                } else if (e.getX() > this.getWidth() - 5) {
                    JBandCursorManager.getInstance().setCursor(Cursor.getPredefinedCursor(11));
                    JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
                } else {
                    JBandCursorManager.getInstance().setCursor(Cursor.getPredefinedCursor(12));
                    JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
                }
            } else {
                JBandCursorManager.getInstance().setCursor(Cursor.getPredefinedCursor(12));
                JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
            }
        } else {
            JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
        }
    }

    public boolean isSelectable() {
        return true;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean selection) {
        this.isSelected = selection;
        if (!this.isSelected) {
            this.setBackgroundPainter(this.unselectedBackgroundPainter);
        } else {
            this.setBackgroundPainter(this.selectedBackgroundPainter);
        }
    }

    public void setNewMode() {
        this.newMode = true;
        this.popup.show((Component)((Object)this), this.getWidth() / 2, this.getHeight() / 2);
    }

    public BandMember getBandMember() {
        return this;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("wert")) {
            this.von = (Double)this.bean.getProperty(this.lineFieldName + ".von.wert");
            this.bis = (Double)this.bean.getProperty(this.lineFieldName + ".bis.wert");
            if (!this.parent.isNormalise()) {
                this.fireBandMemberChanged(false);
            }
        } else if (evt.getPropertyName().equals("von")) {
            if (this.stationFrom != null) {
                this.stationFrom.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.stationFrom = (CidsBean)evt.getNewValue();
            if (this.stationFrom != null) {
                this.stationFrom.addPropertyChangeListener((PropertyChangeListener)this);
            }
            if (this.bean.getProperty(this.lineFieldName + ".von.wert") != null) {
                this.von = (Double)this.bean.getProperty(this.lineFieldName + ".von.wert");
            }
            if (!this.parent.isNormalise()) {
                this.fireBandMemberChanged(false);
            }
        } else if (evt.getPropertyName().equals("bis")) {
            if (this.stationTill != null) {
                this.stationTill.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.stationTill = (CidsBean)evt.getNewValue();
            if (this.stationTill != null) {
                this.stationTill.addPropertyChangeListener((PropertyChangeListener)this);
            }
            if (this.bean.getProperty(this.lineFieldName + ".bis.wert") != null) {
                this.bis = (Double)this.bean.getProperty(this.lineFieldName + ".bis.wert");
            }
            if (!this.parent.isNormalise()) {
                this.fireBandMemberChanged(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.deleteItem) {
            this.deleteMember();
        } else if (e.getSource() == this.splitItem) {
            this.splitMember();
        }
    }

    private void splitMember() {
        double widthPerPixel = (this.getMax() - this.getMin()) / this.getBounds().getWidth();
        int pos = (int)(this.getMin() + (double)this.mouseClickedXPosition * widthPerPixel);
        try {
            CidsBean endStation = (CidsBean)this.bean.getProperty(this.lineFieldName + ".bis");
            CidsBean route = (CidsBean)endStation.getProperty("route");
            CidsBean newStation = LinearReferencingHelper.createStationBeanFromRouteBean(route, pos);
            try {
                newStation = newStation.persist();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while persist station", (Throwable)e);
            }
            LinearReferencedPointFeature pointFeature = LinearReferencingSingletonInstances.FEATURE_REGISTRY.addStationFeature(newStation);
            this.bean.setProperty(this.lineFieldName + ".bis", (Object)newStation);
            newStation.setProperty("wert", newStation.getProperty("wert"));
            this.parent.addMember(this.cloneBean(this.bean), newStation, endStation);
            LinearReferencingSingletonInstances.FEATURE_REGISTRY.removeStationFeature(endStation);
            BandMemberEvent e = new BandMemberEvent();
            e.setSelectionLost(true);
            this.fireBandMemberChanged(e);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while splitting station.", (Throwable)e);
        }
    }

    protected abstract CidsBean cloneBean(CidsBean var1) throws Exception;

    private void deleteMember() {
        this.parent.deleteMember(this);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        if (this.newMode) {
            this.deleteMember();
        }
    }

    public void addBandMemberListener(BandMemberListener listener) {
        this.listenerList.add(listener);
    }

    public void removeBandMemberListener(BandMemberListener listener) {
        this.listenerList.remove(listener);
    }

    public void fireBandMemberChanged(boolean modelChanged) {
        for (BandMemberListener l : this.listenerList) {
            l.bandMemberChanged(new BandMemberEvent(modelChanged));
        }
    }

    public void fireBandMemberChanged(BandMemberEvent e) {
        for (BandMemberListener l : this.listenerList) {
            l.bandMemberChanged(e);
        }
    }

    private void showPopupMenu(int x, int y) {
        this.mouseClickedXPosition = x;
        this.popup.show((Component)((Object)this), x, y);
    }

    public LineBand getParentBand() {
        return this.parent;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void dispose() {
        this.removeOldListener();
    }
}

