/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.LosPanel;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.MassnahmenHistoryListModel;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cids.tools.search.clientstuff.CidsWindowSearch;
import de.cismet.security.WebAccessManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class LosDiagram
extends JPanel
implements CidsWindowSearch,
CidsBeanDropListener {
    private static Logger LOG = Logger.getLogger(LosDiagram.class);
    private MassnahmenHistoryListModel model;
    private int index;
    private CidsBean bean;
    private JScrollPane jScrollPane1;
    private JLabel lblImage;
    private JLabel lblPlan;
    private JLabel lblPlanlab;
    private JPanel panDetail;
    private JPanel panLos;
    private JPanel panOverview;

    public LosDiagram() {
        block2: {
            this.model = new MassnahmenHistoryListModel();
            this.index = 0;
            this.initComponents();
            this.setName("Losverteilung");
            this.panDetail.setVisible(false);
            try {
                new CidsBeanDropTarget((Component)this);
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"Error while creating CidsBeanDropTarget", (Throwable)ex);
            }
        }
    }

    private void initComponents() {
        this.panOverview = new JPanel();
        this.lblPlanlab = new JLabel();
        this.lblPlan = new JLabel();
        this.lblImage = new JLabel();
        this.panDetail = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.panLos = new JPanel();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                LosDiagram.this.formComponentResized(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        this.panOverview.setLayout(new GridBagLayout());
        this.lblPlanlab.setText(NbBundle.getMessage(LosDiagram.class, (String)"LosDiagram.lblPlanlab.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panOverview.add((Component)this.lblPlanlab, gridBagConstraints);
        this.lblPlan.setText(NbBundle.getMessage(LosDiagram.class, (String)"LosDiagram.lblPlan.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panOverview.add((Component)this.lblPlan, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 5, 0);
        this.add((Component)this.panOverview, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.lblImage, gridBagConstraints);
        this.panDetail.setLayout(new BorderLayout());
        this.jScrollPane1.setOpaque(false);
        this.panLos.setOpaque(false);
        this.panLos.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.panLos);
        this.panDetail.add((Component)this.jScrollPane1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.panDetail, gridBagConstraints);
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.bean != null) {
            this.drawDiagram(this.bean);
        }
    }

    public JComponent getSearchWindowComponent() {
        return this;
    }

    public MetaObjectNodeServerSearch getServerSearch() {
        return null;
    }

    public ImageIcon getIcon() {
        MetaClass los = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"gup_los");
        return new ImageIcon(los.getIconData());
    }

    public void beansDropped(ArrayList<CidsBean> beans) {
        CidsBean bean;
        if (beans != null && beans.size() > 0 && (bean = beans.get(0)).getClass().getName().equals("de.cismet.cids.dynamics.Gup_planungsabschnitt")) {
            this.lblPlan.setText(bean.toString());
            this.bean = bean;
            this.drawDiagram(bean);
        }
    }

    private void drawDiagram(CidsBean bean) {
        String url = "http://chart.googleapis.com/chart?cht=p3&";
        int width = this.getWidth();
        int height = this.getHeight() / 2;
        String data = "chd=t:";
        String label = "";
        HashMap<Object, MassnType> dataMap = new HashMap<Object, MassnType>();
        this.lblPlanlab.setText("Planungsabschnitt");
        if (width < 250) {
            width = 250;
        }
        if (height < 100) {
            height = 100;
        }
        if (width * height > 300000) {
            double quot = Math.sqrt((double)(width * height) / 300000.0);
            width = (int)((double)width / quot);
            height = (int)((double)height / quot);
        }
        String size = "chs=" + width + "x" + height;
        List beans = bean.getBeanCollectionProperty("massnahmen");
        for (CidsBean maBean : beans) {
            MassnType type;
            Object id = (Integer)maBean.getProperty("los.id");
            if (id == null) {
                id = -1;
            }
            if ((type = (MassnType)dataMap.get(id)) == null) {
                type = (Integer)id == -1 ? new MassnType("nicht zugewiesen", null) : new MassnType((String)maBean.getProperty("los.bezeichnung"), (CidsBean)maBean.getProperty("los"));
                dataMap.put(id, type);
            }
            type.increaseCounter();
            type.addMassnBean(maBean);
        }
        Set keys = dataMap.keySet();
        boolean first = true;
        this.index = 0;
        this.panDetail.setVisible(true);
        this.panLos.removeAll();
        for (Integer key : keys) {
            MassnType type = (MassnType)dataMap.get(key);
            if (first) {
                first = false;
                data = data + type.getCounter();
                label = label + type.getName();
            } else {
                data = data + "," + type.getCounter();
                label = label + "|" + type.getName();
            }
            this.addLos(type);
        }
        try {
            url = url + size;
            url = url + "&" + data;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("url: " + url));
            }
            this.lblImage.setIcon(this.getImageIconFromUrl(url));
        }
        catch (Exception e) {
            LOG.error((Object)"Error while trying to retrieve the chart.", (Throwable)e);
        }
    }

    private ImageIcon getImageIconFromUrl(String url) throws Exception {
        WebAccessManager wam = WebAccessManager.getInstance();
        InputStream is = wam.doRequest(new URL(url));
        ImageInputStream iis = ImageIO.createImageInputStream(is);
        Iterator<ImageReader> itReader = ImageIO.getImageReaders(iis);
        ImageReader reader = itReader.next();
        ImageReadParam param = reader.getDefaultReadParam();
        reader.setInput(iis, true, true);
        try {
            BufferedImage image = reader.read(0, param);
            ImageIcon imageIcon = new ImageIcon(image);
            return imageIcon;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            reader.dispose();
            iis.close();
        }
    }

    private void addLos(MassnType type) {
        GridBagConstraints constraint = new GridBagConstraints(0, ++this.index, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 5, 2, 5), 0, 0);
        LosPanel los = new LosPanel();
        los.setBeans(type.getLos(), type.getMassnBeans());
        this.panLos.add((Component)los, constraint);
    }

    private class MassnType {
        private String name;
        private int counter = 0;
        private CidsBean los;
        private List<CidsBean> massnBeans = new ArrayList<CidsBean>();

        public MassnType(String name, CidsBean los) {
            this.name = name;
            this.los = los;
        }

        public void increaseCounter() {
            ++this.counter;
        }

        public void addMassnBean(CidsBean massnBean) {
            this.getMassnBeans().add(massnBean);
        }

        public int getCounter() {
            return this.counter;
        }

        public String getName() {
            return this.name;
        }

        public CidsBean getLos() {
            return this.los;
        }

        public List<CidsBean> getMassnBeans() {
            return this.massnBeans;
        }
    }
}

