/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.tools.CismetThreadPool;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdesktop.observablecollections.ObservableList;
import org.jdesktop.observablecollections.ObservableListListener;

public class MassnBezugListListener
implements ObservableListListener {
    private static final Logger LOG = Logger.getLogger(MassnBezugListListener.class);
    private static final MetaClass MASSNAHMEN_BEZEICHNUNG = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"GUP_MASSNAHMENBEZUG");
    private static final transient ReentrantReadWriteLock MASSNAHMEN_BEZEICHNUNG_LOCK = new ReentrantReadWriteLock();
    private static HashMap<Integer, CidsBean> MASSNAHMEN_BEZEICHNUNGEN = new HashMap();
    protected static int waitingOperations;
    protected CidsBean cidsBean;
    protected String collectionPropertyName;
    protected int kindId;

    public MassnBezugListListener(int kindId, CidsBean cidsBean, String collectionPropertyName) {
        this.kindId = kindId;
        this.cidsBean = cidsBean;
        this.collectionPropertyName = collectionPropertyName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listElementsAdded(ObservableList list, int index, int length) {
        if (length == 1) {
            List all = this.cidsBean.getBeanCollectionProperty(this.collectionPropertyName);
            final CidsBean bean = (CidsBean)list.get(index);
            all.add(bean);
            try {
                MassnBezugListListener massnBezugListListener = this;
                synchronized (massnBezugListListener) {
                    ++waitingOperations;
                }
                CismetThreadPool.execute((Runnable)new SwingWorker<CidsBean, Void>(){

                    @Override
                    protected CidsBean doInBackground() throws Exception {
                        CidsBean res = null;
                        MASSNAHMEN_BEZEICHNUNG_LOCK.readLock().lock();
                        try {
                            res = (CidsBean)MASSNAHMEN_BEZEICHNUNGEN.get(MassnBezugListListener.this.kindId);
                        }
                        finally {
                            MASSNAHMEN_BEZEICHNUNG_LOCK.readLock().unlock();
                        }
                        return res;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void done() {
                        try {
                            Object kind = (CidsBean)this.get();
                            if (kind != null) {
                                bean.setProperty("wo", kind);
                            } else {
                                LOG.error((Object)("Massnahmenbezeichnung whith id " + MassnBezugListListener.this.kindId + " does not exist."));
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Problem beim Suchen der Massnahmenbezeichnungen", (Throwable)e);
                        }
                        finally {
                            2 var1_3 = this;
                            synchronized (var1_3) {
                                --waitingOperations;
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot set the wo attribute of an object of the type massnahme.", (Throwable)e);
            }
        } else {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public void listElementsRemoved(ObservableList list, int index, List oldElements) {
        List all = this.cidsBean.getBeanCollectionProperty(this.collectionPropertyName);
        for (Object b : oldElements) {
            all.remove((CidsBean)b);
        }
    }

    public void listElementReplaced(ObservableList list, int index, Object oldElement) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void listElementPropertyChanged(ObservableList list, int index) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static synchronized boolean isReady() {
        return waitingOperations == 0;
    }

    static {
        CismetThreadPool.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MASSNAHMEN_BEZEICHNUNG_LOCK.writeLock().lock();
                try {
                    MetaObject[] metaObjects;
                    String query = "select " + MASSNAHMEN_BEZEICHNUNG.getID() + ", " + MASSNAHMEN_BEZEICHNUNG.getPrimaryKey() + " from " + MASSNAHMEN_BEZEICHNUNG.getTableName();
                    for (MetaObject mo : metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0)) {
                        MASSNAHMEN_BEZEICHNUNGEN.put(mo.getId(), mo.getBean());
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"error", (Throwable)e);
                }
                finally {
                    MASSNAHMEN_BEZEICHNUNG_LOCK.writeLock().unlock();
                }
            }
        });
    }
}

