/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import de.cismet.cids.custom.wrrl_db_mv.util.gup.LineBand;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.LineBandMember;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.MassnStationComparator;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.MassnahmenBandMember;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.UnterhaltungsmassnahmeValidator;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.tools.gui.jbands.interfaces.BandMember;
import de.cismet.tools.gui.jbands.interfaces.BandSnappingPointProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class MassnahmenBand
extends LineBand
implements BandSnappingPointProvider {
    private int measureType;
    private UnterhaltungsmassnahmeValidator uv = null;
    private Boolean invertSide = false;

    public MassnahmenBand(String title, String objectTableName, Boolean invertSide) {
        this(1.0f, title, objectTableName, invertSide);
    }

    public MassnahmenBand(float heightWeight, String objectTableName, Boolean invertSide) {
        super(heightWeight, objectTableName);
        this.setOnlyAcceptNewBeanWithValue(false);
        this.invertSide = invertSide;
    }

    public MassnahmenBand(float heightWeight, String title, String objectTableName, Boolean invertSide) {
        super(heightWeight, title, objectTableName);
        this.setOnlyAcceptNewBeanWithValue(false);
        this.invertSide = invertSide;
    }

    @Override
    protected LineBandMember createBandMemberFromBean() {
        MassnahmenBandMember m = new MassnahmenBandMember(this, this.readOnly, this.uv, this.invertSide);
        return m;
    }

    public void setMeasureType(int measureType) {
        this.measureType = measureType;
    }

    public int getMeasureType() {
        return this.measureType;
    }

    public int getKompartiment() {
        if (this.measureType == 2 || this.measureType == 1) {
            return 2;
        }
        if (this.measureType == 3 || this.measureType == 4) {
            return 3;
        }
        return 1;
    }

    public void setUnterhaltungsmassnahmeValidator(UnterhaltungsmassnahmeValidator uv) {
        this.uv = uv;
        for (int i = 0; i < this.getNumberOfMembers(); ++i) {
            MassnahmenBandMember bm = (MassnahmenBandMember)this.getMember(i);
            bm.setUnterhaltungsmassnahmeValidator(uv);
        }
    }

    public void showNumbers(int firstNumber) {
        int number = firstNumber;
        HashMap<CidsBean, MassnahmenBandMember> beanToMember = new HashMap<CidsBean, MassnahmenBandMember>();
        ArrayList<CidsBean> beans = new ArrayList<CidsBean>();
        for (BandMember member : this.members) {
            if (!(member instanceof MassnahmenBandMember)) continue;
            CidsBean bean = ((MassnahmenBandMember)member).getCidsBean();
            beans.add(bean);
            beanToMember.put(bean, (MassnahmenBandMember)member);
        }
        Collections.sort(beans, new MassnStationComparator());
        for (CidsBean bean : beans) {
            MassnahmenBandMember member = (MassnahmenBandMember)beanToMember.get(bean);
            if (member == null) continue;
            member.setText(String.valueOf(number++));
        }
    }

    public void hideNumbers() {
        for (BandMember member : this.members) {
            if (!(member instanceof MassnahmenBandMember)) continue;
            ((MassnahmenBandMember)member).setText("");
        }
    }
}

