/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import Sirius.navigator.tools.CacheException;
import Sirius.navigator.tools.MetaObjectCache;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.GupUnterhaltungsmassnahmeEditor;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.ExtendedMattePainter;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.LineBandMember;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.MassnahmenBand;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.UnterhaltungsmassnahmeValidator;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.PinstripePainter;
import org.jdesktop.swingx.painter.RectanglePainter;

public class MassnahmenBandMember
extends LineBandMember
implements CidsBeanDropListener {
    private static final MetaClass MASSNAHMEN_ART = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"gup_massnahmenart");
    private static final ConnectionContext cc = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.EDITOR, (String)"Gepp-Massnahme");
    private List<String> errorList;
    private UnterhaltungsmassnahmeValidator.ValidationResult res;
    private UnterhaltungsmassnahmeValidator uv;
    private boolean invertSide;
    private boolean multiColorAllowed;

    public MassnahmenBandMember(MassnahmenBand parent, boolean readOnly, UnterhaltungsmassnahmeValidator uv, Boolean invertSide) {
        block4: {
            super(parent, readOnly);
            this.invertSide = false;
            this.multiColorAllowed = true;
            this.uv = uv;
            if (invertSide != null) {
                this.invertSide = invertSide;
            } else {
                this.multiColorAllowed = false;
            }
            try {
                new CidsBeanDropTarget((Component)((Object)this));
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)"Error while creating CidsBeanDropTarget", (Throwable)ex);
            }
        }
    }

    @Override
    public void setCidsBean(CidsBean cidsBean) {
        super.setCidsBean(cidsBean);
        this.setToolTip();
        this.validateBean();
    }

    public void setUnterhaltungsmassnahmeValidator(UnterhaltungsmassnahmeValidator uv) {
        this.uv = uv;
        this.validateBean();
    }

    private void validateBean() {
        if (this.uv != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    final ArrayList<String> errorList = new ArrayList<String>();
                    final UnterhaltungsmassnahmeValidator.ValidationResult res = MassnahmenBandMember.this.uv.validate(MassnahmenBandMember.this.getCidsBean(), errorList);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MassnahmenBandMember.this.errorList = errorList;
                            MassnahmenBandMember.this.res = res;
                            MassnahmenBandMember.this.determineBackgroundColour();
                            MassnahmenBandMember.this.setToolTip();
                        }
                    });
                }
            }).start();
        }
    }

    private void setToolTip() {
        if (this.res == null || this.res == UnterhaltungsmassnahmeValidator.ValidationResult.ok) {
            if (this.bean.getProperty("massnahme.name") != null) {
                this.setToolTipText(this.bean.getProperty("massnahme.name") + "");
            } else {
                this.setToolTipText("");
            }
        } else {
            StringBuilder text = new StringBuilder("<html>" + this.bean.getProperty("massnahme.name"));
            if (this.errorList != null) {
                if (this.errorList.size() > 0) {
                    text.append("<br />");
                }
                for (String tmp : this.errorList) {
                    text.append(tmp).append("<br />");
                }
            }
            text.append("</html>");
            if (this.bean.getProperty("massnahme.name") != null) {
                this.setToolTipText(this.bean.getProperty("massnahme.name") + "");
            } else {
                this.setToolTipText("");
            }
        }
    }

    @Override
    protected void determineBackgroundColour() {
        if (this.bean.getProperty("massnahme") == null || this.bean.getProperty("massnahme.gewerk") == null || this.bean.getProperty("massnahme.gewerk.color") == null) {
            this.setDefaultBackground();
            return;
        }
        String color = (String)this.bean.getProperty("massnahme.gewerk.color");
        double factor = 0.0;
        Color secondColor = new Color(255, 66, 66);
        if (this.multiColorAllowed) {
            if (this.bean.getProperty("massnahme.einsatzvariante.factor") != null) {
                factor = (Double)this.bean.getProperty("massnahme.einsatzvariante.factor");
            }
            if (this.bean.getProperty("massnahme.einsatzvariante.color") != null) {
                String secColorString = (String)this.bean.getProperty("massnahme.einsatzvariante.color");
                secondColor = Color.decode(secColorString);
            }
        }
        if (color != null) {
            try {
                String auflagenNb = (String)this.bean.getProperty("auflagen_nb");
                String auflagenWb = (String)this.bean.getProperty("auflagen_wb");
                auflagenNb = auflagenNb != null && auflagenNb.equals("") ? null : auflagenNb;
                String string = auflagenWb = auflagenWb != null && auflagenWb.equals("") ? null : auflagenWb;
                if (this.res == null || this.res == UnterhaltungsmassnahmeValidator.ValidationResult.ok) {
                    if (auflagenNb != null || auflagenWb != null) {
                        this.setBackgroundPainter((Painter)new CompoundPainter(new Painter[]{new ExtendedMattePainter(Color.decode(color), secondColor, factor, this.invertSide), new PinstripePainter((Paint)new Color(255, 255, 255), 90.0, 2.0, 5.0)}));
                    } else {
                        this.setBackgroundPainter((Painter)new ExtendedMattePainter(Color.decode(color), secondColor, factor, this.invertSide));
                    }
                } else {
                    Color validatorResultColor = new Color(255, 66, 66);
                    if (this.res == UnterhaltungsmassnahmeValidator.ValidationResult.warning) {
                        validatorResultColor = new Color(229, 240, 76);
                    }
                    if (auflagenNb != null || auflagenWb != null) {
                        this.setBackgroundPainter((Painter)new CompoundPainter(new Painter[]{new ExtendedMattePainter(Color.decode(color), secondColor, factor, this.invertSide), new PinstripePainter((Paint)validatorResultColor, 45.0, 2.0, 5.0), new PinstripePainter((Paint)new Color(255, 255, 255), 90.0, 2.0, 5.0)}));
                    } else {
                        this.setBackgroundPainter((Painter)new CompoundPainter(new Painter[]{new ExtendedMattePainter(Color.decode(color), secondColor, factor, this.invertSide), new PinstripePainter((Paint)validatorResultColor, 45.0, 2.0, 5.0)}));
                    }
                }
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"Error while parsing the color.", (Throwable)e);
                this.setDefaultBackground();
            }
        }
        this.unselectedBackgroundPainter = this.getBackgroundPainter();
        this.selectedBackgroundPainter = new CompoundPainter(new Painter[]{this.unselectedBackgroundPainter, new RectanglePainter(3, 3, 3, 3, 3, 3, true, (Paint)new Color(100, 100, 100, 100), 2.0f, (Paint)new Color(50, 50, 50, 100))});
        this.setSelected(this.isSelected);
    }

    @Override
    protected void setDefaultBackground() {
        String auflagenNb = (String)this.bean.getProperty("auflagen_nb");
        String auflagenWb = (String)this.bean.getProperty("auflagen_wb");
        auflagenNb = auflagenNb != null && auflagenNb.equals("") ? null : auflagenNb;
        auflagenWb = auflagenWb != null && auflagenWb.equals("") ? null : auflagenWb;
        this.unselectedBackgroundPainter = new MattePainter((Paint)new Color(229, 0, 0));
        this.selectedBackgroundPainter = new CompoundPainter(new Painter[]{this.unselectedBackgroundPainter, new RectanglePainter(3, 3, 3, 3, 3, 3, true, (Paint)new Color(100, 100, 100, 100), 2.0f, (Paint)new Color(50, 50, 50, 100))});
        if (this.res == null || this.res == UnterhaltungsmassnahmeValidator.ValidationResult.ok) {
            if (auflagenNb != null || auflagenWb != null) {
                this.setBackgroundPainter((Painter)new CompoundPainter(new Painter[]{this.unselectedBackgroundPainter, new PinstripePainter((Paint)new Color(255, 255, 255), 90.0, 2.0, 5.0)}));
            } else {
                this.setBackgroundPainter(this.unselectedBackgroundPainter);
            }
        } else if (auflagenNb != null || auflagenWb != null) {
            this.setBackgroundPainter((Painter)new CompoundPainter(new Painter[]{this.unselectedBackgroundPainter, new PinstripePainter((Paint)new Color(255, 66, 66), 45.0, 2.0, 5.0), new PinstripePainter((Paint)new Color(255, 255, 255), 90.0, 2.0, 5.0)}));
        } else {
            this.setBackgroundPainter((Painter)new CompoundPainter(new Painter[]{this.unselectedBackgroundPainter, new PinstripePainter((Paint)new Color(255, 66, 66), 45.0, 2.0, 5.0)}));
        }
        this.unselectedBackgroundPainter = this.getBackgroundPainter();
        this.selectedBackgroundPainter = new CompoundPainter(new Painter[]{this.unselectedBackgroundPainter, new RectanglePainter(3, 3, 3, 3, 3, 3, true, (Paint)new Color(100, 100, 100, 100), 2.0f, (Paint)new Color(50, 50, 50, 100))});
        if (this.isSelected) {
            this.setBackgroundPainter(this.selectedBackgroundPainter);
        } else {
            this.setBackgroundPainter(this.unselectedBackgroundPainter);
        }
    }

    private void setMassnahme(int id) {
        MetaObject[] metaObjects = null;
        try {
            String query = "select " + MASSNAHMEN_ART.getID() + "," + MASSNAHMEN_ART.getPrimaryKey() + " from " + MASSNAHMEN_ART.getTableName() + " where id = " + id;
            metaObjects = MetaObjectCache.getInstance().getMetaObjectsByQuery(query, MASSNAHMEN_ART, false, cc);
        }
        catch (CacheException query) {
            // empty catch block
        }
        CidsBean b = null;
        if (metaObjects != null) {
            for (void var7_9 : metaObjects) {
                if (!var7_9.getBean().getProperty("id").equals(id)) continue;
                b = var7_9.getBean();
                break;
            }
        }
        try {
            this.bean.setProperty("massnahme", b);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while setting property massnahme.", (Throwable)e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("massnahme")) {
            this.determineBackgroundColour();
            this.setSelected(this.isSelected);
            this.setToolTip();
            this.validateBean();
        } else {
            super.propertyChange(evt);
            this.validateBean();
        }
    }

    @Override
    protected CidsBean cloneBean(CidsBean bean) throws Exception {
        return CidsBeanSupport.cloneCidsBean(bean, false);
    }

    public void beansDropped(ArrayList<CidsBean> beans) {
        if (this.isReadOnly()) {
            return;
        }
        CidsBean cidsBean = this.getCidsBean();
        if (cidsBean != null) {
            for (CidsBean bean : beans) {
                if (!bean.getClass().getName().equals("de.cismet.cids.dynamics.Gup_massnahmenart")) continue;
                try {
                    if (GupUnterhaltungsmassnahmeEditor.supportsKompartiment(bean, ((MassnahmenBand)this.getParentBand()).getKompartiment())) {
                        cidsBean.setProperty("massnahme", (Object)bean);
                        GupUnterhaltungsmassnahmeEditor.getHistoryModel().addElement(bean);
                        continue;
                    }
                    JOptionPane.showMessageDialog((Component)((Object)this), "Die ausgew\u00e4hlte Ma\u00dfnahme ist f\u00fcr das aktuelle Kompartiment nicht g\u00fcltig.", "Ung\u00fcltige Ma\u00dfnahme", 0);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while saving the new massnahme property", (Throwable)e);
                }
            }
        }
    }
}

