/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.tools.MetaObjectCache;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.GupUnterhaltungsmassnahmeEditor;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.tools.CismetThreadPool;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.log4j.Logger;

public class MassnahmenHistoryListModel
implements ListModel {
    private static final Logger LOG = Logger.getLogger(MassnahmenHistoryListModel.class);
    public MetaClass MASSNAHMEN_TYP_MC;
    private List<CidsBean> list = new ArrayList<CidsBean>();
    private List<ListDataListener> listener = new ArrayList<ListDataListener>();
    private CidsBean userHistory;

    public MassnahmenHistoryListModel() {
        try {
            this.MASSNAHMEN_TYP_MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"gup_massnahmen_historie");
            User user = SessionManager.getSession().getUser();
            String query = "select distinct " + this.MASSNAHMEN_TYP_MC.getID() + ", " + this.MASSNAHMEN_TYP_MC.getPrimaryKey() + " from " + this.MASSNAHMEN_TYP_MC.getTableName() + " where username = '" + user.getName() + "@" + user.getDomain() + "'";
            MetaObject[] metaObjects = MetaObjectCache.getInstance().getMetaObjectsByQuery(query, "WRRL_DB_MV");
            if (metaObjects != null && metaObjects.length == 1) {
                this.userHistory = metaObjects[0].getBean();
            } else {
                this.userHistory = CidsBeanSupport.createNewCidsBeanFromTableName("gup_massnahmen_historie");
                this.userHistory.setProperty("username", (Object)(user.getName() + "@" + user.getDomain()));
            }
            List<CidsBean> history = CidsBeanSupport.getBeanCollectionFromProperty(this.userHistory, "massnahmenarten");
            if (history != null) {
                for (CidsBean tmp : history) {
                    this.list.add(tmp);
                }
            }
            this.fireListDataListener();
            GupUnterhaltungsmassnahmeEditor.setHistoryModel(this);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while loading history.", (Throwable)e);
        }
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    public Object getElementAt(int index) {
        return this.list.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listener.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listener.remove(l);
    }

    public void addElement(CidsBean b) {
        if (this.list.contains(b)) {
            this.list.remove(b);
        }
        if (this.list.size() > 0) {
            this.list.add(this.list.get(this.list.size() - 1));
            for (int i = this.list.size() - 1; i > 0; --i) {
                this.list.set(i, this.list.get(i - 1));
            }
            this.list.set(0, b);
        } else {
            this.list.add(b);
        }
        this.fireListDataListener();
        CismetThreadPool.executeSequentially((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    List<CidsBean> history = CidsBeanSupport.getBeanCollectionFromProperty(MassnahmenHistoryListModel.this.userHistory, "massnahmenarten");
                    history.clear();
                    if (MassnahmenHistoryListModel.this.list.size() <= 10) {
                        history.addAll(MassnahmenHistoryListModel.this.list);
                    } else {
                        history.addAll(MassnahmenHistoryListModel.this.list.subList(0, 10));
                    }
                    MassnahmenHistoryListModel.this.userHistory = MassnahmenHistoryListModel.this.userHistory.persist();
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while saving history.", (Throwable)e);
                }
            }
        });
    }

    public void clean() {
        this.list.clear();
        this.fireListDataListener();
        CismetThreadPool.executeSequentially((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    List<CidsBean> history = CidsBeanSupport.getBeanCollectionFromProperty(MassnahmenHistoryListModel.this.userHistory, "massnahmenarten");
                    history.clear();
                    MassnahmenHistoryListModel.this.userHistory = MassnahmenHistoryListModel.this.userHistory.persist();
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while saving history.", (Throwable)e);
                }
            }
        });
    }

    private void fireListDataListener() {
        ListDataEvent e = new ListDataEvent(this, 0, 0, this.list.size());
        for (ListDataListener tmp : this.listener) {
            tmp.contentsChanged(e);
        }
    }
}

