/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import Sirius.navigator.tools.MetaObjectCache;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.custom.wrrl_db_mv.util.ScrollableComboBox;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.CismetThreadPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ExecutionException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class OperativeZieleComboBox
extends ScrollableComboBox {
    private static final Logger log = Logger.getLogger(OperativeZieleComboBox.class);
    private static final MetaClass MC = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"gup_operatives_ziel");
    private static MetaObject[] metaObjects = null;
    private static final ConnectionContext cc = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.EDITOR, (String)"Operative Ziele");
    private int kompartiment;

    private void init(final MetaClass mc) {
        if (!this.isFakeModel()) {
            if (metaObjects == null) {
                CismetThreadPool.execute((Runnable)new SwingWorker<DefaultComboBoxModel, Void>(){

                    @Override
                    protected DefaultComboBoxModel doInBackground() throws Exception {
                        return OperativeZieleComboBox.this.getModelByMetaClass(mc);
                    }

                    @Override
                    protected void done() {
                        try {
                            CidsBean bean = (CidsBean)OperativeZieleComboBox.this.getSelectedItem();
                            OperativeZieleComboBox.this.setModel((ComboBoxModel)this.get());
                            OperativeZieleComboBox.this.setSelectedItem(bean);
                        }
                        catch (InterruptedException bean) {
                        }
                        catch (ExecutionException executionException) {
                            log.error((Object)"Error while initializing the model of a referenceCombo", (Throwable)executionException);
                        }
                    }
                });
            } else {
                try {
                    CidsBean bean = (CidsBean)this.getSelectedItem();
                    this.setModel(this.getModelByMetaClass(mc));
                    this.setSelectedItem(bean);
                }
                catch (InterruptedException bean) {
                }
                catch (Exception ex) {
                    log.error((Object)"Error while initializing the model of a referenceCombo", (Throwable)ex);
                }
            }
        }
    }

    private DefaultComboBoxModel getModelByMetaClass(MetaClass mc) throws Exception {
        if (metaObjects == null) {
            String query = "select " + mc.getID() + "," + mc.getPrimaryKey() + " from " + mc.getTableName();
            metaObjects = MetaObjectCache.getInstance().getMetaObjectsByQuery(query, mc, false, cc);
        }
        ArrayList<CidsBean> cbv = new ArrayList<CidsBean>(metaObjects.length);
        for (MetaObject mo : metaObjects) {
            if (!OperativeZieleComboBox.isRelevantBean(this.kompartiment, mo.getBean())) continue;
            cbv.add(mo.getBean());
        }
        Collections.sort(cbv, new BeanComparator());
        return new DefaultComboBoxModel<Object>(cbv.toArray());
    }

    public static boolean isRelevantBean(int kompartiment, CidsBean bean) {
        String kompartimentProp = "ufer";
        if (kompartiment == -1) {
            return true;
        }
        if (kompartiment == 2) {
            kompartimentProp = "sohle";
        } else if (kompartiment == 3) {
            kompartimentProp = "umfeld";
        }
        Boolean hasRightType = (Boolean)bean.getProperty(kompartimentProp);
        return hasRightType != null && hasRightType != false;
    }

    public int getKompartiment() {
        return this.kompartiment;
    }

    public void setKompartiment(int kompartiment) {
        if (this.kompartiment != kompartiment) {
            this.kompartiment = kompartiment;
            this.init(MC);
        } else {
            this.setSelectedItem(this.getSelectedItem());
        }
    }

    public MetaClass getMetaClass() {
        return MC;
    }

    protected static final class BeanComparator
    implements Comparator<CidsBean> {
        protected BeanComparator() {
        }

        @Override
        public int compare(CidsBean o1, CidsBean o2) {
            String s1 = o1 == null ? "" : o1.toString();
            String s2 = o2 == null ? "" : o2.toString();
            return s1.compareToIgnoreCase(s2);
        }
    }
}

