/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import de.cismet.cids.dynamics.CidsBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openide.util.NbBundle;

public class PflegezieleValidator {
    private Collection<CidsBean> entwicklungsziele;
    private Collection<CidsBean> situationstypen;

    public Collection<CidsBean> getEntwicklungsziele() {
        return this.entwicklungsziele;
    }

    public void setEntwicklungsziele(Collection<CidsBean> entwicklungsziele) {
        this.entwicklungsziele = entwicklungsziele;
    }

    public Collection<CidsBean> getSituationstypen() {
        return this.situationstypen;
    }

    public void setSituationstypen(Collection<CidsBean> situationstypen) {
        this.situationstypen = situationstypen;
    }

    public boolean isReady() {
        return this.situationstypen != null && this.entwicklungsziele != null;
    }

    public ValidationResult validate(CidsBean bean, List<String> errors) {
        return this.validate(bean, (CidsBean)bean.getProperty("operatives_ziel"), errors);
    }

    public ValidationResult validate(CidsBean abschnittBean, CidsBean pflegeziel, List<String> errors) {
        while (!this.isReady()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        ValidationResult res = ValidationResult.ok;
        double von = (Double)abschnittBean.getProperty("linie.von.wert");
        double bis = (Double)abschnittBean.getProperty("linie.bis.wert");
        if (pflegeziel == null) {
            return ValidationResult.error;
        }
        List entBeans = pflegeziel.getBeanCollectionProperty("entwicklungsziele");
        for (CidsBean mo : this.entwicklungsziele) {
            if (!this.isLineInsideBean(mo, von, bis) || entBeans != null && entBeans.contains((CidsBean)mo.getProperty("name_bezeichnung"))) continue;
            CidsBean ent = (CidsBean)mo.getProperty("name_bezeichnung");
            if (ent != null) {
                errors.add(NbBundle.getMessage(PflegezieleValidator.class, (String)"PflegezieleValidator.validate.invalidDevelopmentTarget", (Object)ent));
            } else {
                errors.add(NbBundle.getMessage(PflegezieleValidator.class, (String)"PflegezieleValidator.validate.DevelopmentTargetWithoutValue"));
            }
            res = ValidationResult.error;
        }
        List ueBeans = pflegeziel.getBeanCollectionProperty("unterhaltungserfordernisse");
        for (CidsBean mo : this.situationstypen) {
            if (!this.isLineInsideBean(mo, von, bis) || ueBeans != null && ueBeans.contains((CidsBean)mo.getProperty("name_beschreibung"))) continue;
            CidsBean ue = (CidsBean)mo.getProperty("name_beschreibung");
            if (ue != null) {
                errors.add(NbBundle.getMessage(PflegezieleValidator.class, (String)"PflegezieleValidator.validate.invalidSituationType", (Object)ue));
            } else {
                errors.add(NbBundle.getMessage(PflegezieleValidator.class, (String)"PflegezieleValidator.validate.SituationTypeWithoutValue"));
            }
            res = ValidationResult.error;
        }
        return res;
    }

    public List<CidsBean> getSituationstypIntersectingPflegezielAbschnitt(CidsBean abschnittBean) {
        while (!this.isReady()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        ArrayList<CidsBean> situationTypList = new ArrayList<CidsBean>();
        double von = (Double)abschnittBean.getProperty("linie.von.wert");
        double bis = (Double)abschnittBean.getProperty("linie.bis.wert");
        for (CidsBean mo : this.situationstypen) {
            CidsBean bean;
            if (!this.isLineInsideBean(mo, von, bis) || (bean = (CidsBean)mo.getProperty("name_beschreibung")) == null) continue;
            situationTypList.add(bean);
        }
        return situationTypList;
    }

    public List<CidsBean> getEntwicklungszielIntersectingPflegezielAbschnitt(CidsBean abschnittBean) {
        while (!this.isReady()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        ArrayList<CidsBean> EntwicklungszielList = new ArrayList<CidsBean>();
        double von = (Double)abschnittBean.getProperty("linie.von.wert");
        double bis = (Double)abschnittBean.getProperty("linie.bis.wert");
        for (CidsBean mo : this.entwicklungsziele) {
            CidsBean bean;
            if (!this.isLineInsideBean(mo, von, bis) || (bean = (CidsBean)mo.getProperty("name_bezeichnung")) == null) continue;
            EntwicklungszielList.add(bean);
        }
        return EntwicklungszielList;
    }

    private boolean isLineInsideBean(CidsBean moBean, double fromBean, double untilBean) {
        double von = (Double)moBean.getProperty("linie.von.wert");
        double bis = (Double)moBean.getProperty("linie.bis.wert");
        long vonRounded = Math.min(Math.round(von), Math.round(bis));
        long bisRounded = Math.max(Math.round(von), Math.round(bis));
        long fromBeanRounded = Math.min(Math.round(fromBean), Math.round(untilBean));
        long untilBeanRounded = Math.max(Math.round(fromBean), Math.round(untilBean));
        return vonRounded < fromBeanRounded && bisRounded > fromBeanRounded || vonRounded < untilBeanRounded && bisRounded > untilBeanRounded || vonRounded >= fromBeanRounded && bisRounded <= untilBeanRounded;
    }

    public static enum ValidationResult {
        ok,
        warning,
        error;

    }
}

