/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.LineBandMember;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.PoiRWBand;
import de.cismet.cids.dynamics.CidsBean;
import java.awt.Color;
import java.awt.Paint;
import java.beans.PropertyChangeEvent;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.RectanglePainter;

public class PoiRWBandMember
extends LineBandMember {
    public PoiRWBandMember(PoiRWBand parent) {
        super(parent);
        this.lineFieldName = "linie";
    }

    public PoiRWBandMember(PoiRWBand parent, boolean readOnly) {
        super(parent, readOnly);
        this.lineFieldName = "linie";
    }

    @Override
    public void setCidsBean(CidsBean cidsBean) {
        super.setCidsBean(cidsBean);
        String name = this.getKind();
        if (name == null || name.equals("null")) {
            name = "";
        }
        this.setToolTipText(name);
        this.setText(name);
    }

    @Override
    protected void determineBackgroundColour() {
        if (this.bean.getProperty("art") == null || this.bean.getProperty("art.color") == null) {
            this.setDefaultBackground();
            return;
        }
        String color = (String)this.bean.getProperty("art.color");
        if (color != null) {
            try {
                this.setBackgroundPainter((Painter)new MattePainter((Paint)Color.decode(color)));
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"Error while parsing the color.", (Throwable)e);
                this.setDefaultBackground();
            }
        }
        this.unselectedBackgroundPainter = this.getBackgroundPainter();
        this.selectedBackgroundPainter = new CompoundPainter(new Painter[]{this.unselectedBackgroundPainter, new RectanglePainter(3, 3, 3, 3, 3, 3, true, (Paint)new Color(100, 100, 100, 100), 2.0f, (Paint)new Color(50, 50, 50, 100))});
        this.setBackgroundPainter(this.unselectedBackgroundPainter);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("art")) {
            String name = this.getKind();
            this.determineBackgroundColour();
            this.setSelected(this.isSelected);
            if (name == null) {
                name = "unbekannt";
            }
            this.setToolTipText(name);
            this.setText(name);
        } else {
            super.propertyChange(evt);
        }
    }

    @Override
    protected CidsBean cloneBean(CidsBean bean) throws Exception {
        return CidsBeanSupport.cloneCidsBean(bean, false);
    }

    private String getKind() {
        String kind = (String)this.bean.getProperty("art.name");
        if (kind != null) {
            return kind;
        }
        return "";
    }
}

