/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.jbands.interfaces.BandMember;
import de.cismet.tools.gui.jbands.interfaces.BandMemberMouseListeningComponent;
import de.cismet.tools.gui.jbands.interfaces.Spot;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingWorker;

public class QuerbauwerkeMember
extends JLabel
implements BandMember,
Spot,
BandMemberMouseListeningComponent {
    protected String name = "";
    Color[] colors = new Color[]{new Color(106, 90, 205), new Color(255, 140, 0), new Color(139, 26, 26), new Color(255, 215, 0), new Color(0, 229, 238), new Color(255, 222, 173), new Color(255, 182, 193), new Color(211, 211, 211), new Color(255, 0, 255), new Color(244, 164, 96), new Color(255, 0, 0)};
    Geometry geom = null;
    private double station;
    private int art = 8;

    public QuerbauwerkeMember() {
    }

    public QuerbauwerkeMember(ArrayList result) {
        this.name = result.get(2) != null ? result.get(2).toString() : "unbekannt";
        if (result.get(1) != null) {
            this.art = (Integer)result.get(1) - 1;
        }
        this.station = (Double)result.get(3);
        this.setIcon(QuerbauwerkeMember.getIcon(this.getColor(), 10));
        this.setToolTipText(this.name);
        this.geom = (Geometry)result.get(4);
    }

    public JComponent getBandMemberComponent() {
        return this;
    }

    public double getMax() {
        return this.station;
    }

    public double getMin() {
        return this.station;
    }

    public double getPosition() {
        return this.station;
    }

    public static Icon getIcon(Color c, int size) {
        BufferedImage bi = new BufferedImage(size, size, 2);
        Graphics2D graphics = (Graphics2D)bi.getGraphics();
        graphics.setColor(c);
        graphics.fillOval(0, 0, size, size);
        return new ImageIcon(bi);
    }

    protected Color getColor() {
        return this.colors[this.art];
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            final MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
            XBoundingBox xbb = new XBoundingBox(this.geom.buffer(75.0));
            mc.gotoBoundingBoxWithHistory((BoundingBox)xbb);
            DefaultStyledFeature dsf = new DefaultStyledFeature();
            dsf.setGeometry(this.geom.buffer(10.0));
            dsf.setCanBeSelected(false);
            dsf.setLinePaint((Paint)Color.YELLOW);
            dsf.setLineWidth(6);
            final PFeature highlighter = new PFeature((Feature)dsf, mc);
            mc.getHighlightingLayer().addChild((PNode)highlighter);
            highlighter.animateToTransparency(0.1f, 2000L);
            CismetThreadPool.execute((Runnable)new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    Thread.currentThread();
                    Thread.sleep(2500L);
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        mc.getHighlightingLayer().removeChild((PNode)highlighter);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }
}

