/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.AbschnittsinfoMember;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.jbands.JBandCursorManager;
import de.cismet.tools.gui.jbands.interfaces.BandMember;
import de.cismet.tools.gui.jbands.interfaces.BandMemberMouseListeningComponent;
import de.cismet.tools.gui.jbands.interfaces.BandMemberSelectable;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.RectanglePainter;

public class ReadOnlyTextBandMember
extends AbschnittsinfoMember
implements BandMemberSelectable,
BandMemberMouseListeningComponent {
    private static final Logger LOG = Logger.getLogger(ReadOnlyTextBandMember.class);
    private CidsBean cidsBean;
    private boolean selected;
    private Painter unselectedBackgroundPainter;
    private Painter selectedBackgroundPainter;
    private String textProperty;
    private String lineFieldName = "linie";

    public ReadOnlyTextBandMember() {
        this.setMinimumSize(new Dimension(1, 7));
        this.setPreferredSize(this.getMinimumSize());
        this.setMemberBorder(true);
    }

    public void setCidsBean(CidsBean cidsBean, String tooltipProperty, String textProperty) {
        super.setCidsBean(cidsBean);
        this.cidsBean = cidsBean;
        this.textProperty = textProperty;
        if (tooltipProperty != null) {
            this.setToolTipText(cidsBean.getProperty(tooltipProperty) + "");
        } else {
            this.setToolTipText(cidsBean.toString());
        }
        this.determineBackgroundColour();
        if (textProperty == null) {
            this.setText(cidsBean.toString());
        } else {
            this.setText(String.valueOf(cidsBean.getProperty(textProperty)));
        }
        this.setBackgroundPainter(this.unselectedBackgroundPainter);
    }

    protected void determineBackgroundColour() {
        this.unselectedBackgroundPainter = new MattePainter((Paint)new Color(153, 204, 255));
        this.selectedBackgroundPainter = new CompoundPainter(new Painter[]{this.unselectedBackgroundPainter, new RectanglePainter(3, 3, 3, 3, 3, 3, true, (Paint)new Color(100, 100, 100, 100), 2.0f, (Paint)new Color(50, 50, 50, 100))});
        this.setBackgroundPainter(this.unselectedBackgroundPainter);
    }

    private void setDefaultBackground() {
        this.setBackgroundPainter((Painter)new MattePainter((Paint)new Color(229, 0, 0)));
        this.unselectedBackgroundPainter = this.getBackgroundPainter();
        this.selectedBackgroundPainter = new CompoundPainter(new Painter[]{this.unselectedBackgroundPainter, new RectanglePainter(3, 3, 3, 3, 3, 3, true, (Paint)new Color(100, 100, 100, 100), 2.0f, (Paint)new Color(50, 50, 50, 100))});
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selection) {
        this.selected = selection;
        if (this.selected) {
            this.setBackgroundPainter(this.selectedBackgroundPainter);
        } else {
            this.setBackgroundPainter(this.unselectedBackgroundPainter);
        }
    }

    public boolean isSelectable() {
        return true;
    }

    public BandMember getBandMember() {
        return this;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && this.cidsBean != null) {
            Geometry g = (Geometry)this.cidsBean.getProperty(this.lineFieldName + ".geom.geo_field");
            final MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
            XBoundingBox xbb = new XBoundingBox(g);
            mc.gotoBoundingBoxWithHistory((BoundingBox)new XBoundingBox(g.getEnvelope().buffer((xbb.getWidth() + xbb.getHeight()) / 2.0 * 0.1)));
            DefaultStyledFeature dsf = new DefaultStyledFeature();
            dsf.setGeometry(g);
            dsf.setCanBeSelected(false);
            dsf.setLinePaint((Paint)Color.YELLOW);
            dsf.setLineWidth(6);
            final PFeature highlighter = new PFeature((Feature)dsf, mc);
            mc.getHighlightingLayer().addChild((PNode)highlighter);
            highlighter.animateToTransparency(0.1f, 2000L);
            CismetThreadPool.execute((Runnable)new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    Thread.currentThread();
                    Thread.sleep(2500L);
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        mc.getHighlightingLayer().removeChild((PNode)highlighter);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        if (JBandCursorManager.getInstance().isLocked()) {
            JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
        }
        this.setAlpha(1.0f);
    }

    public void mouseExited(MouseEvent e) {
        this.setAlpha(0.8f);
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (!JBandCursorManager.getInstance().isLocked()) {
            JBandCursorManager.getInstance().setCursor(Cursor.getPredefinedCursor(12));
            JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
        } else {
            JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
        }
    }

    public void setSize(Dimension d) {
        super.setSize(d);
        this.setFontSize(d.height);
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.setFontSize(height);
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.setFontSize((int)r.getHeight());
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.setFontSize(height);
    }

    private void setFontSize(int height) {
        if (height > 15) {
            int fontHeight = height;
            if (fontHeight > 20) {
                fontHeight = 20;
            }
            Font f = this.getTextFont();
            f = f.deriveFont(fontHeight);
            this.setTextFont(f);
            this.setTextVisible(true);
        } else {
            this.setTextVisible(false);
        }
    }

    public String getTextProperty() {
        return this.textProperty;
    }
}

