/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import de.cismet.cids.custom.wrrl_db_mv.util.gup.RulerSection;
import de.cismet.tools.gui.jbands.MinimumHeightBand;
import de.cismet.tools.gui.jbands.interfaces.BandMember;
import de.cismet.tools.gui.jbands.interfaces.BandSnappingPointProvider;
import org.apache.log4j.Logger;

public class RulerBand
extends MinimumHeightBand
implements BandSnappingPointProvider {
    private static final Logger LOG = Logger.getLogger(RulerBand.class);
    protected double max;
    protected double min;
    protected int distance = 100;

    public RulerBand(double min, double max) {
        this.min = min;
        this.max = max;
        this.setMember();
    }

    protected void setMember() {
        this.removeAllMember();
        int no = 0;
        this.distance = this.calcDistance((int)Math.abs(this.max - this.min));
        for (double i = this.min; i < this.max; i += (double)this.getDistance()) {
            double end = i + (double)this.getDistance();
            ++no;
            if (end > this.max) {
                end = this.max;
            }
            this.addMember((BandMember)new RulerSection("", i, end, no % 5 == 1));
        }
    }

    protected int calcDistance(int totalDistance) {
        int distance = this.getNextPossibleDistance(0);
        while (totalDistance / distance > 30) {
            distance = this.getNextPossibleDistance(distance);
        }
        return distance;
    }

    protected int getNextPossibleDistance(int lastDistance) {
        if (lastDistance == 0) {
            return 100;
        }
        if ((double)lastDistance / Math.pow(10.0, Math.floor(Math.log10(lastDistance))) == 5.0) {
            return lastDistance * 2;
        }
        return lastDistance * 5;
    }

    public void setMinMax(double min, double max) {
        this.min = min;
        this.max = max;
        this.setMember();
    }

    public int getDistance() {
        return this.distance;
    }
}

