/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

public class StateMachine {
    private int[][] adjacencyMatrix;
    private int state = -1;

    public StateMachine(int[][] adjacencyMatrix) {
        this.adjacencyMatrix = adjacencyMatrix;
    }

    public void forceState(int newState) {
        this.state = newState;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int newState) throws IllegalArgumentException {
        if (this.state != -1 && this.adjacencyMatrix[this.state][newState] == 0) {
            throw new IllegalArgumentException("The given state cannot be reached from the current state");
        }
        this.state = newState;
    }

    public int getRoleForState(int newState) {
        return this.adjacencyMatrix[this.state][newState];
    }

    public boolean isStatePossible(int newState) {
        return this.adjacencyMatrix[this.state][newState] != 0;
    }
}

