/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import de.cismet.cids.custom.wrrl_db_mv.util.linearreferencing.LinearReferencingHelper;
import de.cismet.cids.dynamics.CidsBean;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class StationLineBackup {
    private static final Logger LOG = Logger.getLogger(StationLineBackup.class);
    private CidsBean lastRoute;
    private Double lastFrom;
    private Double lastTill;
    private String lineProperty = "linie";

    public StationLineBackup(String lineProperty) {
        this.lineProperty = lineProperty;
    }

    public void save(CidsBean cidsBean) {
        this.lastRoute = LinearReferencingHelper.getRouteBeanFromStationBean((CidsBean)cidsBean.getProperty(this.lineProperty + ".von"));
        this.lastFrom = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)cidsBean.getProperty(this.lineProperty + ".von"));
        this.lastTill = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)cidsBean.getProperty(this.lineProperty + ".bis"));
    }

    public void restoreStationValues(CidsBean cidsBean) {
        try {
            cidsBean.setProperty(this.lineProperty + ".von.route", (Object)this.lastRoute);
            cidsBean.setProperty(this.lineProperty + ".bis.route", (Object)this.lastRoute);
            cidsBean.setProperty(this.lineProperty + ".von.wert", (Object)this.lastFrom);
            cidsBean.setProperty(this.lineProperty + ".bis.wert", (Object)this.lastTill);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while restoring the station values.", (Throwable)e);
        }
    }

    public void cutSubobjects(List<CidsBean> all, double from, double till, int routeId) {
        ArrayList<CidsBean> massnToDelete = new ArrayList<CidsBean>();
        for (CidsBean bean : all) {
            block9: {
                block8: {
                    if (!bean.getProperty(this.lineProperty + ".von.route.id").equals(routeId)) {
                        massnToDelete.add(bean);
                        continue;
                    }
                    if ((Double)bean.getProperty(this.lineProperty + ".bis.wert") < from) break block8;
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!((Double)bean.getProperty(stringBuilder.append(this.lineProperty).append(".von.wert").toString()) > till)) break block9;
                }
                massnToDelete.add(bean);
                continue;
            }
            try {
                StringBuilder stringBuilder = new StringBuilder();
                if ((Double)bean.getProperty(stringBuilder.append(this.lineProperty).append(".von.wert").toString()) < from) {
                    bean.setProperty(this.lineProperty + ".von.wert", (Object)from);
                }
                StringBuilder stringBuilder2 = new StringBuilder();
                if (!((Double)bean.getProperty(stringBuilder2.append(this.lineProperty).append(".bis.wert").toString()) > till)) continue;
                bean.setProperty(this.lineProperty + ".bis.wert", (Object)till);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while setting the valid station value", (Throwable)e);
            }
        }
        all.removeAll(massnToDelete);
    }
}

