/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.LinearReferencedLineEditor;
import de.cismet.cids.custom.objecteditors.wrrl_db_mv.WasserkoerperLabel;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.GUPTableModel;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.log4j.Logger;

public class UnterhaltungsabschnitteModel
implements GUPTableModel {
    private static final Logger LOG = Logger.getLogger(UnterhaltungsabschnitteModel.class);
    WkUnterhaltung[] wku;
    private LinearReferencedLineEditor lrl = null;
    private CidsBean bean;

    public UnterhaltungsabschnitteModel(CidsBean bean) {
        this.bean = bean;
        List<CidsBean> uAbschnitte = CidsBeanSupport.getBeanCollectionFromProperty(bean, "unterhaltungsabschnitte");
        if (uAbschnitte != null && uAbschnitte.size() > 0) {
            long routeGwk = -1L;
            int minStart = -1;
            int maxEnd = -1;
            for (CidsBean tmp : uAbschnitte) {
                CidsBean stationLinie = (CidsBean)tmp.getProperty("linie");
                CidsBean start = (CidsBean)stationLinie.getProperty("von");
                CidsBean end = (CidsBean)stationLinie.getProperty("bis");
                CidsBean routeVon = (CidsBean)start.getProperty("route");
                CidsBean routeBis = (CidsBean)end.getProperty("route");
                long startGwk = (Long)routeVon.getProperty("gwk");
                long endGwk = (Long)routeBis.getProperty("gwk");
                int startValue = (Integer)start.getProperty("wert");
                int endValue = (Integer)end.getProperty("wert");
                if (routeGwk == -1L) {
                    routeGwk = startGwk;
                }
                if (routeGwk != startGwk || startGwk == endGwk) {
                    LOG.error((Object)("The gwk of a unterhaltungsabschnitt object is not correct. former gwk: " + routeGwk + " startGwk: " + startGwk + " endGwk: " + endGwk));
                }
                if (startValue < minStart || minStart == -1) {
                    minStart = startValue;
                }
                if (endValue <= maxEnd) continue;
                maxEnd = endValue;
            }
            if (minStart == -1 || maxEnd == -1 || routeGwk == -1L) {
                LOG.error((Object)("Cannot determine the correct station points for the gwk: " + routeGwk + " min start: " + minStart + " max end: " + maxEnd));
            }
            CidsBean[] wbs = this.readWbsFromServer(routeGwk, minStart, maxEnd);
            Arrays.sort(wbs, new WBComparator(routeGwk));
            this.wku = new WkUnterhaltung[wbs.length];
            for (int i = 0; i < wbs.length; ++i) {
                WasserkoerperLabel wkLab = new WasserkoerperLabel();
                wkLab.setName(wbs[i].toString());
                ArrayList<JLabel> uas = new ArrayList<JLabel>();
                ArrayList<Double> uaLength = new ArrayList<Double>();
                List<CidsBean> allUas = this.getUAsWithinWB(uAbschnitte, wbs[i], routeGwk);
                Collections.sort(allUas, new UAComparator());
                for (CidsBean tmp : allUas) {
                    JLabel lab = new JLabel(String.valueOf(tmp.getProperty("id")));
                    uas.add(lab);
                    uaLength.add(this.getLineLength((CidsBean)tmp.getProperty("linie")));
                }
                this.wku[i] = new WkUnterhaltung(wkLab, uas, uaLength);
            }
        } else {
            this.wku = null;
        }
    }

    @Override
    public JComponent getValue(int x, int y) {
        if (this.isEmpty()) {
            if (x == 0) {
                LinearReferencedLineEditor lrl = this.getLineEditor();
                lrl.setOtherLinesEnabled(false);
                try {
                    lrl.setLineField("linie");
                    lrl.setCidsBean(CidsBeanSupport.createNewCidsBeanFromTableName("GUP_UNTERHALTUNGSABSCHNITTE"));
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot create a cids bean of the type station_linie", (Throwable)e);
                }
                return lrl;
            }
            return new JButton("\u00fcbernehmen");
        }
        if (y == 0) {
            WasserkoerperLabel res = this.wku[x].getWkLab();
            this.confSize(res);
            return res;
        }
        if (y == 1) {
            int n = 0;
            for (WkUnterhaltung tmp : this.wku) {
                if (tmp.getUnterhaltungsabschnitte().size() > x - n) {
                    JLabel res = tmp.getUnterhaltungsabschnitte().get(x - n);
                    res.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
                    res.setText("<html>&nbsp;</html>");
                    this.confSize(res);
                    return res;
                }
                n += tmp.getUnterhaltungsabschnitte().size();
            }
            return null;
        }
        return null;
    }

    @Override
    public JComponent getVerticalHeader(int row) {
        if (row == 0) {
            JLabel lab = new JLabel("WK:");
            lab.setSize(20, 20);
            return lab;
        }
        JLabel lab = new JLabel("UA:");
        lab.setSize(20, 20);
        return lab;
    }

    @Override
    public boolean showVerticalHeader() {
        return !this.isEmpty();
    }

    @Override
    public int getRows() {
        if (this.isEmpty()) {
            return 1;
        }
        return 2;
    }

    @Override
    public int getCols(int row) {
        if (this.isEmpty()) {
            return 2;
        }
        if (row == 0) {
            return this.wku.length;
        }
        int n = 0;
        for (WkUnterhaltung tmp : this.wku) {
            n += tmp.getUnterhaltungsabschnitte().size();
        }
        return n;
    }

    @Override
    public double getWeight(int x, int y, boolean log) {
        if (this.isEmpty()) {
            return 1.0;
        }
        if (y == 0) {
            List<Double> lengths = this.wku[x].getUnterhaltungsabschnitteLaenge();
            double sum = 0.0;
            for (Double tmp : lengths) {
                if (log) {
                    sum += Math.log10(tmp);
                    continue;
                }
                sum += tmp.doubleValue();
            }
            return sum;
        }
        if (y == 1) {
            int n = 0;
            for (WkUnterhaltung tmp : this.wku) {
                if (tmp.getUnterhaltungsabschnitteLaenge().size() > x - n) {
                    if (log) {
                        return Math.log10(tmp.getUnterhaltungsabschnitteLaenge().get(x - n));
                    }
                    return tmp.getUnterhaltungsabschnitteLaenge().get(x - n);
                }
                n += tmp.getUnterhaltungsabschnitteLaenge().size();
            }
        }
        return 0.0;
    }

    @Override
    public GridBagConstraints getConstraint(int x, int y) {
        if (this.isEmpty()) {
            if (x == 0) {
                return UnterhaltungsabschnitteModel.createGridBagConstraint(x, y, 1.0, 1.0, 1, 1);
            }
            GridBagConstraints gbc = UnterhaltungsabschnitteModel.createGridBagConstraint(x, y, 0.0, 0.0, 1, 0);
            return gbc;
        }
        return UnterhaltungsabschnitteModel.createGridBagConstraint(x, 0, this.getWeight(x, y, false), y != 0 ? 1 : 0, 1, y == 0 ? 2 : 1);
    }

    @Override
    public double getRowWeight(int row) {
        if (this.isEmpty()) {
            return 1.0;
        }
        if (row == 0) {
            return 0.0;
        }
        return 1.0;
    }

    public LinearReferencedLineEditor getLineEditor() {
        if (this.lrl == null) {
            this.lrl = new LinearReferencedLineEditor();
        }
        return this.lrl;
    }

    private void confSize(JComponent comp) {
        Dimension d = new Dimension(0, 20);
        comp.setPreferredSize(d);
        comp.setMinimumSize(d);
        comp.setMaximumSize(d);
        comp.setSize(0, 0);
    }

    public boolean isEmpty() {
        return this.wku == null;
    }

    private static GridBagConstraints createGridBagConstraint(int gridx, int gridy, double weightx, double weighty, int gridwidth, int fill) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.fill = fill;
        gridBagConstraints.weightx = weightx;
        gridBagConstraints.weighty = weighty;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridwidth = gridwidth;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        return gridBagConstraints;
    }

    private double getLineLength(CidsBean line) {
        Geometry geom = (Geometry)line.getProperty("geom.geo_field");
        return geom.getLength();
    }

    private List<CidsBean> getUAsWithinWB(List<CidsBean> uas, CidsBean wb, long referenceGwk) {
        ArrayList<CidsBean> res = new ArrayList<CidsBean>();
        for (CidsBean tmp : uas) {
            if (!this.isUaInWb(tmp, wb, referenceGwk)) continue;
            res.add(tmp);
        }
        return res;
    }

    private boolean isUaInWb(CidsBean ua, CidsBean wb, long referenceGwk) {
        double tmp;
        CidsBean uaLine = (CidsBean)ua.getProperty("linie");
        CidsBean wbLine = (CidsBean)this.extractPartWithSuitableGwk(wb, referenceGwk).getProperty("linie");
        double uaStart = (Double)uaLine.getProperty("von.wert");
        double uaEnd = (Double)uaLine.getProperty("bis.wert");
        double wbStart = (Double)wbLine.getProperty("von.wert");
        double wbEnd = (Double)wbLine.getProperty("bis.wert");
        if (uaStart > uaEnd) {
            tmp = uaStart;
            uaStart = uaEnd;
            uaEnd = tmp;
        }
        if (wbStart > wbEnd) {
            tmp = wbStart;
            wbStart = wbEnd;
            wbEnd = tmp;
        }
        return uaStart >= wbStart && uaEnd <= wbEnd;
    }

    private CidsBean[] readWbsFromServer(long gwk, int start, int end) {
        MetaClass mc = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"wk_fg");
        String query = "select distinct " + mc.getID() + ", " + mc.getPrimaryKey() + " from " + mc.getTableName() + " fg, wk_fg_teile teile, wk_teil teil, station_linie linie, station von, station bis, route WHERE teile.wk_fg_reference = fg.id AND teile.teil = teil.id AND teil.linie = linie.id AND linie.von = von.id AND linie.bis = bis.id AND von.route = route.id AND route.gwk = " + gwk + " AND ((von.wert >= " + start + " AND von.wert < " + end + ") OR (bis.wert > " + start + " AND bis.wert <= " + end + ") OR (von.wert <= " + start + " AND bis.wert >= " + end + "))";
        try {
            MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
            CidsBean[] beans = new CidsBean[metaObjects.length];
            for (int i = 0; i < metaObjects.length; ++i) {
                beans[i] = metaObjects[i].getBean();
            }
            return beans;
        }
        catch (ConnectionException e) {
            LOG.error((Object)"Connection exception.", (Throwable)e);
            return null;
        }
    }

    private CidsBean extractPartWithSuitableGwk(CidsBean o, long referenceGwk) {
        List<CidsBean> l = CidsBeanSupport.getBeanCollectionFromProperty(o, "teile");
        for (CidsBean tmp : l) {
            Integer tmpGwk = (Integer)tmp.getProperty("linie.von.route.gwk");
            if (tmpGwk == null || (long)tmpGwk.intValue() != referenceGwk) continue;
            return tmp;
        }
        return null;
    }

    @Override
    public boolean fullScreen() {
        return this.isEmpty();
    }

    private class UAComparator
    implements Comparator<CidsBean> {
        private UAComparator() {
        }

        protected int nullCheck(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return 2;
        }

        @Override
        public int compare(CidsBean o1, CidsBean o2) {
            Integer s2;
            Integer s1 = (Integer)o1.getProperty("linie.von.wert");
            int check = this.nullCheck(s1, s2 = (Integer)o2.getProperty("linie.von.wert"));
            if (check != 2) {
                return check;
            }
            return s1.compareTo(s2);
        }
    }

    private class WBComparator
    extends UAComparator {
        private long gwk;

        public WBComparator(long gwk) {
            this.gwk = gwk;
        }

        @Override
        public int compare(CidsBean o1, CidsBean o2) {
            Integer s2;
            CidsBean p2;
            CidsBean p1 = UnterhaltungsabschnitteModel.this.extractPartWithSuitableGwk(o1, this.gwk);
            int check = this.nullCheck(p1, p2 = UnterhaltungsabschnitteModel.this.extractPartWithSuitableGwk(o2, this.gwk));
            if (check != 2) {
                return check;
            }
            Integer s1 = (Integer)p1.getProperty("linie.von.wert");
            check = this.nullCheck(s1, s2 = (Integer)p2.getProperty("linie.von.wert"));
            if (check != 2) {
                return check;
            }
            return s1.compareTo(s2);
        }
    }

    private class WkUnterhaltung {
        private WasserkoerperLabel wkLab;
        private List<JLabel> unterhaltungsabschnitte;
        private List<Double> unterhaltungsabschnitteLaenge;

        public WkUnterhaltung() {
            this.unterhaltungsabschnitte = new ArrayList<JLabel>();
        }

        public WkUnterhaltung(WasserkoerperLabel wkLab, List<JLabel> unterhaltungsabschnitte, List<Double> unterhaltungsabschnitteLaenge) {
            this.wkLab = wkLab;
            this.unterhaltungsabschnitte = unterhaltungsabschnitte;
            this.unterhaltungsabschnitteLaenge = unterhaltungsabschnitteLaenge;
        }

        public void addUnterhaltungsabschnitt(JLabel unterhaltungsabschnitt) {
            this.getUnterhaltungsabschnitte().add(unterhaltungsabschnitt);
        }

        public WasserkoerperLabel getWkLab() {
            return this.wkLab;
        }

        public void setWkLab(WasserkoerperLabel wkLab) {
            this.wkLab = wkLab;
        }

        public List<JLabel> getUnterhaltungsabschnitte() {
            return this.unterhaltungsabschnitte;
        }

        public void setUnterhaltungsabschnitte(List<JLabel> unterhaltungsabschnitte) {
            this.unterhaltungsabschnitte = unterhaltungsabschnitte;
        }

        public List<Double> getUnterhaltungsabschnitteLaenge() {
            return this.unterhaltungsabschnitteLaenge;
        }

        public void setUnterhaltungsabschnitteLaenge(List<Double> unterhaltungsabschnitteLaenge) {
            this.unterhaltungsabschnitteLaenge = unterhaltungsabschnitteLaenge;
        }
    }
}

