/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import de.cismet.cids.custom.wrrl_db_mv.util.gup.AbschnittsinfoMember;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.LineBandMember;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.tools.gui.jbands.JBandCursorManager;
import de.cismet.tools.gui.jbands.interfaces.BandMember;
import de.cismet.tools.gui.jbands.interfaces.BandMemberMouseListeningComponent;
import de.cismet.tools.gui.jbands.interfaces.BandMemberSelectable;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.RectanglePainter;

public class UnterhaltungserfordernisBandMember
extends AbschnittsinfoMember
implements BandMemberSelectable,
BandMemberMouseListeningComponent {
    protected static final Logger LOG = Logger.getLogger(LineBandMember.class);
    private CidsBean cidsBean;
    private boolean selected;
    private Painter unselectedBackgroundPainter;
    private Painter selectedBackgroundPainter;

    public UnterhaltungserfordernisBandMember() {
        this.setMinimumSize(new Dimension(1, 7));
        this.setPreferredSize(this.getMinimumSize());
    }

    @Override
    public void setCidsBean(CidsBean cidsBean) {
        super.setCidsBean(cidsBean);
        this.cidsBean = cidsBean;
        this.setToolTipText(String.valueOf(cidsBean.getProperty("name_beschreibung.name")));
        this.determineBackgroundColour();
        this.setBackgroundPainter(this.unselectedBackgroundPainter);
    }

    protected void determineBackgroundColour() {
        if (this.cidsBean.getProperty("name_beschreibung") == null || this.cidsBean.getProperty("name_beschreibung.color") == null) {
            this.setDefaultBackground();
            return;
        }
        String color = (String)this.cidsBean.getProperty("name_beschreibung.color");
        if (color != null) {
            try {
                this.setBackgroundPainter((Painter)new MattePainter((Paint)Color.decode(color)));
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"Error while parsing the color.", (Throwable)e);
                this.setDefaultBackground();
            }
        }
        this.unselectedBackgroundPainter = this.getBackgroundPainter();
        this.selectedBackgroundPainter = new CompoundPainter(new Painter[]{this.unselectedBackgroundPainter, new RectanglePainter(3, 3, 3, 3, 3, 3, true, (Paint)new Color(100, 100, 100, 100), 2.0f, (Paint)new Color(50, 50, 50, 100))});
        this.setBackgroundPainter(this.unselectedBackgroundPainter);
    }

    protected void setDefaultBackground() {
        this.unselectedBackgroundPainter = new MattePainter((Paint)new Color(229, 0, 0));
        this.selectedBackgroundPainter = new CompoundPainter(new Painter[]{this.unselectedBackgroundPainter, new RectanglePainter(3, 3, 3, 3, 3, 3, true, (Paint)new Color(100, 100, 100, 100), 2.0f, (Paint)new Color(50, 50, 50, 100))});
        if (this.selected) {
            this.setBackgroundPainter(this.selectedBackgroundPainter);
        } else {
            this.setBackgroundPainter(this.unselectedBackgroundPainter);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selection) {
        this.selected = selection;
        if (this.selected) {
            this.setBackgroundPainter(this.selectedBackgroundPainter);
        } else {
            this.setBackgroundPainter(this.unselectedBackgroundPainter);
        }
    }

    public boolean isSelectable() {
        return true;
    }

    public BandMember getBandMember() {
        return this;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        if (JBandCursorManager.getInstance().isLocked()) {
            JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
        }
        this.setAlpha(1.0f);
    }

    public void mouseExited(MouseEvent e) {
        this.setAlpha(0.8f);
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (!JBandCursorManager.getInstance().isLocked()) {
            JBandCursorManager.getInstance().setCursor(Cursor.getPredefinedCursor(12));
            JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
        } else {
            JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
        }
    }
}

