/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import Sirius.navigator.ui.ComponentRegistry;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.VermeidungsgruppeMitGeom;
import de.cismet.cids.dynamics.CidsBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openide.util.NbBundle;

public class UnterhaltungsmassnahmeValidator {
    private VermeidungsgruppeMitGeom[] verbreitungsraum;
    private Collection<CidsBean> schutzgebiete;
    private Collection<CidsBean> operativeZiele;

    public VermeidungsgruppeMitGeom[] getVerbreitungsraum() {
        return this.verbreitungsraum;
    }

    public void setVerbreitungsraum(VermeidungsgruppeMitGeom[] verbreitungsraum) {
        this.verbreitungsraum = verbreitungsraum;
        if (this.operativeZiele != null && this.schutzgebiete != null) {
            ComponentRegistry.getRegistry().getSearchResultsTree().repaint();
        }
    }

    public Collection<CidsBean> getSchutzgebiete() {
        return this.schutzgebiete;
    }

    public void setSchutzgebiete(Collection<CidsBean> schutzgebiete) {
        this.schutzgebiete = schutzgebiete;
        if (this.verbreitungsraum != null && this.operativeZiele != null) {
            ComponentRegistry.getRegistry().getSearchResultsTree().repaint();
        }
    }

    public Collection<CidsBean> getOperativeZiele() {
        return this.operativeZiele;
    }

    public void setOperativeZiele(Collection<CidsBean> operativeZiele) {
        this.operativeZiele = operativeZiele;
        if (this.verbreitungsraum != null && this.schutzgebiete != null) {
            ComponentRegistry.getRegistry().getSearchResultsTree().repaint();
        }
    }

    public boolean isReady() {
        return this.operativeZiele != null && this.verbreitungsraum != null && this.schutzgebiete != null;
    }

    public ValidationResult validate(CidsBean bean, List<String> errors) {
        return this.validate(bean, (CidsBean)bean.getProperty("massnahme"), errors);
    }

    public ValidationResult validate(CidsBean abschnittBean, CidsBean massnArt, List<String> errors) {
        while (this.operativeZiele == null || this.verbreitungsraum == null || this.schutzgebiete == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        ValidationResult res = ValidationResult.ok;
        double von = (Double)abschnittBean.getProperty("linie.von.wert");
        double bis = (Double)abschnittBean.getProperty("linie.bis.wert");
        Integer wo = (Integer)abschnittBean.getProperty("wo.id");
        if (massnArt == null) {
            return ValidationResult.error;
        }
        if (massnArt.getProperty("gewerk") != null) {
            List opBeans = massnArt.getBeanCollectionProperty("gewerk.operative_ziele");
            for (CidsBean mo : this.operativeZiele) {
                if (!this.isLineInsideBean(mo, von, bis, (int)wo) || opBeans != null && opBeans.contains((CidsBean)mo.getProperty("operatives_ziel"))) continue;
                CidsBean oz = (CidsBean)mo.getProperty("operatives_ziel");
                if (oz != null) {
                    errors.add(NbBundle.getMessage(UnterhaltungsmassnahmeValidator.class, (String)"UnterhaltungsmassnahmeValidator.validate.invalidCareTarget", (Object)oz));
                } else {
                    errors.add(NbBundle.getMessage(UnterhaltungsmassnahmeValidator.class, (String)"UnterhaltungsmassnahmeValidator.validate.careTargetWithoutValue"));
                }
                res = ValidationResult.error;
            }
        }
        ArrayList vrBeans = new ArrayList();
        if (massnArt.getBeanCollectionProperty("einsatzvariante.vermeidungsgruppen") != null) {
            vrBeans.addAll(massnArt.getBeanCollectionProperty("einsatzvariante.vermeidungsgruppen"));
        }
        if (massnArt.getBeanCollectionProperty("ausfuehrungszeitpunkt.vermeidungsgruppen") != null) {
            vrBeans.addAll(massnArt.getBeanCollectionProperty("ausfuehrungszeitpunkt.vermeidungsgruppen"));
        }
        for (VermeidungsgruppeMitGeom vg : this.verbreitungsraum) {
            Boolean warning;
            CidsBean v;
            if (!this.isLineInsideBean(vg, von, bis, (int)wo) || vrBeans.contains(v = vg.getVermeidungsgruppe())) continue;
            Boolean bl = warning = v == null ? null : (Boolean)v.getProperty("warnung");
            if (warning != null && warning.booleanValue()) {
                errors.add(NbBundle.getMessage(UnterhaltungsmassnahmeValidator.class, (String)"UnterhaltungsmassnahmeValidator.validate.preventionGroupYellow", (Object)v));
                if (res.equals((Object)ValidationResult.error)) continue;
                res = ValidationResult.warning;
                continue;
            }
            if (v != null) {
                errors.add(NbBundle.getMessage(UnterhaltungsmassnahmeValidator.class, (String)"UnterhaltungsmassnahmeValidator.validate.invalidPreventionGroup", (Object)v));
            } else {
                errors.add(NbBundle.getMessage(UnterhaltungsmassnahmeValidator.class, (String)"UnterhaltungsmassnahmeValidator.validate.preventionGroupWithoutValue"));
            }
            res = ValidationResult.error;
        }
        int schuWo = wo;
        if (schuWo == 3) {
            schuWo = 2;
        } else if (wo == 4) {
            schuWo = 1;
        }
        for (CidsBean mo : this.schutzgebiete) {
            if (!this.isLineInsideBean(mo, von, bis, schuWo)) continue;
            errors.add(NbBundle.getMessage(UnterhaltungsmassnahmeValidator.class, (String)"UnterhaltungsmassnahmeValidator.validate.measureInNatureReserve"));
            res = ValidationResult.error;
        }
        Boolean alAnf = (Boolean)massnArt.getProperty("erfuellt_al_anf");
        if (alAnf == null || !alAnf.booleanValue()) {
            errors.add(NbBundle.getMessage(UnterhaltungsmassnahmeValidator.class, (String)"UnterhaltungsmassnahmeValidator.validate.notAlAnf"));
            res = ValidationResult.error;
        }
        return res;
    }

    private boolean isLineInsideBean(CidsBean moBean, double fromBean, double untilBean, int woId) {
        double von = (Double)moBean.getProperty("linie.von.wert");
        double bis = (Double)moBean.getProperty("linie.bis.wert");
        long vonRounded = Math.min(Math.round(von), Math.round(bis));
        long bisRounded = Math.max(Math.round(von), Math.round(bis));
        long fromBeanRounded = Math.min(Math.round(fromBean), Math.round(untilBean));
        long untilBeanRounded = Math.max(Math.round(fromBean), Math.round(untilBean));
        Integer wo = (Integer)moBean.getProperty("wo.id");
        if (wo == null) {
            return false;
        }
        return wo == woId && (vonRounded < fromBeanRounded && bisRounded > fromBeanRounded || vonRounded < untilBeanRounded && bisRounded > untilBeanRounded || vonRounded >= fromBeanRounded && bisRounded <= untilBeanRounded);
    }

    private boolean isLineInsideBean(VermeidungsgruppeMitGeom mo, double fromBean, double untilBean, int woId) {
        return this.isLineInsideBean(mo.getGeschuetzteArt(), fromBean, untilBean, woId);
    }

    public static enum ValidationResult {
        ok,
        warning,
        error;

    }
}

