/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.ColoredReadOnlyBandMember;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.LineBandMember;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.jbands.JBandCursorManager;
import de.cismet.tools.gui.jbands.interfaces.BandMember;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.RectanglePainter;

public class VermeidungsgruppeReadOnlyBandMember
extends ColoredReadOnlyBandMember {
    private static final Logger LOG = Logger.getLogger(LineBandMember.class);
    private CidsBean cidsBean;
    private CidsBean vermeidungsgruppe;
    private boolean selected;
    private Painter unselectedBackgroundPainter;
    private Painter selectedBackgroundPainter;
    private String lineFieldName = "linie";

    public VermeidungsgruppeReadOnlyBandMember() {
        this.setMinimumSize(new Dimension(1, 7));
        this.setPreferredSize(this.getMinimumSize());
    }

    public void setCidsBean(CidsBean art, CidsBean vermeidungsgruppe) {
        super.setCidsBean(art);
        this.cidsBean = art;
        this.setVermeidungsgruppe(vermeidungsgruppe);
        this.setToolTipText(vermeidungsgruppe.getProperty("name") + " | " + (art != null && art.getProperty("art.name") != null ? String.valueOf(art.getProperty("art.name")) : ""));
        this.determineBackgroundColour();
        this.setBackgroundPainter(this.unselectedBackgroundPainter);
    }

    @Override
    protected void determineBackgroundColour() {
        if (this.getVermeidungsgruppe() == null || this.getVermeidungsgruppe().getProperty("color") == null) {
            this.setDefaultBackground();
            return;
        }
        String color = (String)this.getVermeidungsgruppe().getProperty("color");
        if (color != null) {
            try {
                this.setBackgroundPainter((Painter)new MattePainter((Paint)Color.decode(color)));
            }
            catch (NumberFormatException e) {
                LOG.error((Object)"Error while parsing the color.", (Throwable)e);
                this.setDefaultBackground();
            }
        }
        this.unselectedBackgroundPainter = this.getBackgroundPainter();
        this.selectedBackgroundPainter = new CompoundPainter(new Painter[]{this.unselectedBackgroundPainter, new RectanglePainter(3, 3, 3, 3, 3, 3, true, (Paint)new Color(100, 100, 100, 100), 2.0f, (Paint)new Color(50, 50, 50, 100))});
        this.setBackgroundPainter(this.unselectedBackgroundPainter);
    }

    private void setDefaultBackground() {
        this.setBackgroundPainter((Painter)new MattePainter((Paint)new Color(229, 0, 0)));
        this.unselectedBackgroundPainter = this.getBackgroundPainter();
        this.selectedBackgroundPainter = new CompoundPainter(new Painter[]{this.unselectedBackgroundPainter, new RectanglePainter(3, 3, 3, 3, 3, 3, true, (Paint)new Color(100, 100, 100, 100), 2.0f, (Paint)new Color(50, 50, 50, 100))});
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selection) {
        this.selected = selection;
        if (this.selected) {
            this.setBackgroundPainter(this.selectedBackgroundPainter);
        } else {
            this.setBackgroundPainter(this.unselectedBackgroundPainter);
        }
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public BandMember getBandMember() {
        return this;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && this.cidsBean != null) {
            Geometry g = (Geometry)this.cidsBean.getProperty(this.lineFieldName + ".geom.geo_field");
            final MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
            XBoundingBox xbb = new XBoundingBox(g);
            mc.gotoBoundingBoxWithHistory((BoundingBox)new XBoundingBox(g.getEnvelope().buffer((xbb.getWidth() + xbb.getHeight()) / 2.0 * 0.1)));
            DefaultStyledFeature dsf = new DefaultStyledFeature();
            dsf.setGeometry(g);
            dsf.setCanBeSelected(false);
            dsf.setLinePaint((Paint)Color.YELLOW);
            dsf.setLineWidth(6);
            final PFeature highlighter = new PFeature((Feature)dsf, mc);
            mc.getHighlightingLayer().addChild((PNode)highlighter);
            highlighter.animateToTransparency(0.1f, 2000L);
            CismetThreadPool.execute((Runnable)new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    Thread.currentThread();
                    Thread.sleep(2500L);
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        mc.getHighlightingLayer().removeChild((PNode)highlighter);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (JBandCursorManager.getInstance().isLocked()) {
            JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
        }
        this.setAlpha(1.0f);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setAlpha(0.8f);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!JBandCursorManager.getInstance().isLocked()) {
            JBandCursorManager.getInstance().setCursor(Cursor.getPredefinedCursor(12));
            JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
        } else {
            JBandCursorManager.getInstance().setCursor((JComponent)((Object)this));
        }
    }

    public CidsBean getVermeidungsgruppe() {
        return this.vermeidungsgruppe;
    }

    public void setVermeidungsgruppe(CidsBean vermeidungsgruppe) {
        this.vermeidungsgruppe = vermeidungsgruppe;
    }

    public CidsBean getArt() {
        return this.cidsBean;
    }

    public void setArt(CidsBean art) {
        this.cidsBean = art;
    }
}

