/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.LineBand;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.VermessungsBand;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.VermessungsbandMember;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.WKBand;
import de.cismet.cids.custom.wrrl_db_mv.util.linearreferencing.FeatureRegistry;
import de.cismet.cids.custom.wrrl_db_mv.util.linearreferencing.LinearReferencingHelper;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateLinearReferencedMarksListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.jbands.EmptyAbsoluteHeightedBand;
import de.cismet.tools.gui.jbands.JBand;
import de.cismet.tools.gui.jbands.SimpleBandModel;
import de.cismet.tools.gui.jbands.interfaces.Band;
import de.cismet.tools.gui.jbands.interfaces.BandMember;
import de.cismet.tools.gui.jbands.interfaces.BandModel;
import de.cismet.tools.gui.jbands.interfaces.BandModelListener;
import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.apache.log4j.Logger;

public class VermessungsbandHelper {
    private static final Logger LOG = Logger.getLogger(VermessungsbandHelper.class);
    private static final String VERMESSUNG = "vermessung_band_element";
    Double[] positions;
    CidsBean routeBean;
    private String lineProperty = "linie";
    private CidsBean cidsBean;
    private final JToggleButton togApplyStats;
    private WKBand vwkband;
    private final JBand jband;
    private PureNewFeature routeFeature;
    private final BandModelListener modelListener;
    private final JPanel panBand;
    private final JPanel panApplyBand;
    private final JPanel panApply;
    private VermessungsBand vermessungsBand = new VermessungsBand("Vermessung", "vermessung_band_element");
    private JBand vBand = new JBand();
    private SimpleBandModel vBandModel = new SimpleBandModel();
    private CidsBean route;
    private List<CidsBean> createdBeans = new ArrayList<CidsBean>();

    public VermessungsbandHelper(JBand jband, BandModelListener modelListener, JPanel panBand, JPanel panApplyBand, JPanel panApply, JToggleButton togApplyStats) {
        this.jband = jband;
        this.modelListener = modelListener;
        this.panBand = panBand;
        this.panApplyBand = panApplyBand;
        this.panApply = panApply;
        this.togApplyStats = togApplyStats;
    }

    public void setVwkBand(WKBand vwkband) {
        this.vwkband = vwkband;
        this.vBand.setModel((BandModel)this.vBandModel);
        this.vBandModel.addBand((Band)vwkband);
        this.vBandModel.addBand((Band)new EmptyAbsoluteHeightedBand(5));
        this.vBandModel.addBand((Band)this.vermessungsBand);
        this.vBandModel.addBandModelListener(this.modelListener);
    }

    public void setWk(ArrayList<ArrayList> wk) {
        this.vwkband.setWK(wk);
        this.vBandModel.fireBandModelChanged();
    }

    public void setCidsBean(final CidsBean cidsBean) {
        this.cidsBean = cidsBean;
        cidsBean.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("linie")) {
                    VermessungsbandHelper.this.togApplyStats.setEnabled(cidsBean.getProperty(VermessungsbandHelper.this.getLineProperty()) != null);
                }
            }
        });
        this.togApplyStats.setEnabled(cidsBean.getProperty(this.getLineProperty()) != null);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                VermessungsbandHelper.this.showRoute();
            }
        });
    }

    public void reset() {
        this.vermessungsBand = new VermessungsBand("Vermessung", VERMESSUNG);
        this.vBand = new JBand();
        this.vBandModel = new SimpleBandModel();
        this.createdBeans = new ArrayList<CidsBean>();
    }

    public void showRoute() {
        CidsBean station;
        if (this.route != null) {
            FeatureRegistry.getInstance().removeRouteFeature(this.route);
        }
        if ((station = (CidsBean)this.cidsBean.getProperty(this.getLineProperty() + ".von")) != null) {
            Geometry routeGeometry = LinearReferencingHelper.getRouteGeometryFromStationBean(station);
            this.route = LinearReferencingHelper.getRouteBeanFromStationBean(station);
            this.routeFeature = FeatureRegistry.getInstance().addRouteFeature(this.route, routeGeometry);
            MappingComponent map = CismapBroker.getInstance().getMappingComponent();
            this.vermessungsBand.setRoute(this.route);
            if (!map.isFixedMapExtent()) {
                map.zoomToAFeatureCollection((Collection)map.getFeatureCollection().getAllFeatures(), true, map.isFixedMapScale());
            }
        }
    }

    public void savePositions() {
        try {
            MappingComponent mappingComponent = CismapBroker.getInstance().getMappingComponent();
            CreateLinearReferencedMarksListener marksListener = (CreateLinearReferencedMarksListener)mappingComponent.getInputListener("LINEMEASUREMENT");
            PFeature selectedPFeature = marksListener.getSelectedLinePFeature();
            this.positions = marksListener.getMarkPositionsOfSelectedFeature();
            this.routeBean = null;
            if (selectedPFeature != null) {
                Feature feature = selectedPFeature.getFeature();
                if (feature != null && feature instanceof CidsFeature) {
                    CidsFeature cidsFeature = (CidsFeature)feature;
                    if (cidsFeature.getMetaClass().getName().equals("route")) {
                        this.routeBean = cidsFeature.getMetaObject().getBean();
                    }
                } else if (feature != null && feature instanceof FeatureRegistry.RouteFeature) {
                    this.routeBean = FeatureRegistry.getInstance().getCidsBean(feature);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while applying stations.", (Throwable)e);
        }
    }

    public void showVermessungsbandFromSavedPositions() {
        try {
            double till;
            double from;
            if (this.routeBean != null) {
                from = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)this.cidsBean.getProperty(this.getLineProperty() + ".von"));
                till = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)this.cidsBean.getProperty(this.getLineProperty() + ".bis"));
                this.vermessungsBand.setRoute(this.routeBean);
                this.vermessungsBand.removeAllMember();
                Double fromPosition = null;
                CidsBean fromStation = null;
                CidsBean toStation = null;
                Double[] doubleArray = this.positions;
                int n = doubleArray.length;
                for (int i = 0; i < n; ++i) {
                    double position = doubleArray[i];
                    Double toPosition = Math.floor(position);
                    if (toPosition < from) {
                        toPosition = from;
                    } else if (position > till) {
                        toPosition = till;
                    }
                    toStation = LinearReferencingHelper.createStationBeanFromRouteBean(this.routeBean, toPosition);
                    if (fromPosition != null && toPosition > fromPosition) {
                        CidsBean memberBean = CidsBeanSupport.createNewCidsBeanFromTableName(VERMESSUNG);
                        this.vermessungsBand.addMember(memberBean, fromStation, toStation);
                    }
                    fromPosition = toPosition;
                    fromStation = toStation;
                }
            }
            from = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)this.cidsBean.getProperty(this.getLineProperty() + ".von"));
            till = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)this.cidsBean.getProperty(this.getLineProperty() + ".bis"));
            this.vBand.setMinValue(from);
            this.vBand.setMaxValue(till);
            this.panBand.removeAll();
            this.panApplyBand.removeAll();
            this.panApplyBand.add((Component)this.vBand, "Center");
            this.panBand.add((Component)this.panApply, "Center");
            this.modelListener.bandModelSelectionChanged(null);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while applying stations.", (Throwable)e);
        }
    }

    public void showVermessungsband() {
        try {
            double till;
            MappingComponent mappingComponent = CismapBroker.getInstance().getMappingComponent();
            CreateLinearReferencedMarksListener marksListener = (CreateLinearReferencedMarksListener)mappingComponent.getInputListener("LINEMEASUREMENT");
            PFeature selectedPFeature = marksListener.getSelectedLinePFeature();
            Double[] positions = marksListener.getMarkPositionsOfSelectedFeature();
            CidsBean routeBean = null;
            if (selectedPFeature != null) {
                Feature feature = selectedPFeature.getFeature();
                if (feature != null && feature instanceof CidsFeature) {
                    CidsFeature cidsFeature = (CidsFeature)feature;
                    if (cidsFeature.getMetaClass().getName().equals("route")) {
                        routeBean = cidsFeature.getMetaObject().getBean();
                    }
                } else if (feature != null && feature == this.routeFeature) {
                    routeBean = (CidsBean)this.cidsBean.getProperty(this.getLineProperty() + ".von.route");
                }
            }
            if (routeBean != null) {
                double from = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)this.cidsBean.getProperty(this.getLineProperty() + ".von"));
                till = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)this.cidsBean.getProperty(this.getLineProperty() + ".bis"));
                this.vermessungsBand.setRoute(routeBean);
                this.vermessungsBand.removeAllMember();
                Double fromPosition = null;
                CidsBean fromStation = null;
                CidsBean toStation = null;
                Double[] doubleArray = positions;
                int n = doubleArray.length;
                for (int i = 0; i < n; ++i) {
                    double position = doubleArray[i];
                    Double toPosition = Math.floor(position);
                    if (toPosition < from) {
                        toPosition = from;
                    } else if (position > till) {
                        toPosition = till;
                    }
                    toStation = LinearReferencingHelper.createStationBeanFromRouteBean(routeBean, toPosition);
                    if (fromPosition != null && toPosition > fromPosition) {
                        CidsBean memberBean = CidsBeanSupport.createNewCidsBeanFromTableName(VERMESSUNG);
                        this.vermessungsBand.addMember(memberBean, fromStation, toStation);
                    }
                    fromPosition = toPosition;
                    fromStation = toStation;
                }
            }
            double from = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)this.cidsBean.getProperty(this.getLineProperty() + ".von"));
            till = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)this.cidsBean.getProperty(this.getLineProperty() + ".bis"));
            this.vBand.setMinValue(from);
            this.vBand.setMaxValue(till);
            this.panBand.removeAll();
            this.panApplyBand.removeAll();
            this.panApplyBand.add((Component)this.vBand, "Center");
            this.panBand.add((Component)this.panApply, "Center");
            this.modelListener.bandModelSelectionChanged(null);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while applying stations.", (Throwable)e);
        }
    }

    private void setNamesAndBands() {
        CidsBean route = LinearReferencingHelper.getRouteBeanFromStationBean((CidsBean)this.cidsBean.getProperty("linie.von"));
        double from = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)this.cidsBean.getProperty("linie.von"));
        double till = LinearReferencingHelper.getLinearValueFromStationBean((CidsBean)this.cidsBean.getProperty("linie.bis"));
        SimpleBandModel sbm = new SimpleBandModel();
        sbm.setMin(from);
        sbm.setMax(till);
        WKBand wkband = new WKBand(from, till);
        this.setVwkBand(new WKBand(sbm.getMin(), sbm.getMax()));
        wkband.fillAndInsertBand(sbm, String.valueOf(route.getProperty("gwk")), this.jband, this);
    }

    public void hideVermessungsband() {
        this.panBand.removeAll();
        this.panBand.add((Component)this.jband, "Center");
        this.modelListener.bandModelSelectionChanged(null);
        this.jband.repaint();
    }

    public void applyStats(Component comp, LineBand[] bands, String cidsBeanTableName) {
        try {
            int res = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)comp), "Wenn Sie die Abschnitte \u00fcbernehmen, dann werden die bereits vorhandenen Abschnitte gel\u00f6scht. Wollen Sie fortfahren?", "Stationen \u00fcbernehmen", 2);
            if (res == 0) {
                for (LineBand tmp : bands) {
                    HashMap<CidsBean, CidsBean> stations = new HashMap<CidsBean, CidsBean>();
                    tmp.removeAllMember();
                    for (int i = 0; i < this.vermessungsBand.getNumberOfMembers(); ++i) {
                        CidsBean bean = ((VermessungsbandMember)this.vermessungsBand.getMember(i)).getCidsBean();
                        CidsBean newBean = CidsBeanSupport.createNewCidsBeanFromTableName(cidsBeanTableName);
                        CidsBean von = this.getStationCopy((CidsBean)bean.getProperty("linie.von"), stations);
                        CidsBean bis = this.getStationCopy((CidsBean)bean.getProperty("linie.bis"), stations);
                        tmp.addMember(newBean, von, bis);
                    }
                }
            }
            this.togApplyStats.setSelected(false);
            this.hideVermessungsband();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating the initial bands.", (Throwable)e);
        }
    }

    private CidsBean getStationCopy(CidsBean s, HashMap<CidsBean, CidsBean> stations) {
        CidsBean bean = stations.get(s);
        if (bean == null) {
            Geometry geom;
            bean = LinearReferencingHelper.createStationBeanFromRouteBean((CidsBean)s.getProperty("route"), (Double)s.getProperty("wert"));
            try {
                bean = bean.persist();
                this.createdBeans.add(bean);
                geom = (CidsBean)bean.getProperty("real_point");
                if (geom != null) {
                    this.createdBeans.add((CidsBean)geom);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot persist station.", (Throwable)e);
            }
            geom = LinearReferencedPointFeature.getPointOnLine((double)LinearReferencingHelper.getLinearValueFromStationBean(bean), (Geometry)LinearReferencingHelper.getRouteGeometryFromStationBean(bean));
            geom.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
            try {
                LinearReferencingHelper.setPointGeometryToStationBean(geom, bean);
            }
            catch (Exception ex) {
                LOG.error((Object)"Cannot create geometry for station", (Throwable)ex);
            }
            stations.put(s, bean);
        }
        return bean;
    }

    public List<CidsBean> getAllMembers() {
        ArrayList<CidsBean> others = new ArrayList<CidsBean>();
        for (int i = 0; i < this.vermessungsBand.getNumberOfMembers(); ++i) {
            others.add(((VermessungsbandMember)this.vermessungsBand.getMember(i)).getCidsBean());
        }
        return others;
    }

    public BandMember getSelectedMember() {
        return this.vBand.getSelectedBandMember();
    }

    public void setZoomFactor(double zoom) {
        this.vBand.setZoomFactor(zoom);
    }

    public void setRefreshAvoided(boolean avoided) {
        this.vBand.setRefreshAvoided(avoided);
    }

    public void bandModelChanged() {
        this.vBand.bandModelChanged(null);
    }

    public void dispose() {
        if (this.route != null) {
            FeatureRegistry.getInstance().removeRouteFeature(this.route);
        }
    }

    public void editorClosed(EditorClosedEvent event) {
        if (event.getStatus() == EditorSaveListener.EditorSaveStatus.CANCELED && this.createdBeans != null) {
            for (CidsBean c : this.createdBeans) {
                try {
                    c.delete();
                    c.persist();
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while deleting unused bean.", (Throwable)e);
                }
            }
        }
    }

    public String getLineProperty() {
        return this.lineProperty;
    }

    public void setLineProperty(String lineProperty) {
        this.lineProperty = lineProperty;
    }
}

