/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.gup;

import Sirius.navigator.connection.SessionManager;
import de.cismet.cids.custom.wrrl_db_mv.server.search.WkSearchByStations;
import de.cismet.cids.custom.wrrl_db_mv.util.gup.VermessungsbandHelper;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.jbands.JBand;
import de.cismet.tools.gui.jbands.MinimumHeightBand;
import de.cismet.tools.gui.jbands.SimpleBandModel;
import de.cismet.tools.gui.jbands.SimpleTextSection;
import de.cismet.tools.gui.jbands.interfaces.Band;
import de.cismet.tools.gui.jbands.interfaces.BandMember;
import de.cismet.tools.gui.jbands.interfaces.BandSnappingPointProvider;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class WKBand
extends MinimumHeightBand
implements BandSnappingPointProvider {
    private static final Logger LOG = Logger.getLogger(WKBand.class);
    private double max;
    private double min;
    private ArrayList<ArrayList> inputResulSet;

    public WKBand(double min, double max) {
        this(min, max, (ArrayList<ArrayList>)null);
    }

    public WKBand(double min, double max, ArrayList<ArrayList> inputResulSet) {
        this(min, max, inputResulSet, "WK");
    }

    public WKBand(double min, double max, String title) {
        this(min, max, null, title);
    }

    public WKBand(double min, double max, ArrayList<ArrayList> inputResulSet, String title) {
        super(title);
        this.max = max;
        this.min = min;
        if (inputResulSet != null) {
            this.setWK(inputResulSet);
        }
    }

    public void setWK(ArrayList<ArrayList> inputResulSet) {
        this.removeAllMember();
        this.inputResulSet = inputResulSet;
        if (inputResulSet != null) {
            for (ArrayList zeile : inputResulSet) {
                String wk_k = String.valueOf(zeile.get(0));
                double von = (Double)zeile.get(1);
                double bis = (Double)zeile.get(2);
                boolean openLeft = false;
                boolean openRight = false;
                if (von < this.min) {
                    von = this.min;
                    openLeft = true;
                }
                if (bis > this.max) {
                    bis = this.max;
                    openRight = true;
                }
                this.addMember((BandMember)new SimpleTextSection(wk_k, von, bis, openLeft, openRight));
            }
        }
    }

    public void setMinMax(double min, double max) {
        this.min = min;
        this.max = max;
        if (this.inputResulSet != null) {
            this.setWK(this.inputResulSet);
        }
    }

    public void fillAndInsertBand(SimpleBandModel sbm, String gwk, JBand jband) {
        this.fillAndInsertBand(sbm, gwk, jband, null);
    }

    public void fillAndInsertBand(final SimpleBandModel sbm, final String gwk, final JBand jband, final VermessungsbandHelper vermessungsband) {
        CismetThreadPool.execute((Runnable)new SwingWorker<ArrayList<ArrayList>, Void>(){

            @Override
            protected ArrayList<ArrayList> doInBackground() throws Exception {
                WkSearchByStations searchWK = new WkSearchByStations(sbm.getMin(), sbm.getMax(), gwk);
                Collection resWK = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)searchWK);
                return (ArrayList)resWK;
            }

            @Override
            protected void done() {
                try {
                    ArrayList res = (ArrayList)this.get();
                    WKBand.this.setWK(res);
                    sbm.insertBand((Band)WKBand.this, 0);
                    ((SimpleBandModel)jband.getModel()).fireBandModelChanged();
                    if (vermessungsband != null) {
                        vermessungsband.setWk(res);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Problem beim Suchen der Wasserkoerper", (Throwable)e);
                }
            }
        });
    }
}

