/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.wrrl_db_mv.util.linearreferencing;

import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.wrrl_db_mv.commons.linearreferencing.LinearReferencingConstants;
import de.cismet.cids.custom.wrrl_db_mv.util.CidsBeanSupport;
import de.cismet.cids.custom.wrrl_db_mv.util.linearreferencing.LinearReferencingSingletonInstances;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;

public class LinearReferencingHelper
implements LinearReferencingConstants,
LinearReferencingSingletonInstances {
    private static final String PROP_ROUTE_ROUTENNAME = "routenname";
    private static MetaClass MC_GEOM = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"geom");
    private static MetaClass MC_STATIONLINIE = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"station_linie");
    private static MetaClass MC_STATION = ClassCacheMultiple.getMetaClass((String)"WRRL_DB_MV", (String)"station");
    private static int NEW_STATION_ID = -1;
    private static int NEW_LINE_ID = -1;

    private LinearReferencingHelper() {
    }

    public static double distanceOfStationGeomToRouteGeomFromStationBean(CidsBean cidsBean) {
        Geometry routeGeometry = LinearReferencingHelper.getRouteGeometryFromStationBean(cidsBean);
        Geometry pointGeometry = LinearReferencingHelper.getPointGeometryFromStationBean(cidsBean);
        if (pointGeometry != null) {
            double distance = pointGeometry.distance(routeGeometry);
            return distance;
        }
        return 0.0;
    }

    public static Geometry getRouteGeometryFromStationBean(CidsBean stationBean) {
        return (Geometry)LinearReferencingHelper.getRouteGeomBeanFromStationBean(stationBean).getProperty("geo_field");
    }

    public static void setLinearValueToStationBean(Double value, CidsBean stationBean) throws Exception {
        if (stationBean == null) {
            return;
        }
        stationBean.setProperty("wert", (Object)value);
    }

    public static Geometry getPointGeometryFromStationBean(CidsBean stationBean) {
        return (Geometry)LinearReferencingHelper.getPointGeomBeanFromStationBean(stationBean).getProperty("geo_field");
    }

    public static void setPointGeometryToStationBean(Geometry point, CidsBean stationBean) throws Exception {
        LinearReferencingHelper.getPointGeomBeanFromStationBean(stationBean).setProperty("geo_field", (Object)point);
    }

    public static void setRouteGeometryToStationBean(Geometry geometry, CidsBean stationBean) throws Exception {
        LinearReferencingHelper.getRouteGeomBeanFromStationBean(stationBean).setProperty("geo_field", (Object)geometry);
    }

    public static Long getRouteGwkFromStationBean(CidsBean stationBean) {
        return (Long)LinearReferencingHelper.getRouteBeanFromStationBean(stationBean).getProperty("gwk");
    }

    public static String getRouteNameFromStationBean(CidsBean stationBean) {
        return (String)LinearReferencingHelper.getRouteBeanFromStationBean(stationBean).getProperty(PROP_ROUTE_ROUTENNAME);
    }

    private static CidsBean getPointGeomBeanFromStationBean(CidsBean stationBean) {
        if (stationBean == null) {
            return null;
        }
        return (CidsBean)stationBean.getProperty("real_point");
    }

    public static CidsBean getRouteBeanFromStationBean(CidsBean stationBean) {
        if (stationBean == null) {
            return null;
        }
        return (CidsBean)stationBean.getProperty("route");
    }

    private static CidsBean getRouteGeomBeanFromStationBean(CidsBean stationBean) {
        return (CidsBean)LinearReferencingHelper.getRouteBeanFromStationBean(stationBean).getProperty("geom");
    }

    public static CidsBean createStationBeanFromRouteBean(CidsBean routeBean) {
        return LinearReferencingHelper.createStationBeanFromRouteBean(routeBean, 0.0);
    }

    public static CidsBean createStationBeanFromRouteBean(CidsBean routeBean, double value) {
        CidsBean stationBean;
        block2: {
            stationBean = MC_STATION.getEmptyInstance().getBean();
            CidsBean geomBean = MC_GEOM.getEmptyInstance().getBean();
            try {
                stationBean.setProperty("route", (Object)routeBean);
                stationBean.setProperty("wert", (Object)value);
                stationBean.setProperty("real_point", (Object)geomBean);
                stationBean.setProperty("id", (Object)NEW_STATION_ID);
                stationBean.getMetaObject().setID(NEW_STATION_ID);
                --NEW_STATION_ID;
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"Error while filling bean", (Throwable)ex);
            }
        }
        return stationBean;
    }

    public static CidsBean createLineBeanFromRouteBean(CidsBean routeBean) {
        CidsBean linieBean;
        block3: {
            if (routeBean == null) {
                return null;
            }
            linieBean = MC_STATIONLINIE.getEmptyInstance().getBean();
            CidsBean fromBean = LinearReferencingHelper.createStationBeanFromRouteBean(routeBean);
            CidsBean toBean = LinearReferencingHelper.createStationBeanFromRouteBean(routeBean);
            CidsBean geomBean = MC_GEOM.getEmptyInstance().getBean();
            try {
                toBean.setProperty("wert", (Object)((Geometry)((CidsBean)routeBean.getProperty("geom")).getProperty("geo_field")).getLength());
                linieBean.setProperty("von", (Object)fromBean);
                linieBean.setProperty("bis", (Object)toBean);
                geomBean.setProperty("geo_field", (Object)((Geometry)((CidsBean)routeBean.getProperty("geom")).getProperty("geo_field")));
                linieBean.setProperty("geom", (Object)geomBean);
                linieBean.setProperty("id", (Object)NEW_LINE_ID);
                linieBean.getMetaObject().setID(NEW_LINE_ID);
                --NEW_LINE_ID;
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)"Error while filling bean", (Throwable)ex);
            }
        }
        return linieBean;
    }

    public static double getLinearValueFromStationBean(CidsBean stationBean) {
        if (stationBean == null) {
            return 0.0;
        }
        return (Double)stationBean.getProperty("wert");
    }

    public static CidsBean getStationBeanFromLineBean(CidsBean lineBean, boolean isFrom) {
        if (lineBean == null) {
            return null;
        }
        String stationField = isFrom ? "von" : "bis";
        return (CidsBean)lineBean.getProperty(stationField);
    }

    public static CidsBean getGeomBeanFromLineBean(CidsBean lineBean) {
        if (lineBean == null) {
            return null;
        }
        return (CidsBean)lineBean.getProperty("geom");
    }

    public static void setGeometryToLineBean(Geometry line, CidsBean lineBean) throws Exception {
        if (LinearReferencingHelper.coalesce(LinearReferencingHelper.getStationBeanFromLineBean(lineBean, true).getProperty("ohne_route"), false) || LinearReferencingHelper.coalesce(LinearReferencingHelper.getStationBeanFromLineBean(lineBean, false).getProperty("ohne_route"), false)) {
            return;
        }
        CidsBean geomBean = LinearReferencingHelper.getGeomBeanFromLineBean(lineBean);
        if (geomBean == null) {
            geomBean = CidsBeanSupport.createNewCidsBeanFromTableName("geom");
            lineBean.setProperty("geom", (Object)geomBean);
        }
        if (geomBean != null) {
            geomBean.setProperty("geo_field", (Object)line);
        }
    }

    private static boolean coalesce(Object value, boolean defaultValue) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public static synchronized int getNewStationId() {
        return --NEW_STATION_ID;
    }

    public static synchronized int getNewLineId() {
        return --NEW_LINE_ID;
    }
}

