/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.wfsforms;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PSticky;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.CrsChangeListener;
import de.cismet.cismap.commons.interaction.events.CrsChangedEvent;
import de.cismet.cismap.commons.wfsforms.AbstractWFSForm;
import de.cismet.cismap.commons.wfsforms.WFSFormFeature;
import de.cismet.cismap.commons.wfsforms.WFSFormQuery;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import edu.umd.cs.piccolo.PNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.deegree.datatypes.QualifiedName;
import org.deegree.model.feature.DefaultFeature;
import org.deegree.model.feature.FeatureProperty;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

public class WFSFormGemeindenSearch
extends AbstractWFSForm
implements ActionListener {
    private final Logger log = Logger.getLogger(this.getClass());
    private WFSFormFeature strasse = null;
    private WFSFormFeature gemeinde = null;
    private WFSFormFeature lastVisualizedFeature = null;
    private JComboBox cboGemeinden;
    private JCheckBox chkLockScale;
    private JCheckBox chkVisualize;
    private JButton cmdOk;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel lblBehind;
    private JPanel panFill;
    private JProgressBar prbGemeinden;
    private JTextField txtSearch;

    public WFSFormGemeindenSearch() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"new WFSFormGemeindeSearch");
        }
        try {
            this.initComponents();
            StaticSwingTools.decorateWithFixedAutoCompleteDecorator((JComboBox)this.cboGemeinden);
            this.prbGemeinden.setPreferredSize(new Dimension(1, 5));
            this.cboGemeinden.setRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    DefaultListCellRenderer dlcr = new DefaultListCellRenderer();
                    JLabel lbl = (JLabel)dlcr.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    String additionalInfo = "";
                    try {
                        FeatureProperty[] fpa = ((WFSFormFeature)value).getRawFeatureArray("app", "the_geom", "http://www.deegree.org/app");
                        for (int i = 0; i < fpa.length; ++i) {
                            if (i > 0) {
                                additionalInfo = additionalInfo + ", ";
                            }
                            additionalInfo = additionalInfo + ((DefaultFeature)fpa[i].getValue()).getProperties(new QualifiedName("app", "the_geom", new URI("http://www.deegree.org/app")))[0].getValue().toString();
                        }
                    }
                    catch (Exception ex) {
                        WFSFormGemeindenSearch.this.log.error((Object)ex, (Throwable)ex);
                    }
                    if (additionalInfo != null) {
                        lbl.setToolTipText(additionalInfo);
                    }
                    return lbl;
                }
            });
            this.listComponents.put("cboGemeinden", this.cboGemeinden);
            this.listComponents.put("cboGemeindenProgress", this.prbGemeinden);
            this.pMark.setVisible(false);
            this.pMark.setSweetSpotX(0.5);
            this.pMark.setSweetSpotY(1.0);
            this.txtSearch.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    WFSFormGemeindenSearch.this.doSearch();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    WFSFormGemeindenSearch.this.doSearch();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    WFSFormGemeindenSearch.this.doSearch();
                }
            });
            this.lblBehind.setMinimumSize(new Dimension(94, 16));
            this.lblBehind.setMaximumSize(new Dimension(94, 16));
            this.lblBehind.setPreferredSize(new Dimension(94, 16));
            super.addActionListener((ActionListener)this);
        }
        catch (Exception e) {
            this.log.error((Object)"Could not Create WFForm", (Throwable)e);
        }
    }

    public void garbageDuringAutoCompletion(JComboBox box) {
    }

    private void doSearch() {
        try {
            if (this.txtSearch.getText().length() >= 3) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"doSearch");
                }
                HashMap<String, String> hm = new HashMap<String, String>();
                String newString = this.getRightEncodedString(this.txtSearch.getText());
                hm.put("@@search_text@@", newString);
                this.requestRefresh("cboGemeinden", hm);
            } else {
                this.lblBehind.setText(NbBundle.getMessage(WFSFormGemeindenSearch.class, (String)"WFSFormGemeindenSearch.lblBehind.text"));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Fehler beim Ausf\u00fchren der Suche", (Throwable)e);
        }
    }

    private void initComponents() {
        this.cmdOk = new JButton();
        this.chkVisualize = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.chkLockScale = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.txtSearch = new JTextField();
        this.lblBehind = new JLabel();
        this.panFill = new JPanel();
        this.cboGemeinden = new JComboBox();
        this.prbGemeinden = new JProgressBar();
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setMinimumSize(new Dimension(373, 1));
        this.setLayout(new GridBagLayout());
        this.cmdOk.setMnemonic('P');
        this.cmdOk.setText(NbBundle.getMessage(WFSFormGemeindenSearch.class, (String)"WFSFormGemeindenSearch.cmdOk.text"));
        this.cmdOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WFSFormGemeindenSearch.this.cmdOkActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.add(this.cmdOk, gridBagConstraints);
        this.chkVisualize.setSelected(true);
        this.chkVisualize.setToolTipText(NbBundle.getMessage(WFSFormGemeindenSearch.class, (String)"WFSFormGemeindenSearch.chkVisualize.toolTipText"));
        this.chkVisualize.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkVisualize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WFSFormGemeindenSearch.this.chkVisualizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 7, 0, 0);
        this.add(this.chkVisualize, gridBagConstraints);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/markPoint.png")));
        this.jLabel1.setToolTipText(NbBundle.getMessage(WFSFormGemeindenSearch.class, (String)"WFSFormGemeindenSearch.jLabel1.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 7, 0, 0);
        this.add(this.jLabel1, gridBagConstraints);
        this.chkLockScale.setSelected(true);
        this.chkLockScale.setToolTipText(NbBundle.getMessage(WFSFormGemeindenSearch.class, (String)"WFSFormGemeindenSearch.chkLockScale.toolTipText"));
        this.chkLockScale.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 14, 0, 0);
        this.add(this.chkLockScale, gridBagConstraints);
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/fixMapScale.png")));
        this.jLabel2.setToolTipText(NbBundle.getMessage(WFSFormGemeindenSearch.class, (String)"WFSFormGemeindenSearch.jLabel2.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 7, 0, 0);
        this.add(this.jLabel2, gridBagConstraints);
        this.txtSearch.setMaximumSize(new Dimension(220, 19));
        this.txtSearch.setMinimumSize(new Dimension(220, 19));
        this.txtSearch.setPreferredSize(new Dimension(220, 19));
        this.txtSearch.addInputMethodListener(new InputMethodListener(){

            @Override
            public void inputMethodTextChanged(InputMethodEvent evt) {
                WFSFormGemeindenSearch.this.txtSearchInputMethodTextChanged(evt);
            }

            @Override
            public void caretPositionChanged(InputMethodEvent evt) {
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.add(this.txtSearch, gridBagConstraints);
        this.lblBehind.setText(NbBundle.getMessage(WFSFormGemeindenSearch.class, (String)"WFSFormGemeindenSearch.lblBehind.text"));
        this.lblBehind.setMaximumSize(new Dimension(150, 14));
        this.lblBehind.setMinimumSize(new Dimension(150, 14));
        this.lblBehind.setPreferredSize(new Dimension(150, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add(this.lblBehind, gridBagConstraints);
        this.panFill.setMinimumSize(new Dimension(1, 1));
        this.panFill.setPreferredSize(new Dimension(1, 1));
        GroupLayout panFillLayout = new GroupLayout((Container)this.panFill);
        this.panFill.setLayout((LayoutManager)panFillLayout);
        panFillLayout.setHorizontalGroup((GroupLayout.Group)panFillLayout.createParallelGroup(1).add(0, 11, Short.MAX_VALUE));
        panFillLayout.setVerticalGroup((GroupLayout.Group)panFillLayout.createParallelGroup(1).add(0, 34, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.panFill, gridBagConstraints);
        this.cboGemeinden.setEnabled(false);
        this.cboGemeinden.setMaximumSize(new Dimension(27, 19));
        this.cboGemeinden.setMinimumSize(new Dimension(27, 19));
        this.cboGemeinden.setPreferredSize(new Dimension(27, 19));
        this.cboGemeinden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WFSFormGemeindenSearch.this.cboGemeindenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 30.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.add(this.cboGemeinden, gridBagConstraints);
        this.prbGemeinden.setBorderPainted(false);
        this.prbGemeinden.setMaximumSize(new Dimension(100, 5));
        this.prbGemeinden.setMinimumSize(new Dimension(100, 5));
        this.prbGemeinden.setPreferredSize(new Dimension(100, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 10);
        this.add(this.prbGemeinden, gridBagConstraints);
    }

    private void txtSearchInputMethodTextChanged(InputMethodEvent evt) {
        this.log.fatal((Object)"kik");
    }

    private void chkVisualizeActionPerformed(ActionEvent evt) {
        if (this.gemeinde != null) {
            this.visualizePosition(this.chkVisualize.isSelected());
        }
    }

    public void visualizePosition(boolean showMarker) {
        this.lastVisualizedFeature = this.gemeinde;
        this.mappingComponent.getHighlightingLayer().removeAllChildren();
        this.mappingComponent.getHighlightingLayer().addChild((PNode)this.pMark);
        this.mappingComponent.addStickyNode((PSticky)this.pMark);
        Point p = (Point)CrsTransformer.transformToGivenCrs((Geometry)((Point)this.getPointFromGemeinde()), (String)this.mappingComponent.getMappingModel().getSrs().getCode());
        double x = this.mappingComponent.getWtst().getScreenX(p.getCoordinate().x);
        double y = this.mappingComponent.getWtst().getScreenY(p.getCoordinate().y);
        this.pMark.setOffset(x, y);
        this.pMark.setVisible(showMarker);
        this.mappingComponent.rescaleStickyNodes();
        CismapBroker.getInstance().removeCrsChangeListener((CrsChangeListener)this);
        CismapBroker.getInstance().addCrsChangeListener((CrsChangeListener)this);
    }

    public void crsChanged(CrsChangedEvent event) {
        if (this.mappingComponent.getHighlightingLayer().getAllNodes().contains(this.pMark) && this.lastVisualizedFeature != null) {
            this.visualizePosition(this.lastVisualizedFeature, this.pMark.getVisible());
        }
    }

    private void cmdOkActionPerformed(ActionEvent evt) {
        boolean history = true;
        MappingComponent mc = this.getMappingComponent();
        if (mc == null) {
            mc = CismapBroker.getInstance().getMappingComponent();
        }
        boolean scaling = !mc.isFixedMapScale() && !this.chkLockScale.isSelected();
        XBoundingBox bb = null;
        int animation = mc.getAnimationDuration();
        if (this.gemeinde == null) {
            return;
        }
        bb = new XBoundingBox(this.getPointFromGemeinde().buffer(1000.0));
        mc.gotoBoundingBox((BoundingBox)bb, true, scaling, animation);
        this.chkVisualizeActionPerformed(null);
    }

    private Geometry getPointFromGemeinde() {
        URI uri = this.gemeinde.getFeature().getProperties()[0].getName().getNamespace();
        QualifiedName qNameHWert = new QualifiedName("hochwert", uri);
        QualifiedName qNameRWert = new QualifiedName("rechstwert", uri);
        String hochwert = (String)this.gemeinde.getFeature().getProperties(qNameHWert)[0].getValue();
        String rechtswert = (String)this.gemeinde.getFeature().getProperties(qNameRWert)[0].getValue();
        double h = Double.parseDouble(hochwert);
        double r = Double.parseDouble(rechtswert);
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 5650);
        return factory.createPoint(new Coordinate(r, h));
    }

    private void cboGemeindenActionPerformed(ActionEvent evt) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"cboGemeindenActionPerformed()");
        }
        if (this.cboGemeinden.getSelectedItem() instanceof WFSFormFeature) {
            this.gemeinde = (WFSFormFeature)this.cboGemeinden.getSelectedItem();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.lblBehind.setText(NbBundle.getMessage(WFSFormGemeindenSearch.class, (String)"WFSFormGemeindenSearch.lblBehind.text2", (Object[])new Object[]{this.cboGemeinden.getItemCount()}));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("cboGemeinden.getItemAt(0):" + this.cboGemeinden.getItemAt(0)));
        }
        if (this.cboGemeinden.getItemCount() == 1) {
            this.cboGemeinden.setEditable(false);
            this.cboGemeinden.setSelectedItem(this.cboGemeinden.getItemAt(0));
            this.cboGemeinden.setEditable(true);
        }
    }

    public static void main(String[] args) throws Exception {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        WFSFormQuery gem = new WFSFormQuery();
        gem.setComponentName("cboGemeinden");
        gem.setServerUrl("http://wfs.fis-wasser-mv.de/services");
        gem.setPropertyNamespace("http://www.deegree.org/app");
        gem.setPropertyPrefix("app");
        gem.setDisplayTextProperty("gen");
        gem.setExtentProperty("the_geom");
        gem.setFilename("/de/cismet/cismap/custom/wfsforms/gemeindentestrequest.xml");
        gem.setId("gemeinden_suche");
        gem.setIdProperty("id");
        gem.setTitle("Suche nach Gemeinden");
        gem.setType("FOLLOWUP");
        gem.setWfsQueryString(WFSFormGemeindenSearch.readFileFromRessourceAsString("/de/cismet/cismap/custom/wfsforms/gemeindentestrequest.xml"));
        System.out.println(gem.getWfsQueryString());
        JFrame f = new JFrame("Test");
        f.setDefaultCloseOperation(3);
        WFSFormGemeindenSearch s = new WFSFormGemeindenSearch();
        Vector<WFSFormQuery> v = new Vector<WFSFormQuery>();
        v.add(gem);
        s.setQueries(v);
        f.getContentPane().setLayout(new BorderLayout());
        f.getContentPane().add((Component)((Object)s), "Center");
        f.pack();
        f.setVisible(true);
    }

    private static String readFileFromRessourceAsString(String file) throws IOException {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        StringBuffer fileData = new StringBuffer(1000);
        URL url = WFSFormGemeindenSearch.class.getResource(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

    private String getRightEncodedString(String s) {
        String ret = s;
        ret = ret.replaceAll("\u00e4", "&#228;");
        ret = ret.replaceAll("\u00c4", "&#196;");
        ret = ret.replaceAll("\u00f6", "&#246;");
        ret = ret.replaceAll("\u00d6", "&#214;");
        ret = ret.replaceAll("\u00fc", "&#252;");
        ret = ret.replaceAll("\u00dc", "&#220;");
        ret = ret.replaceAll("\u00df", "&#223;");
        return ret;
    }
}

