/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import org.apache.log4j.Logger;

import org.jdesktop.swingx.JXList;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;

import java.io.IOException;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;

import de.cismet.cids.dynamics.CidsBean;

import static de.cismet.cids.custom.objecteditors.wunda_blau.GrundwassermessstelleMesswerteDiagrammPanel.STOFF_BEAN_FLAVOR;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class GrundwassermessstelleDiagrammAxisPanel extends javax.swing.JPanel {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = Logger.getLogger(GrundwassermessstelleDiagrammAxisPanel.class);

    //~ Instance fields --------------------------------------------------------

    private final GrundwassermessstelleMesswerteDiagrammPanel diagrammPanel;

    private final List<CidsBean> disabledStoffBeans = new ArrayList<>();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JList<CidsBean> jList1;
    private javax.swing.JScrollPane jScrollPane3;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new GrundwassermessstelleDiagrammAxisPanel object.
     */
    public GrundwassermessstelleDiagrammAxisPanel() {
        initComponents();
        diagrammPanel = null;
    }

    /**
     * Creates a new GrundwassermessstelleDiagrammAxisPanel object.
     *
     * @param  diagrammPanel  DOCUMENT ME!
     */
    public GrundwassermessstelleDiagrammAxisPanel(final GrundwassermessstelleMesswerteDiagrammPanel diagrammPanel) {
        this.diagrammPanel = diagrammPanel;

        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @param  stoffBeans  DOCUMENT ME!
     */
    public void setStoffBeans(final Collection<CidsBean> stoffBeans) {
        disabledStoffBeans.clear();
        ((DefaultListModel<CidsBean>)jList1.getModel()).clear();
        if (stoffBeans != null) {
            for (final CidsBean stoffBean : stoffBeans) {
                ((DefaultListModel<CidsBean>)jList1.getModel()).addElement(stoffBean);
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  name  DOCUMENT ME!
     */
    public void setAxisName(final String name) {
        jLabel1.setText(name);
        jLabel1.setVisible(name != null);
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public String getAxisName() {
        return jLabel1.getText();
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jScrollPane3 = new javax.swing.JScrollPane();
        jList1 = new MesswerteList();

        setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel1,
            org.openide.util.NbBundle.getMessage(
                GrundwassermessstelleDiagrammAxisPanel.class,
                "GrundwassermessstelleDiagrammAxisPanel.jLabel1.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        add(jLabel1, gridBagConstraints);

        jScrollPane3.setBorder(null);
        jScrollPane3.setViewportBorder(null);

        jList1.setBorder(null);
        jList1.setCellRenderer(new MesswerteListCellRenderer());
        jList1.addMouseListener(new java.awt.event.MouseAdapter() {

                @Override
                public void mouseClicked(final java.awt.event.MouseEvent evt) {
                    jList1MouseClicked(evt);
                }
            });
        jScrollPane3.setViewportView(jList1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(jScrollPane3, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jList1MouseClicked(final java.awt.event.MouseEvent evt) { //GEN-FIRST:event_jList1MouseClicked
        final JList list = (JList)evt.getSource();
        if (evt.getClickCount() == 2) {
            final int index = list.locationToIndex(evt.getPoint());
            final CidsBean stoffBean = ((DefaultListModel<CidsBean>)list.getModel()).get(index);
            if (stoffBean != null) {
                if (disabledStoffBeans.contains(stoffBean)) {
                    disabledStoffBeans.remove(stoffBean);
                } else {
                    disabledStoffBeans.add(stoffBean);
                }
                diagrammPanel.refreshChart();
                list.repaint();
            }
        }
    }                                                                      //GEN-LAST:event_jList1MouseClicked

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public List<CidsBean> getStoffBeans() {
        final List<CidsBean> stoffBeans = new ArrayList<>();
        final DefaultListModel<CidsBean> model = (DefaultListModel)jList1.getModel();
        for (int index = 0; index < model.getSize(); index++) {
            final CidsBean stoffBean = model.getElementAt(index);
            stoffBeans.add(stoffBean);
        }
        return stoffBeans;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public List<CidsBean> getEnabledStoffBeans() {
        final List<CidsBean> stoffBeans = getStoffBeans();
        stoffBeans.removeAll(disabledStoffBeans);
        return stoffBeans;
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class MesswerteListCellRenderer extends DefaultListCellRenderer {

        //~ Methods ------------------------------------------------------------

        @Override
        public Component getListCellRendererComponent(final JList list,
                final Object value,
                final int index,
                final boolean isSelected,
                final boolean cellHasFocus) {
            final JLabel label = (JLabel)super.getListCellRendererComponent(
                    list,
                    value,
                    index,
                    false,
                    cellHasFocus);
            final CidsBean stoffBean = (CidsBean)value;
            final String schluessel = (String)stoffBean.getProperty("schluessel");

            final boolean enabled = !disabledStoffBeans.contains(stoffBean);
            label.setEnabled(enabled);
            if (enabled) {
                label.setIcon(diagrammPanel.createIcon(schluessel));
            } else {
                label.setDisabledIcon(diagrammPanel.createIcon(null));
            }
            final String name = (String)stoffBean.getProperty("name");
            final String einheit = (String)stoffBean.getProperty("einheit");

            label.setText(name + ((einheit != null) ? (" (" + einheit + ")") : ""));
            return label;
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class MesswerteListDnDObject {

        //~ Instance fields ----------------------------------------------------

        private final CidsBean stoffBean;
        private final MesswerteList source;

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new MesswerteListDnDObject object.
         *
         * @param  stoffBean  DOCUMENT ME!
         * @param  source     DOCUMENT ME!
         */
        MesswerteListDnDObject(final CidsBean stoffBean, final MesswerteList source) {
            this.stoffBean = stoffBean;
            this.source = source;
        }

        //~ Methods ------------------------------------------------------------

        /**
         * DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        public CidsBean getStoffBean() {
            return stoffBean;
        }

        /**
         * DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        public MesswerteList getSource() {
            return source;
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class MesswerteList extends JXList implements DropTargetListener, DragGestureListener, DragSourceListener {

        //~ Instance fields ----------------------------------------------------

        private final transient DragSource dragSource = DragSource.getDefaultDragSource();

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new MesswerteList object.
         */
        public MesswerteList() {
            super(new DefaultListModel<>());
            dragSource.createDefaultDragGestureRecognizer(this, DnDConstants.ACTION_COPY_OR_MOVE, this);
            new DropTarget(this, DnDConstants.ACTION_COPY_OR_MOVE, this);
        }

        //~ Methods ------------------------------------------------------------

        @Override
        public void dragGestureRecognized(final DragGestureEvent dge) {
            final int index = this.locationToIndex(dge.getDragOrigin());
            final CidsBean stoffBean = getModel().getElementAt(this.convertIndexToModel(index));
            dragSource.startDrag(
                dge,
                DragSource.DefaultMoveDrop,
                new StoffBeanTransferable(new MesswerteListDnDObject(stoffBean, this)),
                this);
        }

        @Override
        public void drop(final DropTargetDropEvent dtde) {
            try {
                final Object o = dtde.getTransferable().getTransferData(STOFF_BEAN_FLAVOR);
                if (o instanceof MesswerteListDnDObject) {
                    final MesswerteListDnDObject mldo = (MesswerteListDnDObject)o;
                    if (!this.equals(mldo.getSource())) {
                        final CidsBean stoffBean = mldo.getStoffBean();
                        final DefaultListModel<CidsBean> model =
                            ((MesswerteList)dtde.getDropTargetContext().getComponent()).getModel();
                        if (!model.contains(stoffBean)) {
                            model.addElement(stoffBean);
                        }
                        dtde.dropComplete(true);
                    }
                }
            } catch (final Exception e) {
                LOG.error("could not drop", e); // NOI18N
                dtde.dropComplete(false);
            }
        }

        @Override
        public void dragDropEnd(final DragSourceDropEvent dsde) {
            if (dsde.getDropSuccess()) {
                try {
                    final Object o = dsde.getDragSourceContext().getTransferable().getTransferData(STOFF_BEAN_FLAVOR);
                    if (o instanceof MesswerteListDnDObject) {
                        final MesswerteListDnDObject mldo = (MesswerteListDnDObject)o;
                        final CidsBean stoffBean = mldo.getStoffBean();
                        final DefaultListModel<CidsBean> model =
                            ((MesswerteList)dsde.getDragSourceContext().getComponent()).getModel();
                        if (model.contains(stoffBean)) {
                            model.removeElement(stoffBean);
                            disabledStoffBeans.remove(stoffBean);
                        }
                    }
                    diagrammPanel.refreshChart();
                    jList1.revalidate();
                } catch (final Exception ex) {
                    LOG.warn("could not obtain transferable data", ex); // NOI18N
                }
            }
        }

        @Override
        public void dragEnter(final DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(final DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(final DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(final DropTargetEvent dte) {
        }

        @Override
        public DefaultListModel<CidsBean> getModel() {
            return (DefaultListModel<CidsBean>)super.getModel();
        }

        @Override
        public void dragEnter(final DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(final DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(final DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(final DragSourceEvent dse) {
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class StoffBeanTransferable implements Transferable {

        //~ Instance fields ----------------------------------------------------

        private final MesswerteListDnDObject stoffBean;

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new StoffBeanTransferable object.
         *
         * @param  stoffBean  DOCUMENT ME!
         */
        public StoffBeanTransferable(final MesswerteListDnDObject stoffBean) {
            this.stoffBean = stoffBean;
        }

        //~ Methods ------------------------------------------------------------

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[] { STOFF_BEAN_FLAVOR };
        }

        @Override
        public boolean isDataFlavorSupported(final DataFlavor flavor) {
            return flavor.match(STOFF_BEAN_FLAVOR);
        }

        @Override
        public Object getTransferData(final DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return flavor.match(STOFF_BEAN_FLAVOR) ? stoffBean : null;
        }
    }
}
