/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau.albo;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.ui.ComponentRegistry;

import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;

import com.vividsolutions.jts.geom.Geometry;

import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.swingx.JXTable;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

import de.cismet.cids.custom.clientutils.CidsBeansTableModel;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.objectrenderer.utils.CidsBeanSupport;
import de.cismet.cids.custom.wunda_blau.search.server.AlboFlaecheErhebungsnummerSearch;
import de.cismet.cids.custom.wunda_blau.search.server.AlboVorgangLightweightSearch;
import de.cismet.cids.custom.wunda_blau.search.server.AlboVorgangSearch;
import de.cismet.cids.custom.wunda_blau.search.server.BplaeneMonSearch;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.editors.DefaultBindableScrollableComboBox;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.hooks.AfterSavingHook;

import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;

import de.cismet.cismap.commons.CrsTransformer;

import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;

import de.cismet.tools.gui.StaticSwingTools;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class AlboFlaecheMainPanel extends AbstractAlboFlaechePanel implements AfterSavingHook {

    //~ Methods ----------------------------------------------------------------

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        comboBoxFilterDialog1 = AlboFlaecheVorgangFilterDialog.getInstance();
        panLinks = new javax.swing.JPanel();
        panBeschreibung = new javax.swing.JPanel();
        alboFlaecheBeschreibungPanel1 =
            new de.cismet.cids.custom.objecteditors.wunda_blau.albo.AlboFlaecheMainBeschreibungPanel(isEditable());
        panTop = new javax.swing.JPanel();
        jLabel8 = new javax.swing.JLabel();
        jTextField9 = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        jTextField6 = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        jPanel10 = new javax.swing.JPanel();
        jButton3 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        filler7 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 32767));
        jScrollPane4 = new javax.swing.JScrollPane();
        jXTable1 = new DroppedBeansTable();
        jButton1 = new javax.swing.JButton();
        panRechts = new javax.swing.JPanel();
        panOrt = new javax.swing.JPanel();
        alboFlaecheOrtPanel1 = new de.cismet.cids.custom.objecteditors.wunda_blau.albo.AlboFlaecheMainOrtPanel(
                isEditable());
        jPanel9 = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        jList2 = new javax.swing.JList<>();
        panSpezifisch = new javax.swing.JPanel();
        panSonstige = new javax.swing.JPanel();
        jLabel55 = new javax.swing.JLabel();
        filler35 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(32767, 32767));
        panStandort = new javax.swing.JPanel();
        alboFlaecheStandortePanel1 =
            new de.cismet.cids.custom.objecteditors.wunda_blau.albo.AlboFlaecheMainStandortePanel(isEditable());
        filler29 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(32767, 32767));
        panAltablagerung = new javax.swing.JPanel();
        alboFlaecheAltablagerungPanel1 =
            new de.cismet.cids.custom.objecteditors.wunda_blau.albo.AlboFlaecheMainAltablagerungPanel(isEditable());
        filler27 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(32767, 32767));
        panRcl = new javax.swing.JPanel();
        alboFlaecheRclPanel1 = new de.cismet.cids.custom.objecteditors.wunda_blau.albo.AlboFlaecheMainRclPanel(
                isEditable());
        filler39 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(32767, 32767));
        panStoffliche = new javax.swing.JPanel();
        filler40 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(32767, 32767));
        alboFlaecheStofflichePanel1 =
            new de.cismet.cids.custom.objecteditors.wunda_blau.albo.AlboFlaecheMainStofflichePanel(isEditable());

        final FormListener formListener = new FormListener();

        comboBoxFilterDialog1.setName("comboBoxFilterDialog1"); // NOI18N

        setName("Form"); // NOI18N
        setOpaque(false);
        setLayout(new java.awt.GridBagLayout());

        panLinks.setName("panLinks"); // NOI18N
        panLinks.setOpaque(false);
        panLinks.setLayout(new java.awt.GridBagLayout());

        panBeschreibung.setBorder(javax.swing.BorderFactory.createTitledBorder("<html><b>Beschreibung"));
        panBeschreibung.setName("panBeschreibung"); // NOI18N
        panBeschreibung.setOpaque(false);
        panBeschreibung.setLayout(new java.awt.GridBagLayout());

        alboFlaecheBeschreibungPanel1.setName("alboFlaecheBeschreibungPanel1"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panBeschreibung.add(alboFlaecheBeschreibungPanel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panLinks.add(panBeschreibung, gridBagConstraints);

        panTop.setOpaque(false);

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_ONCE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${UIClassID}"),
                panTop,
                org.jdesktop.beansbinding.BeanProperty.create("name"));
        bindingGroup.addBinding(binding);

        panTop.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(jLabel8, "Erhebungs-Nr.:");
        jLabel8.setName("jLabel8"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        panTop.add(jLabel8, gridBagConstraints);

        jTextField9.setName("jTextField9"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.erhebungsnummer}"),
                jTextField9,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        panTop.add(jTextField9, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel7, "FISAlBo-Nr.:");
        jLabel7.setName("jLabel7"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(2, 10, 2, 2);
        panTop.add(jLabel7, gridBagConstraints);

        jTextField6.setName("jTextField6"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean.geodaten_id}"),
                jTextField6,
                org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        panTop.add(jTextField6, gridBagConstraints);

        jPanel2.setName("jPanel2"); // NOI18N
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel10.setName("jPanel10"); // NOI18N
        jPanel10.setOpaque(false);
        jPanel10.setLayout(new java.awt.GridBagLayout());

        jButton3.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/optionspanels/wunda_blau/add.png"))); // NOI18N
        jButton3.setName("jButton3");                                                                // NOI18N
        jButton3.addActionListener(formListener);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.PAGE_START;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        jPanel10.add(jButton3, gridBagConstraints);
        jButton3.setVisible(isEditable());

        jButton2.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/optionspanels/wunda_blau/remove.png"))); // NOI18N
        jButton2.setName("jButton2");                                                                   // NOI18N
        jButton2.addActionListener(formListener);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.PAGE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel10.add(jButton2, gridBagConstraints);
        jButton2.setVisible(isEditable());

        filler7.setName("filler7"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        jPanel10.add(filler7, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel2.add(jPanel10, gridBagConstraints);

        jScrollPane4.setMinimumSize(new java.awt.Dimension(26, 100));
        jScrollPane4.setName("jScrollPane4"); // NOI18N
        jScrollPane4.setPreferredSize(new java.awt.Dimension(2, 100));

        jXTable1.setModel(new FlaecheVorgangTableModel());
        jXTable1.setName("jXTable1"); // NOI18N
        jXTable1.addMouseListener(formListener);
        jScrollPane4.setViewportView(jXTable1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add(jScrollPane4, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(10, 2, 2, 2);
        panTop.add(jPanel2, gridBagConstraints);

        jButton1.setToolTipText("Erhebungsnummer setzen");
        jButton1.setName("jButton1"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        panTop.add(jButton1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 15);
        panLinks.add(panTop, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        add(panLinks, gridBagConstraints);

        panRechts.setName("panRechts"); // NOI18N
        panRechts.setOpaque(false);
        panRechts.setLayout(new java.awt.GridBagLayout());

        panOrt.setBorder(javax.swing.BorderFactory.createTitledBorder("<html><b>Karte"));
        panOrt.setName("panOrt"); // NOI18N
        panOrt.setOpaque(false);
        panOrt.setLayout(new java.awt.GridBagLayout());

        alboFlaecheOrtPanel1.setName("alboFlaecheOrtPanel1"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panOrt.add(alboFlaecheOrtPanel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panRechts.add(panOrt, gridBagConstraints);

        jPanel9.setBorder(javax.swing.BorderFactory.createTitledBorder("B-Pläne"));
        jPanel9.setName("jPanel9"); // NOI18N
        jPanel9.setOpaque(false);
        jPanel9.setLayout(new java.awt.GridBagLayout());

        jScrollPane3.setMinimumSize(new java.awt.Dimension(26, 66));
        jScrollPane3.setName("jScrollPane3"); // NOI18N

        jList2.setName("jList2"); // NOI18N
        jList2.setVisibleRowCount(4);
        jList2.addMouseListener(formListener);
        jScrollPane3.setViewportView(jList2);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel9.add(jScrollPane3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panRechts.add(jPanel9, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(panRechts, gridBagConstraints);

        panSpezifisch.setBorder(javax.swing.BorderFactory.createTitledBorder("wird geladen..."));
        panSpezifisch.setName("panSpezifisch"); // NOI18N
        panSpezifisch.setOpaque(false);
        panSpezifisch.setLayout(new java.awt.CardLayout());

        panSonstige.setName("panSonstige"); // NOI18N
        panSonstige.setOpaque(false);
        panSonstige.setLayout(new java.awt.GridBagLayout());

        jLabel55.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel55, "<html><h2>Flächen zu denen Informationen vorliegen.");
        jLabel55.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jLabel55.setName("jLabel55"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panSonstige.add(jLabel55, gridBagConstraints);

        filler35.setName("filler35"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panSonstige.add(filler35, gridBagConstraints);

        panSpezifisch.add(panSonstige, "sonstige");

        panStandort.setName("panStandort"); // NOI18N
        panStandort.setOpaque(false);
        panStandort.setLayout(new java.awt.GridBagLayout());

        alboFlaecheStandortePanel1.setName("alboFlaecheStandortePanel1"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panStandort.add(alboFlaecheStandortePanel1, gridBagConstraints);

        filler29.setName("filler29"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panStandort.add(filler29, gridBagConstraints);

        panSpezifisch.add(panStandort, "standort");

        panAltablagerung.setName("panAltablagerung"); // NOI18N
        panAltablagerung.setOpaque(false);
        panAltablagerung.setLayout(new java.awt.GridBagLayout());

        alboFlaecheAltablagerungPanel1.setName("alboFlaecheAltablagerungPanel1"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panAltablagerung.add(alboFlaecheAltablagerungPanel1, gridBagConstraints);

        filler27.setName("filler27"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panAltablagerung.add(filler27, gridBagConstraints);

        panSpezifisch.add(panAltablagerung, "altablagerung");

        panRcl.setName("panRcl"); // NOI18N
        panRcl.setOpaque(false);
        panRcl.setLayout(new java.awt.GridBagLayout());

        alboFlaecheRclPanel1.setName("alboFlaecheRclPanel1"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panRcl.add(alboFlaecheRclPanel1, gridBagConstraints);

        filler39.setName("filler35"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panRcl.add(filler39, gridBagConstraints);

        panSpezifisch.add(panRcl, "rcl");

        panStoffliche.setName("panStoffliche"); // NOI18N
        panStoffliche.setOpaque(false);
        panStoffliche.setLayout(new java.awt.GridBagLayout());

        filler40.setName("filler40"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        panStoffliche.add(filler40, gridBagConstraints);

        alboFlaecheStofflichePanel1.setName("alboFlaecheStofflichePanel1"); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        panStoffliche.add(alboFlaecheStofflichePanel1, gridBagConstraints);

        panSpezifisch.add(panStoffliche, "stoffliche");

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 5);
        add(panSpezifisch, gridBagConstraints);

        bindingGroup.bind();
    }

    /**
     * Code for dispatching events from components to event handlers.
     *
     * @version  $Revision$, $Date$
     */
    private class FormListener implements java.awt.event.ActionListener, java.awt.event.MouseListener {

        /**
         * Creates a new FormListener object.
         */
        FormListener() {
        }

        @Override
        public void actionPerformed(final java.awt.event.ActionEvent evt) {
            if (evt.getSource() == jButton3) {
                AlboFlaecheMainPanel.this.jButton3ActionPerformed(evt);
            } else if (evt.getSource() == jButton2) {
                AlboFlaecheMainPanel.this.jButton2ActionPerformed(evt);
            }
        }

        @Override
        public void mouseClicked(final java.awt.event.MouseEvent evt) {
            if (evt.getSource() == jXTable1) {
                AlboFlaecheMainPanel.this.jXTable1MouseClicked(evt);
            } else if (evt.getSource() == jList2) {
                AlboFlaecheMainPanel.this.jList2MouseClicked(evt);
            }
        }

        @Override
        public void mouseEntered(final java.awt.event.MouseEvent evt) {
        }

        @Override
        public void mouseExited(final java.awt.event.MouseEvent evt) {
        }

        @Override
        public void mousePressed(final java.awt.event.MouseEvent evt) {
        }

        @Override
        public void mouseReleased(final java.awt.event.MouseEvent evt) {
        }
    } // </editor-fold>//GEN-END:initComponents

    private static final String[] COLUMN_PROPERTIES = new String[] {
            "schluessel",
            "fk_strasse.name||\" \"||hausnummer",
            "{gutachten || gutachten_digital}",
            "[1]",
            "ordner_nummer",
            "[0]"
        };
    private static final String[] COLUMN_NAMES = new String[] {
            "Vorgang",
            "Straße",
            "Gutachten",
            "Ordner-Art",
            "Ordner-Nummer",
            "Auskunft"
        };
    private static final Class[] COLUMN_CLASSES = new Class[] {
            String.class,  // Schlüssel
            String.class,  // Straße
            Boolean.class, // Gutachten
            String.class,  // Ordner-Art
            String.class,  // Ordner-Nummer
            Boolean.class  // Auskunft
        };
    private static final CidsBeansTableModel.PropertyRenderer[] PROPERTY_RENDERER = {
            new CidsBeansTableModel.PropertyRenderer() {

                @Override
                public Object getValue(final CidsBean bean) {
                    if (bean != null) {
                        final List<CidsBean> bearbeitungen = CidsBeanSupport.getBeanCollectionFromProperty(
                                bean,
                                "n_bearbeitungen");
                        Boolean onlyInfos = null;

                        if (bearbeitungen != null) {
                            for (final CidsBean bearbeitung : bearbeitungen) {
                                if ((bearbeitung.getProperty("fk_geschaeft.schluessel") != null)
                                            && bearbeitung.getProperty("fk_geschaeft.schluessel").equals("Auskünfte")) {
                                    if (onlyInfos == null) {
                                        onlyInfos = true;
                                    }
                                } else {
                                    onlyInfos = false;
                                }
                            }

                            if ((onlyInfos != null) && onlyInfos) {
                                return true;
                            } else {
                                return false;
                            }
                        }
                    }

                    return null;
                }
            }
            ,
            new CidsBeansTableModel.PropertyRenderer() {

                @Override
                public Object getValue(final CidsBean bean) {
                    if (bean != null) {
                        final String[] prop = { "art_steh", "art_haenge", "art_digital" };
                        final String[] name = { "Steh", "Hänge", "Digital" };
                        String result = null;

                        for (int i = 0; i < prop.length; ++i) {
                            final Object propValue = (Boolean)bean.getProperty(prop[i]);

                            if ((propValue instanceof Boolean) && (Boolean)propValue) {
                                if (result == null) {
                                    result = name[i];
                                } else {
                                    result += "/" + name[i];
                                }
                            }
                        }

                        return result;
                    }

                    return null;
                }
            }
        };

    //~ Instance fields --------------------------------------------------------

    private boolean unlocked = false;
    private List<CidsBean> originVorgangObjects = new ArrayList<CidsBean>();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private de.cismet.cids.custom.objecteditors.wunda_blau.albo.AlboFlaecheMainAltablagerungPanel
        alboFlaecheAltablagerungPanel1;
    private de.cismet.cids.custom.objecteditors.wunda_blau.albo.AlboFlaecheMainBeschreibungPanel
        alboFlaecheBeschreibungPanel1;
    private de.cismet.cids.custom.objecteditors.wunda_blau.albo.AlboFlaecheMainOrtPanel alboFlaecheOrtPanel1;
    private de.cismet.cids.custom.objecteditors.wunda_blau.albo.AlboFlaecheMainRclPanel alboFlaecheRclPanel1;
    private de.cismet.cids.custom.objecteditors.wunda_blau.albo.AlboFlaecheMainStandortePanel
        alboFlaecheStandortePanel1;
    private de.cismet.cids.custom.objecteditors.wunda_blau.albo.AlboFlaecheMainStofflichePanel
        alboFlaecheStofflichePanel1;
    private de.cismet.cids.custom.objecteditors.wunda_blau.albo.ComboBoxFilterDialog comboBoxFilterDialog1;
    private javax.swing.Box.Filler filler27;
    private javax.swing.Box.Filler filler29;
    private javax.swing.Box.Filler filler35;
    private javax.swing.Box.Filler filler39;
    private javax.swing.Box.Filler filler40;
    private javax.swing.Box.Filler filler7;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JLabel jLabel55;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JList<CidsBean> jList2;
    private javax.swing.JPanel jPanel10;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JTextField jTextField6;
    private javax.swing.JTextField jTextField9;
    private javax.swing.JTable jXTable1;
    private javax.swing.JPanel panAltablagerung;
    private javax.swing.JPanel panBeschreibung;
    private javax.swing.JPanel panLinks;
    private javax.swing.JPanel panOrt;
    private javax.swing.JPanel panRcl;
    private javax.swing.JPanel panRechts;
    private javax.swing.JPanel panSonstige;
    private javax.swing.JPanel panSpezifisch;
    private javax.swing.JPanel panStandort;
    private javax.swing.JPanel panStoffliche;
    private javax.swing.JPanel panTop;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new AlboFlaecheMainPanel object.
     */
    public AlboFlaecheMainPanel() {
        initComponents();
        ((DroppedBeansTable)jXTable1).setVisibleRowCount(4);
    }

    /**
     * Creates a new AlboFlaecheMainPanel object.
     *
     * @param  editable  DOCUMENT ME!
     */
    public AlboFlaecheMainPanel(final boolean editable) {
        super(editable);
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    protected void initGui() {
        initComponents();
        ((DroppedBeansTable)jXTable1).setVisibleRowCount(4);

        if (isEditable()) {
            jButton1.setIcon(new ImageIcon(
                    getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/wizard.png"))); // NOI18N
            jButton1.setMaximumSize(new Dimension(20, 20));
            jButton1.setPreferredSize(new Dimension(20, 20));
            jButton1.setVisible(true);
            jButton1.addActionListener(new ActionListener() {

                    @Override
                    public void actionPerformed(final ActionEvent e) {
                        determineErhebungsnummer();
                    }
                });
        }
        jButton1.setVisible(false);
        alboFlaecheBeschreibungPanel1.setMainPanel(this);
        alboFlaecheBeschreibungPanel1.setPanSpezifisch(panSpezifisch);

        if (isEditable()) {
            try {
                new CidsBeanDropTarget(jXTable1);
            } catch (final Exception ex) {
                LOG.warn("Error while creating CidsBeanDropTarget", ex); // NOI18N
            }
        } else {
            RendererTools.makeReadOnly(jTextField6);
            RendererTools.makeReadOnly(jTextField9);
//            RendererTools.makeReadOnly(jTextField11);
//            RendererTools.makeReadOnly(jTextField12);
//            RendererTools.makeReadOnly(cbFlaechentyp);
        }
        RendererTools.makeReadOnly(jXTable1);
        RendererTools.makeReadOnly(jList2);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jXTable1MouseClicked(final java.awt.event.MouseEvent evt) { //GEN-FIRST:event_jXTable1MouseClicked
        if (evt.getClickCount() == 2) {
            final CidsBean vorgangBean = ((FlaecheVorgangTableModel)jXTable1.getModel()).getCidsBean(
                    jXTable1.getRowSorter().convertRowIndexToModel(jXTable1.getSelectedRow()));
            ComponentRegistry.getRegistry()
                    .getDescriptionPane()
                    .gotoMetaObjectNode(new MetaObjectNode(vorgangBean), false);
        }
    }                                                                        //GEN-LAST:event_jXTable1MouseClicked

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jList2MouseClicked(final java.awt.event.MouseEvent evt) { //GEN-FIRST:event_jList2MouseClicked
        if (evt.getClickCount() == 2) {
            final CidsBean bplanBean = jList2.getSelectedValue();
            ComponentRegistry.getRegistry()
                    .getDescriptionPane()
                    .gotoMetaObjectNode(new MetaObjectNode(bplanBean), false);
        }
    }                                                                      //GEN-LAST:event_jList2MouseClicked

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton3ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton3ActionPerformed
        final Object selectedItem = comboBoxFilterDialog1.showAndGetSelected();
        if (selectedItem instanceof CidsBean) {
            final CidsBean vorgangBean = (CidsBean)selectedItem;
            ((FlaecheVorgangTableModel)jXTable1.getModel()).add(vorgangBean);
            getCidsBean().setArtificialChangeFlag(true);
        }
    }                                                                            //GEN-LAST:event_jButton3ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton2ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton2ActionPerformed
        final CidsBean flaecheBean = ((FlaecheVorgangTableModel)jXTable1.getModel()).getCidsBean(
                jXTable1.getSelectedRow());
        ((FlaecheVorgangTableModel)jXTable1.getModel()).remove(flaecheBean);
        getCidsBean().setArtificialChangeFlag(true);
    }                                                                            //GEN-LAST:event_jButton2ActionPerformed

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        setUnlocked((cidsBean != null) && (MetaObject.NEW == cidsBean.getMetaObject().getStatus()));
        super.setCidsBean(cidsBean);
        if (cidsBean != null) {
            comboBoxFilterDialog1.refresh();
        }

        alboFlaecheBeschreibungPanel1.setCidsBean(cidsBean);
        alboFlaecheOrtPanel1.setCidsBean(cidsBean);

        updateCidsBeanOfFkPanels();

        searchVorgaenge();
        searchBplaene();
    }

    /**
     * DOCUMENT ME!
     *
     * @param  unlocked  DOCUMENT ME!
     */
    public void setLocked(final boolean unlocked) {
        jButton1.setVisible(unlocked);
    }

    /**
     * DOCUMENT ME!
     */
    private void determineErhebungsnummer() {
        final String erhebungsnummer = jTextField9.getText();

        try {
            if (!erhebungsnummer.equals("")) {
                Geometry geom = (Geometry)getCidsBean().getProperty("fk_geom.geo_field");
                String art = (String)getCidsBean().getProperty("fk_art.schluessel");
                String geomText = null;

                if ((geom != null)) {
                    geom = CrsTransformer.transformToDefaultCrs(geom);
                    geomText = geom.toText();
                }

                if ((art != null) && art.equals("")) {
                    art = null;
                }

                final AlboFlaecheErhebungsnummerSearch search = new AlboFlaecheErhebungsnummerSearch(
                        geomText,
                        art,
                        erhebungsnummer,
                        getCidsBean().getMetaObject().getId());

                final ArrayList<ArrayList> result = (ArrayList<ArrayList>)SessionManager.getProxy()
                            .customServerSearch(SessionManager.getSession().getUser(),
                                    search,
                                    getConnectionContext());

                if ((result.size() > 0) && (result.get(0).size() > 0)) {
                    jTextField9.setText((String)result.get(0).get(0));
                } else {
                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame(this),
                        "Es konnte keine Erhebungsnummer generiert werden.",
                        "Erhebungsnummer",
                        JOptionPane.INFORMATION_MESSAGE);
                }
            } else {
                Geometry geom = (Geometry)getCidsBean().getProperty("fk_geom.geo_field");
                final String art = (String)getCidsBean().getProperty("fk_art.schluessel");

                if ((art != null) && (geom != null)) {
                    geom = CrsTransformer.transformToDefaultCrs(geom);
                    final AlboFlaecheErhebungsnummerSearch search = new AlboFlaecheErhebungsnummerSearch(geom.toText(),
                            art,
                            erhebungsnummer,
                            getCidsBean().getMetaObject().getId());

                    final ArrayList<ArrayList> result = (ArrayList<ArrayList>)SessionManager.getProxy()
                                .customServerSearch(SessionManager.getSession().getUser(),
                                        search,
                                        getConnectionContext());

                    if ((result.size() > 0) && (result.get(0).size() > 0) && (result.get(0).get(0) != null)
                                && !result.get(0).get(0).equals("")) {
                        jTextField9.setText((String)result.get(0).get(0));
                    } else {
                        JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame(this),
                            "Es konnte keine Erhebungsnummer generiert werden.",
                            "Erhebungsnummer",
                            JOptionPane.INFORMATION_MESSAGE);
                    }
                } else {
                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame(this),
                        "Um eine Erhebungsnummer zu generieren, muss entweder eine Geometrie und eine Flächenart\noder der Beginn der Erhebungsnummer angegeben sein.",
                        "Erhebungsnummer",
                        JOptionPane.INFORMATION_MESSAGE);
                }
            }
        } catch (Exception ex) {
            LOG.error("Error during AlboFlaecheErhebungsnummerSearch", ex);
        }
    }

    /**
     * DOCUMENT ME!
     */
    public void updateCidsBeanOfFkPanels() {
        final CidsBean cidsBean = getCidsBean();
        if (cidsBean != null) {
            final String art = (String)cidsBean.getProperty("fk_art.schluessel");
            alboFlaecheStandortePanel1.setCidsBean(("altstandort".equals(art) || "betriebsstandort".equals(art))
                    ? cidsBean : null);
            alboFlaecheRclPanel1.setCidsBean(("rcl".equals(art)) ? (CidsBean)cidsBean.getProperty("fk_rcl") : null);
            alboFlaecheStofflichePanel1.setCidsBean(("stoffliche".equals(art))
                    ? (CidsBean)cidsBean.getProperty("fk_stoffliche") : null);
            alboFlaecheAltablagerungPanel1.setCidsBean(("altablagerung".equals(art))
                    ? (CidsBean)cidsBean.getProperty("fk_altablagerung") : null);
        } else {
            alboFlaecheStandortePanel1.setCidsBean(null);
            alboFlaecheRclPanel1.setCidsBean(null);
            alboFlaecheStofflichePanel1.setCidsBean(null);
            alboFlaecheAltablagerungPanel1.setCidsBean(null);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  unlocked  DOCUMENT ME!
     */
    public void setUnlocked(final boolean unlocked) {
        this.unlocked = isEditable() ? unlocked : false;
        alboFlaecheBeschreibungPanel1.setUnlocked(unlocked);
        jButton1.setVisible(unlocked);
        updateLockedFields();
    }

    /**
     * DOCUMENT ME!
     */
    private void updateLockedFields() {
        if (isEditable()) {
            RendererTools.makeUneditable(jTextField6, !unlocked);
            RendererTools.makeUneditable(jTextField9, !unlocked);
//            RendererTools.makeUneditable(jTextField11, !unlocked);
//            RendererTools.makeUneditable(jTextField12, !unlocked);
//            RendererTools.makeUneditable(cbFlaechentyp, !unlocked);
        }
    }

    @Override
    public void dispose() {
        alboFlaecheBeschreibungPanel1.dispose();
        alboFlaecheOrtPanel1.dispose();
        alboFlaecheStandortePanel1.dispose();
        alboFlaecheRclPanel1.dispose();
        alboFlaecheStofflichePanel1.dispose();
        alboFlaecheAltablagerungPanel1.dispose();

        ((FlaecheVorgangTableModel)jXTable1.getModel()).clear();
        ((DefaultListModel<CidsBean>)jList2.getModel()).clear();
        super.dispose();
    }

    @Override
    public void editorClosed(final EditorClosedEvent event) {
        super.editorClosed(event);

        alboFlaecheBeschreibungPanel1.editorClosed(event);
        alboFlaecheOrtPanel1.editorClosed(event);
        alboFlaecheStandortePanel1.editorClosed(event);
        alboFlaecheRclPanel1.editorClosed(event);
        alboFlaecheStofflichePanel1.editorClosed(event);
        alboFlaecheAltablagerungPanel1.editorClosed(event);
    }

    @Override
    public boolean prepareForSave() {
        final boolean prepForSave = super.prepareForSave()
                    && alboFlaecheBeschreibungPanel1.prepareForSave()
                    && alboFlaecheOrtPanel1.prepareForSave()
                    && alboFlaecheStandortePanel1.prepareForSave()
                    && alboFlaecheRclPanel1.prepareForSave()
                    && alboFlaecheStofflichePanel1.prepareForSave()
                    && alboFlaecheAltablagerungPanel1.prepareForSave();

        return prepForSave;
    }

    @Override
    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        alboFlaecheBeschreibungPanel1.initWithConnectionContext(connectionContext);
        alboFlaecheOrtPanel1.initWithConnectionContext(connectionContext);
        alboFlaecheStandortePanel1.initWithConnectionContext(connectionContext);
        alboFlaecheRclPanel1.initWithConnectionContext(connectionContext);
        alboFlaecheStofflichePanel1.initWithConnectionContext(connectionContext);
        alboFlaecheAltablagerungPanel1.initWithConnectionContext(connectionContext);
    }

    @Override
    protected BindingGroup getBindingGroup() {
        return bindingGroup;
    }

    /**
     * DOCUMENT ME!
     */
    private void searchVorgaenge() {
        final FlaecheVorgangTableModel model = new FlaecheVorgangTableModel();
        model.setLoading(true);
        jXTable1.setModel(model);
        jXTable1.getModel().addTableModelListener(new TableModelListener() {

                @Override
                public void tableChanged(final TableModelEvent e) {
                    EventQueue.invokeLater(new Runnable() {

                            @Override
                            public void run() {
                                if (jXTable1.getColumnCount() >= 6) {
                                    jXTable1.getColumnModel().getColumn(0).setPreferredWidth(80);
                                    jXTable1.getColumnModel().getColumn(2).setPreferredWidth(80);
                                    jXTable1.getColumnModel().getColumn(5).setPreferredWidth(80);
                                    jXTable1.getColumnModel().getColumn(0).setMaxWidth(75);
                                    jXTable1.getColumnModel().getColumn(2).setMaxWidth(75);
                                    jXTable1.getColumnModel().getColumn(5).setMaxWidth(75);
                                }
                            }
                        });
                }
            });

        if (getCidsBean() != null) {
            new SwingWorker<List<CidsBean>, Void>() {

                    @Override
                    protected List<CidsBean> doInBackground() throws Exception {
                        final AlboVorgangSearch search = new AlboVorgangSearch();
                        search.setFlaecheId((Integer)getCidsBean().getProperty("id"));

                        final Collection<MetaObjectNode> mons = (Collection)SessionManager.getProxy()
                                    .customServerSearch(SessionManager.getSession().getUser(),
                                            search,
                                            getConnectionContext());

                        if (mons == null) {
                            return null;
                        }

                        final List<CidsBean> beans = new ArrayList<>();
                        for (final MetaObjectNode mon : mons) {
                            beans.add(SessionManager.getProxy().getMetaObject(
                                    mon.getObjectId(),
                                    mon.getClassId(),
                                    "WUNDA_BLAU",
                                    getConnectionContext()).getBean());
                        }

                        originVorgangObjects.clear();
                        originVorgangObjects.addAll(beans);
                        return beans;
                    }

                    @Override
                    protected void done() {
                        try {
                            final List<CidsBean> beans = get();
                            ((FlaecheVorgangTableModel)jXTable1.getModel()).setCidsBeans(beans);
                        } catch (final Exception ex) {
                            LOG.fatal(ex, ex);
                        }
                    }
                }.execute();
        }
    }

    /**
     * DOCUMENT ME!
     */
    private void searchBplaene() {
        jList2.setModel(new DefaultListModel<CidsBean>());
        if (getCidsBean() != null) {
            new SwingWorker<List<CidsBean>, Void>() {

                    @Override
                    protected List<CidsBean> doInBackground() throws Exception {
                        final BplaeneMonSearch search = new BplaeneMonSearch();

                        final Geometry geom = (Geometry)getCidsBean().getProperty("fk_geom.geo_field");
                        search.setGeometry(geom);

                        final Collection<MetaObjectNode> mons = (Collection)SessionManager.getProxy()
                                    .customServerSearch(SessionManager.getSession().getUser(),
                                            search,
                                            getConnectionContext());

                        if (mons == null) {
                            return null;
                        }
                        final List<CidsBean> beans = new ArrayList<>();
                        for (final MetaObjectNode mon : mons) {
                            beans.add(SessionManager.getProxy().getMetaObject(
                                    mon.getObjectId(),
                                    mon.getClassId(),
                                    "WUNDA_BLAU",
                                    getConnectionContext()).getBean());
                        }
                        return beans;
                    }

                    @Override
                    protected void done() {
                        try {
                            final List<CidsBean> beans = get();
                            if (beans != null) {
                                for (final CidsBean bean : beans) {
                                    ((DefaultListModel<CidsBean>)jList2.getModel()).addElement(bean);
                                }
                            }
                        } catch (final Exception ex) {
                            LOG.fatal(ex, ex);
                        }
                    }
                }.execute();
        }
    }
    /**
     * DOCUMENT ME!
     *
     * @param  beans  DOCUMENT ME!
     */
    private void beansDroppedIntoListener(final List<CidsBean> beans) {
        if (isEditable()) {
            final List<CidsBean> flaecheBeans = ((FlaecheVorgangTableModel)jXTable1.getModel()).getCidsBeans();
            for (final CidsBean vorgangBean : beans) {
                if (vorgangBean.getMetaObject().getMetaClass().getTableName().equalsIgnoreCase("albo_vorgang")
                            && !flaecheBeans.contains(vorgangBean)) {
                    ((FlaecheVorgangTableModel)jXTable1.getModel()).add(vorgangBean);
                    getCidsBean().setArtificialChangeFlag(true);
                }
            }
        }
    }

    @Override
    public void afterSaving(final Event event) {
        final CidsBeansTableModel model = (CidsBeansTableModel)jXTable1.getModel();

        if (model != null) {
            final List<CidsBean> vorgangList = model.getCidsBeans();

            if (vorgangList != null) {
                for (final CidsBean vorgangBeanFromList : vorgangList) {
                    // be sure that the current object is used and not the object from the LightWeightMetaObject
                    // cache
                    final Sirius.server.newuser.User u = SessionManager.getSession().getUser();
                    final String domain = vorgangBeanFromList.getMetaObject().getDomain();
                    final Integer objectId = vorgangBeanFromList.getPrimaryKeyValue();
                    final Integer classId = vorgangBeanFromList.getMetaObject().getClassID();
                    MetaObject mo = null;

                    try {
                        mo = SessionManager.getProxy()
                                    .getMetaObject(u, objectId, classId, domain, getConnectionContext());
                    } catch (ConnectionException ex) {
                        LOG.error("Cannot receive vorhaben object^");
                    }

                    final CidsBean vorgangBean = ((mo != null) ? mo.getBean() : vorgangBeanFromList);

                    final List<CidsBean> flaechen = CidsBeanSupport.getBeanCollectionFromProperty(
                            vorgangBean,
                            "arr_flaechen");

                    if (flaechen != null) {
                        if (!flaechen.contains(event.getPersistedBean())) {
                            flaechen.add(event.getPersistedBean());

                            try {
                                vorgangBean.persist(getConnectionContext());
                                comboBoxFilterDialog1.refresh();
                            } catch (Exception e) {
                                LOG.error("Cannot persist dependent vorgang object", e);
                            }
                        }
                    }
                }
            }

            for (final CidsBean vorgangBean : originVorgangObjects) {
                if ((vorgangList == null) || !vorgangList.contains(vorgangBean)) {
                    final List<CidsBean> flaechen = CidsBeanSupport.getBeanCollectionFromProperty(
                            vorgangBean,
                            "arr_flaechen");

                    flaechen.remove(event.getPersistedBean());

                    try {
                        vorgangBean.persist(getConnectionContext());
                    } catch (Exception e) {
                        LOG.error("Cannot persist dependent vorgang object", e);
                    }
                }
            }
        }
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    private class DroppedBeansTable extends JXTable implements CidsBeanDropListener {

        //~ Methods ------------------------------------------------------------

        @Override
        public void beansDropped(final ArrayList<CidsBean> beans) {
            beansDroppedIntoListener(beans);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    class FlaecheVorgangTableModel extends CidsBeansTableModel {

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new FlaecheVorgangTableModel object.
         */
        public FlaecheVorgangTableModel() {
            super(COLUMN_PROPERTIES, COLUMN_NAMES, COLUMN_CLASSES, PROPERTY_RENDERER);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    private static final class AlboFlaecheVorgangFilterDialog extends ComboBoxFilterDialog {

        //~ Static fields/initializers -----------------------------------------

        private static final AlboFlaecheVorgangFilterDialog INSTANCE = new AlboFlaecheVorgangFilterDialog();

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new AlboFlaecheVorgangFilterDialog object.
         */
        private AlboFlaecheVorgangFilterDialog() {
            super(
                null,
                new AlboVorgangLightweightSearch(),
                "Vorgang auswählen",
                ConnectionContext.create(
                    AbstractConnectionContext.Category.STATIC,
                    AlboFlaecheVorgangFilterDialog.class.getSimpleName()));
        }

        //~ Methods ------------------------------------------------------------

        /**
         * DOCUMENT ME!
         *
         * @return  DOCUMENT ME!
         */
        public static AlboFlaecheVorgangFilterDialog getInstance() {
            return INSTANCE;
        }
    }
}
