/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau.albo;

import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.DescriptionPane;
import Sirius.navigator.ui.attributes.editor.AttributeEditor;

import Sirius.server.middleware.types.MetaClass;

import org.jdesktop.beansbinding.BindingGroup;

import java.awt.CardLayout;
import java.awt.Component;

import java.util.List;

import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;

import de.cismet.cids.custom.objectrenderer.utils.CidsBeanSupport;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.NavigatorAttributeEditorGui;

import de.cismet.connectioncontext.ConnectionContext;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class AlboFlaecheMainStandortePanel extends AbstractAlboFlaechePanel {

    //~ Static fields/initializers ---------------------------------------------

    private static CidsBean copiedBean = null;
    private static AlboFlaecheMainStandortePanel lastEditInstance = null;

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        jPanel1 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        butCopyPaste = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jScrollPane3 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList<>();
        jPanel10 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        alboFlaecheMainStandortPanel1 =
            new de.cismet.cids.custom.objecteditors.wunda_blau.albo.AlboFlaecheMainStandortPanel(isEditable());

        final FormListener formListener = new FormListener();

        setName("Form"); // NOI18N
        setOpaque(false);
        setLayout(new java.awt.GridBagLayout());

        jPanel1.setName("jPanel1"); // NOI18N
        jPanel1.setOpaque(false);
        jPanel1.setLayout(new java.awt.GridBagLayout());

        jButton1.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/optionspanels/wunda_blau/add.png"))); // NOI18N
        jButton1.setName("jButton1");                                                                // NOI18N
        jButton1.addActionListener(formListener);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jButton1, gridBagConstraints);
        jButton1.setVisible(isEditable());

        butCopyPaste.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/copy1.png"))); // NOI18N
        butCopyPaste.setToolTipText("kopiere Standort");
        butCopyPaste.setName("butCopyPaste");                                                          // NOI18N
        butCopyPaste.addActionListener(formListener);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(butCopyPaste, gridBagConstraints);

        jButton2.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/optionspanels/wunda_blau/remove.png"))); // NOI18N
        jButton2.setName("jButton2");                                                                   // NOI18N
        jButton2.addActionListener(formListener);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jButton2, gridBagConstraints);
        jButton2.setVisible(isEditable());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 0, 5);
        add(jPanel1, gridBagConstraints);

        jScrollPane3.setMinimumSize(new java.awt.Dimension(100, 26));
        jScrollPane3.setName("jScrollPane3"); // NOI18N
        jScrollPane3.setPreferredSize(new java.awt.Dimension(100, 130));

        jList1.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jList1.setName("jList1"); // NOI18N

        final org.jdesktop.beansbinding.ELProperty eLProperty = org.jdesktop.beansbinding.ELProperty.create(
                "${cidsBean.n_standorte}");
        final org.jdesktop.swingbinding.JListBinding jListBinding = org.jdesktop.swingbinding.SwingBindings
                    .createJListBinding(
                        org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                        this,
                        eLProperty,
                        jList1);
        bindingGroup.addBinding(jListBinding);

        jList1.addListSelectionListener(formListener);
        jScrollPane3.setViewportView(jList1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(jScrollPane3, gridBagConstraints);

        jPanel10.setName("jPanel10"); // NOI18N
        jPanel10.setOpaque(false);
        jPanel10.setLayout(new java.awt.CardLayout());

        jPanel2.setName("jPanel2"); // NOI18N
        jPanel2.setOpaque(false);
        jPanel10.add(jPanel2, "null");

        alboFlaecheMainStandortPanel1.setName("alboFlaecheMainStandortPanel1"); // NOI18N

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                jList1,
                org.jdesktop.beansbinding.ELProperty.create("${selectedElement}"),
                alboFlaecheMainStandortPanel1,
                org.jdesktop.beansbinding.BeanProperty.create("cidsBean"));
        bindingGroup.addBinding(binding);
        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                alboFlaecheMainStandortPanel1,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean != null}"),
                alboFlaecheMainStandortPanel1,
                org.jdesktop.beansbinding.BeanProperty.create("enabled"));
        bindingGroup.addBinding(binding);
        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${cidsBean}"),
                alboFlaecheMainStandortPanel1,
                org.jdesktop.beansbinding.BeanProperty.create("parentBean"));
        bindingGroup.addBinding(binding);

        jPanel10.add(alboFlaecheMainStandortPanel1, "standort");

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        add(jPanel10, gridBagConstraints);

        bindingGroup.bind();
    }

    /**
     * Code for dispatching events from components to event handlers.
     *
     * @version  $Revision$, $Date$
     */
    private class FormListener implements java.awt.event.ActionListener, javax.swing.event.ListSelectionListener {

        /**
         * Creates a new FormListener object.
         */
        FormListener() {
        }

        @Override
        public void actionPerformed(final java.awt.event.ActionEvent evt) {
            if (evt.getSource() == jButton1) {
                AlboFlaecheMainStandortePanel.this.jButton1ActionPerformed(evt);
            } else if (evt.getSource() == butCopyPaste) {
                AlboFlaecheMainStandortePanel.this.butCopyPasteActionPerformed(evt);
            } else if (evt.getSource() == jButton2) {
                AlboFlaecheMainStandortePanel.this.jButton2ActionPerformed(evt);
            }
        }

        @Override
        public void valueChanged(final javax.swing.event.ListSelectionEvent evt) {
            if (evt.getSource() == jList1) {
                AlboFlaecheMainStandortePanel.this.jList1ValueChanged(evt);
            }
        }
    } // </editor-fold>//GEN-END:initComponents

    //~ Instance fields --------------------------------------------------------

    private MetaClass mcStandort;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private de.cismet.cids.custom.objecteditors.wunda_blau.albo.AlboFlaecheMainStandortPanel
        alboFlaecheMainStandortPanel1;
    private javax.swing.JButton butCopyPaste;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JList<CidsBean> jList1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel10;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane3;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new AlboFlaecheMainStandortPanel object.
     */
    public AlboFlaecheMainStandortePanel() {
        initComponents();
    }

    /**
     * Creates a new AlboFlaecheXXXPanel object.
     *
     * @param  editable  DOCUMENT ME!
     */
    public AlboFlaecheMainStandortePanel(final boolean editable) {
        super(editable);
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     */

    @Override
    protected void initGui() {
        try {
            mcStandort = CidsBean.getMetaClassFromTableName(
                    "WUNDA_BLAU",
                    "ALBO_STANDORT",
                    getConnectionContext());
        } catch (final Exception ex) {
            LOG.error(ex, ex);
        }

        initComponents();

        if (isEditable()) {
            butCopyPaste.setIcon(new javax.swing.ImageIcon(
                    getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/copy-paste.png"))); // NOI18N
            butCopyPaste.setToolTipText("füge kopierten Standort hinzu");
            lastEditInstance = this;
        } else {
            butCopyPaste.setIcon(new javax.swing.ImageIcon(
                    getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/copy1.png")));      // NOI18N
            butCopyPaste.setToolTipText("kopiere Standort");
        }

        deActivateCopyPasteButton();
        setListCellRenderer();
    }

    /**
     * DOCUMENT ME!
     */
    private void setListCellRenderer() {
        jList1.setCellRenderer(new DefaultListCellRenderer() {

                @Override
                public Component getListCellRendererComponent(final JList list,
                        final Object value,
                        final int index,
                        final boolean isSelected,
                        final boolean cellHasFocus) {
                    final JLabel component = (JLabel)super.getListCellRendererComponent(
                            list,
                            value,
                            index,
                            isSelected,
                            cellHasFocus);
                    ((JLabel)component).setOpaque(false);
                    component.setBackground(jList1.getBackground());
                    if ((value != null) && (value instanceof CidsBean)) {
                        final Integer jahrVon = (Integer)((CidsBean)value).getProperty("jahr_von");
                        final Integer jahrBis = (Integer)((CidsBean)value).getProperty("jahr_bis");
                        component.setText(
                            String.format(
                                "%04d - %04d",
                                (jahrVon != null) ? jahrVon : 0,
                                (jahrBis != null) ? jahrBis : 0));
                        component.setToolTipText((String)((CidsBean)value).getProperty("name"));
                    } else {
                        component.setText("");
                    }
                    return component;
                }
            });
    }

    @Override
    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        alboFlaecheMainStandortPanel1.initWithConnectionContext(getConnectionContext());
    }

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton1ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton1ActionPerformed
        getCidsBean().getBeanCollectionProperty("n_standorte")
                .add(mcStandort.getEmptyInstance(getConnectionContext()).getBean());
    }                                                                            //GEN-LAST:event_jButton1ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jButton2ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_jButton2ActionPerformed
        getCidsBean().getBeanCollectionProperty("n_standorte").remove(jList1.getSelectedValue());
    }                                                                            //GEN-LAST:event_jButton2ActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void jList1ValueChanged(final javax.swing.event.ListSelectionEvent evt) { //GEN-FIRST:event_jList1ValueChanged
        ((CardLayout)jPanel10.getLayout()).show(jPanel10, (jList1.getSelectedValue() == null) ? "null" : "standort");
        deActivateCopyPasteButton();
    }                                                                                 //GEN-LAST:event_jList1ValueChanged

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void butCopyPasteActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_butCopyPasteActionPerformed
        if (isEditable()) {
            final List<CidsBean> stList = CidsBeanSupport.getBeanCollectionFromProperty(getCidsBean(), "n_standorte");

            if ((stList != null) && (copiedBean != null)) {
                final CidsBean bean = CidsBeanSupport.cloneBean(copiedBean, getConnectionContext());
                stList.add(bean);
            }
        } else {
            final CidsBean bean = jList1.getSelectedValue();
            copiedBean = bean;
        }

        deActivateCopyPasteButton();
    } //GEN-LAST:event_butCopyPasteActionPerformed

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        super.setCidsBean(cidsBean);

        if (!isEditable()) {
            // RendererTools.makeReadOnly from the super method will removes the cell renderer. So it should be added
            // again
            setListCellRenderer();
        }

        deActivateCopyPasteButton();
    }

    /**
     * DOCUMENT ME!
     */
    private void deActivateCopyPasteButton() {
        final DescriptionPane dp = ComponentRegistry.getRegistry().getDescriptionPane();

        if (lastEditInstance != null) {
            lastEditInstance.butCopyPaste.setEnabled(((copiedBean != null) && lastEditInstance.isEditable())
                        || ((lastEditInstance.jList1.getSelectedIndex() != -1) && !lastEditInstance.isEditable()));
        }

        if (lastEditInstance != this) {
            butCopyPaste.setEnabled(((copiedBean != null) && isEditable())
                        || ((jList1.getSelectedIndex() != -1) && !isEditable()));
        }
    }

    @Override
    public void dispose() {
        setCidsBean(null);
        alboFlaecheMainStandortPanel1.dispose();
        super.dispose();
    }

    @Override
    public void editorClosed(final EditorClosedEvent event) {
        super.editorClosed(event);

        alboFlaecheMainStandortPanel1.editorClosed(event);

        if (lastEditInstance == this) {
            lastEditInstance = null;
        }
    }

    @Override
    protected BindingGroup getBindingGroup() {
        return bindingGroup;
    }
}
