/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * BPlanRenderer.java
 *
 * Created on 18. Februar 2008, 16:26
 */
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import Sirius.navigator.ui.RequestsFullSizeComponent;

import javax.swing.JPanel;

import de.cismet.cids.client.tools.DevelopmentTools;

import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;

import de.cismet.cismap.commons.gui.RasterfariDocumentLoaderPanel;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;

/**
 * DOCUMENT ME!
 *
 * @version  $Revision$, $Date$
 */
public class Bplan_planRenderer extends JPanel implements CidsBeanRenderer,
    RequestsFullSizeComponent,
    RasterfariDocumentLoaderPanel.Listener,
    ConnectionContextStore {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(Bplan_planRenderer.class);

    //~ Instance fields --------------------------------------------------------

    private CidsBean cidsBean;

    private ConnectionContext connectionContext;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel panContent;
    private de.cismet.cismap.commons.gui.RasterfariDocumentLoaderPanel rasterfariDocumentLoaderPanel1;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form BplaeneObjectRenderer.
     */
    public Bplan_planRenderer() {
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @param   args  DOCUMENT ME!
     *
     * @throws  Exception  DOCUMENT ME!
     */
    public static void main(final String[] args) throws Exception {
        DevelopmentTools.createRendererInFrameFromRMIConnectionOnLocalhost(
            "WUNDA_BLAU",
            "Administratoren",
            "admin",
            "kif",
            "bplan_plan",
            130,
            "Bebauungsplan",
            1280,
            1024);
    }

    /**
     * DOCUMENT ME!
     */
    private void loadTheImage() {
        final String namePlus = (String)cidsBean.getProperty("nameplus");
        if (namePlus != null) {
            try {
                final String btyp;
                final String plan;
                String path;
                final String r = namePlus;
                btyp = r.substring(0, 1);

                plan = "B" + r.substring(1);
                path = "bplaene/rechtsk";
                if (btyp.equals("N")) {
                    path = "bplaene/nicht_rechtsk";
                }
                final String document = path + "/" + plan + "_TEXT.gif";
                rasterfariDocumentLoaderPanel1.setDocument(document);
            } catch (Exception ex) {
                LOG.error(ex, ex);
            }
        }
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        panContent = new javax.swing.JPanel();
        rasterfariDocumentLoaderPanel1 = new de.cismet.cismap.commons.gui.RasterfariDocumentLoaderPanel(
                ClientAlkisConf.getInstance().getRasterfariUrl(),
                this,
                connectionContext);

        setLayout(new java.awt.BorderLayout());

        panContent.setBorder(javax.swing.BorderFactory.createEmptyBorder(20, 20, 20, 20));
        panContent.setOpaque(false);
        panContent.setLayout(new java.awt.BorderLayout());

        rasterfariDocumentLoaderPanel1.setMinimumSize(new java.awt.Dimension(0, 500));
        rasterfariDocumentLoaderPanel1.setPreferredSize(new java.awt.Dimension(0, 500));
        panContent.add(rasterfariDocumentLoaderPanel1, java.awt.BorderLayout.CENTER);

        add(panContent, java.awt.BorderLayout.CENTER);
    } // </editor-fold>//GEN-END:initComponents

    @Override
    public CidsBean getCidsBean() {
        return cidsBean;
    }

    @Override
    public void setCidsBean(final CidsBean cidsBean) {
        if (cidsBean != null) {
            this.cidsBean = cidsBean;
            loadTheImage();
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public String getTitle() {
        final String nummer = String.valueOf(cidsBean.getProperty("nummer"));
        String shownStatus;
        if ("rechtskräftig".equals(cidsBean.getProperty("status"))) {
            shownStatus = "rechtsverbindlich";
        } else {
            shownStatus = "nicht rechtsverbindlich";
        }
        return "Bebauungsplan - " + nummer + " (" + shownStatus + ")";
    }

    @Override
    public void setTitle(final String title) {
    }

    @Override
    public void showMeasureIsLoading() {
    }

    @Override
    public void showMeasurePanel() {
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return connectionContext;
    }

    @Override
    public void initWithConnectionContext(final ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        initComponents();
    }
}
