/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cids.custom.objectrenderer.wunda_blau;

import org.apache.commons.lang.StringUtils;

import java.awt.Component;

import java.sql.Timestamp;

import java.text.DateFormat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingConstants;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

import de.cismet.cids.custom.clientutils.Sb_RestrictionLevelUtils;
import de.cismet.cids.custom.clientutils.Sb_RestrictionLevelUtils.RestrictionLevel;
import de.cismet.cids.custom.clientutils.StadtbilderUtils;
import de.cismet.cids.custom.objecteditors.utils.Sb_StadtbildserieProvider;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;

/**
 * DOCUMENT ME!
 *
 * @author   Gilles Baatz
 * @version  $Revision$, $Date$
 */
public class Sb_stadtbildserieAggregationRendererInfoPanel extends javax.swing.JPanel implements ListSelectionListener,
    TableModelListener,
    Sb_StadtbildserieProvider,
    Sb_stadtbildserieGridObjectListener,
    ConnectionContextProvider {

    //~ Static fields/initializers ---------------------------------------------

    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(
            Sb_stadtbildserieAggregationRendererInfoPanel.class);
    private static final String[] COLUMN_NAMES = new String[] { "Ausgewählt", "Bildnummer" };
    private static final boolean EDITABLE = false;

    //~ Instance fields --------------------------------------------------------

    private CidsBean stadtbildserie;
    private Sb_stadtbildserieAggregationRenderer aggregationRenderer;
    private RestrictionLevel restrictedLevel = new Sb_RestrictionLevelUtils.RestrictionLevel();
    private Sb_stadtbildserieGridObject gridObject;

    private final ConnectionContext connectionContext;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnInvertSelection;
    private javax.swing.JButton btnSelectAll;
    private javax.swing.JButton btnSelectNone;
    private javax.swing.Box.Filler filler1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JLabel lblAufnahmedatum;
    private javax.swing.JLabel lblStrasse;
    private javax.swing.JLabel lblSuchworte;
    private de.cismet.cids.custom.objecteditors.utils.Sb_StadtbildPreviewImage previewImage;
    private de.cismet.tools.gui.RoundedPanel roundedPanel2;
    private de.cismet.tools.gui.RoundedPanel roundedPanel3;
    private de.cismet.tools.gui.SemiRoundedPanel semiRoundedPanel1;
    private javax.swing.JTable tblStadtbilder;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new Sb_stadtbildserieAggregationRendererInfoPanel object.
     */
    public Sb_stadtbildserieAggregationRendererInfoPanel() {
        this(ConnectionContext.createDeprecated());
    }

    /**
     * Creates new form Sb_stadtbildserieAggregationRendererInfoPanel.
     *
     * @param  connectionContext  DOCUMENT ME!
     */
    public Sb_stadtbildserieAggregationRendererInfoPanel(final ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;

        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public final ConnectionContext getConnectionContext() {
        return connectionContext;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        roundedPanel2 = new de.cismet.tools.gui.RoundedPanel();
        previewImage = new de.cismet.cids.custom.objecteditors.utils.Sb_StadtbildPreviewImage(getConnectionContext());
        roundedPanel3 = new de.cismet.tools.gui.RoundedPanel();
        semiRoundedPanel1 = new de.cismet.tools.gui.SemiRoundedPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        lblAufnahmedatum = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        tblStadtbilder = new JTable() {

                @Override
                public Component prepareRenderer(final TableCellRenderer renderer, final int row, final int col) {
                    final Component c = super.prepareRenderer(renderer, row, col);
                    if (gridObject != null) {
                        c.setEnabled(!gridObject.isIsInBin());
                    }
                    return c;
                }
            };
        jPanel1 = new javax.swing.JPanel();
        btnSelectNone = new javax.swing.JButton();
        btnSelectAll = new javax.swing.JButton();
        btnInvertSelection = new javax.swing.JButton();
        filler1 = new javax.swing.Box.Filler(new java.awt.Dimension(0, 0),
                new java.awt.Dimension(0, 0),
                new java.awt.Dimension(32767, 0));
        jLabel4 = new javax.swing.JLabel();
        lblSuchworte = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        lblStrasse = new javax.swing.JLabel();

        setOpaque(false);
        setLayout(new java.awt.GridBagLayout());

        roundedPanel2.setLayout(new java.awt.GridBagLayout());

        previewImage.setMinimumSize(new java.awt.Dimension(140, 300));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        roundedPanel2.add(previewImage, gridBagConstraints);
        previewImage.setBtnDownloadHighResImageVisible(false);
        previewImage.setTbtnIsPreviewImageVisible(false);

        roundedPanel3.setLayout(new java.awt.GridBagLayout());

        semiRoundedPanel1.setBackground(new java.awt.Color(51, 51, 51));
        semiRoundedPanel1.setLayout(new java.awt.FlowLayout());

        jLabel1.setForeground(new java.awt.Color(255, 255, 255));
        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel1,
            org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieAggregationRendererInfoPanel.class,
                "Sb_stadtbildserieAggregationRendererInfoPanel.jLabel1.text")); // NOI18N
        semiRoundedPanel1.add(jLabel1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        roundedPanel3.add(semiRoundedPanel1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel2,
            org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieAggregationRendererInfoPanel.class,
                "Sb_stadtbildserieAggregationRendererInfoPanel.jLabel2.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        roundedPanel3.add(jLabel2, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel3,
            org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieAggregationRendererInfoPanel.class,
                "Sb_stadtbildserieAggregationRendererInfoPanel.jLabel3.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        roundedPanel3.add(jLabel3, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            lblAufnahmedatum,
            org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieAggregationRendererInfoPanel.class,
                "Sb_stadtbildserieAggregationRendererInfoPanel.lblAufnahmedatum.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        roundedPanel3.add(lblAufnahmedatum, gridBagConstraints);
        lblAufnahmedatum.setVisible(false);

        tblStadtbilder.setModel(new javax.swing.table.DefaultTableModel(
                new Object[][] {
                    { null, null }
                },
                new String[] { "Ausgewählt", "Bildnummer" }) {

                Class[] types = new Class[] { java.lang.Boolean.class, java.lang.Object.class };
                boolean[] canEdit = new boolean[] { true, false };

                @Override
                public Class getColumnClass(final int columnIndex) {
                    return types[columnIndex];
                }

                @Override
                public boolean isCellEditable(final int rowIndex, final int columnIndex) {
                    return canEdit[columnIndex];
                }
            });
        tblStadtbilder.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jScrollPane2.setViewportView(tblStadtbilder);
        tblStadtbilder.getSelectionModel().addListSelectionListener(this);
        final TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(tblStadtbilder.getModel());
        tblStadtbilder.setRowSorter(sorter);
        tblStadtbilder.setDefaultRenderer(Object.class, new CustomTableCellRenderer());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        roundedPanel3.add(jScrollPane2, gridBagConstraints);

        jPanel1.setOpaque(false);
        jPanel1.setLayout(new java.awt.GridBagLayout());

        btnSelectNone.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/table.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(
            btnSelectNone,
            org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieAggregationRendererInfoPanel.class,
                "Sb_stadtbildserieAggregationRendererInfoPanel.btnSelectNone.text"));                   // NOI18N
        btnSelectNone.setToolTipText(org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieAggregationRendererInfoPanel.class,
                "Sb_stadtbildserieAggregationRendererInfoPanel.btnSelectNone.toolTipText"));            // NOI18N
        btnSelectNone.setBorderPainted(false);
        btnSelectNone.setContentAreaFilled(false);
        btnSelectNone.setFocusPainted(false);
        btnSelectNone.setMaximumSize(new java.awt.Dimension(26, 26));
        btnSelectNone.setMinimumSize(new java.awt.Dimension(26, 26));
        btnSelectNone.setPreferredSize(new java.awt.Dimension(26, 26));
        btnSelectNone.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnSelectNoneActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        jPanel1.add(btnSelectNone, gridBagConstraints);

        btnSelectAll.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/table-select-all.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(
            btnSelectAll,
            org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieAggregationRendererInfoPanel.class,
                "Sb_stadtbildserieAggregationRendererInfoPanel.btnSelectAll.text"));                               // NOI18N
        btnSelectAll.setToolTipText(org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieAggregationRendererInfoPanel.class,
                "Sb_stadtbildserieAggregationRendererInfoPanel.btnSelectAll.toolTipText"));                        // NOI18N
        btnSelectAll.setBorderPainted(false);
        btnSelectAll.setContentAreaFilled(false);
        btnSelectAll.setFocusPainted(false);
        btnSelectAll.setMaximumSize(new java.awt.Dimension(26, 26));
        btnSelectAll.setMinimumSize(new java.awt.Dimension(26, 26));
        btnSelectAll.setPreferredSize(new java.awt.Dimension(26, 26));
        btnSelectAll.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnSelectAllActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        jPanel1.add(btnSelectAll, gridBagConstraints);

        btnInvertSelection.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cids/custom/objectrenderer/wunda_blau/table_invert.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(
            btnInvertSelection,
            org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieAggregationRendererInfoPanel.class,
                "Sb_stadtbildserieAggregationRendererInfoPanel.btnInvertSelection.text"));                     // NOI18N
        btnInvertSelection.setToolTipText(org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieAggregationRendererInfoPanel.class,
                "Sb_stadtbildserieAggregationRendererInfoPanel.btnInvertSelection.toolTipText"));              // NOI18N
        btnInvertSelection.setBorderPainted(false);
        btnInvertSelection.setContentAreaFilled(false);
        btnInvertSelection.setFocusPainted(false);
        btnInvertSelection.setMaximumSize(new java.awt.Dimension(26, 26));
        btnInvertSelection.setMinimumSize(new java.awt.Dimension(26, 26));
        btnInvertSelection.setPreferredSize(new java.awt.Dimension(26, 26));
        btnInvertSelection.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnInvertSelectionActionPerformed(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        jPanel1.add(btnInvertSelection, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(filler1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        roundedPanel3.add(jPanel1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel4,
            org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieAggregationRendererInfoPanel.class,
                "Sb_stadtbildserieAggregationRendererInfoPanel.jLabel4.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        roundedPanel3.add(jLabel4, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            lblSuchworte,
            org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieAggregationRendererInfoPanel.class,
                "Sb_stadtbildserieAggregationRendererInfoPanel.lblSuchworte.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        roundedPanel3.add(lblSuchworte, gridBagConstraints);
        lblSuchworte.setVisible(false);

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel6,
            org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieAggregationRendererInfoPanel.class,
                "Sb_stadtbildserieAggregationRendererInfoPanel.jLabel6.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        roundedPanel3.add(jLabel6, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            lblStrasse,
            org.openide.util.NbBundle.getMessage(
                Sb_stadtbildserieAggregationRendererInfoPanel.class,
                "Sb_stadtbildserieAggregationRendererInfoPanel.lblStrasse.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        roundedPanel3.add(lblStrasse, gridBagConstraints);
        lblStrasse.setVisible(false);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        roundedPanel2.add(roundedPanel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        add(roundedPanel2, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnSelectAllActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnSelectAllActionPerformed
        if (gridObject != null) {
            gridObject.selectAllStadtbilder();
        }
    }                                                                                //GEN-LAST:event_btnSelectAllActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnSelectNoneActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnSelectNoneActionPerformed
        if (gridObject != null) {
            gridObject.deselectAllStadtbilder();
        }
    }                                                                                 //GEN-LAST:event_btnSelectNoneActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnInvertSelectionActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnInvertSelectionActionPerformed
        if (gridObject != null) {
            for (final CidsBean stadtbild : gridObject.getImagesToShow()) {
                gridObject.selectOrDeselectStadtbild(stadtbild);
            }
        }
    }                                                                                      //GEN-LAST:event_btnInvertSelectionActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  stadtbildserie  DOCUMENT ME!
     */
    private void setStadtbildserie(final CidsBean stadtbildserie) {
        if (stadtbildserie != null) {
            this.stadtbildserie = stadtbildserie;
            restrictedLevel = Sb_RestrictionLevelUtils.determineRestrictionLevelForStadtbildserie(
                    stadtbildserie,
                    getConnectionContext());
            previewImage.setStadtbildserieProvider(this);
            refillTable(gridObject.getStadtbildUnderMarker());

            final Timestamp aufnahmedatum = (Timestamp)stadtbildserie.getProperty("aufnahmedatum");
            final DateFormat df = DateFormat.getDateInstance(DateFormat.SHORT, Locale.getDefault());
            final String formattedDate = (aufnahmedatum != null) ? df.format(aufnahmedatum) : null;
            lblAufnahmedatum.setText(formattedDate);
            lblAufnahmedatum.setVisible(true);

            final List<CidsBean> suchworte = stadtbildserie.getBeanCollectionProperty("suchwort_arr");
            lblSuchworte.setText("<html><p>" + StringUtils.join(suchworte, ", ") + "</p></html>");
            lblSuchworte.setVisible(true);

            final String hausnummer = (String)stadtbildserie.getProperty("hausnummer");
            final String strassenname = (String)stadtbildserie.getProperty("strasse.name");
            if (StringUtils.isNotBlank(strassenname)) {
                String text = strassenname;
                if (StringUtils.isNotBlank(hausnummer)) {
                    text += ", " + hausnummer;
                }
                lblStrasse.setText(text);
                lblStrasse.setVisible(true);
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param  gridObject  DOCUMENT ME!
     */
    public void setGridObject(final Sb_stadtbildserieGridObject gridObject) {
        if (this.gridObject == gridObject) {
            selectStadtbildInTable(gridObject.getStadtbildUnderMarker());
        } else {
            this.gridObject = gridObject;
            setStadtbildserie(this.gridObject.getCidsBean());
        }
        tblStadtbilder.setEnabled(!gridObject.isIsInBin());
    }

    /**
     * DOCUMENT ME!
     *
     * @param  stadtbildToSelect  DOCUMENT ME!
     */
    private void refillTable(final CidsBean stadtbildToSelect) {
        final List<CidsBean> bilder = stadtbildserie.getBeanCollectionProperty("stadtbilder_arr");
        final Collection<CidsBean> selectedBilder = gridObject.getSelectedBildnummernOfSerie();
        final Object[][] data = new Object[bilder.size()][];

        int stadtbildToSelectModelIndex = 0;

        for (int i = 0; i < data.length; i++) {
            final CidsBean bild = bilder.get(i);
            if (stadtbildToSelect.equals(bild)) {
                stadtbildToSelectModelIndex = i;
            }

            final boolean isSelected = selectedBilder.contains(bild);
            data[i] = new Object[] { isSelected, bild };
        }

        final List<? extends RowSorter.SortKey> sortedColumns = tblStadtbilder.getRowSorter().getSortKeys();

        final DefaultTableModel newModel = new CustomTableModel(data, COLUMN_NAMES);
        tblStadtbilder.setModel(newModel);

        createNewTableSorter(sortedColumns);

        final int stadtbildToSelectRowIndex = tblStadtbilder.convertRowIndexToView(stadtbildToSelectModelIndex);
        tblStadtbilder.setRowSelectionInterval(stadtbildToSelectRowIndex, stadtbildToSelectRowIndex);
    }

    /**
     * After the model of the table was replaced, its RowSorted has to be created again.
     *
     * @param  sortedColumns  DOCUMENT ME!
     */
    private void createNewTableSorter(final List<? extends RowSorter.SortKey> sortedColumns) {
        final TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(tblStadtbilder.getModel());
        tblStadtbilder.setRowSorter(sorter);
        sorter.addRowSorterListener(
            new RowSorterListener() {

                @Override
                public void sorterChanged(final RowSorterEvent e) {
                    if (e.getType() == RowSorterEvent.Type.SORTED) {
                        final ArrayList<CidsBean> sortedStadtbilder = new ArrayList<CidsBean>(
                                tblStadtbilder.getRowCount());
                        for (int i = 0; i < tblStadtbilder.getRowCount(); i++) {
                            sortedStadtbilder.add((CidsBean)tblStadtbilder.getValueAt(i, 1));
                        }
                        gridObject.sortImagesToShow(sortedStadtbilder);
                    }
                }
            });
        if (sortedColumns.isEmpty()) {
            final ArrayList<RowSorter.SortKey> list = new ArrayList<RowSorter.SortKey>();
            list.add(new RowSorter.SortKey(1, SortOrder.ASCENDING));
            tblStadtbilder.getRowSorter().setSortKeys(list);
        } else {
            tblStadtbilder.getRowSorter().setSortKeys(sortedColumns);
        }
    }

    /**
     * Selects the stadtbild in table. Due to the change in the selection, the stadtbild will be shown in the preview
     * image panel.
     *
     * @param  stadtbildToSelect  DOCUMENT ME!
     */
    private void selectStadtbildInTable(final CidsBean stadtbildToSelect) {
        int stadtbildToSelectModelIndex = 0;
        final List data = ((DefaultTableModel)tblStadtbilder.getModel()).getDataVector();
        for (int i = 0; i < data.size(); i++) {
            final CidsBean bild = (CidsBean)((List)data.get(i)).get(1);
            if (stadtbildToSelect.equals(bild)) {
                stadtbildToSelectModelIndex = i;
                break;
            }
        }
        final int stadtbildToSelectRowIndex = tblStadtbilder.convertRowIndexToView(stadtbildToSelectModelIndex);
        tblStadtbilder.setRowSelectionInterval(stadtbildToSelectRowIndex, stadtbildToSelectRowIndex);
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public Sb_stadtbildserieAggregationRenderer getAggregationRenderer() {
        return aggregationRenderer;
    }

    /**
     * DOCUMENT ME!
     *
     * @param  aggregationRenderer  DOCUMENT ME!
     */
    public void setAggregationRenderer(final Sb_stadtbildserieAggregationRenderer aggregationRenderer) {
        this.aggregationRenderer = aggregationRenderer;
    }

    @Override
    public CidsBean getStadtbildserie() {
        return stadtbildserie;
    }

    @Override
    public CidsBean getSelectedStadtbild() {
        final int selectedRowView = tblStadtbilder.getSelectedRow();
        final int selectedRowModel = tblStadtbilder.convertRowIndexToModel(selectedRowView);
        final CidsBean selectedBild = (CidsBean)tblStadtbilder.getModel().getValueAt(selectedRowModel, 1);
        return selectedBild;
    }

    @Override
    public void previousImageSelected() {
        final int selectedRow = tblStadtbilder.getSelectedRow();
        tblStadtbilder.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
    }

    @Override
    public void nextImageSelected() {
        final int selectedRow = tblStadtbilder.getSelectedRow();
        tblStadtbilder.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
    }

    @Override
    public void newPreviewImageSelected() {
        // should not be called, as it is not needed
        LOG.fatal(
            "Sb_stadtbildserieAggregationRendererInfoPanel.newPreviewImageSelected: Not supported yet.",
            new Exception()); // NOI18N
    }

    @Override
    public boolean isFirstSelected() {
        final int selectedRow = tblStadtbilder.getSelectedRow();
        return selectedRow == 0;
    }

    @Override
    public boolean isLastSelected() {
        final int selectedRow = tblStadtbilder.getSelectedRow();
        return selectedRow == (tblStadtbilder.getRowCount() - 1);
    }

    @Override
    public RestrictionLevel getRestrictionLevel() {
        return restrictedLevel;
    }

    @Override
    public boolean isEditable() {
        return EDITABLE;
    }

    /**
     * Another image was selected in table.
     *
     * @param  e  DOCUMENT ME!
     */
    @Override
    public void valueChanged(final ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            final int rowView = tblStadtbilder.getSelectedRow();
            if (rowView >= 0) {
                final int rowModel = tblStadtbilder.convertRowIndexToModel(rowView);
                final CidsBean stadtbild = (CidsBean)tblStadtbilder.getModel().getValueAt(rowModel, 1);
                final StadtbilderUtils.StadtbildInfo stadtbildInfo = new StadtbilderUtils.StadtbildInfo(
                        stadtbildserie,
                        stadtbild);
                previewImage.setStadtbildInfo(stadtbildInfo);

                tblStadtbilder.scrollRectToVisible(tblStadtbilder.getCellRect(rowView, 1, true));
            } else {
                previewImage.removeImage();
            }
        }
    }

    /**
     * A cell in the table was edited.
     *
     * @param  e  DOCUMENT ME!
     */
    @Override
    public void tableChanged(final TableModelEvent e) {
        final DefaultTableModel model = (DefaultTableModel)tblStadtbilder.getModel();
        final int rowModel = e.getFirstRow();
        final Boolean isSelected = (Boolean)model.getValueAt(rowModel, 0);
        final CidsBean bild = (CidsBean)model.getValueAt(rowModel, 1);

        // only change the selection if the values are different, this avoids an endless loop in the listeners.
        if (!Boolean.valueOf(gridObject.isStadtbildSelected(bild)).equals(isSelected)) {
            gridObject.selectOrDeselectStadtbild(bild);
        }
    }

    @Override
    public void previewImageChanged() {
        // do nothing
    }

    /**
     * DOCUMENT ME!
     */
    public void previewImageNotAvailable() {
        previewImage.indicateNotAvailable("", null, "keine Stadtbildserie ausgewählt");
    }

    /**
     * DOCUMENT ME!
     *
     * @param  enable  DOCUMENT ME!
     */
    public void setEnableTable(final boolean enable) {
        tblStadtbilder.setEnabled(enable);
        btnInvertSelection.setEnabled(enable);
        btnSelectAll.setEnabled(enable);
        btnSelectNone.setEnabled(enable);
    }

    @Override
    public void stadtbildChosen(final Sb_stadtbildserieGridObject source, final CidsBean stadtbild) {
        if (source == gridObject) {
            final TableModel model = tblStadtbilder.getModel();
            for (int i = 0; i < model.getRowCount(); i++) {
                final CidsBean stadtbildInTable = (CidsBean)model.getValueAt(i, 1);
                if (stadtbildInTable.equals(stadtbild)) {
                    model.setValueAt(true, i, 0);
                }
            }
        }
    }

    @Override
    public void stadtbildUnchosen(final Sb_stadtbildserieGridObject source, final CidsBean stadtbild) {
        if (source == gridObject) {
            final TableModel model = tblStadtbilder.getModel();
            for (int i = 0; i < model.getRowCount(); i++) {
                final CidsBean stadtbildInTable = (CidsBean)model.getValueAt(i, 1);
                if (stadtbildInTable.equals(stadtbild)) {
                    model.setValueAt(false, i, 0);
                }
            }
        }
    }

    @Override
    public void sb_stadtbildserieGridObjectMoveToBin(final Sb_stadtbildserieGridObject source) {
        // do nothing
    }

    @Override
    public void sb_stadtbildserieGridObjectRemovedFromBin(final Sb_stadtbildserieGridObject source) {
        // do nothing
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    private class CustomTableModel extends DefaultTableModel {

        //~ Instance fields ----------------------------------------------------

        Class[] types = new Class[] { java.lang.Boolean.class, java.lang.Object.class };
        boolean[] canEdit = new boolean[] { true, false };

        //~ Constructors -------------------------------------------------------

        /**
         * Creates a new CustomTableModel object.
         *
         * @param  data         DOCUMENT ME!
         * @param  columnNames  DOCUMENT ME!
         */
        public CustomTableModel(final Object[][] data, final Object[] columnNames) {
            super(data, columnNames);
            this.addTableModelListener(Sb_stadtbildserieAggregationRendererInfoPanel.this);
        }

        //~ Methods ------------------------------------------------------------

        @Override
        public Class getColumnClass(final int columnIndex) {
            return types[columnIndex];
        }

        @Override
        public boolean isCellEditable(final int rowIndex, final int columnIndex) {
            return canEdit[columnIndex];
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @version  $Revision$, $Date$
     */
    private class CustomTableCellRenderer extends DefaultTableCellRenderer {

        //~ Methods ------------------------------------------------------------

        @Override
        public Component getTableCellRendererComponent(final JTable table,
                final Object value,
                final boolean isSelected,
                final boolean hasFocus,
                final int row,
                final int column) {
            final JLabel renderedLabel = (JLabel)super.getTableCellRendererComponent(
                    table,
                    value,
                    isSelected,
                    hasFocus,
                    row,
                    column);
            if (column == 1) {
                renderedLabel.setHorizontalAlignment(SwingConstants.CENTER);
            }
            return renderedLabel;
        }
    }
}
