/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package de.cismet.cids.custom.wunda_blau;

import Sirius.navigator.connection.SessionManager;

import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;

import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

import de.cismet.cids.custom.reports.wunda_blau.PrintJahresberichtReport;
import de.cismet.cids.custom.wunda_blau.search.server.CidsBillingSearchStatement;

import de.cismet.cids.dynamics.CidsBean;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class JahresberichtDialog extends javax.swing.JDialog implements ConnectionContextProvider {

    //~ Static fields/initializers ---------------------------------------------

    private static final Logger LOG = org.apache.log4j.Logger.getLogger(JahresberichtDialog.class);

    private static JahresberichtDialog INSTANCE = null;

    //~ Instance fields --------------------------------------------------------

    private SwingWorker worker;

    private final ConnectionContext connectionContext = ConnectionContext.createDummy();
    private Date fromDate = null;
    private Date stichtag = null;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnCancel;
    private javax.swing.JButton btnOk;
    private de.cismet.cids.editors.DefaultBindableDateChooser defaultBindableDateChooser1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JProgressBar jProgressBar1;
    private javax.swing.JLabel lblErrorBillingsText;
    private javax.swing.JLabel lblErrorBillingsTitle;
    private javax.swing.JLabel lblNoBillingsText;
    private javax.swing.JLabel lblNoBillingsTitle;
    private javax.swing.JSpinner spnYear;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form Jahresbericht.
     */
    private JahresberichtDialog() {
        super((JFrame)null, false);

        initComponents();
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * DOCUMENT ME!
     *
     * @param  stichtag  DOCUMENT ME!
     */
    public void setStichtag(final Date stichtag) {
        this.stichtag = stichtag;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public Date getStichtag() {
        return stichtag;
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    public static JahresberichtDialog getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JahresberichtDialog();
            INSTANCE.pack();

            final Calendar date = GregorianCalendar.getInstance();
            final int year = date.get(Calendar.YEAR);

            INSTANCE.spnYear.setValue(year);
        }
        return INSTANCE;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        lblNoBillingsText = new javax.swing.JLabel();
        lblNoBillingsTitle = new javax.swing.JLabel();
        lblErrorBillingsText = new javax.swing.JLabel();
        lblErrorBillingsTitle = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        spnYear = new javax.swing.JSpinner();
        jPanel2 = new javax.swing.JPanel();
        btnCancel = new javax.swing.JButton();
        btnOk = new javax.swing.JButton();
        jProgressBar1 = new javax.swing.JProgressBar();
        defaultBindableDateChooser1 = new de.cismet.cids.editors.DefaultBindableDateChooser();
        jLabel4 = new javax.swing.JLabel();

        org.openide.awt.Mnemonics.setLocalizedText(
            lblNoBillingsText,
            org.openide.util.NbBundle.getMessage(
                JahresberichtDialog.class,
                "JahresberichtDialog.lblNoBillingsText.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(
            lblNoBillingsTitle,
            org.openide.util.NbBundle.getMessage(
                JahresberichtDialog.class,
                "JahresberichtDialog.lblNoBillingsTitle.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(
            lblErrorBillingsText,
            org.openide.util.NbBundle.getMessage(
                JahresberichtDialog.class,
                "JahresberichtDialog.lblErrorBillingsText.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(
            lblErrorBillingsTitle,
            org.openide.util.NbBundle.getMessage(
                JahresberichtDialog.class,
                "JahresberichtDialog.lblErrorBillingsTitle.text")); // NOI18N

        setTitle(org.openide.util.NbBundle.getMessage(JahresberichtDialog.class, "JahresberichtDialog.title")); // NOI18N
        setResizable(false);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel1,
            org.openide.util.NbBundle.getMessage(JahresberichtDialog.class, "JahresberichtDialog.jLabel1.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        jPanel1.add(jLabel1, gridBagConstraints);

        spnYear.setModel(new javax.swing.SpinnerNumberModel());
        spnYear.setEditor(new javax.swing.JSpinner.NumberEditor(spnYear, "#"));
        spnYear.setMinimumSize(new java.awt.Dimension(70, 28));
        spnYear.setPreferredSize(new java.awt.Dimension(70, 28));
        spnYear.addChangeListener(new javax.swing.event.ChangeListener() {

                @Override
                public void stateChanged(final javax.swing.event.ChangeEvent evt) {
                    spnYearStateChanged(evt);
                }
            });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel1.add(spnYear, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridLayout(1, 0, 10, 0));

        org.openide.awt.Mnemonics.setLocalizedText(
            btnCancel,
            org.openide.util.NbBundle.getMessage(JahresberichtDialog.class, "JahresberichtDialog.btnCancel.text")); // NOI18N
        btnCancel.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnCancelActionPerformed(evt);
                }
            });
        jPanel2.add(btnCancel);

        org.openide.awt.Mnemonics.setLocalizedText(
            btnOk,
            org.openide.util.NbBundle.getMessage(JahresberichtDialog.class, "JahresberichtDialog.btnOk.text")); // NOI18N
        btnOk.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    btnOkActionPerformed(evt);
                }
            });
        jPanel2.add(btnOk);
        getRootPane().setDefaultButton(btnOk);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LINE_END;
        jPanel1.add(jPanel2, gridBagConstraints);

        jProgressBar1.setString(org.openide.util.NbBundle.getMessage(
                JahresberichtDialog.class,
                "JahresberichtDialog.jProgressBar1.string")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 10, 0);
        jPanel1.add(jProgressBar1, gridBagConstraints);

        final org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(
                org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE,
                this,
                org.jdesktop.beansbinding.ELProperty.create("${stichtag}"),
                defaultBindableDateChooser1,
                org.jdesktop.beansbinding.BeanProperty.create("date"));
        bindingGroup.addBinding(binding);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        jPanel1.add(defaultBindableDateChooser1, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel4,
            org.openide.util.NbBundle.getMessage(JahresberichtDialog.class, "JahresberichtDialog.jLabel4.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        jPanel1.add(jLabel4, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
        getContentPane().add(jPanel1, gridBagConstraints);

        bindingGroup.bind();

        pack();
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnCancelActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnCancelActionPerformed
        if (worker != null) {
            worker.cancel(true);
        }

        setVisible(false);
    } //GEN-LAST:event_btnCancelActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void btnOkActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_btnOkActionPerformed
        jProgressBar1.setString(org.openide.util.NbBundle.getMessage(
                JahresberichtDialog.class,
                "JahresberichtDialog.jProgressBar1.string"));
        jProgressBar1.setIndeterminate(true);
        jProgressBar1.setStringPainted(true);
        btnOk.setEnabled(false);

        if (worker != null) {
            worker.cancel(true);
        }
        worker = new SwingWorker<Collection, Integer>() {

                @Override
                protected Collection doInBackground() throws Exception {
                    final CidsBillingSearchStatement cidsBillingSearchStatement = new CidsBillingSearchStatement();

                    cidsBillingSearchStatement.setAbrechnungsdatumFrom(fromDate);
                    cidsBillingSearchStatement.setAbrechnungsdatumTill(stichtag);
                    cidsBillingSearchStatement.setKostentyp(CidsBillingSearchStatement.Kostentyp.KOSTENPFLICHTIG);
                    cidsBillingSearchStatement.setShowAbgerechneteBillings(null);

                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Query to get the billings: " + cidsBillingSearchStatement.generateQuery());
                    }

                    try {
                        final Collection<MetaObjectNode> mons = SessionManager.getProxy()
                                    .customServerSearch(SessionManager.getSession().getUser(),
                                        cidsBillingSearchStatement,
                                        getConnectionContext());

                        if (mons == null) {
                            LOG.error("Billing metaobjects was null.");
                            return null;
                        } else {
                            publish(mons.size());
                            final List<CidsBean> billingBeans = new ArrayList<>(mons.size());
                            for (final MetaObjectNode mon : mons) {
                                if (isCancelled()) {
                                    break;
                                }
                                if (mon != null) {
                                    publish(billingBeans.size() + 1);
                                    final MetaObject mo = SessionManager.getProxy()
                                                .getMetaObject(mon.getObjectId(),
                                                    mon.getClassId(),
                                                    mon.getDomain(),
                                                    getConnectionContext());
                                    final CidsBean bean = (mo != null) ? mo.getBean() : null;
                                    billingBeans.add(bean);
                                }
                            }
                            return billingBeans;
                        }
                    } catch (final Exception ex) {
                        LOG.error("Error while filtering the billings.", ex);
                        return null;
                    }
                }

                @Override
                protected void process(final List<Integer> chunks) {
                    for (final Integer chunk : chunks) {
                        if (jProgressBar1.isIndeterminate()) {
                            jProgressBar1.setIndeterminate(false);
                            jProgressBar1.setMaximum(chunk);
                            jProgressBar1.setValue(0);
                        } else {
                            final String string = "Lade Buchung " + chunk + " von " + jProgressBar1.getMaximum();
                            jProgressBar1.setValue(chunk);
                            jProgressBar1.setString(string);
                        }
                    }
                }

                @Override
                protected void done() {
                    try {
                        if (!isCancelled()) {
                            final Collection<CidsBean> billings = get();
                            if (billings.isEmpty()) {
                                JOptionPane.showMessageDialog(
                                    JahresberichtDialog.this,
                                    lblNoBillingsText.getText(),
                                    lblNoBillingsTitle.getText(),
                                    JOptionPane.ERROR_MESSAGE);
                            } else {
                                final Date[] fromDate_tillDate = new Date[2];
                                fromDate_tillDate[0] = fromDate;
                                fromDate_tillDate[1] = stichtag;
                                final int year = (Integer)spnYear.getValue();
                                final PrintJahresberichtReport report = new PrintJahresberichtReport(
                                        fromDate_tillDate,
                                        billings,
                                        getConnectionContext());
                                report.print();
                            }
                        }
                        setVisible(false);
                    } catch (final Exception ex) {
                        LOG.error(ex, ex);
                        JOptionPane.showMessageDialog(
                            JahresberichtDialog.this,
                            lblErrorBillingsText.getText(),
                            lblErrorBillingsTitle.getText(),
                            JOptionPane.ERROR_MESSAGE);
                    } finally {
                        jProgressBar1.setMaximum(0);
                        jProgressBar1.setValue(0);
                        jProgressBar1.setStringPainted(false);
                        jProgressBar1.setIndeterminate(false);
                        btnOk.setEnabled(true);
                    }
                }
            };
        worker.execute();
    } //GEN-LAST:event_btnOkActionPerformed

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void spnYearStateChanged(final javax.swing.event.ChangeEvent evt) { //GEN-FIRST:event_spnYearStateChanged
        final int year = (Integer)spnYear.getValue();

        final Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(Calendar.DAY_OF_MONTH, 1);
        calendar.set(Calendar.MONTH, Calendar.JANUARY);
        calendar.set(Calendar.YEAR, year);
        fromDate = calendar.getTime();

        calendar.clear();
        calendar.set(Calendar.DAY_OF_MONTH, 31);
        calendar.set(Calendar.MONTH, Calendar.DECEMBER);
        calendar.set(Calendar.YEAR, year);
        Date tmpTillDate = calendar.getTime();

        final Date now = new Date();
        final boolean fullYear;
        if (now.before(tmpTillDate)) {
            tmpTillDate = now;
            fullYear = false;
        } else {
            fullYear = true;
        }
        defaultBindableDateChooser1.setEnabled(!fullYear);
        bindingGroup.unbind();
        stichtag = tmpTillDate;
        bindingGroup.bind();
    } //GEN-LAST:event_spnYearStateChanged

    @Override
    public final ConnectionContext getConnectionContext() {
        return connectionContext;
    }
}
