/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.actions.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import de.cismet.cids.custom.nas.NasDialog;
import de.cismet.cismap.commons.features.CommonFeatureAction;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class NASDataRetrievalAction
extends AbstractAction
implements CommonFeatureAction,
ConnectionContextStore {
    private static final String DEFAULT_CRS = "EPSG:25832";
    Feature f = null;
    private final transient Logger log = Logger.getLogger(this.getClass());
    private boolean hasNasAccess = false;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();

    public NASDataRetrievalAction() {
        super("NAS Daten abfragen");
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        try {
            this.hasNasAccess = SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "csa://nasDataQuery", this.getConnectionContext());
        }
        catch (Exception ex) {
            this.log.error((Object)"Could not validate nas action tag (csa://nasDataQuery)!", (Throwable)ex);
            this.hasNasAccess = false;
        }
    }

    public int getSorter() {
        return 10;
    }

    public Feature getSourceFeature() {
        return this.f;
    }

    public boolean isActive() {
        return this.hasNasAccess;
    }

    public void setSourceFeature(Feature source) {
        this.f = source;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LinkedList<Feature> featureToSelect = new LinkedList<Feature>();
                featureToSelect.add(NASDataRetrievalAction.this.f);
                NasDialog dialog = new NasDialog(StaticSwingTools.getParentFrame((Component)CismapBroker.getInstance().getMappingComponent()), false, featureToSelect, NASDataRetrievalAction.this.getConnectionContext());
                StaticSwingTools.showDialog((JDialog)dialog);
            }
        });
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

