/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.butler;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.butler.ButlerProductGroup;
import de.cismet.cids.custom.butler.ButlerProductInfo;
import de.cismet.cids.custom.nas.NasFeeCalculator;
import de.cismet.cids.custom.utils.butler.ButlerFormat;
import de.cismet.cids.custom.utils.butler.ButlerProduct;
import de.cismet.cids.custom.utils.butler.ButlerResolution;
import de.cismet.cids.custom.wunda_blau.search.actions.NasZaehlObjekteServerAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.StaticDecimalTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JComboBoxBinding;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class Butler1ProductPanel
extends JPanel
implements ListSelectionListener,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(Butler1ProductPanel.class);
    ArrayList<ButlerProductGroup> productGroups;
    ArrayList<ButlerProduct> products;
    ArrayList<ButlerResolution> resolutions;
    ArrayList<ButlerResolution> defaultGroupResolutions;
    ArrayList<ButlerFormat> formats;
    private Geometry geom;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private ButtonGroup btGroupFormat;
    private JComboBox cbProduktGruppe;
    private JComboBox cbResolution;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblAufl\u00f6sung;
    private JLabel lblFiller;
    private JLabel lblFormat;
    private JLabel lblProdukt;
    private JLabel lblProduktGruppe;
    private JLabel lblVolumeParam;
    private JLabel lblVolumeParamKey;
    private JLabel lblVolumeParamTitle;
    private JList lstProdukt;
    private JPanel pnlFeeParrameter;
    private JPanel pnlFormat;
    private JRadioButton rbDxf;
    private JRadioButton rbGeoTif;
    private JRadioButton rbShp;
    private JRadioButton rbTif;
    private BindingGroup bindingGroup;

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.loadPrductDescriptions();
        this.initComponents();
        this.lstProdukt.setSelectionMode(0);
        this.lstProdukt.addListSelectionListener(this);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.btGroupFormat = new ButtonGroup();
        this.lblProduktGruppe = new JLabel();
        this.cbProduktGruppe = new JComboBox();
        this.lblProdukt = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.lstProdukt = new JList();
        this.lblFormat = new JLabel();
        this.pnlFormat = new JPanel();
        this.rbDxf = new JRadioButton();
        this.rbShp = new JRadioButton();
        this.rbTif = new JRadioButton();
        this.rbGeoTif = new JRadioButton();
        this.lblFiller = new JLabel();
        this.lblAufl\u00f6sung = new JLabel();
        this.cbResolution = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.pnlFeeParrameter = new JPanel();
        this.lblVolumeParamTitle = new JLabel();
        this.lblVolumeParamKey = new JLabel();
        this.lblVolumeParam = new JLabel();
        this.jLabel1 = new JLabel();
        this.setBorder(null);
        this.setMinimumSize(new Dimension(400, 291));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblProduktGruppe, (String)NbBundle.getMessage(Butler1ProductPanel.class, (String)"Butler1ProductPanel.lblProduktGruppe.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 40);
        this.add((Component)this.lblProduktGruppe, gridBagConstraints);
        ELProperty eLProperty = ELProperty.create((String)"${productGroups}");
        JComboBoxBinding jComboBoxBinding = SwingBindings.createJComboBoxBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)eLProperty, (JComboBox)this.cbProduktGruppe);
        this.bindingGroup.addBinding((Binding)jComboBoxBinding);
        this.cbProduktGruppe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Butler1ProductPanel.this.cbProduktGruppeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        this.add((Component)this.cbProduktGruppe, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblProdukt, (String)NbBundle.getMessage(Butler1ProductPanel.class, (String)"Butler1ProductPanel.lblProdukt.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 10, 40);
        this.add((Component)this.lblProdukt, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(250, 150));
        this.jScrollPane1.setPreferredSize(new Dimension(258, 150));
        eLProperty = ELProperty.create((String)"${products}");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)eLProperty, (JList)this.lstProdukt, (String)"productBinding");
        this.bindingGroup.addBinding((Binding)jListBinding);
        this.jScrollPane1.setViewportView(this.lstProdukt);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblFormat, (String)NbBundle.getMessage(Butler1ProductPanel.class, (String)"Butler1ProductPanel.lblFormat.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 40);
        this.add((Component)this.lblFormat, gridBagConstraints);
        this.pnlFormat.setLayout(new GridBagLayout());
        this.btGroupFormat.add(this.rbDxf);
        Mnemonics.setLocalizedText((AbstractButton)this.rbDxf, (String)NbBundle.getMessage(Butler1ProductPanel.class, (String)"Butler1ProductPanel.rbDxf.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.pnlFormat.add((Component)this.rbDxf, gridBagConstraints);
        this.btGroupFormat.add(this.rbShp);
        Mnemonics.setLocalizedText((AbstractButton)this.rbShp, (String)NbBundle.getMessage(Butler1ProductPanel.class, (String)"Butler1ProductPanel.rbShp.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.pnlFormat.add((Component)this.rbShp, gridBagConstraints);
        this.btGroupFormat.add(this.rbTif);
        Mnemonics.setLocalizedText((AbstractButton)this.rbTif, (String)NbBundle.getMessage(Butler1ProductPanel.class, (String)"Butler1ProductPanel.rbTif.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.pnlFormat.add((Component)this.rbTif, gridBagConstraints);
        this.btGroupFormat.add(this.rbGeoTif);
        Mnemonics.setLocalizedText((AbstractButton)this.rbGeoTif, (String)NbBundle.getMessage(Butler1ProductPanel.class, (String)"Butler1ProductPanel.rbGeoTif.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.pnlFormat.add((Component)this.rbGeoTif, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblFiller, (String)NbBundle.getMessage(Butler1ProductPanel.class, (String)"Butler1ProductPanel.lblFiller.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlFormat.add((Component)this.lblFiller, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.add((Component)this.pnlFormat, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblAufl\u00f6sung, (String)NbBundle.getMessage(Butler1ProductPanel.class, (String)"Butler1ProductPanel.lblAufl\u00f6sung.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 10, 40);
        this.add((Component)this.lblAufl\u00f6sung, gridBagConstraints);
        eLProperty = ELProperty.create((String)"${resolutions}");
        jComboBoxBinding = SwingBindings.createJComboBoxBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)eLProperty, (JComboBox)this.cbResolution, (String)"resolutionBinding");
        this.bindingGroup.addBinding((Binding)jComboBoxBinding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.add((Component)this.cbResolution, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.pnlFeeParrameter.setBackground(new Color(255, 255, 255));
        this.pnlFeeParrameter.setBorder(BorderFactory.createEtchedBorder());
        this.pnlFeeParrameter.setLayout(new GridBagLayout());
        this.lblVolumeParamTitle.setFont(new Font("DejaVu Sans", 1, 14));
        Mnemonics.setLocalizedText((JLabel)this.lblVolumeParamTitle, (String)NbBundle.getMessage(Butler1ProductPanel.class, (String)"Butler1ProductPanel.lblVolumeParamTitle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 20, 10);
        this.pnlFeeParrameter.add((Component)this.lblVolumeParamTitle, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblVolumeParamKey, (String)NbBundle.getMessage(Butler1ProductPanel.class, (String)"Butler1ProductPanel.lblVolumeParamKey.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.pnlFeeParrameter.add((Component)this.lblVolumeParamKey, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblVolumeParam, (String)NbBundle.getMessage(Butler1ProductPanel.class, (String)"Butler1ProductPanel.lblVolumeParam.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.pnlFeeParrameter.add((Component)this.lblVolumeParam, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(Butler1ProductPanel.class, (String)"Butler1ProductPanel.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.pnlFeeParrameter.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.add((Component)this.pnlFeeParrameter, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void cbProduktGruppeActionPerformed(ActionEvent evt) {
        ButlerProductGroup productGroup = (ButlerProductGroup)this.cbProduktGruppe.getSelectedItem();
        if (productGroup != null) {
            Binding productBinding = this.bindingGroup.getBinding("productBinding");
            Property productProp = productBinding.getSourceProperty();
            productProp.setValue((Object)this, productGroup.getButlerProducts());
            Binding resolutionBinding = this.bindingGroup.getBinding("resolutionBinding");
            Property resolutionProp = resolutionBinding.getSourceProperty();
            resolutionProp.setValue((Object)this, productGroup.getButlerResolutions());
            this.defaultGroupResolutions = productGroup.getButlerResolutions();
            productGroup.getButlerFormats();
            this.updateFormatButtons(productGroup.getButlerFormats());
        }
    }

    private void loadPrductDescriptions() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ButlerProductInfo tester = (ButlerProductInfo)mapper.readValue(ButlerProductInfo.class.getResourceAsStream("/de/cismet/cids/custom/butler/productDescription.json"), ButlerProductInfo.class);
            this.productGroups = tester.getButler1ProductGroups();
            this.products = this.productGroups.get(0).getButlerProducts();
            this.resolutions = this.productGroups.get(0).getButlerResolutions();
        }
        catch (IOException ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public ArrayList<ButlerProductGroup> getProductGroups() {
        return this.productGroups;
    }

    public void setProductGroups(ArrayList<ButlerProductGroup> productGroups) {
        this.productGroups = productGroups;
    }

    public ArrayList<ButlerProduct> getProducts() {
        return this.products;
    }

    public ButlerProduct getSelectedProduct() {
        ButlerProduct bp = (ButlerProduct)this.lstProdukt.getSelectedValue();
        if (bp != null) {
            if (this.rbDxf.isSelected()) {
                bp.setFormat(new ButlerFormat("dxf"));
            } else if (this.rbGeoTif.isSelected()) {
                bp.setFormat(new ButlerFormat("geotif"));
            } else if (this.rbShp.isSelected()) {
                bp.setFormat(new ButlerFormat("shp"));
            } else if (this.rbTif.isSelected()) {
                bp.setFormat(new ButlerFormat("tif"));
            }
            ButlerResolution res = (ButlerResolution)this.cbResolution.getSelectedItem();
            bp.setResolution(res);
        }
        return bp;
    }

    public void setProducts(ArrayList<ButlerProduct> products) {
        this.products = products;
    }

    public ArrayList<ButlerResolution> getResolutions() {
        return this.resolutions;
    }

    public void setResolutions(ArrayList<ButlerResolution> resolution) {
        this.resolutions = resolution;
    }

    private void updateFormatButtons(ArrayList<ButlerFormat> allowedButlerFormats) {
        this.btGroupFormat.clearSelection();
        this.rbDxf.setEnabled(false);
        this.rbGeoTif.setEnabled(false);
        this.rbShp.setEnabled(false);
        this.rbTif.setEnabled(false);
        for (ButlerFormat f : allowedButlerFormats) {
            if (f.getKey().equals("TIF")) {
                this.rbTif.setEnabled(true);
                continue;
            }
            if (f.getKey().equals("GEOTIF")) {
                this.rbGeoTif.setEnabled(true);
                continue;
            }
            if (f.getKey().equals("DXF")) {
                this.rbDxf.setEnabled(true);
                continue;
            }
            if (!f.getKey().equals("SHAPE")) continue;
            this.rbShp.setEnabled(true);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ButlerProduct selectedProduct = (ButlerProduct)this.lstProdukt.getSelectedValue();
        if (selectedProduct != null) {
            String text = selectedProduct.getVolumeParamText() == null ? "" : selectedProduct.getVolumeParamText();
            this.lblVolumeParamKey.setText(text);
            this.calculateVolumePram();
            if (selectedProduct.getButlerResolutions() != null && !selectedProduct.getButlerResolutions().isEmpty()) {
                Binding resolutionBinding = this.bindingGroup.getBinding("resolutionBinding");
                Property resolutionProp = resolutionBinding.getSourceProperty();
                resolutionProp.setValue((Object)this, (Object)selectedProduct.getButlerResolutions());
            } else {
                Binding resolutionBinding = this.bindingGroup.getBinding("resolutionBinding");
                Property resolutionProp = resolutionBinding.getSourceProperty();
                resolutionProp.setValue((Object)this, this.defaultGroupResolutions);
            }
        }
    }

    private void calculateVolumePram() {
        ButlerProduct product = (ButlerProduct)this.lstProdukt.getSelectedValue();
        if (product == null || this.geom == null) {
            this.lblVolumeParam.setText("0");
            return;
        }
        String productKey = product.getKey();
        if (productKey != null) {
            String volumeParamText = "";
            volumeParamText = productKey.equals("0108") ? this.getDachPunkteCount() : (productKey.equals("0109") ? this.getBodenPuntkeCount() : (productKey.equals("0501") ? this.getGebauedeCount() : (productKey.equals("0502") ? this.getFlurstueckeCount() : (productKey.equals("0503") ? this.getAdressCount() : this.getFlaeche()))));
            this.lblVolumeParam.setText(volumeParamText);
        }
    }

    public void setGeometry(Geometry g) {
        this.geom = g;
        this.calculateVolumePram();
    }

    private String getDachPunkteCount() {
        if (this.geom != null) {
            try {
                int dachPunkteCount = NasFeeCalculator.getDachPunkteAmount(this.geom, this.getConnectionContext());
                return "" + dachPunkteCount;
            }
            catch (ConnectionException ex) {
                LOG.error((Object)"Error during Dachpunkte search in butler 1 prduct panel", (Throwable)ex);
            }
        }
        return "0";
    }

    private String getBodenPuntkeCount() {
        if (this.geom != null) {
            try {
                int bodenPuntkeCount = NasFeeCalculator.getBodenPunkteAmount(this.geom, this.getConnectionContext());
                return "" + bodenPuntkeCount;
            }
            catch (ConnectionException ex) {
                LOG.error((Object)"Error during Dachpunkte search in butler 1 prduct panel", (Throwable)ex);
            }
        }
        return "0";
    }

    private String getGebauedeCount() {
        if (this.geom != null) {
            try {
                int gebaeudeCount = NasFeeCalculator.getGebaeudeAmount(this.geom, this.getConnectionContext());
                return "" + gebaeudeCount;
            }
            catch (ConnectionException ex) {
                LOG.error((Object)"Error during Gebaeude search in butler 1 prduct panel", (Throwable)ex);
            }
        }
        return "0";
    }

    private String getFlurstueckeCount() {
        if (this.geom != null) {
            try {
                int flurstueckCount = NasFeeCalculator.getFlurstueckAmount(this.geom, this.getConnectionContext());
                return "" + flurstueckCount;
            }
            catch (ConnectionException ex) {
                LOG.error((Object)"Error during Flurstuecksearch in butler 1 prduct panel");
            }
        }
        return "0";
    }

    private String getAdressCount() {
        if (this.geom != null) {
            try {
                ServerActionParameter sapType = new ServerActionParameter(NasZaehlObjekteServerAction.Parameter.SEARCH_TYPE.toString(), (Object)NasZaehlObjekteServerAction.NasSearchType.ADRESSE);
                ServerActionParameter sapGeom = new ServerActionParameter(NasZaehlObjekteServerAction.Parameter.GEOMETRY.toString(), (Object)this.geom);
                ArrayList c = (ArrayList)SessionManager.getProxy().executeTask("nasZaehlObjekte", "WUNDA_BLAU", null, this.getConnectionContext(), new ServerActionParameter[]{sapType, sapGeom});
                return "" + c.get(0);
            }
            catch (ConnectionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return "0";
            }
        }
        return "0";
    }

    private String getFlaeche() {
        if (this.geom == null) {
            return null;
        }
        double areaInKm = this.geom.getArea() / 1000000.0;
        return StaticDecimalTools.round((String)"0.0##", (double)areaInKm);
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

