/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.butler;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cids.custom.butler.Butler1Dialog;
import de.cismet.cids.custom.butler.Butler1ProductPanel;
import de.cismet.cids.custom.butler.Butler2ProductPanel;
import de.cismet.cids.custom.butler.ButlerDownload;
import de.cismet.cids.custom.butler.ButlerGeometryComboBox;
import de.cismet.cids.custom.butler.CoordWrapper;
import de.cismet.cids.custom.butler.PredefinedBoxes;
import de.cismet.cids.custom.objectrenderer.utils.alkis.ClientAlkisConf;
import de.cismet.cids.custom.objectrenderer.utils.billing.BillingPopup;
import de.cismet.cids.custom.utils.billing.BillingProductGroupAmount;
import de.cismet.cids.custom.utils.butler.ButlerFormat;
import de.cismet.cids.custom.utils.butler.ButlerProduct;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWMS;
import de.cismet.cismap.commons.raster.wms.simple.SimpleWmsGetMapUrl;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.tools.gui.downloadmanager.MultipleDownload;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicButtonUI;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JComboBoxBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class Butler2Dialog
extends JDialog
implements DocumentListener,
ListSelectionListener,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(Butler2Dialog.class);
    private static HashMap<String, CoordWrapper> gkRahmenKartenMap = new HashMap();
    private static HashMap<String, CoordWrapper> etrsRahmenKartenMap = new HashMap();
    private static final String FELDVERGLEICH = "0903";
    private static final String FELDVERGLEICH_BOX_500 = "600m x 350m";
    private static final String FELDVERGLEICH_BOX_1000 = "1200m x 700m";
    private static final String RASTER_DATEN_BILLING_KEY = "skmekomtiff";
    private static final String DXF_BILLING_KEY = "skmekomdxf";
    final DecimalFormat coordFormatter = new DecimalFormat("#.###");
    private ArrayList<PredefinedBoxes> boxes;
    private DefaultStyledFeature rectangleFeature;
    private MappingComponent map = new MappingComponent();
    private boolean mapInitDone = false;
    private PredefinedBoxes feldVergleichBox500 = null;
    private PredefinedBoxes feldVergleichBox1000 = null;
    private boolean isEtrsRahmenkarte = false;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private JButton btnCancel;
    private JButton btnCreate;
    private Butler2ProductPanel butler2ProductPanel1;
    private JComboBox cbPointGeom;
    private JComboBox cbRahmenkartenScale;
    private JComboBox cbSize;
    private Box.Filler filler1;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel lblGeomTitle;
    private JLabel lblLowerPosition;
    private JLabel lblPointGeoms;
    private JLabel lblRahmenkartenNr;
    private JLabel lblRequestNumber;
    private JLabel lblSize;
    private JPanel pnlControls;
    private JPanel pnlMap;
    private JPanel pnlMapSettings;
    private JPanel pnlProductSettings;
    private JPanel pnlRequestNumber;
    private JTabbedPane tbpProducts;
    private JTextField tfLowerE;
    private JTextField tfLowerN;
    private JTextField tfOrderId;
    private JTextField tfRahmenkartenNr;
    private BindingGroup bindingGroup;

    public Butler2Dialog() {
        super(StaticSwingTools.getParentFrame((Component)CismapBroker.getInstance().getMappingComponent()), true);
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        DecimalFormatSymbols formatSymbols = new DecimalFormatSymbols();
        formatSymbols.setDecimalSeparator('.');
        this.coordFormatter.setDecimalFormatSymbols(formatSymbols);
        this.boxes = PredefinedBoxes.butler2Boxes;
        this.initComponents();
        this.butler2ProductPanel1.initWithConnectionContext(connectionContext);
        this.butler2ProductPanel1.addProductListSelectionListener(this);
        this.tfLowerE.getDocument().addDocumentListener(this);
        this.tfLowerN.getDocument().addDocumentListener(this);
        this.tbpProducts.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                int tabNr = Butler2Dialog.this.tbpProducts.getUI().tabForCoordinate(Butler2Dialog.this.tbpProducts, me.getX(), me.getY());
                if (tabNr == Butler2Dialog.this.tbpProducts.getTabCount() - 1) {
                    if (Butler2Dialog.this.tbpProducts.getTabCount() == 2) {
                        Butler2Dialog.this.tbpProducts.setTabComponentAt(0, Butler2Dialog.this.getTabComponent(true, 1));
                    }
                    Butler2Dialog.this.addCloseableTab();
                    Butler2Dialog.this.tbpProducts.setSelectedIndex(Butler2Dialog.this.tbpProducts.getTabCount() - 2);
                }
            }
        });
        this.tbpProducts.setBorder(null);
        this.tbpProducts.setTabComponentAt(0, this.getTabComponent(false));
        this.tbpProducts.setToolTipTextAt(0, "Produkt 1");
        this.tfRahmenkartenNr.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                Butler2Dialog.this.updateForRahmenKartenNr();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                Butler2Dialog.this.updateForRahmenKartenNr();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                Butler2Dialog.this.updateForRahmenKartenNr();
            }
        });
        for (PredefinedBoxes box : this.boxes) {
            if (box.getDisplayName().equals(FELDVERGLEICH_BOX_500)) {
                this.feldVergleichBox500 = box;
                continue;
            }
            if (!box.getDisplayName().equals(FELDVERGLEICH_BOX_1000)) continue;
            this.feldVergleichBox1000 = box;
        }
        JPanel addPan = new JPanel();
        addPan.setLayout(new FlowLayout(0, 0, 0));
        addPan.setOpaque(false);
        addPan.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        JLabel addLabel = new JLabel("+");
        addLabel.setOpaque(false);
        addLabel.setBorder(null);
        addLabel.setFocusable(false);
        addPan.add(addLabel);
        this.tbpProducts.addTab("+", null);
        this.tbpProducts.setTabComponentAt(this.tbpProducts.getTabCount() - 1, addPan);
        this.initMap();
        this.pnlMap.setLayout(new BorderLayout());
        this.pnlMap.add((Component)this.map, "Center");
        this.cbPointGeomActionPerformed(null);
    }

    private void updateForRahmenKartenNr() {
        boolean inputError = false;
        boolean possibleEtrsNumber = false;
        this.isEtrsRahmenkarte = false;
        CoordWrapper coord = null;
        String enteredRahmenKartenNr = this.tfRahmenkartenNr.getText();
        if (enteredRahmenKartenNr.length() == 5) {
            coord = gkRahmenKartenMap.get(enteredRahmenKartenNr);
            if (coord != null) {
                this.tfLowerE.setText("" + coord.getMiddleE());
                this.tfLowerN.setText("" + coord.getMiddleN());
            } else {
                inputError = true;
                for (int i = 1; i <= 9; ++i) {
                    String etrsRahmenNumber = enteredRahmenKartenNr + "" + i;
                    if (etrsRahmenKartenMap.get(etrsRahmenNumber) == null) continue;
                    possibleEtrsNumber = true;
                    break;
                }
            }
        } else if (enteredRahmenKartenNr.length() == 6) {
            coord = etrsRahmenKartenMap.get(enteredRahmenKartenNr);
            if (coord != null) {
                this.tfLowerE.setText("" + coord.getMiddleE());
                this.tfLowerN.setText("" + coord.getMiddleN());
                this.isEtrsRahmenkarte = true;
            } else {
                inputError = true;
            }
        } else if (enteredRahmenKartenNr.length() > 6) {
            inputError = true;
        }
        if (inputError && !possibleEtrsNumber) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.RahmenkartenNrCheck.JOptionPane.message"), NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.RahmenkartenNrCheck.JOptionPane.title"), 0);
        }
    }

    private static void loadPropertiesIntoMap(Properties prop, Map map) {
        Enumeration<?> keys = prop.propertyNames();
        ArrayList<String> keyList = new ArrayList<String>();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            keyList.add(key);
        }
        for (String key : keyList) {
            String[] splittedVal = prop.getProperty(key).split(";");
            double middleE = Double.parseDouble(splittedVal[0]);
            double middleN = Double.parseDouble(splittedVal[1]);
            CoordWrapper coord = new CoordWrapper(middleE, middleN);
            map.put(key, coord);
        }
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.pnlProductSettings = new JPanel();
        this.tbpProducts = new JTabbedPane();
        this.butler2ProductPanel1 = new Butler2ProductPanel();
        this.pnlMapSettings = new JPanel();
        this.lblLowerPosition = new JLabel();
        this.lblSize = new JLabel();
        this.cbSize = new JComboBox();
        this.pnlMap = new JPanel();
        this.lblRahmenkartenNr = new JLabel();
        this.lblPointGeoms = new JLabel();
        this.cbPointGeom = new ButlerGeometryComboBox(ButlerGeometryComboBox.GEOM_FILTER_TYPE.POINT);
        this.jPanel1 = new JPanel();
        this.tfLowerN = new JTextField();
        this.tfLowerE = new JTextField();
        this.lblGeomTitle = new JLabel();
        this.jPanel2 = new JPanel();
        this.tfRahmenkartenNr = new JTextField();
        this.jLabel1 = new JLabel();
        this.cbRahmenkartenScale = new JComboBox();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.pnlControls = new JPanel();
        this.btnCreate = new JButton();
        this.btnCancel = new JButton();
        this.pnlRequestNumber = new JPanel();
        this.lblRequestNumber = new JLabel();
        this.tfOrderId = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.pnlProductSettings.setMinimumSize(new Dimension(450, 300));
        this.pnlProductSettings.setPreferredSize(new Dimension(450, 300));
        this.pnlProductSettings.setLayout(new GridBagLayout());
        this.tbpProducts.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.tbpProducts.setMinimumSize(new Dimension(400, 400));
        this.tbpProducts.setPreferredSize(new Dimension(448, 407));
        this.butler2ProductPanel1.setBorder(null);
        this.butler2ProductPanel1.setMinimumSize(new Dimension(400, 291));
        this.butler2ProductPanel1.setPreferredSize(new Dimension(442, 372));
        this.tbpProducts.addTab(NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.butler2ProductPanel1.TabConstraints.tabTitle"), this.butler2ProductPanel1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlProductSettings.add((Component)this.tbpProducts, gridBagConstraints);
        this.tbpProducts.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.tbpProducts.AccessibleContext.accessibleName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.pnlProductSettings, gridBagConstraints);
        this.pnlMapSettings.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblLowerPosition, (String)NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.lblLowerPosition.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.pnlMapSettings.add((Component)this.lblLowerPosition, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblSize, (String)NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.lblSize.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlMapSettings.add((Component)this.lblSize, gridBagConstraints);
        this.cbSize.setPreferredSize(new Dimension(150, 27));
        ELProperty eLProperty = ELProperty.create((String)"${boxes}");
        JComboBoxBinding jComboBoxBinding = SwingBindings.createJComboBoxBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)eLProperty, (JComboBox)this.cbSize);
        this.bindingGroup.addBinding((Binding)jComboBoxBinding);
        this.cbSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Butler2Dialog.this.cbSizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlMapSettings.add((Component)this.cbSize, gridBagConstraints);
        this.pnlMap.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout pnlMapLayout = new GroupLayout(this.pnlMap);
        this.pnlMap.setLayout(pnlMapLayout);
        pnlMapLayout.setHorizontalGroup(pnlMapLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 481, Short.MAX_VALUE));
        pnlMapLayout.setVerticalGroup(pnlMapLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 320, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlMapSettings.add((Component)this.pnlMap, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblRahmenkartenNr, (String)NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.lblRahmenkartenNr.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.pnlMapSettings.add((Component)this.lblRahmenkartenNr, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblPointGeoms, (String)NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.lblPointGeoms.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.pnlMapSettings.add((Component)this.lblPointGeoms, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${rectangleFeature.geometry}"), (Object)this.cbPointGeom, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        this.cbPointGeom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Butler2Dialog.this.cbPointGeomActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlMapSettings.add((Component)this.cbPointGeom, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.tfLowerN.setText(NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.tfLowerN.text"));
        this.tfLowerN.setMinimumSize(new Dimension(70, 27));
        this.tfLowerN.setPreferredSize(new Dimension(90, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel1.add((Component)this.tfLowerN, gridBagConstraints);
        this.tfLowerE.setText(NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.tfLowerE.text"));
        this.tfLowerE.setMinimumSize(new Dimension(70, 27));
        this.tfLowerE.setPreferredSize(new Dimension(90, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.anchor = 18;
        this.jPanel1.add((Component)this.tfLowerE, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlMapSettings.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lblGeomTitle, (String)NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.lblGeomTitle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 15, 0);
        this.pnlMapSettings.add((Component)this.lblGeomTitle, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.tfRahmenkartenNr.setText(NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.tfRahmenkartenNr.text"));
        this.tfRahmenkartenNr.setEnabled(false);
        this.tfRahmenkartenNr.setMinimumSize(new Dimension(70, 27));
        this.tfRahmenkartenNr.setPreferredSize(new Dimension(90, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanel2.add((Component)this.tfRahmenkartenNr, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.jLabel1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.cbRahmenkartenScale.setModel(new DefaultComboBoxModel<String>(new String[]{"1:500", "1:1000"}));
        this.cbRahmenkartenScale.setEnabled(false);
        this.cbRahmenkartenScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Butler2Dialog.this.cbRahmenkartenScaleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.jPanel2.add((Component)this.cbRahmenkartenScale, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.filler1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.pnlMapSettings.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(18, 10, 10, 10);
        this.getContentPane().add((Component)this.pnlMapSettings, gridBagConstraints);
        this.pnlControls.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreate, (String)NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.btnCreate.text"));
        this.btnCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Butler2Dialog.this.btnCreateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.pnlControls.add((Component)this.btnCreate, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.btnCancel.text"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Butler2Dialog.this.btnCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.pnlControls.add((Component)this.btnCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.pnlControls, gridBagConstraints);
        this.pnlRequestNumber.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblRequestNumber, (String)NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.lblRequestNumber.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 10, 33);
        this.pnlRequestNumber.add((Component)this.lblRequestNumber, gridBagConstraints);
        this.tfOrderId.setText(NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.tfOrderId.text"));
        this.tfOrderId.setMinimumSize(new Dimension(70, 27));
        this.tfOrderId.setPreferredSize(new Dimension(90, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 5);
        this.pnlRequestNumber.add((Component)this.tfOrderId, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.getContentPane().add((Component)this.pnlRequestNumber, gridBagConstraints);
        this.bindingGroup.bind();
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cbSizeActionPerformed(ActionEvent evt) {
        this.changeMap();
    }

    private void btnCreateActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StringBuilder missConfiguredProducts = new StringBuilder();
                boolean showErrorPane = false;
                int missConfigPrdCount = 0;
                for (int i = 0; i < Butler2Dialog.this.tbpProducts.getTabCount() - 1; ++i) {
                    Butler2ProductPanel productPanel = (Butler2ProductPanel)Butler2Dialog.this.tbpProducts.getComponentAt(i);
                    ButlerProduct bp = productPanel.getSelectedProduct();
                    if (Butler2Dialog.this.isProductConfigurationValid(bp)) continue;
                    showErrorPane = true;
                    ++missConfigPrdCount;
                    missConfiguredProducts.append(i + 1);
                    missConfiguredProducts.append(", ");
                }
                if (showErrorPane) {
                    String productNumbers = missConfiguredProducts.toString().substring(0, missConfiguredProducts.toString().length() - 2);
                    String message = missConfigPrdCount == 1 ? NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.ProductConfigCheck.JOptionPane.singularMessage") : NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.ProductConfigCheck.JOptionPane.multiMessage");
                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)Butler2Dialog.this), String.format(message, productNumbers), NbBundle.getMessage(Butler1ProductPanel.class, (String)"Butler1Dialog.ProductConfigCheck.JOptionPane.title"), 0);
                    return;
                }
                if (Butler2Dialog.this.rectangleFeature == null || Butler2Dialog.this.rectangleFeature.getGeometry() == null) {
                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)Butler2Dialog.this), NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.GeomConfigCheck.JOptionPane.message"), NbBundle.getMessage(Butler1Dialog.class, (String)"Butler1Dialog.GeomConfigCheck.JOptionPane.title"), 0);
                    return;
                }
                String orderId = Butler2Dialog.this.tfOrderId.getText();
                if (!orderId.matches("[a-zA-Z0-9_-]*")) {
                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)Butler2Dialog.this), NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.OrderIdCheck.JOptionPane.message"), NbBundle.getMessage(Butler2Dialog.class, (String)"Butler2Dialog.OrderIdCheck.JOptionPane.title"), 0);
                    return;
                }
                Geometry g = Butler2Dialog.this.rectangleFeature.getGeometry();
                Point p = g.getCentroid();
                double middleX = p.getX();
                double middleY = p.getY();
                StringBuilder jobnameBuilder = new StringBuilder();
                if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)CismapBroker.getInstance().getMappingComponent())) {
                    String jobname = DownloadManagerDialog.getInstance().getJobName();
                    if (jobname == null) {
                        jobnameBuilder.append("");
                    } else {
                        jobnameBuilder.append(jobname);
                    }
                }
                PredefinedBoxes box = (PredefinedBoxes)Butler2Dialog.this.cbSize.getSelectedItem();
                ArrayList<ButlerDownload> downloads = new ArrayList<ButlerDownload>();
                for (int i = 0; i < Butler2Dialog.this.tbpProducts.getTabCount() - 1; ++i) {
                    Butler2ProductPanel productPanel = (Butler2ProductPanel)Butler2Dialog.this.tbpProducts.getComponentAt(i);
                    ButlerProduct bp = productPanel.getSelectedProduct();
                    if (bp.getKey().startsWith(Butler2Dialog.FELDVERGLEICH)) {
                        String scale = Butler2Dialog.this.cbRahmenkartenScale.getSelectedItem().equals("1:500") ? "500" : "1000";
                        bp.setScale(scale);
                    }
                    ButlerFormat format = bp.getFormat();
                    ButlerDownload download = new ButlerDownload(jobnameBuilder.toString(), Butler2Dialog.this.tfOrderId.getText() + "_" + (i + 1), bp, Butler2Dialog.this.isEtrsRahmenkarte, box.getKey(), middleX, middleY, Butler2Dialog.this.getConnectionContext());
                    String productKey = "";
                    productKey = format != null && format.getKey().equals("dxf") ? Butler2Dialog.DXF_BILLING_KEY : Butler2Dialog.RASTER_DATEN_BILLING_KEY;
                    String requestNr = Butler2Dialog.this.tfOrderId.getText().trim() + "_" + i;
                    ArrayList<BillingProductGroupAmount> list = productPanel.getProductGroupAmounts();
                    BillingProductGroupAmount[] groupAmounts = list.toArray(new BillingProductGroupAmount[list.size()]);
                    try {
                        if (!BillingPopup.doBilling(productKey, "butler 2", requestNr, null, Butler2Dialog.this.getConnectionContext(), groupAmounts)) continue;
                        downloads.add(download);
                        continue;
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"error during billing for ALKIS Datenausgabe", (Throwable)ex);
                    }
                }
                DownloadManager.instance().add((Download)new MultipleDownload(downloads, "Butler Downloads " + Butler2Dialog.this.tfOrderId.getText()));
                Butler2Dialog.this.dispose();
            }
        });
    }

    private void cbPointGeomActionPerformed(ActionEvent evt) {
        Object obj = this.cbPointGeom.getSelectedItem();
        if (obj != null && obj instanceof Point) {
            Point p = (Point)obj;
            this.tfLowerE.getDocument().removeDocumentListener(this);
            this.tfLowerN.getDocument().removeDocumentListener(this);
            this.tfLowerE.setText(this.coordFormatter.format(p.getX()));
            this.tfLowerN.setText(this.coordFormatter.format(p.getY()));
            this.changeMap();
            this.tfLowerE.getDocument().addDocumentListener(this);
            this.tfLowerN.getDocument().addDocumentListener(this);
        }
    }

    private void cbRahmenkartenScaleActionPerformed(ActionEvent evt) {
        if (this.cbRahmenkartenScale.getSelectedItem().equals("1:500")) {
            this.cbSize.setSelectedItem(this.feldVergleichBox500);
        } else {
            this.cbSize.setSelectedItem(this.feldVergleichBox1000);
        }
    }

    private void initMap() {
        Runnable mapRunnable = new Runnable(){

            @Override
            public void run() {
                ActiveLayerModel mappingModel = new ActiveLayerModel();
                mappingModel.setSrs(ClientAlkisConf.getInstance().getSrsService());
                mappingModel.addHome(this.getBoundingBox());
                SimpleWMS swms = new SimpleWMS(new SimpleWmsGetMapUrl(ClientAlkisConf.getInstance().getMapCallString()));
                swms.setName("butler-background");
                mappingModel.addLayer((RetrievalServiceLayer)swms);
                Butler2Dialog.this.map.setMappingModel((MappingModel)mappingModel);
                int duration = Butler2Dialog.this.map.getAnimationDuration();
                Butler2Dialog.this.map.setAnimationDuration(0);
                Butler2Dialog.this.map.setInteractionMode("ZOOM");
                Butler2Dialog.this.map.unlock();
                Butler2Dialog.this.map.setInteractionMode("MUTE");
                Butler2Dialog.this.map.setAnimationDuration(duration);
                Butler2Dialog.this.mapInitDone = true;
            }

            private XBoundingBox getBoundingBox() {
                XBoundingBox currBb = (XBoundingBox)CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBox();
                Geometry transformedGeom = CrsTransformer.transformToGivenCrs((Geometry)currBb.getGeometry(), (String)ClientAlkisConf.getInstance().getSrsService());
                XBoundingBox result = new XBoundingBox(transformedGeom.buffer(20.0));
                return result;
            }
        };
        if (EventQueue.isDispatchThread()) {
            mapRunnable.run();
        } else {
            EventQueue.invokeLater(mapRunnable);
        }
    }

    private void changeMap() {
        Runnable mapChangeRunnable = new Runnable(){

            @Override
            public void run() {
                if (Butler2Dialog.this.mapInitDone) {
                    Geometry g;
                    if (Butler2Dialog.this.rectangleFeature == null) {
                        Butler2Dialog.this.rectangleFeature = Butler2Dialog.this.createFeature();
                    }
                    if ((g = Butler2Dialog.this.createGeometry()) != null) {
                        Butler2Dialog.this.updateGeomInAllProducts(g);
                        Butler2Dialog.this.rectangleFeature.setGeometry(g);
                        if (!Butler2Dialog.this.map.getFeatureCollection().contains((Feature)Butler2Dialog.this.rectangleFeature)) {
                            Butler2Dialog.this.map.getFeatureCollection().addFeature((Feature)Butler2Dialog.this.rectangleFeature);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Butler2Dialog.this.map.reconsiderFeature((Feature)Butler2Dialog.this.rectangleFeature);
                                Butler2Dialog.this.map.zoomToFeatureCollection();
                            }
                        });
                    }
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            mapChangeRunnable.run();
        } else {
            EventQueue.invokeLater(mapChangeRunnable);
        }
    }

    private void updateGeomInAllProducts(Geometry geom) {
        for (int i = 0; i < this.tbpProducts.getTabCount() - 1; ++i) {
            Butler2ProductPanel productPan = (Butler2ProductPanel)this.tbpProducts.getComponentAt(i);
            productPan.setGeometry(geom);
        }
    }

    private DefaultStyledFeature createFeature() {
        DefaultStyledFeature dsf = new DefaultStyledFeature();
        Geometry geom = this.createGeometry();
        dsf.setGeometry(geom);
        dsf.setTransparency(0.8f);
        dsf.setFillingPaint((Paint)new Color(192, 80, 77, 192));
        return dsf;
    }

    private Geometry createGeometry() {
        double lowerE = 0.0;
        double lowerN = 0.0;
        PredefinedBoxes box = (PredefinedBoxes)this.cbSize.getSelectedItem();
        try {
            double middleE = Double.parseDouble(this.tfLowerE.getText());
            double middleN = Double.parseDouble(this.tfLowerN.getText());
            if (!(middleE >= 361000.0 && middleE <= 384000.0 && middleN >= 5669000.0 && middleN <= 5687000.0)) {
                return null;
            }
            lowerE = middleE - box.getEastSize() / 2.0;
            lowerN = middleN - box.getNorthSize() / 2.0;
        }
        catch (Exception ex) {
            return null;
        }
        PredefinedBoxes selectedBoxSize = (PredefinedBoxes)this.cbSize.getSelectedItem();
        double upperE = lowerE + selectedBoxSize.getEastSize();
        double upperN = lowerN + selectedBoxSize.getNorthSize();
        Coordinate[] coords = new Coordinate[5];
        Coordinate startCoord = new Coordinate(lowerE, lowerN);
        coords[0] = new Coordinate(lowerE, lowerN);
        double c1 = lowerN + Math.abs(upperN - lowerN);
        coords[1] = new Coordinate(lowerE, c1);
        double c2 = lowerE + Math.abs(lowerE - upperE);
        coords[2] = new Coordinate(c2, c1);
        coords[3] = new Coordinate(c2, lowerN);
        coords[4] = startCoord;
        int currentSrid = CrsTransformer.extractSridFromCrs((String)this.map.getMappingModel().getSrs().getCode());
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), currentSrid);
        Polygon p = new Polygon(geometryFactory.createLinearRing(coords), null, geometryFactory);
        return p;
    }

    public ArrayList<PredefinedBoxes> getBoxes() {
        return this.boxes;
    }

    public void setBoxes(ArrayList<PredefinedBoxes> boxes) {
        this.boxes = boxes;
    }

    private void addCloseableTab() {
        Component tabComp = this.getTabComponent(true);
        int number = this.tbpProducts.getTabCount();
        String title = "Produkt " + number;
        int tabPos = this.tbpProducts.getTabCount() - 1;
        Butler2ProductPanel productPan = new Butler2ProductPanel();
        productPan.initWithConnectionContext(this.getConnectionContext());
        productPan.addProductListSelectionListener(this);
        if (this.rectangleFeature == null || this.rectangleFeature.getGeometry() != null) {
            // empty if block
        }
        this.tbpProducts.insertTab("", null, productPan, title, tabPos);
        int tabPosNew = this.tbpProducts.indexOfComponent(productPan);
        this.tbpProducts.setTabComponentAt(tabPosNew, tabComp);
        this.tbpProducts.setBorder(null);
    }

    private Component getTabComponent(boolean isCloseableTab) {
        int number = this.tbpProducts.getTabCount();
        return this.getTabComponent(isCloseableTab, number);
    }

    private Component getTabComponent(boolean isCloseableTab, int tabNumber) {
        final JPanel tabComp = new JPanel();
        tabComp.setLayout(new GridBagLayout());
        tabComp.setOpaque(false);
        tabComp.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        tabComp.setPreferredSize(new Dimension(120, 22));
        String title = "Produkt " + tabNumber;
        JLabel label = new JLabel(title);
        label.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/butler/page_white.png")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        tabComp.add((Component)label, gridBagConstraints);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        if (isCloseableTab) {
            final JButton button = new JButton("x");
            button.setPreferredSize(new Dimension(10, 19));
            button.setToolTipText("close this tab");
            button.setUI(new BasicButtonUI());
            button.setContentAreaFilled(false);
            button.setFocusable(false);
            button.setBorder(null);
            button.setBorderPainted(false);
            button.setRolloverEnabled(true);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    int i = Butler2Dialog.this.tbpProducts.indexOfTabComponent(tabComp);
                    if (i != -1) {
                        Butler2Dialog.this.tbpProducts.remove(i);
                    }
                    if (i == Butler2Dialog.this.tbpProducts.getSelectedIndex()) {
                        if (i == 0) {
                            Butler2Dialog.this.tbpProducts.setSelectedIndex(0);
                        } else {
                            Butler2Dialog.this.tbpProducts.setSelectedIndex(i - 1);
                        }
                    }
                    Butler2Dialog.this.updateTabComponents();
                }
            });
            button.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent me) {
                    button.setBorder(new LineBorder(Color.GRAY));
                    button.setBorderPainted(true);
                }

                @Override
                public void mouseExited(MouseEvent me) {
                    button.setBorder(null);
                    button.setBorderPainted(false);
                }
            });
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            tabComp.add((Component)button, gridBagConstraints);
        }
        return tabComp;
    }

    private void updateTabComponents() {
        if (this.tbpProducts.getTabCount() <= 2) {
            this.tbpProducts.setTabComponentAt(0, this.getTabComponent(false, 1));
        } else {
            for (int i = 0; i < this.tbpProducts.getTabCount() - 1; ++i) {
                this.tbpProducts.setTabComponentAt(i, this.getTabComponent(true, i + 1));
                this.tbpProducts.setToolTipTextAt(i, "Produkt " + (i + 1));
            }
        }
    }

    private boolean isProductConfigurationValid(ButlerProduct bp) {
        if (bp == null) {
            return false;
        }
        if (bp.getKey() == null || bp.getKey().equals("")) {
            return false;
        }
        if (bp.getFormat() == null || bp.getFormat().getKey() == null || bp.getFormat().getKey().equals("")) {
            return false;
        }
        return bp.getResolution() != null && bp.getResolution().getKey() != null && !bp.getResolution().getKey().equals("");
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        this.changeMap();
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        this.changeMap();
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
        this.changeMap();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                for (int i = 0; i < Butler2Dialog.this.tbpProducts.getTabCount() - 1; ++i) {
                    Butler2ProductPanel productPanel = (Butler2ProductPanel)Butler2Dialog.this.tbpProducts.getComponentAt(i);
                    ButlerProduct product = productPanel.getSelectedProduct();
                    if (product == null || product.getKey() == null || !product.getKey().startsWith(Butler2Dialog.FELDVERGLEICH)) continue;
                    return true;
                }
                return false;
            }

            @Override
            protected void done() {
                try {
                    Boolean isFeldvergleichSelected = (Boolean)this.get();
                    if (isFeldvergleichSelected.booleanValue()) {
                        Butler2Dialog.this.tfRahmenkartenNr.setEnabled(true);
                        Butler2Dialog.this.cbRahmenkartenScale.setEnabled(true);
                        if (Butler2Dialog.this.cbRahmenkartenScale.getSelectedItem().equals("1:500")) {
                            Butler2Dialog.this.cbSize.setSelectedItem(Butler2Dialog.this.feldVergleichBox500);
                        } else {
                            Butler2Dialog.this.cbSize.setSelectedItem(Butler2Dialog.this.feldVergleichBox1000);
                        }
                        Butler2Dialog.this.cbSize.setEnabled(false);
                        Butler2Dialog.this.cbPointGeom.setEnabled(false);
                        Butler2Dialog.this.tfLowerE.setEnabled(false);
                        Butler2Dialog.this.tfLowerN.setEnabled(false);
                        Butler2Dialog.this.lblLowerPosition.setEnabled(false);
                        Butler2Dialog.this.lblPointGeoms.setEnabled(false);
                        Butler2Dialog.this.lblSize.setEnabled(false);
                    } else {
                        Butler2Dialog.this.tfRahmenkartenNr.setEnabled(false);
                        Butler2Dialog.this.cbRahmenkartenScale.setEnabled(false);
                        Butler2Dialog.this.cbSize.setEnabled(true);
                        Butler2Dialog.this.cbPointGeom.setEnabled(true);
                        Butler2Dialog.this.tfLowerE.setEnabled(true);
                        Butler2Dialog.this.tfLowerN.setEnabled(true);
                        Butler2Dialog.this.lblLowerPosition.setEnabled(true);
                        Butler2Dialog.this.lblPointGeoms.setEnabled(true);
                        Butler2Dialog.this.lblSize.setEnabled(true);
                    }
                }
                catch (InterruptedException ex) {
                    LOG.error((Object)ex);
                }
                catch (ExecutionException ex) {
                    LOG.error((Object)ex);
                }
            }
        };
        worker.execute();
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    static {
        Properties gkRahmenProp = new Properties();
        Properties etrsRahmenProp = new Properties();
        try {
            gkRahmenProp.load(Butler2Dialog.class.getResourceAsStream("rahmenkarten_gk.properties"));
            Butler2Dialog.loadPropertiesIntoMap(gkRahmenProp, gkRahmenKartenMap);
            etrsRahmenProp.load(Butler2Dialog.class.getResourceAsStream("rahmenkarten_etrs.properties"));
            Butler2Dialog.loadPropertiesIntoMap(etrsRahmenProp, etrsRahmenKartenMap);
        }
        catch (IOException ex) {
            LOG.error((Object)"Could not read property file with defined boxes for butler 1", (Throwable)ex);
        }
    }
}

