/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.butler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PredefinedBoxes {
    protected static final ArrayList<PredefinedBoxes> butler1Boxes = new ArrayList();
    protected static final ArrayList<PredefinedBoxes> butler2Boxes = new ArrayList();
    private static final Logger LOG = Logger.getLogger(PredefinedBoxes.class);
    private final String displayName;
    private double eSize;
    private final double nSize;
    private String key;

    public PredefinedBoxes(String displayName, double eSize, double nSize) {
        this.displayName = displayName;
        this.eSize = eSize;
        this.nSize = nSize;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public double getEastSize() {
        return this.eSize;
    }

    public double getNorthSize() {
        return this.nSize;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String toString() {
        return this.displayName;
    }

    private static void loadPropertiesIntoList(ArrayList list, Properties prop) {
        Enumeration<?> keys = prop.propertyNames();
        ArrayList<String> keyList = new ArrayList<String>();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            keyList.add(key);
        }
        Comparator<String> keyComp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int number1 = Integer.parseInt(o1.replaceAll("box", ""));
                int number2 = Integer.parseInt(o2.replaceAll("box", ""));
                return Integer.valueOf(number1).compareTo(number2);
            }
        };
        Collections.sort(keyList, keyComp);
        for (String key : keyList) {
            String[] splittedVal = prop.getProperty(key).split(";");
            double width = Double.parseDouble(splittedVal[1]);
            double height = Double.parseDouble(splittedVal[2]);
            PredefinedBoxes box = new PredefinedBoxes(splittedVal[0], width, height);
            if (splittedVal.length == 4) {
                box.setKey(splittedVal[3]);
            }
            list.add(box);
        }
    }

    static {
        Properties prop = new Properties();
        try {
            prop.load(PredefinedBoxes.class.getResourceAsStream("butler1Boxes.properties"));
            PredefinedBoxes.loadPropertiesIntoList(butler1Boxes, prop);
            prop = new Properties();
            prop.load(PredefinedBoxes.class.getResourceAsStream("butler2Boxes.properties"));
            PredefinedBoxes.loadPropertiesIntoList(butler2Boxes, prop);
        }
        catch (IOException ex) {
            LOG.error((Object)"Could not read property file with defined boxes for butler 1", (Throwable)ex);
        }
    }
}

