/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.clientutils;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.ui.actions.PreparedAsyncDownloadHelper;
import de.cismet.cids.server.actions.PreparedAsyncByteAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.gui.downloadmanager.AbstractCancellableDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.Future;

public class ByteArrayActionDownload
extends AbstractCancellableDownload
implements ConnectionContextProvider {
    private static final int MIN_LENGTH_TO_SHOW_PROGRESS = 10000;
    protected String taskname;
    protected Object body;
    protected ServerActionParameter[] params;
    protected Future<ServerActionParameter[]> paramsFuture;
    private final String domain;
    private final ConnectionContext connectionContext;
    private volatile int progress = 0;

    public ByteArrayActionDownload(String taskname, Object body, ServerActionParameter[] params, String title, String directory, String filename, String extension, ConnectionContext connectionContext) {
        this("WUNDA_BLAU", taskname, body, params, title, directory, filename, extension, connectionContext);
    }

    public ByteArrayActionDownload(String taskname, Object body, String title, String directory, String filename, String extension, Future<ServerActionParameter[]> params, ConnectionContext connectionContext) {
        this("WUNDA_BLAU", taskname, body, title, directory, filename, extension, params, connectionContext);
    }

    public ByteArrayActionDownload(String domain, String taskname, Object body, ServerActionParameter[] params, String title, String directory, String filename, String extension, ConnectionContext connectionContext) {
        this.domain = domain;
        this.taskname = taskname;
        this.body = body;
        this.params = params;
        this.title = title;
        this.directory = directory;
        this.connectionContext = connectionContext;
        this.status = Download.State.WAITING;
        this.determineDestinationFile(filename, extension);
    }

    public ByteArrayActionDownload(String domain, String taskname, Object body, String title, String directory, String filename, String extension, Future<ServerActionParameter[]> params, ConnectionContext connectionContext) {
        this.domain = domain;
        this.taskname = taskname;
        this.body = body;
        this.paramsFuture = params;
        this.title = title;
        this.directory = directory;
        this.connectionContext = connectionContext;
        this.status = Download.State.WAITING;
        this.determineDestinationFile(filename, extension);
    }

    protected ByteArrayActionDownload(ConnectionContext connectionContext) {
        this("WUNDA_BLAU", connectionContext);
    }

    protected ByteArrayActionDownload(String domain, ConnectionContext connectionContext) {
        this.domain = domain;
        this.connectionContext = connectionContext;
        this.status = Download.State.WAITING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object contentObject;
        if (this.status != Download.State.WAITING) {
            return;
        }
        this.status = Download.State.RUNNING;
        this.stateChanged();
        try {
            contentObject = this.execAction();
        }
        catch (Exception ex) {
            log.warn((Object)("Couldn't execute task '" + this.taskname + "'."), (Throwable)ex);
            this.error(ex);
            return;
        }
        if (contentObject instanceof PreparedAsyncByteAction) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(this.fileToSaveTo);
                PreparedAsyncDownloadHelper.PreparedAsyncDownloadMonitor monitor = null;
                final long fileLength = ((PreparedAsyncByteAction)contentObject).getLength();
                if (fileLength > 10000L) {
                    monitor = new PreparedAsyncDownloadHelper.PreparedAsyncDownloadMonitor(){

                        public void progress(long bytesRead) {
                            int prog = (int)(bytesRead * 100L / fileLength);
                            if (prog > ByteArrayActionDownload.this.progress + 5) {
                                ByteArrayActionDownload.this.progress = prog;
                                ByteArrayActionDownload.this.status = Download.State.RUNNING_WITH_PROGRESS;
                                ByteArrayActionDownload.this.stateChanged();
                            }
                        }
                    };
                }
                PreparedAsyncDownloadHelper.download((PreparedAsyncByteAction)((PreparedAsyncByteAction)contentObject), (FileOutputStream)out, monitor);
            }
            catch (Exception ex) {
                log.warn((Object)("Couldn't write downloaded content to file '" + this.fileToSaveTo + "'."), (Throwable)ex);
                this.error(ex);
                return;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception fileLength) {}
                }
            }
        }
        byte[] content = (byte[])contentObject;
        if (content == null || content.length <= 0) {
            log.info((Object)"Downloaded content seems to be empty..");
            if (this.status == Download.State.RUNNING) {
                this.status = Download.State.COMPLETED;
                this.stateChanged();
            }
            return;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.fileToSaveTo);
            out.write(content);
        }
        catch (IOException ex) {
            log.warn((Object)("Couldn't write downloaded content to file '" + this.fileToSaveTo + "'."), (Throwable)ex);
            this.error(ex);
            return;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.status == Download.State.RUNNING || this.status == Download.State.RUNNING_WITH_PROGRESS) {
            this.status = Download.State.COMPLETED;
            this.stateChanged();
        }
    }

    public int getProgress() {
        return this.progress;
    }

    protected Object execAction() throws Exception {
        Object ret;
        if (this.paramsFuture != null && this.params == null) {
            this.params = this.paramsFuture.get();
        }
        if ((ret = SessionManager.getProxy().executeTask(this.taskname, this.domain, this.body, this.getConnectionContext(), false, this.params)) instanceof Exception) {
            Exception ex = (Exception)ret;
            throw ex;
        }
        return ret;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

