/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.clientutils;

import de.cismet.cids.custom.clientutils.DmsUrlPathMapper;
import de.cismet.cids.custom.clientutils.DmsUrlsPanel;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.tools.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public class DmsUrlPanel
extends JPanel {
    public static final int MAX_DESCRIPTION_LENGTH = 12;
    public static final String DELETE_ACTION_COMMAND = "DELETE_ACTION";
    private static final Logger LOG = Logger.getLogger(DmsUrlPanel.class);
    private final Collection<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private boolean deletable = false;
    private CidsBean dmsUrlBean;
    private JPanel jPanel1;
    private JLabel lblDescr;
    private JLabel lblIcon;
    private JMenuItem mniDelete;
    private JPopupMenu pmnLink;

    public DmsUrlPanel() {
        this((CidsBean)null);
    }

    public DmsUrlPanel(CidsBean dmsUrlBean) {
        this.initComponents();
        this.dmsUrlBean = dmsUrlBean;
        String description = dmsUrlBean != null ? (String)dmsUrlBean.getProperty("name") : "null";
        this.initDescription(description);
        this.initIcon(DmsUrlPanel.makeIcon(dmsUrlBean), DmsUrlPanel.getUrlString(dmsUrlBean));
    }

    private static ImageIcon makeIcon(CidsBean dmsUrlBean) {
        ImageIcon icon;
        Integer typ = dmsUrlBean != null ? (Integer)dmsUrlBean.getProperty("typ") : 0;
        if (typ != null) {
            switch (typ) {
                case 0: {
                    icon = new ImageIcon(DmsUrlPanel.class.getResource("/de/cismet/cids/custom/clientutils/filetypes/dms_default.png"));
                    break;
                }
                case 1: {
                    ImageIcon tryIcon;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"suche nach Bild f\u00fcr link");
                    }
                    String url = DmsUrlPanel.getUrlString(dmsUrlBean);
                    int pPos = url.lastIndexOf(".");
                    String type = url.substring(pPos + 1, url.length()).toLowerCase();
                    String filename = "" + type + ".png";
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Filename f\u00fcr Bild: " + filename));
                    }
                    try {
                        tryIcon = new ImageIcon(DmsUrlPanel.class.getResource("/de/cismet/cids/custom/clientutils/filetypes/" + filename));
                    }
                    catch (Exception e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Fehler beim Suchen des Icons:" + type));
                        }
                        tryIcon = new ImageIcon(DmsUrlPanel.class.getResource("/de/cismet/cids/custom/clientutils/filetypes/dms_default.png"));
                    }
                    icon = tryIcon;
                    break;
                }
                default: {
                    icon = null;
                    break;
                }
            }
        } else {
            icon = null;
        }
        return icon;
    }

    public void setDMSUrlEntity(CidsBean dmsUrlBean) {
        this.dmsUrlBean = dmsUrlBean;
    }

    public Integer getTyp() {
        return (Integer)this.dmsUrlBean.getProperty("typ");
    }

    public CidsBean getDMSUrlBean() {
        return this.dmsUrlBean;
    }

    private void initIcon(Icon icon, String tooltip) {
        this.lblIcon.setIcon(icon);
        this.lblIcon.setToolTipText(tooltip);
    }

    private void initDescription(String desc) {
        if (desc != null && desc.length() > 12) {
            this.lblDescr.setText(desc.substring(0, 12) + "...");
            this.lblDescr.setToolTipText(desc);
        } else {
            this.lblDescr.setText(desc);
        }
    }

    private void initComponents() {
        this.pmnLink = new JPopupMenu();
        this.mniDelete = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.lblIcon = new JLabel();
        this.lblDescr = new JLabel();
        this.mniDelete.setText("Link entfernen");
        this.mniDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DmsUrlPanel.this.mniDeleteActionPerformed(evt);
            }
        });
        this.pmnLink.add(this.mniDelete);
        this.setMaximumSize(new Dimension(100, 100));
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new BorderLayout());
        this.lblIcon.setHorizontalAlignment(0);
        this.lblIcon.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/clientutils/filetypes/dms_default.png")));
        this.lblIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                DmsUrlPanel.this.lblIconMousePressed(evt);
            }
        });
        this.jPanel1.add((Component)this.lblIcon, "Center");
        this.lblDescr.setHorizontalAlignment(0);
        this.lblDescr.setText("Beschreibung");
        this.lblDescr.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                DmsUrlPanel.this.lblDescrMouseMoved(evt);
            }
        });
        this.lblDescr.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DmsUrlPanel.this.lblDescrMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                DmsUrlPanel.this.lblDescrMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                DmsUrlPanel.this.lblDescrMouseEntered(evt);
            }
        });
        this.jPanel1.add((Component)this.lblDescr, "South");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void lblIconMousePressed(MouseEvent evt) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"mouse pressed");
        }
        if (evt.getButton() == 3 && this.isDeletable()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"button3 && isDeletable");
            }
            if (this.getParent() instanceof DmsUrlsPanel && ((DmsUrlsPanel)this.getParent()).isEnabled()) {
                this.pmnLink.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    private void mniDeleteActionPerformed(ActionEvent evt) {
        this.fireDeleteActionPerformed();
    }

    private void lblDescrMouseClicked(MouseEvent evt) {
        String urlString = DmsUrlPanel.getUrlString(this.dmsUrlBean);
        if (urlString == null) {
            JOptionPane.showMessageDialog(this, "Es wurde keine Url hinterlegt!", "Fehler", 0);
            return;
        }
        String gotoUrl = DmsUrlPathMapper.getInstance().replaceNetworkPath(urlString);
        try {
            BrowserLauncher.openURL((String)gotoUrl);
        }
        catch (Exception e) {
            LOG.warn((Object)("Fehler beim \u00f6ffnen von:" + gotoUrl + "\nNeuer Versuch"), (Throwable)e);
            try {
                BrowserLauncher.openURL((String)gotoUrl);
            }
            catch (Exception e2) {
                String newGotoUrl = gotoUrl.replaceAll("\\\\", "/").replaceAll(" ", "%20");
                try {
                    LOG.warn((Object)("Auch das 2te Mal ging schief.Fehler beim \u00f6ffnen von:" + newGotoUrl + "\nLetzter Versuch"), (Throwable)e2);
                    BrowserLauncher.openURL((String)("file:///" + newGotoUrl));
                }
                catch (Exception e3) {
                    LOG.error((Object)("Auch das 3te Mal ging schief.Fehler beim \u00f6ffnen von:file://" + newGotoUrl), (Throwable)e3);
                }
            }
        }
    }

    private void lblDescrMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
        this.lblDescr.setForeground(Color.BLACK);
    }

    private void lblDescrMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
        this.lblDescr.setForeground(Color.BLUE);
    }

    private void lblDescrMouseMoved(MouseEvent evt) {
    }

    public void addActionListener(ActionListener al) {
        this.actionListeners.add(al);
    }

    public void removeActionListener(ActionListener al) {
        this.actionListeners.remove(al);
    }

    public void fireDeleteActionPerformed() {
        Iterator<ActionListener> it = this.actionListeners.iterator();
        ActionEvent event = new ActionEvent(this, 0, DELETE_ACTION_COMMAND);
        while (it.hasNext()) {
            ActionListener elem = it.next();
            if (!(elem instanceof ActionListener)) continue;
            elem.actionPerformed(event);
        }
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    private static String getUrlString(CidsBean dmsUrlBean) {
        if (dmsUrlBean != null) {
            CidsBean urlBean = (CidsBean)dmsUrlBean.getProperty("url");
            CidsBean urlBase = (CidsBean)urlBean.getProperty("url_base_id");
            String proPrefix = (String)urlBase.getProperty("prot_prefix");
            String server = (String)urlBase.getProperty("server");
            String path = (String)urlBase.getProperty("path");
            String objectName = (String)urlBean.getProperty("object_name");
            return proPrefix + server + path + objectName;
        }
        return null;
    }
}

