/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.clientutils;

import Sirius.navigator.connection.SessionManager;
import de.cismet.cids.custom.clientutils.StadtbilderUtils;
import de.cismet.cids.custom.wunda_blau.search.actions.TifferAction;
import de.cismet.cids.custom.wunda_blau.search.server.MetaObjectNodesStadtbildSerieSearchStatement;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.gui.downloadmanager.AbstractDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class TifferDownload
extends AbstractDownload
implements ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(TifferDownload.class);
    private final StadtbilderUtils.StadtbildInfo stadtbildInfo;
    private final String scale;
    private final String format;
    private final ConnectionContext connectionContext;

    public TifferDownload(String directory, String title, String filename, StadtbilderUtils.StadtbildInfo stadtbildInfo, String scale, ConnectionContext connectionContext) {
        this.stadtbildInfo = stadtbildInfo;
        this.directory = directory;
        this.title = title;
        this.scale = scale;
        this.connectionContext = connectionContext;
        this.status = Download.State.WAITING;
        String string = this.format = MetaObjectNodesStadtbildSerieSearchStatement.Bildtyp.REIHENSCHRAEG.getId() == stadtbildInfo.getBildtypId().intValue() ? "jpg" : StadtbilderUtils.getFormatOfHighResPicture(stadtbildInfo);
        if (this.format != null) {
            this.determineDestinationFile(filename, "." + this.format.toLowerCase());
        }
    }

    public void run() {
        if (this.status != Download.State.WAITING) {
            return;
        }
        if (this.format == null) {
            log.error((Object)"No format found for the image. The image might not exist");
            this.error(new Exception("No format found for the image. The image might not exist"));
            return;
        }
        this.status = Download.State.RUNNING;
        this.stateChanged();
        String imageNumber = this.stadtbildInfo.getBildnummer();
        Integer bildtypId = this.stadtbildInfo.getBildtypId();
        String blickrichtung = this.stadtbildInfo.getBlickrichtung();
        Integer jahr = this.stadtbildInfo.getJahr();
        char firstCharacter = imageNumber.charAt(0);
        String subdir = "SB/" + firstCharacter + "/SB_";
        ServerActionParameter paramNummer = new ServerActionParameter(TifferAction.ParameterType.BILDNUMMER.toString(), (Object)imageNumber);
        ServerActionParameter paramScale = new ServerActionParameter(TifferAction.ParameterType.SCALE.toString(), (Object)this.scale);
        ServerActionParameter paramFormat = new ServerActionParameter(TifferAction.ParameterType.FORMAT.toString(), (Object)this.format);
        ServerActionParameter paramSubdir = new ServerActionParameter(TifferAction.ParameterType.SUBDIR.toString(), (Object)subdir);
        ServerActionParameter paramArt = new ServerActionParameter(TifferAction.ParameterType.BILDTYP_ID.toString(), (Object)bildtypId);
        ServerActionParameter paramJahr = new ServerActionParameter(TifferAction.ParameterType.JAHR.toString(), (Object)jahr);
        ServerActionParameter paramBlickrichtung = new ServerActionParameter(TifferAction.ParameterType.BLICKRICHTUNG.toString(), (Object)blickrichtung);
        try {
            byte[] result = (byte[])SessionManager.getProxy().executeTask("tifferAction", "WUNDA_BLAU", null, this.getConnectionContext(), new ServerActionParameter[]{paramNummer, paramScale, paramFormat, paramSubdir, paramArt, paramJahr, paramBlickrichtung});
            if (result != null) {
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(result));
                TifferAction.writeImage((RenderedImage)image, (String)this.format, (Object)this.fileToSaveTo);
            } else {
                log.error((Object)"Nothing returned by TifferAction. Check its log to see what went wrong.");
                this.error(new Exception("Nothing returned by TifferAction. Check its log to see what went wrong."));
            }
        }
        catch (Exception ex) {
            log.error((Object)"error during loading the high resolution picture", (Throwable)ex);
            this.error(ex);
        }
        if (this.status == Download.State.RUNNING) {
            this.status = Download.State.COMPLETED;
            this.stateChanged();
        }
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

