/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.featurerenderer.wunda_blau;

import de.cismet.cids.annotations.CidsAttribute;
import de.cismet.cids.featurerenderer.CustomCidsFeatureRenderer;
import de.cismet.tools.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Paint;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.apache.log4j.Logger;

public class LuftbildschraegaufnahmenFeatureRenderer
extends CustomCidsFeatureRenderer {
    @CidsAttribute(value="BILDNUMMER")
    public String nummer;
    ImageIcon errorimage = new ImageIcon(((Object)((Object)this)).getClass().getResource("/de/cismet/cids/tools/metaobjectrenderer/examples/error.png"));
    Properties properties = new Properties();
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private JLabel jLabel1;
    private JLabel jLabel12;
    private JProgressBar jProgressBar1;
    private JLabel lblImagePreview;

    public LuftbildschraegaufnahmenFeatureRenderer() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"LSAFEatureRenderer init()");
        }
        this.initComponents();
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(150, 150));
        try {
            this.properties.load(((Object)((Object)this)).getClass().getResourceAsStream("/renderer.properties"));
        }
        catch (Exception e) {
            this.log.warn((Object)"Fehler beim Laden der Properties", (Throwable)e);
        }
    }

    public void assign() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"ASSIGN");
            this.log.debug((Object)("Nummer=" + this.nummer));
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ImageIcon i;
                    String url = LuftbildschraegaufnahmenFeatureRenderer.this.properties.getProperty("luftbildschraegaufnahmenservicesmall");
                    if (url == null) {
                        i = new ImageIcon(new URL("http://s10220:8098/luft/tiffer?bnr=" + LuftbildschraegaufnahmenFeatureRenderer.this.nummer + "&scale=0.15&format=JPG"));
                    } else {
                        String newUrl = url.replaceAll("<cismet::nummer>", LuftbildschraegaufnahmenFeatureRenderer.this.nummer);
                        i = new ImageIcon(new URL(newUrl));
                    }
                    final ImageIcon icon = i;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LuftbildschraegaufnahmenFeatureRenderer.this.lblImagePreview.setIcon(icon);
                            LuftbildschraegaufnahmenFeatureRenderer.this.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
                            LuftbildschraegaufnahmenFeatureRenderer.this.setSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
                            LuftbildschraegaufnahmenFeatureRenderer.this.revalidate();
                        }
                    });
                }
                catch (Exception e) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LuftbildschraegaufnahmenFeatureRenderer.this.lblImagePreview.setIcon(LuftbildschraegaufnahmenFeatureRenderer.this.errorimage);
                        }
                    });
                }
            }
        });
        t.start();
    }

    public float getTransparency() {
        return 0.9f;
    }

    public Paint getFillingStyle() {
        return new Color(100, 100, 100, 50);
    }

    private void initComponents() {
        this.jProgressBar1 = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.lblImagePreview = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel1.setText("jLabel1");
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setPreferredSize(new Dimension(100, 100));
        this.setLayout(new BorderLayout());
        this.lblImagePreview.setHorizontalAlignment(0);
        this.lblImagePreview.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/de/cismet/cids/tools/metaobjectrenderer/examples/load.png")));
        this.lblImagePreview.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LuftbildschraegaufnahmenFeatureRenderer.this.lblImagePreviewMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                LuftbildschraegaufnahmenFeatureRenderer.this.lblImagePreviewMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                LuftbildschraegaufnahmenFeatureRenderer.this.lblImagePreviewMouseExited(evt);
            }
        });
        this.add(this.lblImagePreview, "Center");
        this.jLabel12.setHorizontalAlignment(0);
        this.jLabel12.setText("H\u00f6here Aufl\u00f6sung durch Mausklick.");
        this.add(this.jLabel12, "Last");
    }

    private void lblImagePreviewMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void lblImagePreviewMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void lblImagePreviewMouseClicked(MouseEvent evt) {
        try {
            String url = this.properties.getProperty("luftbildschraegaufnahmenservicefull");
            String newUrl = null;
            newUrl = url == null ? "http://s10220:8098/luft/tiffer?bnr=" + this.nummer + "&scale=1&format=JPG" : url.replaceAll("<cismet::nummer>", this.nummer);
            BrowserLauncher.openURL((String)newUrl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

