/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.featurerenderer.wunda_blau;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.featurerenderer.CustomCidsFeatureRenderer;
import de.cismet.cismap.commons.Refreshable;
import de.cismet.cismap.commons.gui.piccolo.CustomFixedWidthStroke;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.Layer;

public class ZaehlungsstandortFeatureRenderer
extends CustomCidsFeatureRenderer {
    private static final int MARK1 = 400;
    private static final int MARK2 = 700;
    private static final int MARK3 = 1000;
    private static final int MARK4 = 2000;
    private static final int MARK5 = 3000;
    private static final int MARK6 = 5000;
    private static final int MARK7 = 8000;
    private static final Logger LOG = Logger.getLogger(ZaehlungsstandortFeatureRenderer.class);
    private final ImageIcon errorimage = new ImageIcon(((Object)((Object)this)).getClass().getResource("/de/cismet/cids/tools/metaobjectrenderer/examples/error.png"));
    private DefaultCategoryDataset dataset;
    private final TreeMap<String, int[]> jahresAnzahl = new TreeMap();
    private long avgLast = 0L;
    private String lastYear = null;
    private Refreshable refresh;
    private JLabel lblChart;

    public ZaehlungsstandortFeatureRenderer() {
        this.initComponents();
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(350, 200));
    }

    public void assign() {
        this.cidsBean = this.metaObject.getBean();
        if (this.cidsBean != null) {
            List zaehlungen = this.cidsBean.getBeanCollectionProperty("zaehlungen");
            final ArrayList<Timestamp> datum = new ArrayList<Timestamp>(zaehlungen.size());
            final ArrayList<Integer> anzahl = new ArrayList<Integer>(zaehlungen.size());
            for (CidsBean zaehlung : zaehlungen) {
                datum.add((Timestamp)zaehlung.getProperty("datum"));
                anzahl.add((Integer)zaehlung.getProperty("anzahl"));
            }
            if (datum.size() > 0 && anzahl.size() > 0) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ZaehlungsstandortFeatureRenderer.this.dataset = new DefaultCategoryDataset();
                        String max = "1000";
                        for (int i = 0; i < datum.size(); ++i) {
                            try {
                                String jahr = DateFormat.getDateInstance(1, Locale.GERMANY).format((Date)datum.get(i));
                                jahr = jahr.substring(jahr.length() - 4);
                                int wert = (Integer)anzahl.get(i) * 12;
                                if (ZaehlungsstandortFeatureRenderer.this.jahresAnzahl.get(jahr) != null) {
                                    int[] tmp = (int[])ZaehlungsstandortFeatureRenderer.this.jahresAnzahl.get(jahr);
                                    tmp[0] = tmp[0] + wert;
                                    tmp[1] = tmp[1] + 1;
                                    ZaehlungsstandortFeatureRenderer.this.jahresAnzahl.put(jahr, tmp);
                                } else {
                                    int[] newArr = new int[]{wert, 1};
                                    ZaehlungsstandortFeatureRenderer.this.jahresAnzahl.put(jahr, newArr);
                                }
                                if (jahr.compareTo(max) <= 0) continue;
                                max = new String(jahr);
                                continue;
                            }
                            catch (Exception ex) {
                                LOG.error((Object)"Error beim Erstellen des FeatureRenderers", (Throwable)ex);
                            }
                        }
                        for (String key : ZaehlungsstandortFeatureRenderer.this.jahresAnzahl.keySet()) {
                            ZaehlungsstandortFeatureRenderer.this.dataset.addValue((double)Math.round(((int[])ZaehlungsstandortFeatureRenderer.this.jahresAnzahl.get(key))[0] / ((int[])ZaehlungsstandortFeatureRenderer.this.jahresAnzahl.get(key))[1]), (Comparable)((Object)"Daten"), (Comparable)((Object)key));
                        }
                        ZaehlungsstandortFeatureRenderer.this.avgLast = Math.round(((int[])ZaehlungsstandortFeatureRenderer.this.jahresAnzahl.get(max))[0] / ((int[])ZaehlungsstandortFeatureRenderer.this.jahresAnzahl.get(max))[1]);
                        ZaehlungsstandortFeatureRenderer.this.lastYear = max;
                        JFreeChart chart = ZaehlungsstandortFeatureRenderer.createChart((CategoryDataset)ZaehlungsstandortFeatureRenderer.this.dataset, ZaehlungsstandortFeatureRenderer.this.avgLast);
                        chart.setBackgroundPaint((Paint)new Color(210, 210, 210));
                        final BufferedImage icon = chart.createBufferedImage(340, 170);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ZaehlungsstandortFeatureRenderer.this.lblChart.setIcon(new ImageIcon(icon));
                                ZaehlungsstandortFeatureRenderer.this.refresh.refresh();
                            }
                        });
                    }
                });
                t.start();
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ZaehlungsstandortFeatureRenderer.this.lblChart.setIcon(ZaehlungsstandortFeatureRenderer.this.errorimage);
                    }
                });
            }
        }
    }

    public float getTransparency() {
        return 1.0f;
    }

    public Paint getFillingStyle() {
        return new Color(100, 100, 100, 50);
    }

    public Stroke getLineStyle() {
        return new CustomFixedWidthStroke(3.0f);
    }

    public Paint getLinePaint() {
        return new Color(255, 0, 0, 100);
    }

    public String getAlternativeName() {
        String s = null;
        Integer standpunkt = (Integer)this.cidsBean.getProperty("standort");
        if (standpunkt != null) {
            s = standpunkt.toString();
            switch (s.length()) {
                case 1: {
                    s = "00" + s;
                    break;
                }
                case 2: {
                    s = "0" + s;
                }
            }
        }
        if (this.lastYear != null) {
            return s + " (" + this.avgLast + "/h)";
        }
        return s + " (noch keine Z\u00e4hlung vorhanden)";
    }

    static JFreeChart createChart(CategoryDataset dataset, double average) {
        JFreeChart chart = ChartFactory.createBarChart3D(null, null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        CategoryPlot plot = chart.getCategoryPlot();
        CustomBarRenderer renderer = new CustomBarRenderer();
        plot.setRenderer((CategoryItemRenderer)renderer);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setVisible(true);
        ValueMarker marker1 = new ValueMarker(400.0, (Paint)new Color(150, 150, 150, 150), (Stroke)new BasicStroke(1.0f), (Paint)new Color(200, 200, 255), (Stroke)new BasicStroke(1.0f), 1.0f);
        ValueMarker marker2 = new ValueMarker(700.0, (Paint)new Color(150, 150, 150, 150), (Stroke)new BasicStroke(1.0f), (Paint)new Color(200, 200, 255), (Stroke)new BasicStroke(1.0f), 1.0f);
        ValueMarker marker3 = new ValueMarker(1000.0, (Paint)new Color(150, 150, 150, 150), (Stroke)new BasicStroke(1.0f), (Paint)new Color(200, 200, 255), (Stroke)new BasicStroke(1.0f), 1.0f);
        ValueMarker marker4 = new ValueMarker(2000.0, (Paint)new Color(150, 150, 150, 150), (Stroke)new BasicStroke(1.0f), (Paint)new Color(200, 200, 255), (Stroke)new BasicStroke(1.0f), 1.0f);
        ValueMarker marker5 = new ValueMarker(3000.0, (Paint)new Color(150, 150, 150, 150), (Stroke)new BasicStroke(1.0f), (Paint)new Color(200, 200, 255), (Stroke)new BasicStroke(1.0f), 1.0f);
        ValueMarker marker6 = new ValueMarker(5000.0, (Paint)new Color(150, 150, 150, 150), (Stroke)new BasicStroke(1.0f), (Paint)new Color(200, 200, 255), (Stroke)new BasicStroke(1.0f), 1.0f);
        ValueMarker marker7 = new ValueMarker(8000.0, (Paint)new Color(150, 150, 150, 150), (Stroke)new BasicStroke(1.0f), (Paint)new Color(200, 200, 255), (Stroke)new BasicStroke(1.0f), 1.0f);
        ValueMarker markerAvg = new ValueMarker(average, (Paint)new Color(100, 100, 255), (Stroke)new BasicStroke(2.5f));
        plot.addRangeMarker((Marker)marker1, Layer.BACKGROUND);
        plot.addRangeMarker((Marker)marker2, Layer.BACKGROUND);
        plot.addRangeMarker((Marker)marker3, Layer.BACKGROUND);
        plot.addRangeMarker((Marker)marker4, Layer.BACKGROUND);
        plot.addRangeMarker((Marker)marker5, Layer.BACKGROUND);
        plot.addRangeMarker((Marker)marker6, Layer.BACKGROUND);
        plot.addRangeMarker((Marker)marker7, Layer.BACKGROUND);
        plot.addRangeMarker((Marker)markerAvg, Layer.BACKGROUND);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setVisible(true);
        rangeAxis.setAutoRange(true);
        return chart;
    }

    public JComponent getInfoComponent(Refreshable refresh) {
        this.refresh = refresh;
        return super.getInfoComponent(refresh);
    }

    private void initComponents() {
        this.lblChart = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.setPreferredSize(new Dimension(350, 200));
        this.setLayout(new BorderLayout());
        this.lblChart.setHorizontalAlignment(0);
        this.lblChart.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/res/load.png")));
        this.lblChart.setPreferredSize(new Dimension(350, 200));
        this.add(this.lblChart, "Center");
    }

    static class CustomBarRenderer
    extends BarRenderer {
        CustomBarRenderer() {
        }

        public Paint getItemPaint(int row, int column) {
            CategoryDataset dataset = this.getPlot().getDataset();
            double value = dataset.getValue(row, column).doubleValue();
            if (value <= 400.0) {
                return new Color(255, 255, 200);
            }
            if (value <= 700.0) {
                return new Color(255, 255, 155);
            }
            if (value <= 1000.0) {
                return Color.yellow;
            }
            if (value <= 2000.0) {
                return new Color(255, 155, 0);
            }
            if (value <= 3000.0) {
                return new Color(255, 100, 0);
            }
            if (value <= 5000.0) {
                return new Color(255, 0, 0);
            }
            if (value <= 8000.0) {
                return new Color(150, 0, 0);
            }
            return new Color(100, 0, 0);
        }

        public Paint getItemOutlinePaint(int arg0, int arg1) {
            return Color.GRAY;
        }
    }
}

