/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.nas;

import Sirius.navigator.connection.SessionManager;
import com.vividsolutions.jts.geom.GeometryCollection;
import de.cismet.cids.custom.utils.nas.NasProduct;
import de.cismet.cids.custom.wunda_blau.search.actions.NasCsvDataQueryAction;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.gui.downloadmanager.AbstractCancellableDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.openide.util.NbBundle;

public class CSVListDownload
extends AbstractCancellableDownload
implements ConnectionContextProvider {
    private static String CSV_EXTENSION = ".csv";
    protected String filename = null;
    private NasProduct product;
    private GeometryCollection geometries;
    private String orderId;
    private String requestId;
    private final ConnectionContext connectionContext;

    public CSVListDownload(String title, String filename, String directory, String requestId, NasProduct product, GeometryCollection g, ConnectionContext connectionContext) {
        this.product = product;
        this.connectionContext = connectionContext;
        this.geometries = g;
        this.title = title;
        this.directory = directory;
        this.requestId = requestId;
        this.status = Download.State.WAITING;
        this.fileToSaveTo = requestId != null && !requestId.equals("") ? new File("" + requestId) : new File("" + System.currentTimeMillis());
        this.filename = filename;
        String extension = CSV_EXTENSION;
        if (filename != null && !filename.equals("")) {
            this.determineDestinationFile(filename, extension);
        } else {
            this.determineDestinationFile(requestId, extension);
        }
    }

    private CSVListDownload(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.fileToSaveTo = new File("" + System.currentTimeMillis());
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public boolean cancel() {
        boolean cancelled = true;
        boolean isDone = false;
        if (this.downloadFuture != null) {
            isDone = this.downloadFuture.isDone();
            cancelled = this.downloadFuture.cancel(true);
        }
        if (cancelled || isDone) {
            this.status = Download.State.ABORTED;
            this.stateChanged();
        }
        return this.downloadFuture.isCancelled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            block30: {
                if (this.status != Download.State.WAITING) {
                    return;
                }
                this.setTitleForPhase(Phase.DOWNLOAD);
                this.titleChanged();
                this.status = Download.State.RUNNING;
                this.stateChanged();
                if (!this.downloadFuture.isCancelled()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"CSV Download: sending request to server");
                    }
                } else {
                    this.doCancellationHandling(false, false);
                    return;
                }
                String content = this.sendListRequest();
                if (content == null || content.length() <= 0) {
                    log.info((Object)"NAS Download: Downloaded content seems to be empty..");
                    if (this.status == Download.State.RUNNING && !Thread.interrupted()) {
                        this.status = Download.State.COMPLETED_WITH_ERROR;
                        this.stateChanged();
                    }
                    return;
                }
                BufferedWriter out = null;
                try {
                    if (!this.downloadFuture.isCancelled()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"NAS Download: Start writing the result to file");
                        }
                        out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.fileToSaveTo)));
                        out.write(content);
                        break block30;
                    }
                    this.doCancellationHandling(false, false);
                    return;
                }
                catch (IOException ex) {
                    log.error((Object)("Couldn't write downloaded content to file '" + this.fileToSaveTo + "'."), (Throwable)ex);
                    this.error(ex);
                    return;
                }
                catch (Exception ex) {
                    log.error((Object)("Couldn't write downloaded content to file '" + this.fileToSaveTo + "'."), (Throwable)ex);
                    this.error(ex);
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception e) {
                            log.error((Object)("Couldn't write downloaded content to file '" + this.fileToSaveTo + "'."), (Throwable)e);
                            this.error(e);
                        }
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"NAS Download: done.");
            }
            if (!this.downloadFuture.isCancelled()) {
                this.setTitleForPhase(Phase.DONE);
                this.status = Download.State.COMPLETED;
                this.stateChanged();
            }
        }
        catch (Exception ex) {
            log.error((Object)("Exception during NASDownload " + this.filename), (Throwable)ex);
            this.error(ex);
        }
    }

    private void doCancellationHandling(boolean cancelServerRequest, boolean cancelPollingThread) {
        log.warn((Object)"NAS Download was interuppted");
        this.deleteFile();
    }

    private void setTitleForPhase(Phase p) {
        String appendix = "";
        if (p == Phase.REQEUST_GEN) {
            appendix = NbBundle.getMessage(CSVListDownload.class, (String)"NASDownload.requestGenTitle.text");
        } else if (p == Phase.RETRIEVAL) {
            appendix = NbBundle.getMessage(CSVListDownload.class, (String)"NASDownload.resultRetrievalTitle.text");
        } else if (p == Phase.DOWNLOAD) {
            appendix = NbBundle.getMessage(CSVListDownload.class, (String)"NASDownload.downloadTitle.text");
        }
        if (appendix != null && !appendix.equals("")) {
            this.title = this.title + "CSV - " + appendix;
        }
    }

    private String sendListRequest() {
        ServerActionParameter paramTemplate = new ServerActionParameter(NasCsvDataQueryAction.PARAMETER_TYPE.TEMPLATE.toString(), (Object)this.product);
        ServerActionParameter paramGeom = new ServerActionParameter(NasCsvDataQueryAction.PARAMETER_TYPE.GEOMETRY_COLLECTION.toString(), (Object)this.geometries);
        ServerActionParameter paramMethod = new ServerActionParameter(NasCsvDataQueryAction.PARAMETER_TYPE.METHOD.toString(), (Object)NasCsvDataQueryAction.METHOD_TYPE.CREATE);
        ServerActionParameter paramRequest = new ServerActionParameter(NasCsvDataQueryAction.PARAMETER_TYPE.AUFTRAGSNUMMER.toString(), (Object)this.requestId);
        try {
            Object answer = SessionManager.getProxy().executeTask("nasCsvDataQuery", "WUNDA_BLAU", null, this.getConnectionContext(), new ServerActionParameter[]{paramTemplate, paramGeom, paramMethod, paramRequest});
            if (answer instanceof byte[]) {
                return new String((byte[])answer, "CP1252");
            }
            return null;
        }
        catch (Exception ex) {
            log.error((Object)"error during enqueuing nas server request", (Throwable)ex);
            return null;
        }
    }

    private void deleteFile() {
        if (this.fileToSaveTo.exists() && this.fileToSaveTo.isFile()) {
            this.fileToSaveTo.delete();
        }
    }

    private static enum Phase {
        REQEUST_GEN,
        RETRIEVAL,
        DOWNLOAD,
        DONE;

    }
}

