/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.StringReader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class AlConfProperties {
    private static final transient Logger LOG = Logger.getLogger(AlConfProperties.class);
    private final String mapUrl;
    private final String rasterfariUrl;
    private final Double bufferMeter;

    private AlConfProperties(Properties properties) {
        this.mapUrl = this.readProperty(properties, "MAP_CALL_STRING", null);
        this.rasterfariUrl = this.readProperty(properties, "RASTERFARI_URL", null);
        this.bufferMeter = Double.valueOf(this.readProperty(properties, "BUFFER_METER", null));
    }

    private String readProperty(Properties properties, String property, String defaultValue) {
        String value = defaultValue;
        try {
            value = properties.getProperty(property, defaultValue);
        }
        catch (Exception ex) {
            String message = "could not read " + property + " from " + WundaBlauServerResources.AL_CONF_PROPERTIES.getValue() + ". setting to default value: " + defaultValue;
            LOG.warn((Object)message, (Throwable)ex);
        }
        return value;
    }

    public static AlConfProperties getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public String getMapUrl() {
        return this.mapUrl;
    }

    public String getRasterfariUrl() {
        return this.rasterfariUrl;
    }

    public Double getBufferMeter() {
        return this.bufferMeter;
    }

    private static final class LazyInitialiser {
        private static final AlConfProperties INSTANCE;

        private LazyInitialiser() {
        }

        static {
            AlConfProperties instance = null;
            try {
                User user = SessionManager.getSession().getUser();
                Object ret = SessionManager.getSession().getConnection().executeTask(user, "getServerResource", "WUNDA_BLAU", (Object)WundaBlauServerResources.AL_CONF_PROPERTIES.getValue(), ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STATIC, (String)AlConfProperties.class.getSimpleName()), new ServerActionParameter[0]);
                if (ret instanceof Exception) {
                    throw (Exception)ret;
                }
                Properties properties = new Properties();
                properties.load(new StringReader((String)ret));
                instance = new AlConfProperties(properties);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            INSTANCE = instance;
        }
    }
}

