/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cids.custom.objecteditors.wunda_blau.BaumParentPanel;
import de.cismet.cids.custom.wunda_blau.search.server.BaumChildLightweightSearch;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.connectioncontext.ConnectionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BaumChildrenLoader {
    private static final Logger LOG = Logger.getLogger(BaumChildrenLoader.class);
    private static final String CHILD_TOSTRING_TEMPLATE = "%s";
    private static final String TABLE_ERSATZ = "baum_ersatz";
    private static final String TABLE_FEST = "baum_festsetzung";
    private static final String TABLE_SCHADEN = "baum_schaden";
    private static final String TABLE_ORT = "baum_ortstermin";
    private static final String TABLE_MELDUNG = "baum_meldung";
    private static final String[] CHILD_TOSTRING_FIELDS = new String[]{"id"};
    private static final String FK_SCHADEN = "fk_schaden";
    private static final String FK_MELDUNG = "fk_meldung";
    private static final String FK_GEBIET = "fk_gebiet";
    public Boolean loadingCompletedWithoutError = false;
    public Map<Integer, List<CidsBean>> mapErsatz = new HashMap<Integer, List<CidsBean>>();
    public Map<Integer, List<CidsBean>> mapFest = new HashMap<Integer, List<CidsBean>>();
    public Map<Integer, List<CidsBean>> mapSchaden = new HashMap<Integer, List<CidsBean>>();
    public Map<Integer, List<CidsBean>> mapOrt = new HashMap<Integer, List<CidsBean>>();
    public Collection<Listener> listeners = new ArrayList<Listener>();
    public final Map<Integer, List<CidsBean>> mapMeldung = new HashMap<Integer, List<CidsBean>>();
    private final BaumChildLightweightSearch searchChild = new BaumChildLightweightSearch("%s", CHILD_TOSTRING_FIELDS, "baum_meldung", "fk_gebiet");
    private final BaumParentPanel parentOrganizer;

    public BaumChildrenLoader(BaumParentPanel baumOrganizer) {
        this.parentOrganizer = baumOrganizer;
    }

    public boolean loadChildrenMeldung(Integer gebietId, ConnectionContext connectionContext) throws ConnectionException {
        try {
            this.searchChild.setParentId(gebietId);
            this.searchChild.setFkField(FK_GEBIET);
            this.searchChild.setTable(TABLE_MELDUNG);
            this.searchChild.setRepresentationFields(CHILD_TOSTRING_FIELDS);
            Collection mons = SessionManager.getProxy().customServerSearch((CidsServerSearch)this.searchChild, connectionContext);
            ArrayList<CidsBean> beansMeldung = new ArrayList<CidsBean>();
            if (!mons.isEmpty()) {
                for (MetaObjectNode mon : mons) {
                    beansMeldung.add(SessionManager.getProxy().getMetaObject(mon.getObjectId(), mon.getClassId(), "WUNDA_BLAU", connectionContext).getBean());
                }
            }
            if (!this.mapMeldung.containsKey(gebietId)) {
                this.mapMeldung.put(gebietId, beansMeldung);
            }
            this.fireLoadingCompleteMeldung();
            for (CidsBean beanMeldung : beansMeldung) {
                if (!this.loadChildrenSchaden(beanMeldung.getPrimaryKeyValue(), connectionContext)) {
                    this.fireLoadingErrorSchaden(beanMeldung.getPrimaryKeyValue());
                    return false;
                }
                if (this.loadChildrenOrtstermin(beanMeldung.getPrimaryKeyValue(), connectionContext)) {
                    this.fireLoadingCompleteOrt(beanMeldung.getPrimaryKeyValue());
                    continue;
                }
                this.fireLoadingErrorOrt(beanMeldung.getPrimaryKeyValue());
                return false;
            }
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Error during loading", (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean loadChildrenForSchaden(Integer id, ConnectionContext connectionContext) throws ConnectionException {
        if (!this.loadChildrenFest(id, connectionContext)) {
            this.fireLoadingErrorFest(id);
            return false;
        }
        this.fireLoadingCompleteFest(id);
        if (!this.loadChildrenErsatz(id, connectionContext)) {
            this.fireLoadingErrorErsatz(id);
            return false;
        }
        this.fireLoadingCompleteErsatz(id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadChildrenOrtstermin(Integer id, ConnectionContext connectionContext) throws ConnectionException {
        try {
            this.searchChild.setParentId(id);
            this.searchChild.setTable(TABLE_ORT);
            this.searchChild.setFkField(FK_MELDUNG);
            Collection mons = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)this.searchChild, connectionContext);
            ArrayList<CidsBean> beansOrt = new ArrayList<CidsBean>();
            if (!mons.isEmpty()) {
                for (MetaObjectNode mon : mons) {
                    beansOrt.add(SessionManager.getProxy().getMetaObject(mon.getObjectId(), mon.getClassId(), "WUNDA_BLAU", connectionContext).getBean());
                }
                if (!this.mapOrt.containsKey(id)) {
                    this.mapOrt.put(id, beansOrt);
                }
            }
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Error during loading", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public boolean loadChildrenSchaden(Integer id, ConnectionContext connectionContext) throws ConnectionException {
        try {
            this.searchChild.setParentId(id);
            this.searchChild.setTable(TABLE_SCHADEN);
            this.searchChild.setFkField(FK_MELDUNG);
            Collection mons = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)this.searchChild, connectionContext);
            ArrayList<CidsBean> beansSchaden = new ArrayList<CidsBean>();
            if (!mons.isEmpty()) {
                for (MetaObjectNode mon : mons) {
                    beansSchaden.add(SessionManager.getProxy().getMetaObject(mon.getObjectId(), mon.getClassId(), "WUNDA_BLAU", connectionContext).getBean());
                }
                if (!this.mapSchaden.containsKey(id)) {
                    this.mapSchaden.put(id, beansSchaden);
                }
                this.fireLoadingCompleteSchaden(id);
                for (CidsBean beanSchaden : beansSchaden) {
                    if (this.loadChildrenForSchaden(beanSchaden.getPrimaryKeyValue(), connectionContext)) continue;
                    return false;
                }
            }
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Error during loading", (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean loadChildrenErsatz(Integer id, ConnectionContext connectionContext) throws ConnectionException {
        try {
            this.searchChild.setTable(TABLE_ERSATZ);
            this.searchChild.setParentId(id);
            this.searchChild.setFkField(FK_SCHADEN);
            Collection mons = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)this.searchChild, connectionContext);
            ArrayList<CidsBean> beansErsatz = new ArrayList<CidsBean>();
            if (!mons.isEmpty()) {
                for (MetaObjectNode mon : mons) {
                    beansErsatz.add(SessionManager.getProxy().getMetaObject(mon.getObjectId(), mon.getClassId(), "WUNDA_BLAU", connectionContext).getBean());
                }
                if (!this.mapErsatz.containsKey(id)) {
                    this.mapErsatz.put(id, beansErsatz);
                }
            }
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Error during loading", (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean loadChildrenFest(Integer id, ConnectionContext connectionContext) throws ConnectionException {
        try {
            this.searchChild.setParentId(id);
            this.searchChild.setTable(TABLE_FEST);
            this.searchChild.setFkField(FK_SCHADEN);
            Collection mons = SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)this.searchChild, connectionContext);
            ArrayList<CidsBean> beansFest = new ArrayList<CidsBean>();
            if (!mons.isEmpty()) {
                for (MetaObjectNode mon : mons) {
                    beansFest.add(SessionManager.getProxy().getMetaObject(mon.getObjectId(), mon.getClassId(), "WUNDA_BLAU", connectionContext).getBean());
                }
                if (!this.mapFest.containsKey(id)) {
                    this.mapFest.put(id, beansFest);
                }
            }
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Error during loading", (Throwable)ex);
            return false;
        }
        return true;
    }

    public List<CidsBean> getMapValueMeldung(Integer key) {
        return this.mapMeldung.get(key);
    }

    public List<CidsBean> getMapValueSchaden(Integer key) {
        return this.mapSchaden.get(key);
    }

    public List<CidsBean> getMapValueOrt(Integer key) {
        return this.mapOrt.get(key);
    }

    public List<CidsBean> getMapValueFest(Integer key) {
        return this.mapFest.get(key);
    }

    public List<CidsBean> getMapValueErsatz(Integer key) {
        return this.mapErsatz.get(key);
    }

    public void clearAllMaps() {
        this.mapOrt.clear();
        this.mapSchaden.clear();
        this.mapErsatz.clear();
        this.mapFest.clear();
        this.mapMeldung.clear();
    }

    public void setLoadingCompletedWithoutError(Boolean status) {
        this.loadingCompletedWithoutError = status;
        if (status.booleanValue()) {
            this.fireLoadingComplete();
        }
    }

    public boolean removeOrt(Integer idMeldung, CidsBean beanOrt) {
        return this.removeFromMap(idMeldung, beanOrt, this.mapOrt);
    }

    public boolean removeSchaden(Integer idMeldung, CidsBean beanSchaden) {
        return this.removeFromMap(idMeldung, beanSchaden, this.mapSchaden);
    }

    public boolean removeFest(Integer idSchaden, CidsBean beanFest) {
        return this.removeFromMap(idSchaden, beanFest, this.mapFest);
    }

    public boolean removeErsatz(Integer idSchaden, CidsBean beanErsatz) {
        return this.removeFromMap(idSchaden, beanErsatz, this.mapErsatz);
    }

    public boolean removeMeldung(Integer idGebiet, CidsBean beanMeldung) {
        return this.removeFromMap(idGebiet, beanMeldung, this.mapMeldung);
    }

    public void addOrt(Integer idMeldung, CidsBean beanOrt) {
        this.addToMap(idMeldung, beanOrt, this.mapOrt);
    }

    public void addSchaden(Integer idMeldung, CidsBean beanSchaden) {
        this.addToMap(idMeldung, beanSchaden, this.mapSchaden);
    }

    public void addMeldung(Integer idMeldung, CidsBean beanMeldung) {
        this.addToMap(idMeldung, beanMeldung, this.mapMeldung);
    }

    public void addErsatz(Integer idSchaden, CidsBean beanErsatz) {
        this.addToMap(idSchaden, beanErsatz, this.mapErsatz);
    }

    public void addFest(Integer idSchaden, CidsBean beanFest) {
        this.addToMap(idSchaden, beanFest, this.mapFest);
    }

    public boolean removeFromMap(Integer id, CidsBean bean, Map<Integer, List<CidsBean>> map) {
        return map.get(id).remove(bean);
    }

    public void addToMap(Integer id, CidsBean bean, Map<Integer, List<CidsBean>> map) {
        List<Object> tempList = new ArrayList<CidsBean>();
        if (map.get(id) != null) {
            tempList = map.get(id);
            tempList.add(bean);
            map.replace(id, tempList);
        } else {
            tempList.add(bean);
            map.put(id, tempList);
        }
    }

    public boolean addListener(Listener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(Listener listener) {
        return this.listeners.remove(listener);
    }

    private void fireLoadingComplete() {
        for (Listener listener : this.listeners) {
            listener.loadingComplete();
        }
    }

    private void fireLoadingCompleteMeldung() {
        for (Listener listener : this.listeners) {
            listener.loadingCompleteMeldung();
        }
    }

    private void fireLoadingCompleteOrt(Integer primaryKeyValue) {
        for (Listener listener : this.listeners) {
            listener.loadingCompleteOrt(primaryKeyValue);
        }
    }

    private void fireLoadingErrorOrt(Integer primaryKeyValue) {
        for (Listener listener : this.listeners) {
            listener.loadingErrorOrt(primaryKeyValue);
        }
    }

    private void fireLoadingCompleteSchaden(Integer primaryKeyValue) {
        for (Listener listener : this.listeners) {
            listener.loadingCompleteSchaden(primaryKeyValue);
        }
    }

    private void fireLoadingErrorSchaden(Integer primaryKeyValue) {
        for (Listener listener : this.listeners) {
            listener.loadingErrorSchaden(primaryKeyValue);
        }
    }

    private void fireLoadingCompleteErsatz(Integer primaryKeyValue) {
        for (Listener listener : this.listeners) {
            listener.loadingCompleteErsatz(primaryKeyValue);
        }
    }

    private void fireLoadingErrorErsatz(Integer primaryKeyValue) {
        for (Listener listener : this.listeners) {
            listener.loadingErrorErsatz(primaryKeyValue);
        }
    }

    private void fireLoadingCompleteFest(Integer primaryKeyValue) {
        for (Listener listener : this.listeners) {
            listener.loadingCompleteFest(primaryKeyValue);
        }
    }

    private void fireLoadingErrorFest(Integer primaryKeyValue) {
        for (Listener listener : this.listeners) {
            listener.loadingErrorFest(primaryKeyValue);
        }
    }

    public Boolean getLoadingCompletedWithoutError() {
        return this.loadingCompletedWithoutError;
    }

    public Map<Integer, List<CidsBean>> getMapErsatz() {
        return this.mapErsatz;
    }

    public Map<Integer, List<CidsBean>> getMapFest() {
        return this.mapFest;
    }

    public Map<Integer, List<CidsBean>> getMapSchaden() {
        return this.mapSchaden;
    }

    public Map<Integer, List<CidsBean>> getMapOrt() {
        return this.mapOrt;
    }

    public Map<Integer, List<CidsBean>> getMapMeldung() {
        return this.mapMeldung;
    }

    public BaumParentPanel getParentOrganizer() {
        return this.parentOrganizer;
    }

    public static interface Listener {
        public void loadingComplete();

        public void loadingCompleteMeldung();

        public void loadingCompleteSchaden(Integer var1);

        public void loadingCompleteOrt(Integer var1);

        public void loadingCompleteFest(Integer var1);

        public void loadingCompleteErsatz(Integer var1);

        public void loadingErrorSchaden(Integer var1);

        public void loadingErrorFest(Integer var1);

        public void loadingErrorErsatz(Integer var1);

        public void loadingErrorOrt(Integer var1);
    }
}

