/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import de.cismet.cids.custom.objecteditors.utils.NumberConverter;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.Converter;

public class IntegerNumberConverter
extends Converter<Integer, String> {
    private static final transient Logger LOG = Logger.getLogger(NumberConverter.class);
    private static final IntegerNumberConverter INSTANCE = new IntegerNumberConverter();

    public static IntegerNumberConverter getInstance() {
        return INSTANCE;
    }

    public String convertForward(Integer value) {
        return value.toString();
    }

    public Integer convertReverse(String value) {
        try {
            if (value == null) {
                return null;
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("No valid integer number: " + value), (Throwable)e);
            return null;
        }
    }
}

