/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.StringReader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class KlimarouteConfProperties {
    private static final transient Logger LOG = Logger.getLogger(KlimarouteConfProperties.class);
    private final Double bufferMeter;
    private final String mapUrl;
    private final String keyPattern;
    private final Integer keyLength;

    private KlimarouteConfProperties(Properties properties) {
        this.bufferMeter = Double.valueOf(this.readProperty(properties, "BUFFER_METER", null));
        this.mapUrl = String.valueOf(this.readProperty(properties, "URL_LAGE", null));
        this.keyPattern = String.valueOf(this.readProperty(properties, "KEY_PATTERN", null));
        this.keyLength = Integer.valueOf(this.readProperty(properties, "KEY_LENGTH", null));
    }

    private String readProperty(Properties properties, String property, String defaultValue) {
        String value = defaultValue;
        try {
            value = properties.getProperty(property, defaultValue);
        }
        catch (Exception ex) {
            String message = "could not read " + property + " from " + WundaBlauServerResources.KLIMAROUTE_CONF_PROPERTIES.getValue() + ". setting to default value: " + defaultValue;
            LOG.warn((Object)message, (Throwable)ex);
        }
        return value;
    }

    public static KlimarouteConfProperties getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public Double getBufferMeter() {
        return this.bufferMeter;
    }

    public String getMapUrl() {
        return this.mapUrl;
    }

    public String getKeyPattern() {
        return this.keyPattern;
    }

    public Integer getKeyLength() {
        return this.keyLength;
    }

    private static final class LazyInitialiser {
        private static final KlimarouteConfProperties INSTANCE;

        private LazyInitialiser() {
        }

        static {
            KlimarouteConfProperties instance = null;
            try {
                User user = SessionManager.getSession().getUser();
                Object ret = SessionManager.getSession().getConnection().executeTask(user, "getServerResource", "WUNDA_BLAU", (Object)WundaBlauServerResources.KLIMAROUTE_CONF_PROPERTIES.getValue(), ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STATIC, (String)KlimarouteConfProperties.class.getSimpleName()), new ServerActionParameter[0]);
                if (ret instanceof Exception) {
                    throw (Exception)ret;
                }
                Properties properties = new Properties();
                properties.load(new StringReader((String)ret));
                instance = new KlimarouteConfProperties(properties);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            INSTANCE = instance;
        }
    }
}

