/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.StringReader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class SpstConfProperties {
    private static final transient Logger LOG = Logger.getLogger(SpstConfProperties.class);
    private final String urlKarte;
    private final Double bufferHnr;
    private final Double bufferStr;

    private SpstConfProperties(Properties properties) {
        this.urlKarte = this.readProperty(properties, "MAP_CALL_STRING", null);
        this.bufferHnr = Double.valueOf(this.readProperty(properties, "BUFFER_HNR", null));
        this.bufferStr = Double.valueOf(this.readProperty(properties, "BUFFER_STR", null));
    }

    private String readProperty(Properties properties, String property, String defaultValue) {
        String value = defaultValue;
        try {
            value = properties.getProperty(property, defaultValue);
        }
        catch (Exception ex) {
            String message = "could not read " + property + " from " + WundaBlauServerResources.SPST_CONF_PROPERTIES.getValue() + ". setting to default value: " + defaultValue;
            LOG.warn((Object)message, (Throwable)ex);
        }
        return value;
    }

    public static SpstConfProperties getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public String getUrlKarte() {
        return this.urlKarte;
    }

    public Double getBufferHnr() {
        return this.bufferHnr;
    }

    public Double getBufferStr() {
        return this.bufferStr;
    }

    private static final class LazyInitialiser {
        private static final SpstConfProperties INSTANCE;

        private LazyInitialiser() {
        }

        static {
            SpstConfProperties instance = null;
            try {
                User user = SessionManager.getSession().getUser();
                Object ret = SessionManager.getSession().getConnection().executeTask(user, "getServerResource", "WUNDA_BLAU", (Object)WundaBlauServerResources.SPST_CONF_PROPERTIES.getValue(), ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STATIC, (String)SpstConfProperties.class.getSimpleName()), new ServerActionParameter[0]);
                if (ret instanceof Exception) {
                    throw (Exception)ret;
                }
                Properties properties = new Properties();
                properties.load(new StringReader((String)ret));
                instance = new SpstConfProperties(properties);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            INSTANCE = instance;
        }
    }
}

