/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.utils.WundaBlauServerResources;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import java.io.StringReader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class UaConfProperties {
    private static final transient Logger LOG = Logger.getLogger(UaConfProperties.class);
    private final Double bufferMeter;
    private final String url;
    private final String urlRasterfari;
    private final String filesDokumente;
    private final String filesFotos;
    private final String kompFotos;
    private final String showFotos;
    private final Integer fileLimit;
    private final Integer fileLimitDok;
    private final String ordnerThema;

    private UaConfProperties(Properties properties) {
        this.bufferMeter = Double.valueOf(this.readProperty(properties, "BUFFER_METER", null));
        this.url = String.valueOf(this.readProperty(properties, "MAP_CALL_STRING", null));
        this.urlRasterfari = String.valueOf(this.readProperty(properties, "RASTERFARI_URL", null));
        this.filesDokumente = String.valueOf(this.readProperty(properties, "FILES_DOKUMENTE", null));
        this.filesFotos = String.valueOf(this.readProperty(properties, "FILES_FOTOS", null));
        this.ordnerThema = String.valueOf(this.readProperty(properties, "ORDNER_THEMA", null));
        this.kompFotos = String.valueOf(this.readProperty(properties, "KOMP_FOTOS", null));
        this.showFotos = String.valueOf(this.readProperty(properties, "SHOW_FOTOS", null));
        this.fileLimit = Integer.valueOf(this.readProperty(properties, "FILE_LIMIT", null));
        this.fileLimitDok = Integer.valueOf(this.readProperty(properties, "FILE_LIMIT_DOK", null));
    }

    private String readProperty(Properties properties, String property, String defaultValue) {
        String value = defaultValue;
        try {
            value = properties.getProperty(property, defaultValue);
        }
        catch (Exception ex) {
            String message = "could not read " + property + " from " + WundaBlauServerResources.UA_CONF_PROPERTIES.getValue() + ". setting to default value: " + defaultValue;
            LOG.warn((Object)message, (Throwable)ex);
        }
        return value;
    }

    public static UaConfProperties getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public Double getBufferMeter() {
        return this.bufferMeter;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUrlRasterfari() {
        return this.urlRasterfari;
    }

    public String getFilesDokumente() {
        return this.filesDokumente;
    }

    public String getFilesFotos() {
        return this.filesFotos;
    }

    public String getKompFotos() {
        return this.kompFotos;
    }

    public String getShowFotos() {
        return this.showFotos;
    }

    public Integer getFileLimit() {
        return this.fileLimit;
    }

    public Integer getFileLimitDok() {
        return this.fileLimitDok;
    }

    public String getOrdnerThema() {
        return this.ordnerThema;
    }

    private static final class LazyInitialiser {
        private static final UaConfProperties INSTANCE;

        private LazyInitialiser() {
        }

        static {
            UaConfProperties instance = null;
            try {
                User user = SessionManager.getSession().getUser();
                Object ret = SessionManager.getSession().getConnection().executeTask(user, "getServerResource", "WUNDA_BLAU", (Object)WundaBlauServerResources.UA_CONF_PROPERTIES.getValue(), ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STATIC, (String)UaConfProperties.class.getSimpleName()), new ServerActionParameter[0]);
                if (ret instanceof Exception) {
                    throw (Exception)ret;
                }
                Properties properties = new Properties();
                properties.load(new StringReader((String)ret));
                instance = new UaConfProperties(properties);
            }
            catch (Exception ex) {
                LOG.error((Object)"Fehler beim Laden der Properties f\u00fcr Ua-Client", (Throwable)ex);
            }
            INSTANCE = instance;
        }
    }
}

