/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.utils;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.connectioncontext.ConnectionContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class VermessungRissUtils {
    private static final Logger LOG = Logger.getLogger(VermessungRissUtils.class);

    public static void setFluerstueckKickerInVermessung(CidsBean vermessung, ConnectionContext connectionContext) throws ConnectionException, Exception {
        Object tmp = vermessung.getProperty("tmp_lp_orig");
        if (tmp instanceof CidsBean) {
            MetaObject[] kickers;
            String gemarkung = null;
            String flur = null;
            String zaehler = null;
            String nenner = null;
            CidsBean tmpbean = (CidsBean)tmp;
            CidsBean kicker = null;
            if (tmpbean.getMetaObject().getMetaClass().getTableName().equalsIgnoreCase("flurstueck")) {
                gemarkung = String.valueOf(tmpbean.getProperty("gemarkungs_nr.gemarkungsnummer"));
                flur = String.valueOf(tmpbean.getProperty("flur"));
                zaehler = String.valueOf(tmpbean.getProperty("fstnr_z"));
                nenner = String.valueOf(tmpbean.getProperty("fstnr_n"));
                if (nenner == null) {
                    zaehler = "0";
                }
            } else if (tmpbean.getMetaObject().getMetaClass().getTableName().equalsIgnoreCase("ALKIS_landparcel")) {
                gemarkung = ((String)tmpbean.getProperty("alkis_id")).substring(2, 6);
                flur = (String)tmpbean.getProperty("flur");
                zaehler = new Integer((String)tmpbean.getProperty("fstck_zaehler")).toString();
                nenner = (String)tmpbean.getProperty("fstck_nenner");
                nenner = nenner == null ? "0" : new Integer(nenner).toString();
            }
            MetaClass kickerClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"vermessung_flurstueck_kicker", (ConnectionContext)connectionContext);
            StringBuffer kickerQuery = new StringBuffer("select ").append(kickerClass.getId()).append(", ").append(kickerClass.getPrimaryKey()).append(" from ").append(kickerClass.getTableName()).append(" where gemarkung=").append(gemarkung).append(" and flur='").append(flur).append("'").append(" and zaehler='").append(zaehler).append("'").append(" and nenner='").append(nenner).append("'");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("SQL: kickerQuery:" + kickerQuery.toString()));
            }
            if ((kickers = SessionManager.getProxy().getMetaObjectByQuery(kickerQuery.toString(), 0, connectionContext)).length > 0) {
                kicker = kickers[0].getBean();
            }
            if (kicker == null) {
                MetaObject[] matchedLandparcels;
                kicker = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)"vermessung_flurstueck_kicker", (ConnectionContext)connectionContext);
                MetaClass vermessungGemarkungClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"vermessung_gemarkung", (ConnectionContext)connectionContext);
                MetaObject gemarkungObject = SessionManager.getProxy().getMetaObject(new Integer(gemarkung).intValue(), vermessungGemarkungClass.getId(), "WUNDA_BLAU", connectionContext);
                CidsBean vGemarkungBean = gemarkungObject.getBean();
                kicker.setProperty("gemarkung", (Object)vGemarkungBean);
                kicker.setProperty("flur", (Object)StringUtils.leftPad((String)flur, (int)3, (String)"0"));
                kicker.setProperty("zaehler", (Object)zaehler);
                kicker.setProperty("nenner", (Object)nenner);
                MetaClass flurstueckClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"flurstueck", (ConnectionContext)connectionContext);
                StringBuffer fQuery = new StringBuffer("select ").append(flurstueckClass.getId()).append(", ").append(flurstueckClass.getPrimaryKey()).append(" from ").append(flurstueckClass.getTableName()).append(" where gemarkungs_nr=").append(gemarkung).append(" and flur='").append(flur).append("'").append(" and fstnr_z='").append(zaehler).append("'").append(" and fstnr_n='").append(nenner).append("'");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SQL: flurstueckQuery:" + fQuery.toString()));
                }
                if ((matchedLandparcels = SessionManager.getProxy().getMetaObjectByQuery(fQuery.toString(), 0, connectionContext)).length > 0) {
                    kicker.setProperty("flurstueck", (Object)matchedLandparcels[0].getBean());
                }
            }
            vermessung.setProperty("flurstueck", (Object)kicker);
            vermessung.setProperty("tmp_lp_orig", null);
        }
    }
}

