/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.ui.RequestsFullSizeComponent;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.annotations.AggregationRenderer;
import de.cismet.cids.custom.objecteditors.wunda_blau.Alb_Constraints;
import de.cismet.cids.custom.objecteditors.wunda_blau.Alb_baulastEditorPanel;
import de.cismet.cids.custom.objecteditors.wunda_blau.Alb_picturePanel;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.editors.converters.SqlDateToUtilDateConverter;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.tools.gui.BorderProvider;
import de.cismet.tools.gui.FooterComponentProvider;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.TitleComponentProvider;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Date;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

@AggregationRenderer
public class Alb_baulastEditor
extends JPanel
implements DisposableCidsBeanStore,
TitleComponentProvider,
FooterComponentProvider,
BorderProvider,
RequestsFullSizeComponent,
EditorSaveListener,
ConnectionContextStore {
    private static final Logger LOG = Logger.getLogger(Alb_baulastEditor.class);
    public static final String TITLE_AGR_PREFIX = "Baulasten";
    private static final String ACTION_TAG = "custom.baulast.document@WUNDA_BLAU";
    private static final Converter<Date, String> DATE_TO_STRING = new Converter<Date, String>(){

        public String convertForward(Date value) {
            if (value != null) {
                return DateFormat.getDateInstance().format(value);
            }
            return "";
        }

        public Date convertReverse(String value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };
    private final boolean editable;
    private CidsBean cidsBean;
    private CardLayout cardLayout;
    private ConnectionContext connectionContext = ConnectionContext.createDummy();
    private Alb_picturePanel alb_picturePanel;
    private JButton btnBack;
    private JButton btnForward;
    private Box.Filler filler1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JLabel lblBack;
    private JLabel lblBearbeiter;
    private JLabel lblBearbeitetAm;
    private JLabel lblDurch;
    private JLabel lblForw;
    private JLabel lblLetzteBearbeitung;
    private JLabel lblTitle;
    private JPanel panButtons;
    private JPanel panFooter;
    private JPanel panFooterLeft;
    private JPanel panFooterRight;
    private Alb_baulastEditorPanel panMain;
    private JPanel panTitle;
    private SqlDateToUtilDateConverter sqlDateToUtilDateConverter;
    private BindingGroup bindingGroup;

    public Alb_baulastEditor() {
        this(true);
    }

    public Alb_baulastEditor(boolean editable) {
        this.editable = editable;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.alb_picturePanel = new Alb_picturePanel(!this.editable, false, this.getConnectionContext());
        this.alb_picturePanel.getDocTypePanel().setVisible(false);
        this.initComponents();
        this.initFooterElements();
        this.cardLayout = (CardLayout)this.getLayout();
        this.lblBearbeiter.setVisible(this.editable);
        this.lblLetzteBearbeitung.setVisible(this.editable);
        this.lblDurch.setVisible(this.editable);
        this.lblBearbeitetAm.setVisible(this.editable);
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public static void addPruefungsInfoToBean(CidsBean cidsBean) {
        try {
            Object geprueftObj;
            if (cidsBean != null && cidsBean.getMetaObject().getStatus() == 2 && ((geprueftObj = cidsBean.getProperty("geprueft")) == null || geprueftObj instanceof Boolean && !((Boolean)geprueftObj).booleanValue())) {
                cidsBean.setProperty("bearbeitet_von", (Object)SessionManager.getSession().getUser().getName());
                cidsBean.setProperty("bearbeitungsdatum", (Object)new Date(System.currentTimeMillis()));
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Can not set Pruefunfsinfo for Bean!", (Throwable)ex);
        }
    }

    private void initFooterElements() {
        ObjectRendererUtils.decorateJLabelAndButtonSynced(this.lblForw, this.btnForward, ObjectRendererUtils.FORWARD_SELECTED, ObjectRendererUtils.FORWARD_PRESSED);
        ObjectRendererUtils.decorateJLabelAndButtonSynced(this.lblBack, this.btnBack, ObjectRendererUtils.BACKWARD_SELECTED, ObjectRendererUtils.BACKWARD_PRESSED);
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setAllSelectedMetaObjects(Collection<MetaObject> selection) {
        this.panMain.setAllSelectedMetaObjects(selection);
    }

    public void setCidsBean(CidsBean cidsBean) {
        if (cidsBean != null) {
            this.bindingGroup.unbind();
            this.cidsBean = cidsBean;
            this.disableSecondPageIfNoPermission();
            this.panMain.setCidsBean(cidsBean);
            this.alb_picturePanel.setCidsBean(cidsBean);
            Object laufendeNr = cidsBean.getProperty("laufende_nummer");
            Object blattNummer = cidsBean.getProperty("blattnummer");
            this.lblTitle.setText("Baulastblatt " + blattNummer + ": lfd. Nummer " + laufendeNr);
            this.bindingGroup.bind();
        }
    }

    private void disableSecondPageIfNoPermission() {
        if (!ObjectRendererUtils.checkActionTag(ACTION_TAG, this.getConnectionContext())) {
            for (MouseListener l : this.lblForw.getMouseListeners()) {
                this.lblForw.removeMouseListener(l);
            }
            this.lblForw.setEnabled(false);
            this.btnForward.setEnabled(false);
            for (MouseListener l : this.lblBack.getMouseListeners()) {
                this.lblBack.removeMouseListener(l);
            }
            this.lblBack.setEnabled(false);
            this.btnBack.setEnabled(false);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panTitle = new JPanel();
        this.lblTitle = new JLabel();
        this.sqlDateToUtilDateConverter = new SqlDateToUtilDateConverter();
        this.panFooter = new JPanel();
        this.panButtons = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.filler1 = new Box.Filler(new Dimension(20, 0), new Dimension(20, 0), new Dimension(20, Short.MAX_VALUE));
        this.lblLetzteBearbeitung = new JLabel();
        this.lblBearbeiter = new JLabel();
        this.lblDurch = new JLabel();
        this.lblBearbeitetAm = new JLabel();
        this.panFooterLeft = new JPanel();
        this.lblBack = new JLabel();
        this.btnBack = new JButton();
        this.jPanel3 = new JPanel();
        this.panFooterRight = new JPanel();
        this.btnForward = new JButton();
        this.lblForw = new JLabel();
        this.jPanel5 = new JPanel();
        this.jPanel4 = this.alb_picturePanel.getDocTypePanel();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.panMain = new Alb_baulastEditorPanel(this.editable, this.getConnectionContext());
        this.alb_picturePanel = this.alb_picturePanel;
        this.panTitle.setOpaque(false);
        this.panTitle.setLayout(new GridBagLayout());
        this.lblTitle.setFont(new Font("Tahoma", 1, 14));
        this.lblTitle.setForeground(new Color(255, 255, 255));
        this.lblTitle.setText("Baulast");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panTitle.add((Component)this.lblTitle, gridBagConstraints);
        this.panFooter.setOpaque(false);
        this.panFooter.setLayout(new BorderLayout());
        this.panButtons.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        this.panButtons.setOpaque(false);
        this.panButtons.setLayout(new GridLayout(1, 0));
        this.jPanel1.setOpaque(false);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel2.setOpaque(false);
        this.jPanel2.add(this.filler1);
        this.lblLetzteBearbeitung.setForeground(new Color(204, 204, 204));
        this.lblLetzteBearbeitung.setText("Letzte Bearbeitung am");
        this.jPanel2.add(this.lblLetzteBearbeitung);
        this.lblBearbeiter.setForeground(new Color(204, 204, 204));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.bearbeitungsdatum}"), (Object)this.lblBearbeiter, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"(unbekannt)");
        binding.setSourceUnreadableValue((Object)"(unbekannt)");
        binding.setConverter(DATE_TO_STRING);
        this.bindingGroup.addBinding((Binding)binding);
        this.jPanel2.add(this.lblBearbeiter);
        this.lblDurch.setForeground(new Color(204, 204, 204));
        this.lblDurch.setText("durch");
        this.jPanel2.add(this.lblDurch);
        this.lblBearbeitetAm.setForeground(new Color(204, 204, 204));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.bearbeitet_von}"), (Object)this.lblBearbeitetAm, (Property)BeanProperty.create((String)"text"));
        binding.setSourceNullValue((Object)"(unbekannt)");
        binding.setSourceUnreadableValue((Object)"(unbekannt)");
        this.bindingGroup.addBinding((Binding)binding);
        this.jPanel2.add(this.lblBearbeitetAm);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.01;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.panFooterLeft.setMaximumSize(new Dimension(124, 40));
        this.panFooterLeft.setMinimumSize(new Dimension(124, 40));
        this.panFooterLeft.setOpaque(false);
        this.panFooterLeft.setPreferredSize(new Dimension(124, 40));
        this.panFooterLeft.setLayout(new FlowLayout(2, 10, 5));
        this.lblBack.setFont(new Font("Tahoma", 1, 14));
        this.lblBack.setForeground(new Color(255, 255, 255));
        this.lblBack.setText("Info");
        this.lblBack.setEnabled(false);
        this.lblBack.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Alb_baulastEditor.this.lblBackMouseClicked(evt);
            }
        });
        this.panFooterLeft.add(this.lblBack);
        this.btnBack.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-left.png")));
        this.btnBack.setBorder(null);
        this.btnBack.setBorderPainted(false);
        this.btnBack.setContentAreaFilled(false);
        this.btnBack.setEnabled(false);
        this.btnBack.setFocusPainted(false);
        this.btnBack.setMaximumSize(new Dimension(30, 30));
        this.btnBack.setMinimumSize(new Dimension(30, 30));
        this.btnBack.setPreferredSize(new Dimension(30, 30));
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_baulastEditor.this.btnBackActionPerformed(evt);
            }
        });
        this.panFooterLeft.add(this.btnBack);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        this.jPanel1.add((Component)this.panFooterLeft, gridBagConstraints);
        this.panButtons.add(this.jPanel1);
        this.jPanel3.setOpaque(false);
        this.jPanel3.setLayout(new GridBagLayout());
        this.panFooterRight.setMaximumSize(new Dimension(124, 40));
        this.panFooterRight.setOpaque(false);
        this.panFooterRight.setLayout(new FlowLayout(0, 10, 5));
        this.btnForward.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/wunda_blau/res/arrow-right.png")));
        this.btnForward.setBorder(null);
        this.btnForward.setBorderPainted(false);
        this.btnForward.setContentAreaFilled(false);
        this.btnForward.setFocusPainted(false);
        this.btnForward.setMaximumSize(new Dimension(30, 30));
        this.btnForward.setMinimumSize(new Dimension(30, 30));
        this.btnForward.setPreferredSize(new Dimension(30, 30));
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Alb_baulastEditor.this.btnForwardActionPerformed(evt);
            }
        });
        this.panFooterRight.add(this.btnForward);
        this.lblForw.setFont(new Font("Tahoma", 1, 14));
        this.lblForw.setForeground(new Color(255, 255, 255));
        this.lblForw.setText("Dokumente");
        this.lblForw.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                Alb_baulastEditor.this.lblForwMouseClicked(evt);
            }
        });
        this.panFooterRight.add(this.lblForw);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.panFooterRight, gridBagConstraints);
        this.jPanel5.setOpaque(false);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jPanel4.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel7.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jPanel7, gridBagConstraints);
        this.panButtons.add(this.jPanel3);
        this.panFooter.add((Component)this.panButtons, "Center");
        this.setOpaque(false);
        this.setLayout(new CardLayout());
        this.panMain.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)this.panMain, "card1");
        this.add((Component)this.alb_picturePanel, "card2");
        this.bindingGroup.bind();
    }

    private void lblBackMouseClicked(MouseEvent evt) {
        this.btnBackActionPerformed(null);
    }

    private void btnBackActionPerformed(ActionEvent evt) {
        this.cardLayout.show(this, "card1");
        this.alb_picturePanel.getDocTypePanel().setVisible(false);
        this.btnBack.setEnabled(false);
        this.btnForward.setEnabled(true);
        this.lblBack.setEnabled(false);
        this.lblForw.setEnabled(true);
    }

    private void btnForwardActionPerformed(ActionEvent evt) {
        this.cardLayout.show(this, "card2");
        this.alb_picturePanel.getDocTypePanel().setVisible(true);
        this.btnBack.setEnabled(true);
        this.btnForward.setEnabled(false);
        this.lblBack.setEnabled(true);
        this.lblForw.setEnabled(false);
        this.alb_picturePanel.updateIfPicturePathsChanged();
        String fileCollisionWarning = this.alb_picturePanel.getCollisionWarning();
        if (fileCollisionWarning.length() > 0) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), fileCollisionWarning, "Unterschiedliche Dateiformate", 2);
        }
        this.alb_picturePanel.clearCollisionWarning();
    }

    private void lblForwMouseClicked(MouseEvent evt) {
        this.btnForwardActionPerformed(null);
    }

    public JComponent getTitleComponent() {
        return this.panTitle;
    }

    public JComponent getFooterComponent() {
        return this.panFooter;
    }

    public Border getTitleBorder() {
        return new EmptyBorder(10, 10, 10, 10);
    }

    public Border getFooterBorder() {
        return new EmptyBorder(5, 5, 5, 5);
    }

    public Border getCenterrBorder() {
        return new EmptyBorder(0, 5, 0, 5);
    }

    public void dispose() {
        this.bindingGroup.unbind();
        this.panMain.dispose();
        this.alb_picturePanel.dispose();
    }

    public void editorClosed(EditorClosedEvent event) {
    }

    public boolean prepareForSave() {
        try {
            List baulastArt;
            ArrayList<String> errors = new ArrayList<String>();
            Object laufendeNrObj = this.cidsBean.getProperty("laufende_nummer");
            Object blattNrObj = this.cidsBean.getProperty("blattnummer");
            boolean unique = Alb_Constraints.checkUniqueBaulastNummer(String.valueOf(blattNrObj), String.valueOf(laufendeNrObj), this.cidsBean.getMetaObject().getID(), this.getConnectionContext());
            if (!unique) {
                errors.add("Die Laufende Nummer " + laufendeNrObj + " existiert bereits unter Baulastblatt " + blattNrObj + "! Bitte geben Sie eine andere Nummer ein.");
            }
            if (!Alb_Constraints.checkBaulastHasBelastetesFlurstueck(this.cidsBean)) {
                errors.add("Der Baulast ist noch kein belastetes Flurst\u00fcck zugeordnet!\nBitte ordnen Sie mind. ein belastetes Flurst\u00fcck zu, erst dann kann der Datensatz gespeichert werden.");
            }
            if (!Alb_Constraints.checkEintragungsdatum(this.cidsBean)) {
                errors.add("Die Baulast muss ein Eintragungsdatum haben.");
            }
            if (!Alb_Constraints.checkBaulastDates(this.cidsBean)) {
                errors.add("Sie haben unplausible Datumsangaben vorgenommen (Eingabedatum fehlt oder liegt nach dem L\u00f6sch- Schlie\u00df oder Befristungsdatum).\nBitte korrigieren Sie die fehlerhaften Datumsangaben, erst dann kann der Datensatz gespeichert werden.");
            }
            if ((baulastArt = (List)this.cidsBean.getProperty("art")) == null || baulastArt.isEmpty()) {
                errors.add("Die Baulast muss mindestens eine Baulastart haben");
            }
            if (errors.size() > 0) {
                String errorOutput = "";
                for (String s : errors) {
                    errorOutput = errorOutput + s + "\n";
                }
                errorOutput = errorOutput.substring(0, errorOutput.length() - 1);
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), errorOutput, "Fehler aufgetreten", 2);
                return false;
            }
            Alb_baulastEditor.addPruefungsInfoToBean(this.cidsBean);
            return true;
        }
        catch (Exception ex) {
            ObjectRendererUtils.showExceptionWindowToUser("Fehler beim Speichern", ex, this);
            throw new RuntimeException(ex);
        }
    }
}

