/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.ui.RequestsFullSizeComponent;
import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.client.tools.DevelopmentTools;
import de.cismet.cids.custom.objecteditors.utils.BparkConfProperties;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.objectrenderer.utils.DefaultPreviewMapPanel;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.DefaultBindableScrollableComboBox;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.SaveVetoable;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.cismap.cids.geometryeditor.DefaultCismapGeometryComboBoxEditor;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.MissingResourceException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class BparkCityausweisEditor
extends DefaultCustomObjectEditor
implements CidsBeanRenderer,
SaveVetoable,
RequestsFullSizeComponent,
PropertyChangeListener {
    private static final MetaClass MC__CITY;
    private static String MAPURL;
    private static Double BUFFER;
    private static final Logger LOG;
    public static final String FIELD__ID = "id";
    public static final String FIELD__CITY = "fk_cityausweisbereich";
    public static final String FIELD__PUBLISH = "veroeffentlicht";
    public static final String FIELD__GEOM = "fk_geom";
    public static final String FIELD__GEO_FIELD = "geo_field";
    public static final String FIELD__GEOREFERENZ__GEO_FIELD = "fk_geom.geo_field";
    public static final String TABLE_NAME = "bpark_cityausweis";
    public static final String TABLE_GEOM = "geom";
    public static final String BUNDLE_NOCITY = "BparkCityausweisEditor.isOkForSaving().noCity";
    public static final String BUNDLE_NOGEOM = "BparkCityausweisEditor.isOkForSaving().noGeom";
    public static final String BUNDLE_PANE_PREFIX = "BparkCityausweisEditor.isOkForSaving().JOptionPane.message.prefix";
    public static final String BUNDLE_PANE_SUFFIX = "BparkCityausweisEditor.isOkForSaving().JOptionPane.message.suffix";
    public static final String BUNDLE_PANE_TITLE = "BparkCityausweisEditor.isOkForSaving().JOptionPane.title";
    private static final String TITLE_NEW_ZONE = "eine neue City-Parkfl\u00e4che anlegen...";
    private final boolean editor;
    private JComboBox<String> cbCity;
    private JComboBox cbGeom;
    private JCheckBox chkVeroeffentlicht;
    private JLabel lblBemerkung;
    private JLabel lblCity;
    private JLabel lblGeom;
    private JLabel lblHinweis;
    private JLabel lblKarte;
    private JLabel lblVeroeffentlicht;
    private JPanel panBemerkung;
    private JPanel panContent;
    private JPanel panDaten;
    private JPanel panHinweis;
    private JPanel panLage;
    private DefaultPreviewMapPanel panPreviewMap;
    private RoundedPanel rpKarte;
    private JScrollPane scpBemerkung;
    private JScrollPane scpHinweis;
    private SemiRoundedPanel semiRoundedPanel7;
    private JTextArea taBemerkung;
    private JTextArea taHinweis;
    private BindingGroup bindingGroup;

    public BparkCityausweisEditor() {
        this(true);
    }

    public BparkCityausweisEditor(boolean boolEditor) {
        this.editor = boolEditor;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        this.initProperties();
        this.initComponents();
        this.setReadOnly();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panContent = new RoundedPanel();
        this.panDaten = new JPanel();
        this.lblCity = new JLabel();
        this.cbCity = new DefaultBindableScrollableComboBox(MC__CITY);
        this.lblGeom = new JLabel();
        if (this.isEditor()) {
            this.cbGeom = new DefaultCismapGeometryComboBoxEditor();
            ((DefaultCismapGeometryComboBoxEditor)this.cbGeom).setAllowedGeometryTypes(new Class[]{Polygon.class, MultiPolygon.class});
        }
        this.lblHinweis = new JLabel();
        this.panHinweis = new JPanel();
        this.scpHinweis = new JScrollPane();
        this.taHinweis = new JTextArea();
        this.lblBemerkung = new JLabel();
        this.panBemerkung = new JPanel();
        this.scpBemerkung = new JScrollPane();
        this.taBemerkung = new JTextArea();
        this.lblVeroeffentlicht = new JLabel();
        this.chkVeroeffentlicht = new JCheckBox();
        this.panLage = new JPanel();
        this.rpKarte = new RoundedPanel();
        this.panPreviewMap = new DefaultPreviewMapPanel();
        this.semiRoundedPanel7 = new SemiRoundedPanel();
        this.lblKarte = new JLabel();
        this.setLayout(new GridBagLayout());
        this.panContent.setName("");
        this.panContent.setOpaque(false);
        this.panContent.setLayout(new GridBagLayout());
        this.panDaten.setOpaque(false);
        this.panDaten.setLayout(new GridBagLayout());
        this.lblCity.setFont(new Font("Tahoma", 1, 11));
        this.lblCity.setText("City-Parkzone:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblCity, gridBagConstraints);
        this.cbCity.setFont(new Font("Dialog", 0, 12));
        this.cbCity.setPreferredSize(new Dimension(100, 24));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.fk_cityausweisbereich}"), this.cbCity, (Property)BeanProperty.create((String)"selectedItem"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add(this.cbCity, gridBagConstraints);
        this.lblGeom.setFont(new Font("Tahoma", 1, 11));
        this.lblGeom.setText("Geometrie:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblGeom, gridBagConstraints);
        if (this.isEditor()) {
            if (this.editor) {
                this.cbGeom.setFont(new Font("Dialog", 0, 12));
            }
            binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.fk_geom}"), (Object)this.cbGeom, (Property)BeanProperty.create((String)"selectedItem"));
            binding.setConverter(((DefaultCismapGeometryComboBoxEditor)this.cbGeom).getConverter());
            this.bindingGroup.addBinding((Binding)binding);
        }
        if (this.isEditor()) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.panDaten.add((Component)this.cbGeom, gridBagConstraints);
        }
        this.lblHinweis.setFont(new Font("Tahoma", 1, 11));
        this.lblHinweis.setText("Hinweis:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblHinweis, gridBagConstraints);
        this.panHinweis.setOpaque(false);
        this.panHinweis.setLayout(new GridBagLayout());
        this.taHinweis.setColumns(20);
        this.taHinweis.setLineWrap(true);
        this.taHinweis.setRows(2);
        this.taHinweis.setWrapStyleWord(true);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.hinweis}"), (Object)this.taHinweis, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.scpHinweis.setViewportView(this.taHinweis);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panHinweis.add((Component)this.scpHinweis, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.panHinweis, gridBagConstraints);
        this.lblBemerkung.setFont(new Font("Tahoma", 1, 11));
        this.lblBemerkung.setText("Bemerkung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblBemerkung, gridBagConstraints);
        this.panBemerkung.setOpaque(false);
        this.panBemerkung.setLayout(new GridBagLayout());
        this.taBemerkung.setColumns(20);
        this.taBemerkung.setLineWrap(true);
        this.taBemerkung.setRows(2);
        this.taBemerkung.setWrapStyleWord(true);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.bemerkung}"), (Object)this.taBemerkung, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        this.scpBemerkung.setViewportView(this.taBemerkung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panBemerkung.add((Component)this.scpBemerkung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.panBemerkung, gridBagConstraints);
        this.lblVeroeffentlicht.setFont(new Font("Tahoma", 1, 11));
        this.lblVeroeffentlicht.setText("Ver\u00f6ffentlicht:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblVeroeffentlicht, gridBagConstraints);
        this.chkVeroeffentlicht.setContentAreaFilled(false);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.veroeffentlicht}"), (Object)this.chkVeroeffentlicht, (Property)BeanProperty.create((String)"selected"));
        binding.setSourceNullValue((Object)false);
        binding.setSourceUnreadableValue((Object)false);
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.panDaten.add((Component)this.chkVeroeffentlicht, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        this.panContent.add((Component)this.panDaten, gridBagConstraints);
        this.panLage.setMinimumSize(new Dimension(300, 142));
        this.panLage.setOpaque(false);
        this.panLage.setLayout(new GridBagLayout());
        this.rpKarte.setName("");
        this.rpKarte.setLayout((LayoutManager)new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.rpKarte.add((Component)this.panPreviewMap, (Object)gridBagConstraints);
        this.semiRoundedPanel7.setBackground(Color.darkGray);
        this.semiRoundedPanel7.setLayout((LayoutManager)new GridBagLayout());
        this.lblKarte.setForeground(new Color(255, 255, 255));
        this.lblKarte.setText("Lage");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.semiRoundedPanel7.add((Component)this.lblKarte, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.rpKarte.add((Component)this.semiRoundedPanel7, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panLage.add((Component)this.rpKarte, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panContent.add((Component)this.panLage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add(this.panContent, gridBagConstraints);
        this.bindingGroup.bind();
    }

    public boolean isEditor() {
        return this.editor;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cb) {
        try {
            if (this.isEditor() && this.getCidsBean() != null) {
                LOG.info((Object)("remove propchange bpark_cityausweis: " + this.getCidsBean()));
                this.getCidsBean().removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.bindingGroup.unbind();
            this.cidsBean = cb;
            if (this.isEditor() && this.getCidsBean() != null) {
                LOG.info((Object)("add propchange bpark_cityausweis: " + this.getCidsBean()));
                this.getCidsBean().addPropertyChangeListener((PropertyChangeListener)this);
            }
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cb, (ConnectionContext)this.getConnectionContext());
            this.setMapWindow();
            this.bindingGroup.bind();
            this.setTitle(this.getTitle());
            if (this.getCidsBean().getMetaObject().getStatus() == 1) {
                try {
                    this.getCidsBean().setProperty(FIELD__PUBLISH, (Object)false);
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot set default values", (Throwable)e);
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Bean not set", (Throwable)ex);
        }
    }

    private void setReadOnly() {
        if (!this.isEditor()) {
            this.lblGeom.setVisible(this.isEditor());
            RendererTools.makeReadOnly(this.cbCity);
            RendererTools.makeReadOnly(this.taHinweis);
            RendererTools.makeReadOnly(this.taBemerkung);
            RendererTools.makeReadOnly(this.chkVeroeffentlicht);
        }
    }

    public void setMapWindow() {
        CidsBean cb = this.getCidsBean();
        try {
            if (cb.getProperty(FIELD__GEOM) != null) {
                this.panPreviewMap.initMap(cb, FIELD__GEOREFERENZ__GEO_FIELD, BUFFER, MAPURL);
            } else {
                int srid = CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode());
                BoundingBox initialBoundingBox = CismapBroker.getInstance().getMappingComponent().getMappingModel().getInitialBoundingBox();
                Point centerPoint = initialBoundingBox.getGeometry(srid).getCentroid();
                MetaClass geomMetaClass = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)TABLE_GEOM, (ConnectionContext)this.getConnectionContext());
                CidsBean newGeom = geomMetaClass.getEmptyInstance(this.getConnectionContext()).getBean();
                newGeom.setProperty(FIELD__GEO_FIELD, (Object)centerPoint);
                this.panPreviewMap.initMap(newGeom, FIELD__GEO_FIELD, BUFFER);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            LOG.warn((Object)"Map window not set.", (Throwable)ex);
        }
    }

    private void initProperties() {
        try {
            BUFFER = BparkConfProperties.getInstance().getBufferMeter();
            MAPURL = BparkConfProperties.getInstance().getUrlMap();
        }
        catch (Exception ex) {
            LOG.warn((Object)"Get no conf properties.", (Throwable)ex);
        }
    }

    public static void main(String[] args) throws Exception {
        Log4JQuickConfig.configure4LumbermillOnLocalhost();
        MappingComponent mc = new MappingComponent();
        CismapBroker.getInstance().setMappingComponent(mc);
        DevelopmentTools.createEditorFromRestfulConnection((String)"http://localhost:9986/callserver/binary", (String)"WUNDA_BLAU", null, (boolean)true, (String)TABLE_NAME, (int)1, (int)800, (int)600);
    }

    public String getTitle() {
        if (this.getCidsBean().getMetaObject().getStatus() == 1) {
            return TITLE_NEW_ZONE;
        }
        String id = this.getCidsBean().getPrimaryKeyValue().toString();
        return id;
    }

    public void dispose() {
        this.panPreviewMap.dispose();
        if (this.isEditor()) {
            ((DefaultCismapGeometryComboBoxEditor)this.cbGeom).dispose();
            if (this.getCidsBean() != null) {
                LOG.info((Object)("remove propchange bpark_cityausweis: " + this.getCidsBean()));
                this.getCidsBean().removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
        this.bindingGroup.unbind();
        super.dispose();
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "<Error>";
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(FIELD__GEOM)) {
            this.setMapWindow();
        }
    }

    public boolean isOkForSaving() {
        boolean save = true;
        StringBuilder errorMessage = new StringBuilder();
        try {
            if (this.getCidsBean().getProperty(FIELD__CITY) == null) {
                LOG.warn((Object)"No citybereich specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(BparkCityausweisEditor.class, (String)BUNDLE_NOCITY));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Citybereich not given.", (Throwable)ex);
            save = false;
        }
        try {
            if (this.getCidsBean().getProperty(FIELD__GEOM) == null) {
                LOG.warn((Object)"No geom specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(BparkCityausweisEditor.class, (String)BUNDLE_NOGEOM));
                save = false;
            }
        }
        catch (MissingResourceException ex) {
            LOG.warn((Object)"Geom not given.", (Throwable)ex);
            save = false;
        }
        if (errorMessage.length() > 0) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(BparkCityausweisEditor.class, (String)BUNDLE_PANE_PREFIX) + errorMessage.toString() + NbBundle.getMessage(BparkCityausweisEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(BparkCityausweisEditor.class, (String)BUNDLE_PANE_TITLE), 2);
        }
        return save;
    }

    static {
        ConnectionContext connectionContext = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STATIC, (String)BparkCityausweisEditor.class.getSimpleName());
        MC__CITY = ClassCacheMultiple.getMetaClass((String)"WUNDA_BLAU", (String)"BPARK_CITYAUSWEISBEREICH", (ConnectionContext)connectionContext);
        LOG = Logger.getLogger(BparkCityausweisEditor.class);
    }

    private static enum DocumentCard {
        BUSY,
        DOCUMENT,
        NO_DOCUMENT,
        ERROR;

    }
}

