/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.ui.RequestsFullSizeComponent;
import de.cismet.cids.custom.objecteditors.utils.RendererTools;
import de.cismet.cids.custom.objecteditors.utils.TableUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.editors.BindingGroupStore;
import de.cismet.cids.editors.DefaultCustomObjectEditor;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.tools.metaobjectrenderer.CidsBeanRenderer;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.security.WebAccessManager;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class EmobradBetreiberEditor
extends DefaultCustomObjectEditor
implements CidsBeanRenderer,
EditorSaveListener,
BindingGroupStore,
PropertyChangeListener,
RequestsFullSizeComponent {
    private static final Logger LOG = Logger.getLogger(EmobradBetreiberEditor.class);
    public static final String TABLE_NAME = "emobrad_betreiber";
    public static final String FIELD__HOMEPAGE = "homepage";
    public static final String FIELD__NAME = "name";
    public static final String FIELD__SCHLUESSEL = "schluessel";
    public static final String FIELD__TELEFON = "telefon";
    public static final String FIELD__ID = "id";
    public static final String BUNDLE_NONAME = "EmobradBetreiberEditor.prepareForSave().noName";
    public static final String BUNDLE_DUPLICATENAME = "EmobradBetreiberEditor.prepareForSave().duplicateName";
    public static final String BUNDLE_DUPLICATEKEY = "EmobradBetreiberEditor.prepareForSave().duplicateSchluessel";
    public static final String BUNDLE_PANE_PREFIX = "EmobradBetreiberEditor.prepareForSave().JOptionPane.message.prefix";
    public static final String BUNDLE_PANE_SUFFIX = "EmobradBetreiberEditor.prepareForSave().JOptionPane.message.suffix";
    public static final String BUNDLE_PANE_TITLE = "EmobradBetreiberEditor.prepareForSave().JOptionPane.title";
    public static final String BUNDLE_HP_TITLE = "EmobradBetreiberEditor.xhHomepageActionPerformed.title";
    public static final String BUNDLE_HP_TEXT = "EmobradBetreiberEditor.xhHomepageActionPerformed.text";
    public static final Pattern TEL_FILLING_PATTERN = Pattern.compile("(|\\+(-|[0-9])*)");
    public static final Pattern TEL_MATCHING_PATTERN = Pattern.compile("\\+[0-9]{1,3}(-[0-9]+){1,}");
    private SwingWorker worker_key;
    private SwingWorker worker_name;
    private SwingWorker worker_url;
    private Boolean redundantName = false;
    private Boolean redundantKey = false;
    private boolean isEditor = true;
    private final ImageIcon statusFalsch = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/status-busy.png"));
    private final ImageIcon statusOk = new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/status.png"));
    private final RegexPatternFormatter telPatternFormatter = new RegexPatternFormatter(TEL_FILLING_PATTERN, TEL_MATCHING_PATTERN);
    private Box.Filler filler3;
    private JFormattedTextField ftxtPlz;
    private JFormattedTextField ftxtTelefon;
    private JLabel lblBemerkung;
    private JLabel lblHnr;
    private JLabel lblHomepage;
    private JLabel lblMail;
    private JLabel lblName;
    private JLabel lblOrt;
    private JLabel lblPlz;
    private JLabel lblStrasse;
    private JLabel lblTelefon;
    private JLabel lblUrlCheck;
    private JPanel panContent;
    private JPanel panDaten;
    private JPanel panFillerUnten;
    private JPanel panFillerUnten1;
    private JPanel panHomepage;
    private JTextField txtBemerkung;
    private JTextField txtHnr;
    private JTextField txtHomepage;
    private JTextField txtMail;
    private JTextField txtName;
    private JTextField txtOrt;
    private JTextField txtStrasse;
    private JXHyperlink xhHomepage;
    private BindingGroup bindingGroup;

    public EmobradBetreiberEditor() {
    }

    public EmobradBetreiberEditor(boolean boolEditor) {
        this.isEditor = boolEditor;
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        super.initWithConnectionContext(connectionContext);
        this.initComponents();
        this.txtHomepage.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EmobradBetreiberEditor.this.homepageCheck();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EmobradBetreiberEditor.this.homepageCheck();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EmobradBetreiberEditor.this.homepageCheck();
            }
        });
        this.txtName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EmobradBetreiberEditor.this.checkAttributes();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EmobradBetreiberEditor.this.checkAttributes();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EmobradBetreiberEditor.this.checkAttributes();
            }
        });
        this.setReadOnly();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.panContent = new RoundedPanel();
        this.panDaten = new JPanel();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblStrasse = new JLabel();
        this.txtStrasse = new JTextField();
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.lblHnr = new JLabel();
        this.txtHnr = new JTextField();
        this.lblPlz = new JLabel();
        this.ftxtPlz = new JFormattedTextField();
        this.lblOrt = new JLabel();
        this.txtOrt = new JTextField();
        this.lblTelefon = new JLabel();
        this.ftxtTelefon = new JFormattedTextField(this.telPatternFormatter);
        this.lblMail = new JLabel();
        this.txtMail = new JTextField();
        this.lblHomepage = new JLabel();
        this.panHomepage = new JPanel();
        this.xhHomepage = new JXHyperlink();
        this.txtHomepage = new JTextField();
        this.lblUrlCheck = new JLabel();
        this.lblBemerkung = new JLabel();
        this.txtBemerkung = new JTextField();
        this.panFillerUnten1 = new JPanel();
        this.panFillerUnten = new JPanel();
        this.setAutoscrolls(true);
        this.setMinimumSize(new Dimension(600, 646));
        this.setPreferredSize(new Dimension(600, 737));
        this.setLayout(new GridBagLayout());
        this.panContent.setAutoscrolls(true);
        this.panContent.setMaximumSize(new Dimension(450, Integer.MAX_VALUE));
        this.panContent.setMinimumSize(new Dimension(450, 488));
        this.panContent.setName("");
        this.panContent.setOpaque(false);
        this.panContent.setPreferredSize(new Dimension(450, 961));
        this.panContent.setLayout(new GridBagLayout());
        this.panDaten.setOpaque(false);
        this.panDaten.setLayout(new GridBagLayout());
        this.lblName.setFont(new Font("Tahoma", 1, 11));
        this.lblName.setText("Name:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblName, gridBagConstraints);
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.name}"), (Object)this.txtName, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.txtName, gridBagConstraints);
        this.lblStrasse.setFont(new Font("Tahoma", 1, 11));
        this.lblStrasse.setText("Stra\u00dfe:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblStrasse, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.strasse}"), (Object)this.txtStrasse, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.txtStrasse, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.panDaten.add((Component)this.filler3, gridBagConstraints);
        this.lblHnr.setFont(new Font("Tahoma", 1, 11));
        this.lblHnr.setText("Hnr:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblHnr, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.hausnummer}"), (Object)this.txtHnr, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.txtHnr, gridBagConstraints);
        this.lblPlz.setFont(new Font("Tahoma", 1, 11));
        this.lblPlz.setText("PLZ:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblPlz, gridBagConstraints);
        this.ftxtPlz.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#####"))));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.plz}"), (Object)this.ftxtPlz, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.ftxtPlz, gridBagConstraints);
        this.lblOrt.setFont(new Font("Tahoma", 1, 11));
        this.lblOrt.setText("Ort:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblOrt, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.ort}"), (Object)this.txtOrt, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.txtOrt, gridBagConstraints);
        this.lblTelefon.setFont(new Font("Tahoma", 1, 11));
        this.lblTelefon.setText("Telefon:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblTelefon, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.telefon}"), (Object)this.ftxtTelefon, (Property)BeanProperty.create((String)"value"));
        this.bindingGroup.addBinding((Binding)binding);
        this.ftxtTelefon.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                EmobradBetreiberEditor.this.ftxtTelefonFocusLost(evt);
            }
        });
        this.ftxtTelefon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EmobradBetreiberEditor.this.ftxtTelefonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.ftxtTelefon, gridBagConstraints);
        this.lblMail.setFont(new Font("Tahoma", 1, 11));
        this.lblMail.setText("Email:");
        this.lblMail.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblMail, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.email}"), (Object)this.txtMail, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.txtMail, gridBagConstraints);
        this.lblHomepage.setFont(new Font("Tahoma", 1, 11));
        this.lblHomepage.setText("Homepage:");
        this.lblHomepage.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblHomepage, gridBagConstraints);
        this.panHomepage.setOpaque(false);
        this.panHomepage.setLayout(new GridBagLayout());
        this.xhHomepage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EmobradBetreiberEditor.this.xhHomepageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panHomepage.add((Component)this.xhHomepage, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.homepage}"), (Object)this.txtHomepage, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panHomepage.add((Component)this.txtHomepage, gridBagConstraints);
        this.lblUrlCheck.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/status-busy.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.panHomepage.add((Component)this.lblUrlCheck, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.panHomepage, gridBagConstraints);
        this.lblBemerkung.setFont(new Font("Tahoma", 1, 11));
        this.lblBemerkung.setText("Bemerkung:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 5);
        this.panDaten.add((Component)this.lblBemerkung, gridBagConstraints);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)ELProperty.create((String)"${cidsBean.bemerkung}"), (Object)this.txtBemerkung, (Property)BeanProperty.create((String)"text"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.panDaten.add((Component)this.txtBemerkung, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.panContent.add((Component)this.panDaten, gridBagConstraints);
        this.panFillerUnten1.setName("");
        this.panFillerUnten1.setOpaque(false);
        GroupLayout panFillerUnten1Layout = new GroupLayout(this.panFillerUnten1);
        this.panFillerUnten1.setLayout(panFillerUnten1Layout);
        panFillerUnten1Layout.setHorizontalGroup(panFillerUnten1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUnten1Layout.setVerticalGroup(panFillerUnten1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.panContent.add((Component)this.panFillerUnten1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.add(this.panContent, gridBagConstraints);
        this.panFillerUnten.setName("");
        this.panFillerUnten.setOpaque(false);
        GroupLayout panFillerUntenLayout = new GroupLayout(this.panFillerUnten);
        this.panFillerUnten.setLayout(panFillerUntenLayout);
        panFillerUntenLayout.setHorizontalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        panFillerUntenLayout.setVerticalGroup(panFillerUntenLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.add(this.panFillerUnten, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void ftxtTelefonFocusLost(FocusEvent evt) {
        this.refreshValidTel();
    }

    private void ftxtTelefonActionPerformed(ActionEvent evt) {
        this.refreshValidTel();
    }

    private void xhHomepageActionPerformed(ActionEvent evt) {
        try {
            BrowserLauncher.openURL((String)this.xhHomepage.getText());
        }
        catch (Exception e) {
            LOG.fatal((Object)"Problem during opening url", (Throwable)e);
            ErrorInfo ei = new ErrorInfo(BUNDLE_HP_TITLE, BUNDLE_HP_TEXT, null, null, (Throwable)e, Level.SEVERE, null);
            JXErrorPane.showDialog((Component)((Object)this), (ErrorInfo)ei);
        }
    }

    public void homepageCheck() {
        this.checkUrl(this.txtHomepage.getText(), this.lblUrlCheck);
    }

    public boolean prepareForSave() {
        boolean save = true;
        StringBuilder errorMessage = new StringBuilder();
        try {
            if (this.txtName.getText().trim().isEmpty()) {
                LOG.warn((Object)"No name specified. Skip persisting.");
                errorMessage.append(NbBundle.getMessage(EmobradBetreiberEditor.class, (String)BUNDLE_NONAME));
            } else {
                if (this.cidsBean.getMetaObject().getStatus() == 1) {
                    this.cidsBean.setProperty(FIELD__SCHLUESSEL, (Object)this.txtName.getText().trim());
                }
                if (this.redundantName.booleanValue()) {
                    LOG.warn((Object)"Duplicate name specified. Skip persisting.");
                    errorMessage.append(NbBundle.getMessage(EmobradBetreiberEditor.class, (String)BUNDLE_DUPLICATENAME));
                } else if (this.redundantKey.booleanValue()) {
                    LOG.warn((Object)"Duplicate key specified. Skip persisting.");
                    errorMessage.append(NbBundle.getMessage(EmobradBetreiberEditor.class, (String)BUNDLE_DUPLICATEKEY));
                }
            }
        }
        catch (Exception ex) {
            LOG.warn((Object)"Name not given.", (Throwable)ex);
            save = false;
        }
        if (errorMessage.length() > 0) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)((Object)this)), NbBundle.getMessage(EmobradBetreiberEditor.class, (String)BUNDLE_PANE_PREFIX) + errorMessage.toString() + NbBundle.getMessage(EmobradBetreiberEditor.class, (String)BUNDLE_PANE_SUFFIX), NbBundle.getMessage(EmobradBetreiberEditor.class, (String)BUNDLE_PANE_TITLE), 2);
            return false;
        }
        return save;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cb) {
        try {
            if (this.isEditor && this.cidsBean != null) {
                LOG.info((Object)("remove propchange emobrad_betreiber: " + this.cidsBean));
                this.cidsBean.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.bindingGroup.unbind();
            this.cidsBean = cb;
            if (this.isEditor && this.cidsBean != null) {
                LOG.info((Object)("add propchange emobrad_betreiber: " + this.cidsBean));
                this.cidsBean.addPropertyChangeListener((PropertyChangeListener)this);
            }
            DefaultCustomObjectEditor.setMetaClassInformationToMetaClassStoreComponentsInBindingGroup((BindingGroup)this.bindingGroup, (CidsBean)cb, (ConnectionContext)this.getConnectionContext());
            this.bindingGroup.bind();
            this.saveValidTel(String.valueOf(this.cidsBean.getProperty(FIELD__TELEFON)));
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            LOG.error((Object)"Bean not set.", (Throwable)ex);
        }
    }

    private void setReadOnly() {
        if (!this.isEditor) {
            RendererTools.makeReadOnly(this.ftxtPlz);
            RendererTools.makeReadOnly(this.ftxtTelefon);
            RendererTools.makeReadOnly(this.txtMail);
            RendererTools.makeReadOnly(this.txtOrt);
            RendererTools.makeReadOnly(this.txtHnr);
            RendererTools.makeReadOnly(this.txtStrasse);
            RendererTools.makeReadOnly(this.txtName);
            RendererTools.makeReadOnly(this.txtHomepage);
            RendererTools.makeReadOnly(this.txtBemerkung);
            RendererTools.makeReadOnly(this.txtName);
            RendererTools.makeReadOnly((JComponent)this.xhHomepage);
            RendererTools.makeReadOnly(this.panHomepage);
            this.panHomepage.setOpaque(this.isEditor);
        }
    }

    public void dispose() {
        super.dispose();
    }

    public String getTitle() {
        return this.cidsBean.toString();
    }

    public void setTitle(String string) {
    }

    public void editorClosed(EditorClosedEvent ece) {
    }

    public BindingGroup getBindingGroup() {
        return this.bindingGroup;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    private void refreshValidTel() {
        this.ftxtTelefon.setValue(this.telPatternFormatter.getLastValid());
    }

    private void saveValidTel(Object okValue) {
        this.telPatternFormatter.setLastValid(okValue);
    }

    private void checkName(String field, OtherTableCases fall) {
        this.valueFromOtherTable(TABLE_NAME, " where " + field + " ilike '" + this.txtName.getText().trim() + "' and " + FIELD__ID + " <> " + this.cidsBean.getProperty(FIELD__ID), fall);
    }

    private void checkAttributes() {
        this.checkName(FIELD__NAME, OtherTableCases.REDUNDANT_ATT_NAME);
        this.checkName(FIELD__SCHLUESSEL, OtherTableCases.REDUNDANT_ATT_KEY);
    }

    private void checkUrl(final String url, final JLabel showLabel) {
        showLabel.setIcon(this.statusFalsch);
        showLabel.setCursor(new Cursor(0));
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                return WebAccessManager.getInstance().checkIfURLaccessible(new URL(url));
            }

            @Override
            protected void done() {
                try {
                    if (!this.isCancelled()) {
                        Boolean check = (Boolean)this.get();
                        if (check.booleanValue()) {
                            showLabel.setIcon(EmobradBetreiberEditor.this.statusOk);
                            showLabel.setCursor(new Cursor(12));
                        } else {
                            showLabel.setIcon(EmobradBetreiberEditor.this.statusFalsch);
                            showLabel.setCursor(new Cursor(0));
                        }
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    showLabel.setIcon(EmobradBetreiberEditor.this.statusFalsch);
                    showLabel.setCursor(new Cursor(0));
                    LOG.warn((Object)"URL Check Problem in Worker.", (Throwable)e);
                }
            }
        };
        if (this.worker_url != null) {
            this.worker_url.cancel(true);
        }
        this.worker_url = worker;
        this.worker_url.execute();
    }

    private void valueFromOtherTable(final String tableName, final String whereClause, final OtherTableCases fall) {
        SwingWorker<CidsBean, Void> worker = new SwingWorker<CidsBean, Void>(){

            @Override
            protected CidsBean doInBackground() throws Exception {
                return TableUtils.getOtherTableValue(tableName, whereClause, EmobradBetreiberEditor.this.getConnectionContext());
            }

            @Override
            protected void done() {
                try {
                    if (!this.isCancelled()) {
                        CidsBean check = (CidsBean)this.get();
                        if (check != null) {
                            switch (fall) {
                                case REDUNDANT_ATT_KEY: {
                                    EmobradBetreiberEditor.this.redundantKey = true;
                                    break;
                                }
                                case REDUNDANT_ATT_NAME: {
                                    EmobradBetreiberEditor.this.redundantName = true;
                                }
                            }
                        } else {
                            switch (fall) {
                                case REDUNDANT_ATT_KEY: {
                                    EmobradBetreiberEditor.this.redundantKey = false;
                                    break;
                                }
                                case REDUNDANT_ATT_NAME: {
                                    EmobradBetreiberEditor.this.redundantName = false;
                                }
                            }
                        }
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.warn((Object)"problem in Worker: load values.", (Throwable)e);
                }
            }
        };
        if (fall.equals((Object)OtherTableCases.REDUNDANT_ATT_NAME)) {
            if (this.worker_name != null) {
                this.worker_name.cancel(true);
            }
            this.worker_name = worker;
            this.worker_name.execute();
        } else {
            if (this.worker_key != null) {
                this.worker_key.cancel(true);
            }
            this.worker_key = worker;
            this.worker_key.execute();
        }
    }

    class RegexPatternFormatter
    extends DefaultFormatter {
        protected Matcher fillingMatcher;
        protected Matcher matchingMatcher;
        private Object lastValid = null;

        public RegexPatternFormatter(Pattern fillingRegex, Pattern matchingRegex) {
            this.setOverwriteMode(false);
            this.fillingMatcher = fillingRegex.matcher("");
            this.matchingMatcher = matchingRegex.matcher("");
        }

        @Override
        public Object stringToValue(String string) throws ParseException {
            if (string == null || string.isEmpty()) {
                this.lastValid = null;
                return null;
            }
            this.fillingMatcher.reset(string);
            if (!this.fillingMatcher.matches()) {
                throw new ParseException("does not match regex", 0);
            }
            String value = (String)super.stringToValue(string);
            this.matchingMatcher.reset(string);
            if (this.matchingMatcher.matches()) {
                this.lastValid = value;
            }
            return value;
        }

        public Object getLastValid() {
            return this.lastValid;
        }

        public void setLastValid(Object okValue) {
            if (this.lastValid == null) {
                this.lastValid = okValue;
            }
        }
    }

    private static enum OtherTableCases {
        REDUNDANT_ATT_KEY,
        REDUNDANT_ATT_NAME;

    }
}

