/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.ui.ComponentRegistry;
import de.cismet.cids.custom.clientutils.PotenzialflaecheReportDownload;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.custom.wunda_blau.search.actions.DeletePotenzialflaecheReportCacheServerAction;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.actions.ServerActionParameter;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class PfPotenzialflaecheReportGenerator {
    private static final Logger LOG = Logger.getLogger(PfPotenzialflaecheReportGenerator.class);

    private static void startZipDownload(CidsBean kategorieBean, CidsBean selectedTemplateBean, ConnectionContext connectionContext) {
        if (selectedTemplateBean != null) {
            try {
                PotenzialflaecheReportDownload download = new PotenzialflaecheReportDownload(PotenzialflaecheReportDownload.Type.KATEGORIE, false, selectedTemplateBean, Arrays.asList(kategorieBean), connectionContext);
                DownloadManager.instance().add((Download)download);
            }
            catch (Exception ex) {
                LOG.error((Object)"Cannot create report", (Throwable)ex);
                ObjectRendererUtils.showExceptionWindowToUser("Fehler Erstellen des Reports", ex, StaticSwingTools.getFirstParentFrame((Component)ComponentRegistry.getRegistry().getDescriptionPane()));
            }
        }
    }

    private static void startZipDownload(Collection<CidsBean> flaecheBeans, CidsBean selectedTemplateBean, ConnectionContext connectionContext) {
        if (selectedTemplateBean != null) {
            try {
                PotenzialflaecheReportDownload download = new PotenzialflaecheReportDownload(PotenzialflaecheReportDownload.Type.FLAECHE, false, selectedTemplateBean, flaecheBeans, connectionContext);
                DownloadManager.instance().add((Download)download);
            }
            catch (Exception ex) {
                LOG.error((Object)"Cannot create report", (Throwable)ex);
                ObjectRendererUtils.showExceptionWindowToUser("Fehler Erstellen des Reports", ex, StaticSwingTools.getFirstParentFrame((Component)ComponentRegistry.getRegistry().getDescriptionPane()));
            }
        }
    }

    private static void startPdfDownload(CidsBean flaecheBean, CidsBean selectedTemplateBean, ConnectionContext connectionContext) {
        if (selectedTemplateBean != null) {
            try {
                PotenzialflaecheReportDownload download = new PotenzialflaecheReportDownload(PotenzialflaecheReportDownload.Type.FLAECHE, false, selectedTemplateBean, Arrays.asList(flaecheBean), connectionContext);
                DownloadManager.instance().add((Download)download);
            }
            catch (Exception ex) {
                LOG.error((Object)"Cannot create report", (Throwable)ex);
                ObjectRendererUtils.showExceptionWindowToUser("Fehler Erstellen des Reports", ex, StaticSwingTools.getFirstParentFrame((Component)ComponentRegistry.getRegistry().getDescriptionPane()));
            }
        }
    }

    private static Collection<CidsBean> identifyActiveTemplateBeans(CidsBean kategorieBean, ConnectionContext connectionContext) throws Exception {
        return kategorieBean != null ? (Collection)PfPotenzialflaecheReportGenerator.identifyActiveTemplateBeansMap(Arrays.asList(kategorieBean), connectionContext).get((Object)kategorieBean) : null;
    }

    private static MultiValueMap identifyActiveTemplateBeansMap(Collection<CidsBean> kategorieBeans, ConnectionContext connectionContext) throws Exception {
        MultiValueMap activeTemplateBeansMap = new MultiValueMap();
        if (kategorieBeans != null) {
            for (CidsBean kategorieBean : kategorieBeans) {
                if (kategorieBean == null) continue;
                for (CidsBean templateBean : kategorieBean.getBeanCollectionProperty("n_steckbrieftemplates")) {
                    if (templateBean == null) continue;
                    String confAttr = (String)templateBean.getProperty("conf_attr");
                    if (confAttr != null && !confAttr.trim().isEmpty()) {
                        if (!SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), confAttr, connectionContext)) continue;
                        activeTemplateBeansMap.put((Object)kategorieBean, (Object)templateBean);
                        continue;
                    }
                    activeTemplateBeansMap.put((Object)kategorieBean, (Object)templateBean);
                }
            }
        }
        return activeTemplateBeansMap;
    }

    private static CidsBean askForSelection(Integer mainTemplateId, Collection<CidsBean> activeTemplateBeans) {
        Object selection;
        CidsBean mainTemplateBean = !activeTemplateBeans.isEmpty() ? activeTemplateBeans.iterator().next() : null;
        for (CidsBean templateBean : activeTemplateBeans) {
            if (templateBean.getMetaObject().getId() != mainTemplateId.intValue()) continue;
            mainTemplateBean = templateBean;
        }
        CidsBean selectedTemplateBean = activeTemplateBeans.size() > 1 ? ((selection = JOptionPane.showInputDialog((Component)ComponentRegistry.getRegistry().getDescriptionPane(), "W\u00e4hlen Sie die Art des Steckbriefs, der erzeugt werden soll:", "Steckbriefart ausw\u00e4hlen", 3, null, activeTemplateBeans.toArray(new CidsBean[0]), mainTemplateBean)) instanceof CidsBean ? (CidsBean)selection : null) : mainTemplateBean;
        return selectedTemplateBean;
    }

    public static void startDownloadForKategorie(final CidsBean kategorieBean, final ConnectionContext connectionContext) {
        if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)ComponentRegistry.getRegistry().getMainWindow())) {
            new SwingWorker<Collection<CidsBean>, Void>(){

                @Override
                protected Collection<CidsBean> doInBackground() throws Exception {
                    return PfPotenzialflaecheReportGenerator.identifyActiveTemplateBeans(kategorieBean, connectionContext);
                }

                @Override
                protected void done() {
                    try {
                        Collection activeTemplateBeans = (Collection)this.get();
                        Integer mainTemplateId = (Integer)kategorieBean.getProperty("haupt_steckbrieftemplate_id");
                        PfPotenzialflaecheReportGenerator.startZipDownload(kategorieBean, PfPotenzialflaecheReportGenerator.askForSelection(mainTemplateId, activeTemplateBeans), connectionContext);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                        ObjectRendererUtils.showExceptionWindowToUser("Fehler Erstellen des Reports", ex, StaticSwingTools.getFirstParentFrame((Component)ComponentRegistry.getRegistry().getDescriptionPane()));
                    }
                }
            }.execute();
        }
    }

    public static void startDownloadForFlaeche(final CidsBean flaecheBean, final ConnectionContext connectionContext) {
        CidsBean kategorieBean;
        CidsBean cidsBean = kategorieBean = flaecheBean != null ? (CidsBean)flaecheBean.getProperty("kampagne") : null;
        if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)ComponentRegistry.getRegistry().getMainWindow())) {
            new SwingWorker<Collection<CidsBean>, Void>(){

                @Override
                protected Collection<CidsBean> doInBackground() throws Exception {
                    return PfPotenzialflaecheReportGenerator.identifyActiveTemplateBeans(kategorieBean, connectionContext);
                }

                @Override
                protected void done() {
                    try {
                        Collection activeTemplateBeans = (Collection)this.get();
                        Integer mainTemplateId = (Integer)kategorieBean.getProperty("haupt_steckbrieftemplate_id");
                        PfPotenzialflaecheReportGenerator.startPdfDownload(flaecheBean, PfPotenzialflaecheReportGenerator.askForSelection(mainTemplateId, activeTemplateBeans), connectionContext);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                        ObjectRendererUtils.showExceptionWindowToUser("Fehler Erstellen des Reports", ex, StaticSwingTools.getFirstParentFrame((Component)ComponentRegistry.getRegistry().getDescriptionPane()));
                    }
                }
            }.execute();
        }
    }

    public static void deleteDownloadCacheForFlaechen(final Collection<CidsBean> flaecheBeans, final ConnectionContext connectionContext) {
        if (flaecheBeans != null) {
            new SwingWorker<Boolean, Void>(){

                @Override
                protected Boolean doInBackground() throws Exception {
                    ArrayList<Integer> idList = new ArrayList<Integer>();
                    for (CidsBean tmpFlaeche : flaecheBeans) {
                        Integer pk = tmpFlaeche.getPrimaryKeyValue();
                        idList.add(pk);
                    }
                    ArrayList<ServerActionParameter> params = new ArrayList<ServerActionParameter>();
                    params.add(new ServerActionParameter(DeletePotenzialflaecheReportCacheServerAction.Parameter.POTENZIALFLAECHE.toString(), (Object)idList.toArray(new Integer[idList.size()])));
                    Object ret = SessionManager.getProxy().executeTask("deletePotenzialflaecheReportCache", "WUNDA_BLAU", null, connectionContext, params.toArray(new ServerActionParameter[0]));
                    return (Boolean)ret;
                }

                @Override
                protected void done() {
                    try {
                        Boolean success = (Boolean)this.get();
                        if (success.booleanValue()) {
                            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(PfPotenzialflaecheReportGenerator.class, (String)"PfPotenzialflaecheReportGenerator.deleteDownloadCacheForFlaechen().success.message"), NbBundle.getMessage(PfPotenzialflaecheReportGenerator.class, (String)"PfPotenzialflaecheReportGenerator.deleteDownloadCacheForFlaechen().success.title"), 1);
                        } else {
                            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(PfPotenzialflaecheReportGenerator.class, (String)"PfPotenzialflaecheReportGenerator.deleteDownloadCacheForFlaechen().error.message"), NbBundle.getMessage(PfPotenzialflaecheReportGenerator.class, (String)"PfPotenzialflaecheReportGenerator.deleteDownloadCacheForFlaechen().error.title"), 1);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                        ObjectRendererUtils.showExceptionWindowToUser("Fehler L\u00f6schen des Caches", ex, StaticSwingTools.getFirstParentFrame((Component)ComponentRegistry.getRegistry().getDescriptionPane()));
                    }
                }
            }.execute();
        }
    }

    public static void startDownloadForFlaechen(Collection<CidsBean> flaecheBeans, final ConnectionContext connectionContext) {
        final MultiValueMap flaecheToKategorieMaps = new MultiValueMap();
        for (CidsBean flaecheBean : flaecheBeans) {
            flaecheToKategorieMaps.put((Object)((CidsBean)flaecheBean.getProperty("kampagne")), (Object)flaecheBean);
        }
        if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)ComponentRegistry.getRegistry().getMainWindow())) {
            new SwingWorker<MultiValueMap, Void>(){

                @Override
                protected MultiValueMap doInBackground() throws Exception {
                    return PfPotenzialflaecheReportGenerator.identifyActiveTemplateBeansMap(flaecheToKategorieMaps.keySet(), connectionContext);
                }

                @Override
                protected void done() {
                    try {
                        MultiValueMap activeTemplateBeansMap = (MultiValueMap)this.get();
                        for (CidsBean kategorieBean : activeTemplateBeansMap.keySet()) {
                            Collection activeTemplateBeans = activeTemplateBeansMap.getCollection((Object)kategorieBean);
                            Integer mainTemplateId = (Integer)kategorieBean.getProperty("haupt_steckbrieftemplate_id");
                            CidsBean templateBean = PfPotenzialflaecheReportGenerator.askForSelection(mainTemplateId, activeTemplateBeans);
                            PfPotenzialflaecheReportGenerator.startZipDownload(flaecheToKategorieMaps.getCollection((Object)kategorieBean), templateBean, connectionContext);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex, (Throwable)ex);
                        ObjectRendererUtils.showExceptionWindowToUser("Fehler Erstellen des Reports", ex, StaticSwingTools.getFirstParentFrame((Component)ComponentRegistry.getRegistry().getDescriptionPane()));
                    }
                }
            }.execute();
        }
    }
}

