/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cids.custom.objecteditors.wunda_blau;

import de.cismet.cids.client.tools.WebDavTunnelHelper;
import de.cismet.cids.custom.objectrenderer.utils.ObjectRendererUtils;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanStore;
import de.cismet.cids.dynamics.Disposable;
import de.cismet.cids.editors.SaveVetoable;
import de.cismet.cids.editors.hooks.AfterClosingHook;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.commons.concurrency.CismetConcurrency;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.gui.RoundedPanel;
import de.cismet.tools.gui.SemiRoundedPanel;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.AbstractDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SimpleDocumentWebDavPanel
extends JPanel
implements CidsBeanStore,
SaveVetoable,
AfterClosingHook,
Disposable,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(SimpleDocumentWebDavPanel.class);
    private static final String FILE_PROTOCOL_PREFIX = "file://";
    private static File lastFolder = null;
    public static final String FIELD__NAME = "name";
    public static final String FIELD__DATEINAME = "dateiname";
    public static final String BUNDLE_LIMIT_MESSAGE = "SimpleDocumentWebDavPanel.ImageUploadWorker.doInBackground.fileLimitMessage";
    public static final String BUNDLE_LIMIT_TITLE = "SimpleDocumentWebDavPanel.ImageUploadWorker.doInBackground.fileLimitTitle";
    protected final String beanCollProp;
    protected final String nameProp;
    protected final String bildClassName;
    protected final JFileChooser fileChooser;
    protected final List<CidsBean> removeNewAddedDateiBean = new ArrayList<CidsBean>();
    protected final List<CidsBean> removedDateiBeans = new ArrayList<CidsBean>();
    protected boolean listListenerEnabled = true;
    protected CidsBean cidsBean;
    final boolean editor;
    private final String[] imageEndings;
    private final int fileLimit;
    private final WebDavTunnelHelper webdavHelper;
    private List<ListSelectionListener> listSelectionListeners = new ArrayList<ListSelectionListener>();
    private final ConnectionContext connectionContext;
    JButton btnAddDatei;
    JButton btnRemoveDateien;
    JList lstDateien;
    private BindingGroup bindingGroup;

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        RoundedPanel pnlDateien = new RoundedPanel();
        SemiRoundedPanel pnlHeaderDateien = new SemiRoundedPanel();
        JLabel lblHeaderDateien = new JLabel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel1 = new JPanel();
        JScrollPane jspDateiList = new JScrollPane();
        this.lstDateien = new JList();
        JPanel pnlCtrlButtons = new JPanel();
        this.btnAddDatei = new JButton();
        this.btnRemoveDateien = new JButton();
        FormListener formListener = new FormListener();
        this.setName("Form");
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        pnlDateien.setName("pnlDateien");
        pnlDateien.setLayout((LayoutManager)new GridBagLayout());
        pnlHeaderDateien.setBackground(new Color(51, 51, 51));
        pnlHeaderDateien.setForeground(new Color(51, 51, 51));
        pnlHeaderDateien.setName("pnlHeaderDateien");
        pnlHeaderDateien.setLayout((LayoutManager)new FlowLayout());
        lblHeaderDateien.setForeground(new Color(255, 255, 255));
        Mnemonics.setLocalizedText((JLabel)lblHeaderDateien, (String)NbBundle.getMessage(SimpleDocumentWebDavPanel.class, (String)"SimpleDocumentWebDavPanel.lblHeaderDateien.text"));
        lblHeaderDateien.setName("lblHeaderDateien");
        pnlHeaderDateien.add((Component)lblHeaderDateien);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        pnlDateien.add((Component)pnlHeaderDateien, (Object)gridBagConstraints);
        jPanel2.setName("jPanel2");
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new GridBagLayout());
        jPanel1.setName("jPanel1");
        jPanel1.setOpaque(false);
        jPanel1.setLayout(new GridBagLayout());
        jspDateiList.setMinimumSize(new Dimension(250, 130));
        jspDateiList.setName("jspDateiList");
        this.lstDateien.setMinimumSize(new Dimension(250, 130));
        this.lstDateien.setName("lstDateien");
        this.lstDateien.setPreferredSize(new Dimension(250, 130));
        ELProperty eLProperty = ELProperty.create((String)("${cidsBean." + this.beanCollProp + "}"));
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this, (Property)eLProperty, (JList)this.lstDateien);
        this.bindingGroup.addBinding((Binding)jListBinding);
        this.lstDateien.addMouseListener(formListener);
        this.lstDateien.addListSelectionListener(formListener);
        jspDateiList.setViewportView(this.lstDateien);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel1.add((Component)jspDateiList, gridBagConstraints);
        pnlCtrlButtons.setName("pnlCtrlButtons");
        pnlCtrlButtons.setOpaque(false);
        pnlCtrlButtons.setLayout(new GridBagLayout());
        this.btnAddDatei.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_add_mini.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddDatei, (String)NbBundle.getMessage(SimpleDocumentWebDavPanel.class, (String)"SimpleDocumentWebDavPanel.btnAddDatei.text"));
        this.btnAddDatei.setBorderPainted(false);
        this.btnAddDatei.setContentAreaFilled(false);
        this.btnAddDatei.setName("btnAddDatei");
        this.btnAddDatei.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        pnlCtrlButtons.add((Component)this.btnAddDatei, gridBagConstraints);
        this.btnRemoveDateien.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cids/custom/objecteditors/wunda_blau/edit_remove_mini.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemoveDateien, (String)NbBundle.getMessage(SimpleDocumentWebDavPanel.class, (String)"SimpleDocumentWebDavPanel.btnRemoveDateien.text"));
        this.btnRemoveDateien.setBorderPainted(false);
        this.btnRemoveDateien.setContentAreaFilled(false);
        this.btnRemoveDateien.setName("btnRemoveDateien");
        this.btnRemoveDateien.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        pnlCtrlButtons.add((Component)this.btnRemoveDateien, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel1.add((Component)pnlCtrlButtons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 5);
        jPanel2.add((Component)jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        pnlDateien.add((Component)jPanel2, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)pnlDateien, gridBagConstraints);
        this.bindingGroup.bind();
    }

    public SimpleDocumentWebDavPanel() {
        this(false, "dokumente", "albo_flaeche_document", FIELD__DATEINAME, "UaWebDavTunnelAction", ConnectionContext.createDummy(), new JFileChooser(), new String[]{"jpg", "jpeg", "png", "gif", "svg"}, 0x200000);
    }

    public SimpleDocumentWebDavPanel(boolean editable, String beanCollProp, String bildClassName, String nameProp, String tunnelAction, ConnectionContext connectionContext, JFileChooser file_chooser, String[] endings, int limit) {
        this.editor = editable;
        this.beanCollProp = beanCollProp;
        this.bildClassName = bildClassName;
        this.nameProp = nameProp;
        this.connectionContext = connectionContext;
        this.fileChooser = file_chooser;
        this.imageEndings = endings;
        Arrays.sort(this.imageEndings);
        this.fileLimit = limit;
        WebDavTunnelHelper webdavHelp = null;
        try {
            webdavHelp = new WebDavTunnelHelper("WUNDA_BLAU", tunnelAction);
        }
        catch (Exception ex) {
            String message = "Fehler beim Initialisieren des WebdavHelpers.";
            LOG.error((Object)"Fehler beim Initialisieren des WebdavHelpers.", (Throwable)ex);
            ObjectRendererUtils.showExceptionWindowToUser("Fehler beim Initialisieren des WebdavHelpers.", ex, null);
        }
        this.webdavHelper = webdavHelp;
        this.initComponents();
        this.lstDateien.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (component instanceof JLabel && value instanceof CidsBean) {
                    CidsBean dokumentBean = (CidsBean)value;
                    String name = (String)dokumentBean.getProperty(SimpleDocumentWebDavPanel.FIELD__DATEINAME);
                    ((JLabel)component).setText(name);
                }
                return component;
            }
        });
        this.fileChooser.setMultiSelectionEnabled(true);
        this.lstDateien.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                SimpleDocumentWebDavPanel.this.defineButtonStatus();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                SimpleDocumentWebDavPanel.this.defineButtonStatus();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                SimpleDocumentWebDavPanel.this.defineButtonStatus();
            }
        });
        if (editable) {
            new DropTarget(this.lstDateien, new DropTargetAdapter(){

                @Override
                public void drop(DropTargetDropEvent dtde) {
                    boolean a = false;
                    try {
                        Transferable tr = dtde.getTransferable();
                        DataFlavor[] flavors = tr.getTransferDataFlavors();
                        for (int i = 0; i < flavors.length; ++i) {
                            if (flavors[i].isFlavorJavaFileListType()) {
                                dtde.acceptDrop(dtde.getDropAction());
                                List files = (List)tr.getTransferData(flavors[i]);
                                if (files != null && files.size() > 0) {
                                    CismetConcurrency.getInstance((String)"WebDavPanel").getDefaultExecutor().execute(new DateiUploadWorker(files));
                                }
                                dtde.dropComplete(true);
                                return;
                            }
                            if (!flavors[i].isRepresentationClassInputStream()) continue;
                            if (!a) {
                                dtde.acceptDrop(dtde.getDropAction());
                                a = true;
                            }
                            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)tr.getTransferData(flavors[i])));
                            String tmp = null;
                            ArrayList<File> fileList = new ArrayList<File>();
                            while ((tmp = br.readLine()) != null) {
                                if (!tmp.trim().startsWith(SimpleDocumentWebDavPanel.FILE_PROTOCOL_PREFIX)) continue;
                                File f = new File(tmp.trim().substring(SimpleDocumentWebDavPanel.FILE_PROTOCOL_PREFIX.length()));
                                if (f.exists()) {
                                    fileList.add(f);
                                    continue;
                                }
                                f = new File(URLDecoder.decode(tmp.trim().substring(SimpleDocumentWebDavPanel.FILE_PROTOCOL_PREFIX.length()), "UTF-8"));
                                if (f.exists()) {
                                    fileList.add(f);
                                    continue;
                                }
                                LOG.warn((Object)("File " + f.toString() + " does not exist."));
                            }
                            br.close();
                            if (fileList == null || fileList.size() <= 0) continue;
                            CismetConcurrency.getInstance((String)"WebDavPanel").getDefaultExecutor().execute(new DateiUploadWorker(fileList));
                            dtde.dropComplete(true);
                            return;
                        }
                    }
                    catch (UnsupportedFlavorException | IOException ex) {
                        LOG.warn((Object)ex, (Throwable)ex);
                    }
                    dtde.rejectDrop();
                }
            });
        }
        this.btnAddDatei.setVisible(editable);
        this.btnRemoveDateien.setVisible(editable);
    }

    private void defineButtonStatus() {
        boolean hasSelection = this.lstDateien.getSelectedValue() != null;
        this.btnRemoveDateien.setEnabled(hasSelection && this.isEditor());
    }

    public WebDavTunnelHelper getWebdavHelper() {
        return this.webdavHelper;
    }

    public boolean isEditor() {
        return this.editor;
    }

    private void lstDateienValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting() && this.listListenerEnabled) {
            for (ListSelectionListener listener : this.listSelectionListeners) {
                listener.valueChanged(evt);
            }
        }
    }

    private void btnAddDateiActionPerformed(ActionEvent evt) {
        File[] selFiles;
        if (lastFolder != null) {
            this.fileChooser.setCurrentDirectory(lastFolder);
        }
        if (0 == this.fileChooser.showOpenDialog(this) && (selFiles = this.fileChooser.getSelectedFiles()) != null && selFiles.length > 0) {
            lastFolder = selFiles[0].getParentFile();
            CismetConcurrency.getInstance((String)"WebDavPanel").getDefaultExecutor().execute(new DateiUploadWorker(Arrays.asList(selFiles)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnRemoveDateienActionPerformed(ActionEvent evt) {
        int answer;
        Object[] selection = this.lstDateien.getSelectedValuesList().toArray();
        if (selection != null && selection.length > 0 && (answer = JOptionPane.showConfirmDialog(StaticSwingTools.getParentFrame((Component)this), "Sollen die Dokumente wirklich gel\u00f6scht werden?", "Dokumente entfernen", 0)) == 0) {
            try {
                this.listListenerEnabled = false;
                List<Object> removeList = Arrays.asList(selection);
                List dateien = this.cidsBean.getBeanCollectionProperty(this.beanCollProp);
                if (dateien != null) {
                    dateien.removeAll(removeList);
                }
                for (int i = 0; i < this.lstDateien.getModel().getSize(); ++i) {
                    CidsBean datei = (CidsBean)this.lstDateien.getModel().getElementAt(i);
                    datei.setProperty("laufende_nummer", (Object)(i + 1));
                }
                for (Object toDeleteObj : removeList) {
                    if (!(toDeleteObj instanceof CidsBean)) continue;
                    CidsBean dateiToDelete = (CidsBean)toDeleteObj;
                    this.removedDateiBeans.add(dateiToDelete);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                SimpleDocumentWebDavPanel.showExceptionToUser(ex, this);
            }
            finally {
                this.listListenerEnabled = true;
                int modelSize = this.lstDateien.getModel().getSize();
                if (modelSize > 0) {
                    this.lstDateien.setSelectedIndex(0);
                }
            }
        }
    }

    private void lstDateienMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            final CidsBean dokumentBean = (CidsBean)this.lstDateien.getSelectedValue();
            if (DownloadManagerDialog.getInstance().showAskingForUserTitleDialog((Component)this.getParent())) {
                final String jobname = DownloadManagerDialog.getInstance().getJobName();
                AbstractDownload download = new AbstractDownload(){
                    {
                        this.status = Download.State.WAITING;
                        this.directory = jobname;
                        String dateiname = (String)dokumentBean.getProperty(SimpleDocumentWebDavPanel.FIELD__DATEINAME);
                        int extIndex = dateiname.lastIndexOf(".");
                        String extension = extIndex >= 0 ? dateiname.substring(extIndex) : "";
                        String filename = extIndex >= 0 ? dateiname.substring(0, extIndex) : dateiname;
                        this.determineDestinationFile(filename, extension);
                    }

                    public void run() {
                        try {
                            this.status = Download.State.RUNNING;
                            this.stateChanged();
                            InputStream is = SimpleDocumentWebDavPanel.this.getWebdavHelper().getFileFromWebDAV((String)dokumentBean.getProperty(SimpleDocumentWebDavPanel.this.nameProp), SimpleDocumentWebDavPanel.this.getConnectionContext());
                            try (FileOutputStream os = new FileOutputStream(this.fileToSaveTo);){
                                IOUtils.copy((InputStream)is, (OutputStream)os);
                            }
                            if (this.status == Download.State.RUNNING) {
                                this.status = Download.State.COMPLETED;
                                this.stateChanged();
                            }
                        }
                        catch (Exception ex) {
                            LOG.error((Object)ex, (Throwable)ex);
                            this.status = Download.State.ABORTED;
                            this.stateChanged();
                        }
                    }
                };
                DownloadManager.instance().add((Download)download);
            }
        }
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.listSelectionListeners.add(l);
    }

    public boolean removeListSelectionListener(ListSelectionListener l) {
        return this.listSelectionListeners.remove(l);
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.bindingGroup.unbind();
        this.cidsBean = cidsBean;
        this.bindingGroup.bind();
        if (cidsBean != null && this.lstDateien.getModel().getSize() > 0) {
            this.lstDateien.setSelectedIndex(0);
        }
    }

    public static Image adjustScale(BufferedImage bi, JComponent component, int insetX, int insetY) {
        double scaley;
        double scalex = (double)component.getWidth() / (double)bi.getWidth();
        double scale = Math.min(scalex, scaley = (double)component.getHeight() / (double)bi.getHeight());
        if (scale <= 1.0) {
            return bi.getScaledInstance((int)((double)bi.getWidth() * scale) - insetX, (int)((double)bi.getHeight() * scale) - insetY, 4);
        }
        return bi;
    }

    private static byte[] resizeImage(File tempFile, String ending) throws Exception {
        BufferedImage img = ImageIO.read(tempFile);
        int height = ((Image)img).getHeight(null);
        int width = ((Image)img).getWidth(null);
        int longestSide = Math.max(width, height);
        double scale = 1.0;
        if (longestSide > 800) {
            scale = 800.0 / (double)longestSide;
        }
        BufferedImage imgThumb = new BufferedImage((int)((double)width * scale), (int)((double)height * scale), 1);
        imgThumb.createGraphics().drawImage(img.getScaledInstance((int)((double)width * scale), (int)((double)height * scale), 4), 0, 0, null);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)imgThumb, ending, os);
        return os.toByteArray();
    }

    private static void showExceptionToUser(Exception ex, JComponent parent) {
        ErrorInfo ei = new ErrorInfo("Fehler", "Beim Vorgang ist ein Fehler aufgetreten", null, null, (Throwable)ex, Level.SEVERE, null);
        JXErrorPane.showDialog((Component)parent, (ErrorInfo)ei);
    }

    public void afterClosing(AfterClosingHook.Event event) {
        if (AfterClosingHook.Status.SAVED == event.getStatus()) {
            for (CidsBean deleteBean : this.removedDateiBeans) {
                String fileName = (String)deleteBean.getProperty(this.nameProp);
                try {
                    this.webdavHelper.deleteFileFromWebDAV(fileName, this.getConnectionContext());
                    deleteBean.delete();
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    SimpleDocumentWebDavPanel.showExceptionToUser(ex, this);
                }
            }
        } else {
            for (CidsBean deleteBean : this.removeNewAddedDateiBean) {
                String fileName = (String)deleteBean.getProperty(this.nameProp);
                try {
                    this.webdavHelper.deleteFileFromWebDAV(fileName, this.getConnectionContext());
                }
                catch (Exception ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    SimpleDocumentWebDavPanel.showExceptionToUser(ex, this);
                }
            }
        }
    }

    public boolean isOkForSaving() {
        return true;
    }

    public void dispose() {
        this.bindingGroup.unbind();
        this.cidsBean = null;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private synchronized String createUniqueFilename(String filename) {
        if (filename.contains(".")) {
            return filename.substring(0, filename.lastIndexOf(".")) + new Long(System.currentTimeMillis()).hashCode() + filename.substring(filename.lastIndexOf("."));
        }
        return filename + new Long(System.currentTimeMillis()).hashCode();
    }

    private String cutEnding(String filename) {
        if (filename.contains(".")) {
            return filename.substring(0, filename.lastIndexOf("."));
        }
        return filename;
    }

    protected class DateiUploadWorker
    extends SwingWorker<Collection<CidsBean>, Void> {
        private final Collection<File> dokumente;

        public DateiUploadWorker(Collection<File> dokumente) {
            this.dokumente = dokumente;
        }

        @Override
        protected Collection<CidsBean> doInBackground() throws Exception {
            ArrayList<CidsBean> newBeans = new ArrayList<CidsBean>();
            for (File dokument : this.dokumente) {
                String filename = SimpleDocumentWebDavPanel.this.createUniqueFilename(dokument.getName());
                String fileEnding = null;
                if (dokument.getName().toLowerCase().contains(".")) {
                    fileEnding = dokument.getName().toLowerCase().substring(dokument.getName().toLowerCase().lastIndexOf(".") + 1);
                }
                if (fileEnding != null && Arrays.binarySearch(SimpleDocumentWebDavPanel.this.imageEndings, fileEnding) >= 0) {
                    ByteArrayInputStream is = new ByteArrayInputStream(SimpleDocumentWebDavPanel.resizeImage(dokument, fileEnding));
                    SimpleDocumentWebDavPanel.this.getWebdavHelper().uploadFileToWebDAV(filename, (InputStream)is, (Component)SimpleDocumentWebDavPanel.this, SimpleDocumentWebDavPanel.this.getConnectionContext());
                } else {
                    if (dokument.length() > (long)SimpleDocumentWebDavPanel.this.fileLimit) {
                        JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)CismapBroker.getInstance().getMappingComponent()), NbBundle.getMessage(SimpleDocumentWebDavPanel.class, (String)SimpleDocumentWebDavPanel.BUNDLE_LIMIT_MESSAGE), NbBundle.getMessage(SimpleDocumentWebDavPanel.class, (String)SimpleDocumentWebDavPanel.BUNDLE_LIMIT_TITLE), 0);
                        continue;
                    }
                    SimpleDocumentWebDavPanel.this.getWebdavHelper().uploadFileToWebDAV(filename, dokument, (Component)SimpleDocumentWebDavPanel.this, SimpleDocumentWebDavPanel.this.getConnectionContext());
                }
                CidsBean newDokument = CidsBean.createNewCidsBeanFromTableName((String)"WUNDA_BLAU", (String)SimpleDocumentWebDavPanel.this.bildClassName, (ConnectionContext)SimpleDocumentWebDavPanel.this.getConnectionContext());
                newDokument.setProperty(SimpleDocumentWebDavPanel.this.nameProp, (Object)filename);
                newBeans.add(newDokument);
            }
            return newBeans;
        }

        @Override
        protected void done() {
            try {
                Collection newBeans = (Collection)this.get();
                if (!newBeans.isEmpty()) {
                    List oldBeans = SimpleDocumentWebDavPanel.this.cidsBean.getBeanCollectionProperty(SimpleDocumentWebDavPanel.this.beanCollProp);
                    oldBeans.addAll(newBeans);
                    SimpleDocumentWebDavPanel.this.removeNewAddedDateiBean.addAll(newBeans);
                    SimpleDocumentWebDavPanel.this.lstDateien.setSelectedValue(newBeans.iterator().next(), true);
                }
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
            catch (ExecutionException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
        }
    }

    private class FormListener
    implements ActionListener,
    MouseListener,
    ListSelectionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == SimpleDocumentWebDavPanel.this.btnAddDatei) {
                SimpleDocumentWebDavPanel.this.btnAddDateiActionPerformed(evt);
            } else if (evt.getSource() == SimpleDocumentWebDavPanel.this.btnRemoveDateien) {
                SimpleDocumentWebDavPanel.this.btnRemoveDateienActionPerformed(evt);
            }
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if (evt.getSource() == SimpleDocumentWebDavPanel.this.lstDateien) {
                SimpleDocumentWebDavPanel.this.lstDateienMouseClicked(evt);
            }
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (evt.getSource() == SimpleDocumentWebDavPanel.this.lstDateien) {
                SimpleDocumentWebDavPanel.this.lstDateienValueChanged(evt);
            }
        }
    }
}

